/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.util.UniqueMultiMap;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClusterCommand {
    private final String mTaskId;
    private final String mRequestId;
    private final String mCommandId;
    private final String mCommandLine;
    private final RequestType mRequestType;
    private final Integer mShardCount;
    private final Integer mShardIndex;
    private final String mAttemptId;
    private List<String> mTargetDeviceSerials = new ArrayList<String>();
    private UniqueMultiMap<String, String> mExtraOptions = new UniqueMultiMap();

    public ClusterCommand(String commandId, String taskId, String cmdLine) {
        this(null, commandId, taskId, cmdLine, null, RequestType.UNMANAGED, null, null);
    }

    public ClusterCommand(String requestId, String commandId, String taskId, String cmdLine, String attemptId, RequestType requestType, Integer shardCount, Integer shardIndex) {
        this.mTaskId = taskId;
        this.mRequestId = requestId;
        this.mCommandId = commandId;
        this.mCommandLine = cmdLine;
        this.mRequestType = requestType;
        this.mShardCount = shardCount;
        this.mShardIndex = shardIndex;
        this.mAttemptId = !Strings.isNullOrEmpty(attemptId) ? attemptId : UUID.randomUUID().toString();
    }

    public String getTaskId() {
        return this.mTaskId;
    }

    public String getRequestId() {
        return this.mRequestId;
    }

    public String getCommandId() {
        return this.mCommandId;
    }

    public String getAttemptId() {
        return this.mAttemptId;
    }

    public String getCommandLine() {
        return this.mCommandLine;
    }

    public RequestType getRequestType() {
        return this.mRequestType;
    }

    public List<String> getTargetDeviceSerials() {
        return this.mTargetDeviceSerials;
    }

    public void setTargetDeviceSerials(List<String> targetDeviceSerials) {
        this.mTargetDeviceSerials = targetDeviceSerials;
    }

    public UniqueMultiMap<String, String> getExtraOptions() {
        return this.mExtraOptions;
    }

    public Integer getShardCount() {
        return this.mShardCount;
    }

    public Integer getShardIndex() {
        return this.mShardIndex;
    }

    private static Integer optInteger(JSONObject json, String name) throws JSONException {
        if (json.isNull(name)) {
            return null;
        }
        return json.getInt(name);
    }

    public static ClusterCommand fromJson(JSONObject json) throws JSONException {
        JSONArray extraOptions;
        ClusterCommand command = new ClusterCommand(json.getString("request_id"), json.getString("command_id"), json.getString("task_id"), json.getString("command_line"), json.optString("attempt_id", null), RequestType.valueOf(json.optString("request_type", RequestType.UNMANAGED.name())), ClusterCommand.optInteger(json, "shard_count"), ClusterCommand.optInteger(json, "shard_index"));
        JSONArray jsonDeviceSerials = json.optJSONArray("device_serials");
        if (jsonDeviceSerials != null) {
            ArrayList<String> deviceSerials = new ArrayList<String>();
            for (int j = 0; j < jsonDeviceSerials.length(); ++j) {
                deviceSerials.add(jsonDeviceSerials.getString(j));
            }
            command.setTargetDeviceSerials(deviceSerials);
        }
        if ((extraOptions = json.optJSONArray("extra_options")) != null) {
            for (int i = 0; i < extraOptions.length(); ++i) {
                JSONObject entry = extraOptions.getJSONObject(i);
                String key = entry.getString("key");
                JSONArray values2 = entry.getJSONArray("values");
                for (int j = 0; j < values2.length(); ++j) {
                    command.mExtraOptions.put(key, values2.getString(j));
                }
            }
        }
        return command;
    }

    public static enum RequestType {
        UNMANAGED,
        MANAGED;

    }

    public static enum State {
        UNKNOWN,
        QUEUED,
        RUNNING,
        CANCELED,
        COMPLETED,
        ERROR,
        FATAL;

    }
}

