/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.ClusterBuildProvider;
import com.android.tradefed.cluster.ClusterCommand;
import com.android.tradefed.cluster.ClusterCommandLauncher;
import com.android.tradefed.cluster.ClusterHostUtil;
import com.android.tradefed.cluster.ClusterLogSaver;
import com.android.tradefed.cluster.TestContext;
import com.android.tradefed.cluster.TestEnvironment;
import com.android.tradefed.cluster.TestResource;
import com.android.tradefed.cluster.TradefedConfigObject;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DeviceConfigurationHolder;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.log.SimpleFileLogger;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.StringUtil;
import com.android.tradefed.util.UniqueMultiMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;

public class ClusterCommandConfigBuilder {
    private static final String TEST_TAG = "cluster_command_launcher";
    private ClusterCommand mCommand;
    private TestEnvironment mTestEnvironment;
    private List<TestResource> mTestResources;
    private TestContext mTestContext;
    private File mWorkDir;

    public ClusterCommandConfigBuilder setClusterCommand(ClusterCommand command) {
        this.mCommand = command;
        return this;
    }

    public ClusterCommandConfigBuilder setTestEnvironment(TestEnvironment testEnvironment) {
        this.mTestEnvironment = testEnvironment;
        return this;
    }

    public ClusterCommandConfigBuilder setTestResources(List<TestResource> testResources) {
        this.mTestResources = testResources;
        return this;
    }

    public ClusterCommandConfigBuilder setTestContext(TestContext testContext) {
        this.mTestContext = testContext;
        return this;
    }

    public ClusterCommandConfigBuilder setWorkDir(File workDir) {
        this.mWorkDir = workDir;
        return this;
    }

    private String getConfigObjectTypeName(TradefedConfigObject.Type type) {
        switch (type) {
            case TARGET_PREPARER: {
                return "target_preparer";
            }
            case RESULT_REPORTER: {
                return "result_reporter";
            }
        }
        throw new UnsupportedOperationException(String.format("%s is not supported", new Object[]{type}));
    }

    private Object createConfigObject(TradefedConfigObject configObjDef, Map<String, String> envVars) throws ConfigurationException {
        Object configObj = null;
        try {
            configObj = Class.forName(configObjDef.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(String.format("Failed to add a config object '%s'", configObjDef.getClassName()), e);
        }
        MultiMap<String, String> optionValues = configObjDef.getOptionValues();
        ArrayList<String> optionArgs = new ArrayList<String>();
        for (String name : optionValues.keySet()) {
            List<String> values2 = optionValues.get(name);
            for (String value : values2) {
                optionArgs.add(String.format("--%s", name));
                if (value == null) continue;
                optionArgs.add(StringUtil.expand(value, envVars));
            }
        }
        ArgsOptionParser parser = new ArgsOptionParser(new Object[]{configObj});
        parser.parse(optionArgs);
        return configObj;
    }

    @VisibleForTesting
    IConfiguration initConfiguration() {
        return new Configuration("Cluster Command " + this.mCommand.getCommandId(), "");
    }

    @VisibleForTesting
    Map<String, String> getSystemEnvMap() {
        return System.getenv();
    }

    /*
     * WARNING - void declaration
     */
    public File build() throws ConfigurationException, IOException, JSONException {
        assert (this.mCommand != null);
        assert (this.mTestEnvironment != null);
        assert (this.mTestResources != null);
        assert (this.mWorkDir != null);
        IConfiguration config = this.initConfiguration();
        config.getCommandOptions().setTestTag(TEST_TAG);
        ArrayList<IDeviceConfiguration> deviceConfigs = new ArrayList<IDeviceConfiguration>();
        int index = 0;
        assert (0 < this.mCommand.getTargetDeviceSerials().size());
        ArrayList<TradefedConfigObject> deviceConfigObjDefs = new ArrayList<TradefedConfigObject>();
        ArrayList<TradefedConfigObject> nonDeviceConfigObjDefs = new ArrayList<TradefedConfigObject>();
        for (TradefedConfigObject configObjDef : this.mTestEnvironment.getTradefedConfigObjects()) {
            if (TradefedConfigObject.Type.TARGET_PREPARER.equals((Object)configObjDef.getType())) {
                deviceConfigObjDefs.add(configObjDef);
                continue;
            }
            nonDeviceConfigObjDefs.add(configObjDef);
        }
        TreeMap<String, String> envVars = new TreeMap<String, String>();
        Map<String, String> systemEnvMap = this.getSystemEnvMap();
        envVars.putAll(systemEnvMap);
        envVars.put("TF_WORK_DIR", this.mWorkDir.getAbsolutePath());
        envVars.putAll(this.mTestEnvironment.getEnvVars());
        envVars.putAll(this.mTestContext.getEnvVars());
        for (String string : this.mCommand.getTargetDeviceSerials()) {
            String string2 = ClusterHostUtil.getLocalDeviceSerial(string);
            DeviceConfigurationHolder deviceConfigurationHolder = new DeviceConfigurationHolder(String.format("TF_DEVICE_%d", index++));
            deviceConfigurationHolder.getDeviceRequirements().setSerial(string2);
            for (TradefedConfigObject configObjDef : deviceConfigObjDefs) {
                deviceConfigurationHolder.addSpecificConfig(this.createConfigObject(configObjDef, envVars));
            }
            deviceConfigurationHolder.addSpecificConfig(new ClusterBuildProvider());
            deviceConfigs.add(deviceConfigurationHolder);
        }
        config.setDeviceConfigList(deviceConfigs);
        if (this.mTestEnvironment.useParallelSetup()) {
            config.injectOptionValue("parallel-setup", "true");
            config.injectOptionValue("parallel-setup-timeout", "0");
        }
        config.setTest(new ClusterCommandLauncher());
        config.setLogSaver(new ClusterLogSaver());
        config.setLogOutput(new SimpleFileLogger());
        config.injectOptionValue("simple-file:path", Paths.get(this.mWorkDir.getAbsolutePath(), "logs", "host_log.txt").toString());
        config.setTestInvocationListeners(Collections.emptyList());
        for (TradefedConfigObject tradefedConfigObject : nonDeviceConfigObjDefs) {
            String string = this.getConfigObjectTypeName(tradefedConfigObject.getType());
            List<?> list2 = config.getConfigurationObjectList(string);
            list2.add(this.createConfigObject(tradefedConfigObject, envVars));
            config.setConfigurationObjectList(string, list2);
        }
        config.injectOptionValue("cluster:request-id", this.mCommand.getRequestId());
        config.injectOptionValue("cluster:command-id", this.mCommand.getCommandId());
        config.injectOptionValue("cluster:attempt-id", this.mCommand.getAttemptId());
        config.injectOptionValue("enable-root", "false");
        String commandLine = this.mTestContext.getCommandLine();
        if (commandLine == null || commandLine.isEmpty()) {
            commandLine = this.mCommand.getCommandLine();
        }
        config.injectOptionValue("cluster:command-line", commandLine);
        config.injectOptionValue("cluster:original-command-line", this.mCommand.getCommandLine());
        config.injectOptionValue("cluster:root-dir", this.mWorkDir.getAbsolutePath());
        for (Map.Entry entry : envVars.entrySet()) {
            config.injectOptionValue("cluster:env-var", (String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : this.mTestEnvironment.getSetupScripts()) {
            config.injectOptionValue("cluster:setup-script", string);
        }
        if (this.mTestEnvironment.useSubprocessReporting()) {
            config.injectOptionValue("cluster:use-subprocess-reporting", "true");
        }
        config.getCommandOptions().setInvocationTimeout(this.mTestEnvironment.getInvocationTimeout());
        config.injectOptionValue("cluster:output-idle-timeout", String.valueOf(this.mTestEnvironment.getOutputIdleTimeout()));
        for (String string : this.mTestEnvironment.getJvmOptions()) {
            config.injectOptionValue("cluster:jvm-option", string);
        }
        for (Map.Entry<String, String> entry : this.mTestEnvironment.getJavaProperties().entrySet()) {
            config.injectOptionValue("cluster:java-property", entry.getKey(), entry.getValue());
        }
        if (this.mTestEnvironment.getOutputFileUploadUrl() != null) {
            void var9_19;
            String string = this.mTestEnvironment.getOutputFileUploadUrl();
            if (!string.endsWith("/")) {
                String string3 = string + "/";
            }
            String string4 = String.format("%s%s/%s/", var9_19, this.mCommand.getCommandId(), this.mCommand.getAttemptId());
            config.injectOptionValue("cluster:output-file-upload-url", StringUtil.expand(string4, envVars));
        }
        for (String string : this.mTestEnvironment.getOutputFilePatterns()) {
            config.injectOptionValue("cluster:output-file-pattern", string);
        }
        if (this.mTestEnvironment.getContextFilePattern() != null) {
            config.injectOptionValue("cluster:context-file-pattern", this.mTestEnvironment.getContextFilePattern());
        }
        for (String string : this.mTestEnvironment.getExtraContextFiles()) {
            config.injectOptionValue("cluster:extra-context-file", string);
        }
        if (this.mTestEnvironment.getRetryCommandLine() != null) {
            config.injectOptionValue("cluster:retry-command-line", this.mTestEnvironment.getRetryCommandLine());
        }
        if (this.mTestEnvironment.getLogLevel() != null) {
            config.injectOptionValue("log-level", this.mTestEnvironment.getLogLevel());
        }
        for (String string : this.mTestEnvironment.getExcludedFilesInJavaClasspath()) {
            config.injectOptionValue("cluster:exclude-file-in-java-classpath", string);
        }
        ArrayList<TestResource> arrayList = new ArrayList<TestResource>();
        arrayList.addAll(this.mTestResources);
        arrayList.addAll(this.mTestContext.getTestResources());
        for (TestResource testResource : arrayList) {
            config.injectOptionValue("cluster:test-resource", StringUtil.expand(testResource.toJson().toString(), envVars));
        }
        UniqueMultiMap<String, String> uniqueMultiMap = this.mCommand.getExtraOptions();
        for (String key : uniqueMultiMap.keySet()) {
            for (String value : uniqueMultiMap.get(key)) {
                config.injectOptionValue(key, StringUtil.expand(value, envVars));
            }
        }
        File file2 = new File(this.mWorkDir, "command.xml");
        PrintWriter writer = new PrintWriter(file2);
        config.dumpXml(writer);
        writer.close();
        return file2;
    }
}

