/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.ClusterCommand;
import com.android.tradefed.cluster.IClusterEvent;
import com.android.tradefed.cluster.InvocationStatus;
import com.android.tradefed.log.LogUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClusterCommandEvent
implements IClusterEvent {
    public static final String DATA_KEY_ERROR = "error";
    public static final String DATA_KEY_SUMMARY = "summary";
    public static final String DATA_KEY_SETUP_TIME_MILLIS = "setup_time_millis";
    public static final String DATA_KEY_FETCH_BUILD_TIME_MILLIS = "fetch_build_time_millis";
    public static final String DATA_KEY_TOTAL_TEST_COUNT = "total_test_count";
    public static final String DATA_KEY_FAILED_TEST_COUNT = "failed_test_count";
    public static final String DATA_KEY_PASSED_TEST_COUNT = "passed_test_count";
    public static final String DATA_KEY_FAILED_TEST_RUN_COUNT = "failed_test_run_count";
    public static final String DATA_KEY_LOST_DEVICE_DETECTED = "device_lost_detected";
    public static final String DATA_KEY_SUBPROCESS_COMMAND_ERROR = "subprocess_command_error";
    public static final String DATA_KEY_ERROR_ID_NAME = "error_name";
    public static final String DATA_KEY_ERROR_ID_CODE = "error_code";
    public static final String DATA_KEY_ERROR_STATUS = "error_status";
    public static final int MAX_DATA_STRING_SIZE = 4095;
    private long mTimestamp;
    private Type mType;
    private String mCommandTaskId;
    private String mAttemptId;
    private String mHostName;
    private InvocationStatus mInvocationStatus;
    private Map<String, Object> mData = new HashMap<String, Object>();
    private Set<String> mDeviceSerials;

    private ClusterCommandEvent() {
    }

    public String getHostName() {
        return this.mHostName;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public Type getType() {
        return this.mType;
    }

    public String getCommandTaskId() {
        return this.mCommandTaskId;
    }

    public String getAttemptId() {
        return this.mAttemptId;
    }

    public InvocationStatus getInvocationStatus() {
        return this.mInvocationStatus;
    }

    public Map<String, Object> getData() {
        return this.mData;
    }

    public Set<String> getDeviceSerials() {
        return this.mDeviceSerials;
    }

    public static Builder createEventBuilder() {
        return ClusterCommandEvent.createEventBuilder(null);
    }

    public static Builder createEventBuilder(ClusterCommand command) {
        Builder builder = new Builder();
        if (command != null) {
            builder.setCommandTaskId(command.getTaskId());
            builder.setAttemptId(command.getAttemptId());
        }
        return builder;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("type", this.getType().toString());
        json.put("time", this.getTimestamp() / 1000L);
        json.put("task_id", this.getCommandTaskId());
        json.put("attempt_id", this.getAttemptId());
        json.put("hostname", this.getHostName());
        if (!this.getDeviceSerials().isEmpty()) {
            json.put("device_serial", this.getDeviceSerials().iterator().next());
        }
        json.put("device_serials", new JSONArray(this.getDeviceSerials()));
        if (this.mInvocationStatus != null) {
            json.put("invocation_status", this.mInvocationStatus.toJSON());
        }
        json.put("data", new JSONObject(this.getData()));
        return json;
    }

    public String toString() {
        String str = null;
        try {
            str = this.toJSON().toString();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return str;
    }

    public static enum Type {
        AllocationFailed,
        ConfigurationError,
        FetchFailed,
        ExecuteFailed,
        InvocationInitiated,
        InvocationStarted,
        InvocationFailed,
        InvocationEnded,
        InvocationCompleted,
        TestRunInProgress,
        TestEnded,
        Unleased;

    }

    public static class Builder {
        private long mTimestamp = System.currentTimeMillis();
        private Type mType;
        private String mCommandTaskId;
        private String mAttemptId;
        private String mHostName;
        private InvocationStatus mInvocationStatus;
        private Map<String, Object> mData = new HashMap<String, Object>();
        private Set<String> mDeviceSerials = new HashSet<String>();

        public Builder setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        public Builder setType(Type type) {
            this.mType = type;
            return this;
        }

        public Builder setCommandTaskId(String commandTaskId) {
            this.mCommandTaskId = commandTaskId;
            return this;
        }

        public Builder setAttemptId(String attemptId) {
            this.mAttemptId = attemptId;
            return this;
        }

        public Builder setHostName(String hostName) {
            this.mHostName = hostName;
            return this;
        }

        public Builder setInvocationStatus(InvocationStatus invocationStatus) {
            this.mInvocationStatus = invocationStatus;
            return this;
        }

        public Builder setData(String name, Object value) {
            if (value instanceof String && ((String)value).length() > 4095) {
                LogUtil.CLog.w(String.format("Data for '%s' exceeds %d characters, and has been truncated.", name, 4095));
                this.mData.put(name, ((String)value).substring(0, 4095));
            } else {
                this.mData.put(name, value);
            }
            return this;
        }

        public Builder setDeviceSerials(Set<String> deviceSerials) {
            this.mDeviceSerials = deviceSerials;
            return this;
        }

        public Builder addDeviceSerial(String deviceSerial) {
            this.mDeviceSerials.add(deviceSerial);
            return this;
        }

        public ClusterCommandEvent build() {
            ClusterCommandEvent obj = new ClusterCommandEvent();
            obj.mTimestamp = this.mTimestamp;
            obj.mType = this.mType;
            obj.mCommandTaskId = this.mCommandTaskId;
            obj.mAttemptId = this.mAttemptId;
            obj.mHostName = this.mHostName;
            obj.mInvocationStatus = this.mInvocationStatus;
            obj.mData = new HashMap<String, Object>(this.mData);
            obj.mDeviceSerials = this.mDeviceSerials;
            return obj;
        }
    }
}

