/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.helper.aoa.UsbDevice;
import com.android.helper.aoa.UsbHelper;
import com.android.tradefed.cluster.SubprocessCommandException;
import com.android.tradefed.cluster.SubprocessReportingHelper;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LocalAndroidVirtualDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileIdleMonitor;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.StringEscapeUtils;
import com.android.tradefed.util.StringUtil;
import com.android.tradefed.util.SubprocessEventHelper;
import com.android.tradefed.util.SubprocessTestResultsParser;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@OptionClass(alias="cluster", global_namespace=false)
public class ClusterCommandLauncher
implements IRemoteTest,
IInvocationContextReceiver,
IConfigurationReceiver {
    public static final String TF_JAR_DIR = "TF_JAR_DIR";
    public static final String TF_PATH = "TF_PATH";
    public static final String TEST_WORK_DIR = "TEST_WORK_DIR";
    public static final String ANDROID_SERIALS = "ANDROID_SERIALS";
    public static final String TF_DEVICE_COUNT = "TF_DEVICE_COUNT";
    private static final Duration MAX_EVENT_RECEIVER_WAIT_TIME = Duration.ofMinutes(30L);
    @Option(name="root-dir", description="A root directory", mandatory=true)
    private File mRootDir;
    @Option(name="env-var", description="Environment variables")
    private Map<String, String> mEnvVars = new LinkedHashMap<String, String>();
    @Option(name="setup-script", description="Setup scripts")
    private List<String> mSetupScripts = new ArrayList<String>();
    @Option(name="script-timeout", description="Script execution timeout", isTimeVal=true)
    private long mScriptTimeout = 1800000L;
    @Option(name="jvm-option", description="JVM options")
    private List<String> mJvmOptions = new ArrayList<String>();
    @Option(name="java-property", description="Java properties")
    private Map<String, String> mJavaProperties = new LinkedHashMap<String, String>();
    @Option(name="command-line", description="A command line to launch.", mandatory=true)
    private String mCommandLine = null;
    @Option(name="original-command-line", description="Original command line. It may differ from command-line in retry invocations.")
    private String mOriginalCommandLine = null;
    @Option(name="use-subprocess-reporting", description="Use subprocess reporting.")
    private boolean mUseSubprocessReporting = false;
    @Option(name="output-idle-timeout", description="Maximum time to wait for an idle subprocess", isTimeVal=true)
    private long mOutputIdleTimeout = 0L;
    @Option(name="exclude-file-in-java-classpath", description="The file not to include in the java classpath.")
    private List<String> mExcludedFilesInClasspath = new ArrayList<String>(Arrays.asList("art-run-test.*", "art-gtest-jars.*"));
    private IInvocationContext mInvocationContext;
    private IConfiguration mConfiguration;
    private IRunUtil mRunUtil;

    @Override
    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mInvocationContext = invocationContext;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    private String getEnvVar(String key) {
        return this.getEnvVar(key, null);
    }

    private String getEnvVar(String key, String defaultValue) {
        String value = this.mEnvVars.getOrDefault(key, defaultValue);
        if (value != null) {
            value = StringUtil.expand(value, this.mEnvVars);
        }
        return value;
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        IRunUtil runUtil = this.getRunUtil();
        runUtil.setWorkingDir(this.mRootDir);
        runUtil.unsetEnvVariable("TF_GLOBAL_CONFIG");
        this.mEnvVars.put(TF_DEVICE_COUNT, String.valueOf(this.mInvocationContext.getDevices().size()));
        for (String key : this.mEnvVars.keySet()) {
            runUtil.setEnvVariable(key, this.getEnvVar(key));
        }
        runUtil.setEnvVariable(ANDROID_SERIALS, String.join((CharSequence)",", this.mInvocationContext.getSerials()));
        File testWorkDir = new File(this.getEnvVar(TEST_WORK_DIR, this.mRootDir.getAbsolutePath()));
        File logDir = new File(this.mRootDir, "logs");
        logDir.mkdirs();
        File stdoutFile = new File(logDir, "stdout.txt");
        File stderrFile = new File(logDir, "stderr.txt");
        this.runSetupScripts(runUtil, stdoutFile, stderrFile);
        FileIdleMonitor monitor = this.createFileMonitor(stdoutFile, stderrFile);
        SubprocessTestResultsParser subprocessEventParser = null;
        try {
            String classpath = this.buildJavaClasspath();
            if (this.mUseSubprocessReporting) {
                subprocessEventParser = this.createSubprocessTestResultsParser(listener, true, this.mInvocationContext);
                String port = Integer.toString(subprocessEventParser.getSocketServerPort());
                SubprocessReportingHelper mHelper = new SubprocessReportingHelper(this.mCommandLine, classpath, testWorkDir, port);
                File subprocessReporterJar = mHelper.buildSubprocessReporterJar();
                classpath = String.format("%s:%s", subprocessReporterJar.getAbsolutePath(), classpath);
            }
            List<String> javaCommandArgs = this.buildJavaCommandArgs(classpath, this.mCommandLine);
            LogUtil.CLog.i("Running a command line: %s", this.mCommandLine);
            LogUtil.CLog.i("args = %s", javaCommandArgs);
            LogUtil.CLog.i("test working directory = %s", testWorkDir);
            monitor.start();
            runUtil.setWorkingDir(testWorkDir);
            CommandResult result = runUtil.runTimedCmdWithInput(this.mConfiguration.getCommandOptions().getInvocationTimeout(), null, stdoutFile, stderrFile, javaCommandArgs.toArray(new String[javaCommandArgs.size()]));
            if (!result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
                String error = null;
                Throwable cause = null;
                if (result.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
                    error = String.format("Command timed out after %sms", this.mConfiguration.getCommandOptions().getInvocationTimeout());
                } else {
                    error = String.format("Command finished unsuccessfully: status=%s, exit_code=%s", new Object[]{result.getStatus(), result.getExitCode()});
                    SubprocessEventHelper.InvocationFailedEventInfo errorInfo = subprocessEventParser.getReportedInvocationFailedEventInfo();
                    cause = errorInfo != null ? errorInfo.mCause : new Throwable(FileUtil.readStringFromFile(stderrFile));
                }
                throw new SubprocessCommandException(error, cause);
            }
            LogUtil.CLog.i("Successfully ran a command");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            monitor.stop();
            if (subprocessEventParser != null) {
                subprocessEventParser.joinReceiver(MAX_EVENT_RECEIVER_WAIT_TIME.toMillis(), false);
                StreamUtil.close(subprocessEventParser);
            }
        }
    }

    private void runSetupScripts(IRunUtil runUtil, File stdoutFile, File stderrFile) {
        try {
            long timeout = this.mScriptTimeout;
            long startTime = System.currentTimeMillis();
            for (String script : this.mSetupScripts) {
                CommandResult result;
                script = StringUtil.expand(script, this.mEnvVars);
                LogUtil.CLog.i("Running a setup script: %s", script);
                File scriptFile = new File(QuotationAwareTokenizer.tokenizeLine(script)[0]);
                if (scriptFile.isFile()) {
                    scriptFile.setExecutable(true);
                }
                if (!(result = runUtil.runTimedCmdWithInput(timeout, null, stdoutFile, stderrFile, QuotationAwareTokenizer.tokenizeLine(script))).getStatus().equals((Object)CommandStatus.SUCCESS)) {
                    String error = null;
                    error = result.getStatus().equals((Object)CommandStatus.TIMED_OUT) ? "timeout" : FileUtil.readStringFromFile(stderrFile);
                    throw new RuntimeException(String.format("Script failed to run: %s", error));
                }
                if ((timeout -= System.currentTimeMillis() - startTime) >= 0L) continue;
                throw new RuntimeException(String.format("Setup scripts failed to run in %sms", this.mScriptTimeout));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error running setup scripts", e);
        }
    }

    private String buildJavaClasspath() {
        String tfPath = this.getEnvVar(TF_PATH, System.getProperty(TF_JAR_DIR));
        if (tfPath == null) {
            throw new RuntimeException("cannot find TF path!");
        }
        ArrayList<Pattern> excludedPatterns = new ArrayList<Pattern>();
        for (String string : this.mExcludedFilesInClasspath) {
            excludedPatterns.add(Pattern.compile(StringUtil.expand(string, this.mEnvVars)));
        }
        LinkedHashSet<String> jars = new LinkedHashSet<String>();
        for (String path : tfPath.split(":")) {
            File jarFile = new File(path);
            if (!jarFile.exists()) {
                LogUtil.CLog.w("TF_PATH %s doesn't exist; ignoring", path);
                continue;
            }
            if (jarFile.isFile() && !ClusterCommandLauncher.matchPatterns(excludedPatterns, jarFile.getAbsolutePath())) {
                jars.add(jarFile.getAbsolutePath());
                continue;
            }
            try (Stream<Path> walk = Files.walk(jarFile.toPath(), new FileVisitOption[0]);){
                List result = walk.map(Path::toString).filter(f -> f.toLowerCase().endsWith(".jar") && !ClusterCommandLauncher.matchPatterns(excludedPatterns, f)).collect(Collectors.toList());
                jars.addAll(result);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("failed to find jars from %s", jarFile), e);
            }
        }
        if (jars.isEmpty()) {
            throw new RuntimeException(String.format("cannot find any TF jars from %s!", tfPath));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator2 = jars.iterator();
        while (iterator2.hasNext()) {
            String jar = (String)iterator2.next();
            if (!new File(jar).getName().equalsIgnoreCase("tradefed.jar")) continue;
            arrayList.add(jar);
            iterator2.remove();
        }
        if (!jars.isEmpty()) {
            arrayList.add(String.join((CharSequence)":", jars));
        }
        return String.join((CharSequence)":", arrayList);
    }

    private List<String> buildJavaCommandArgs(String classpath, String tfCommandLine) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        String javaHome = this.getEnvVar("JAVA_HOME", System.getProperty("java.home"));
        String javaPath = String.format("%s/bin/java", javaHome);
        cmdArgs.add(new File(javaPath).getAbsolutePath());
        cmdArgs.add("-cp");
        cmdArgs.add(classpath);
        cmdArgs.addAll(this.mJvmOptions);
        File tmpDir = new File(this.mRootDir, "tmp");
        tmpDir.mkdirs();
        cmdArgs.add("-Djava.io.tmpdir=" + tmpDir.getAbsolutePath());
        for (Map.Entry<String, String> entry : this.mJavaProperties.entrySet()) {
            cmdArgs.add(String.format("-D%s=%s", entry.getKey(), StringUtil.expand(entry.getValue(), this.mEnvVars)));
        }
        cmdArgs.add("com.android.tradefed.command.CommandRunner");
        tfCommandLine = StringUtil.expand(tfCommandLine, this.mEnvVars);
        cmdArgs.addAll(StringEscapeUtils.paramsToArgs(ArrayUtil.list(tfCommandLine)));
        Integer shardCount = this.mConfiguration.getCommandOptions().getShardCount();
        Integer shardIndex = this.mConfiguration.getCommandOptions().getShardIndex();
        if (shardCount != null && shardCount > 1) {
            cmdArgs.add("--shard-count");
            cmdArgs.add(Integer.toString(shardCount));
            if (shardIndex != null) {
                cmdArgs.add("--shard-index");
                cmdArgs.add(Integer.toString(shardIndex));
            }
        }
        for (ITestDevice device : this.mInvocationContext.getDevices()) {
            cmdArgs.add("--serial");
            cmdArgs.add(device.getSerialNumber());
        }
        return cmdArgs;
    }

    private FileIdleMonitor createFileMonitor(File ... files) {
        long timeout = this.mOutputIdleTimeout > 0L ? this.mOutputIdleTimeout : Long.MAX_VALUE;
        return new FileIdleMonitor(Duration.ofMillis(timeout), this::resetDevices, files);
    }

    private void resetDevices() {
        LogUtil.CLog.i("Subprocess output idle for %d ms, attempting device reset.", this.mOutputIdleTimeout);
        try (UsbHelper usb = new UsbHelper();){
            List<ITestDevice> devices = this.mInvocationContext.getDevices();
            for (ITestDevice device : devices) {
                if (device instanceof LocalAndroidVirtualDevice) {
                    LogUtil.CLog.d("Shutting down local virtual device '%s'", device.getSerialNumber());
                    ((LocalAndroidVirtualDevice)device).shutdown();
                    continue;
                }
                this.resetUsbPort(usb, device.getSerialNumber());
            }
        }
    }

    private void resetUsbPort(UsbHelper usb, String serial) {
        try (UsbDevice device = usb.getDevice(serial);){
            if (device == null) {
                LogUtil.CLog.w("Device '%s' not found during USB reset.", serial);
                return;
            }
            LogUtil.CLog.d("Resetting USB port for device '%s'", serial);
            device.reset();
        }
    }

    private static boolean matchPatterns(List<Pattern> patterns, String str) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    SubprocessTestResultsParser createSubprocessTestResultsParser(ITestInvocationListener listener, boolean streaming, IInvocationContext context) throws IOException {
        return new SubprocessTestResultsParser(listener, streaming, context);
    }

    Map<String, String> getEnvVars() {
        return this.mEnvVars;
    }

    List<String> getSetupScripts() {
        return this.mSetupScripts;
    }

    List<String> getJvmOptions() {
        return this.mJvmOptions;
    }

    Map<String, String> getJavaProperties() {
        return this.mJavaProperties;
    }

    String getCommandLine() {
        return this.mCommandLine;
    }

    boolean useSubprocessReporting() {
        return this.mUseSubprocessReporting;
    }
}

