/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.cluster.ClusterCommand;
import com.android.tradefed.cluster.ClusterCommandConfigBuilder;
import com.android.tradefed.cluster.ClusterCommandEvent;
import com.android.tradefed.cluster.ClusterCommandStatus;
import com.android.tradefed.cluster.ClusterDeviceInfo;
import com.android.tradefed.cluster.ClusterHostEvent;
import com.android.tradefed.cluster.ClusterHostUtil;
import com.android.tradefed.cluster.IClusterClient;
import com.android.tradefed.cluster.IClusterEventUploader;
import com.android.tradefed.cluster.IClusterOptions;
import com.android.tradefed.cluster.InvocationStatus;
import com.android.tradefed.cluster.SubprocessCommandException;
import com.android.tradefed.cluster.TestContext;
import com.android.tradefed.cluster.TestEnvironment;
import com.android.tradefed.cluster.TestGroupStatus;
import com.android.tradefed.cluster.TestResource;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NoDeviceException;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.battery.BatteryController;
import com.android.tradefed.device.battery.IBatteryInfo;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.ErrorStorageUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.StreamUtil;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public class ClusterCommandScheduler
extends CommandScheduler {
    private static final Set<InfraErrorIdentifier> NONE_RETRIABLE_CONFIG_ERRORS = new HashSet<InfraErrorIdentifier>(Arrays.asList(InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR));
    private ScheduledThreadPoolExecutor mHeartbeatThreadPool = null;
    private IClusterOptions mClusterOptions;
    private IClusterClient mClusterClient;

    @Override
    public void start() {
        this.UploadHostEventWithState(CommandScheduler.HostState.RUNNING);
        super.start();
    }

    @Override
    public void shutdown() {
        this.UploadHostEventWithState(CommandScheduler.HostState.QUITTING);
        this.getHeartbeatThreadPool().shutdown();
        super.shutdown();
    }

    @Override
    public synchronized void shutdownHard() {
        this.UploadHostEventWithState(CommandScheduler.HostState.KILLING);
        this.getHeartbeatThreadPool().shutdown();
        super.shutdownHard();
    }

    synchronized ScheduledThreadPoolExecutor getHeartbeatThreadPool() {
        if (this.mHeartbeatThreadPool == null) {
            this.mHeartbeatThreadPool = new ScheduledThreadPoolExecutor(1, new HeartbeatThreadFactory());
            this.mHeartbeatThreadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                    LogUtil.CLog.w("Rejecting Task %s rejected from executor %s", r.toString(), e.toString());
                }
            });
            this.mHeartbeatThreadPool.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
        }
        return this.mHeartbeatThreadPool;
    }

    @Override
    protected void processReadyCommands(IDeviceManager manager) {
        super.processReadyCommands(manager);
        if (this.isShuttingDown()) {
            return;
        }
        List<ClusterCommand> commands = null;
        MultiMap<String, DeviceDescriptor> devices = this.getAvailableDevices(manager);
        if (devices.isEmpty()) {
            LogUtil.CLog.d("No devices are available for testing.");
            return;
        }
        devices = this.getDevices(manager, false);
        commands = this.fetchHostCommands(devices);
        if (commands.isEmpty()) {
            LogUtil.CLog.d("No commands available for testing.");
            return;
        }
        if (this.isShuttingDown()) {
            LogUtil.CLog.d("Tradefed shutting down, unleasing commands.");
            this.unleaseCommands(commands);
            return;
        }
        this.execCommands(commands);
    }

    MultiMap<String, DeviceDescriptor> getAvailableDevices(IDeviceManager manager) {
        return this.getDevices(manager, true);
    }

    MultiMap<String, DeviceDescriptor> getDevices(IDeviceManager manager, boolean availableOnly) {
        MultiMap<String, DeviceDescriptor> devices = new MultiMap<String, DeviceDescriptor>();
        for (DeviceDescriptor device : manager.listAllDevices()) {
            TestDeviceState deviceState;
            if (availableOnly && device.getState() != DeviceAllocationState.Available || TestDeviceState.FASTBOOT.equals((Object)(deviceState = device.getTestDeviceState())) || TestDeviceState.FASTBOOTD.equals((Object)deviceState) || ClusterHostUtil.isLocalhostIpPort(device.getSerial())) continue;
            String runTargetFormat = this.getClusterOptions().getRunTargetFormat();
            String runTarget = ClusterHostUtil.getRunTarget(device, runTargetFormat, this.getClusterOptions().getDeviceTag());
            devices.put(runTarget, device);
        }
        return devices;
    }

    private int permitsAvailableToSchedule() {
        if (!this.getClusterOptions().checkPermitsOnLease()) {
            return Integer.MAX_VALUE;
        }
        for (IHostOptions.PermitLimitType permit : IHostOptions.PermitLimitType.values()) {
            if (this.getHostOptions().getAvailablePermits(permit) > 0) continue;
            LogUtil.CLog.i("There is no available '%s' permits. Not leasing any additional commands.", new Object[]{permit});
            return 0;
        }
        int heuriticPermitCalculation = this.getHostOptions().getAvailablePermits(IHostOptions.PermitLimitType.CONCURRENT_FLASHER) - this.getHostOptions().getInUsePermits(IHostOptions.PermitLimitType.CONCURRENT_DOWNLOAD);
        if (heuriticPermitCalculation < 0) {
            LogUtil.CLog.i("Download permits will exceed the flashing limit and might create permit delays. Not Leasing.");
            return 0;
        }
        return heuriticPermitCalculation;
    }

    private boolean checkDiskSpace() {
        if (this.getClusterOptions().maxDiskUsagePercentage() == 100L) {
            return true;
        }
        File rootPartition = new File("/");
        long freeSpace = (long)((double)rootPartition.getUsableSpace() * 100.0) / rootPartition.getTotalSpace();
        long usage = 100L - freeSpace;
        if (usage > this.getClusterOptions().maxDiskUsagePercentage()) {
            LogUtil.CLog.i("Disk space utilization is '%s%%'. Stop leasing.", usage);
            return false;
        }
        return true;
    }

    List<ClusterCommand> fetchHostCommands(MultiMap<String, DeviceDescriptor> devices) {
        LogUtil.CLog.d("fetching cluster host commands from leasehosttasks...");
        int permitsAvailable = this.permitsAvailableToSchedule();
        if (permitsAvailable <= 0) {
            return Collections.emptyList();
        }
        if (!this.checkDiskSpace()) {
            return Collections.emptyList();
        }
        IClusterOptions options = this.getClusterOptions();
        MultiMap<String, String> deviceGroups = options.getDeviceGroup();
        HashMap<String, String> deviceToGroup = new HashMap<String, String>();
        for (String string : deviceGroups.keySet()) {
            for (String deviceSerial : deviceGroups.get(string)) {
                deviceToGroup.put(deviceSerial, string);
            }
        }
        LinkedList<ClusterDeviceInfo> deviceInfos = new LinkedList<ClusterDeviceInfo>();
        for (String runTarget : devices.keySet()) {
            for (DeviceDescriptor d : devices.get(runTarget)) {
                String groupName = deviceToGroup.getOrDefault(d.getSerial(), null);
                ClusterDeviceInfo deviceInfo = new ClusterDeviceInfo.Builder().setDeviceDescriptor(d).setRunTarget(runTarget).setGroupName(groupName).build();
                deviceInfos.add(deviceInfo);
            }
        }
        try {
            int n = Math.min(deviceInfos.size(), permitsAvailable);
            List<ClusterCommand> commands = this.getClusterClient().leaseHostCommands(options.getClusterId(), ClusterHostUtil.getHostName(), deviceInfos, options.getNextClusterIds(), n);
            return commands;
        }
        catch (JSONException jSONException) {
            LogUtil.CLog.e(jSONException);
            return Collections.emptyList();
        }
    }

    void execCommands(List<ClusterCommand> commands) {
        int commandIdx = 0;
        for (ClusterCommand commandTask : commands) {
            ClusterCommandEvent.Builder eventBuilder;
            IClusterEventUploader<ClusterCommandEvent> eventUploader;
            if (this.isShuttingDown()) {
                LogUtil.CLog.d("Tradefed shutting down, unleasing remaining commands.");
                this.unleaseCommands(commands.subList(commandIdx, commands.size()));
                return;
            }
            try {
                InvocationEventHandler handler = new InvocationEventHandler(commandTask);
                switch (commandTask.getRequestType()) {
                    case UNMANAGED: {
                        this.execClusterCommand(commandTask, handler);
                        break;
                    }
                    case MANAGED: {
                        this.execManagedClusterCommand(commandTask, handler);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (NoDeviceException e) {
                LogUtil.CLog.w("no device meets requirements for cluster command [%s]; returning...", commandTask.getTaskId());
                LogUtil.CLog.w(e);
                eventUploader = this.getClusterClient().getCommandEventUploader();
                eventBuilder = ClusterCommandEvent.createEventBuilder(commandTask).setHostName(ClusterHostUtil.getHostName()).setType(ClusterCommandEvent.Type.AllocationFailed).setData("error", StreamUtil.getStackTrace(e));
                if (e.getErrorId() != null) {
                    eventBuilder.setData("error_name", e.getErrorId().name());
                    eventBuilder.setData("error_code", e.getErrorId().code());
                    eventBuilder.setData("error_status", ErrorStorageUtil.mapStatus(e.getErrorId().status()));
                }
                eventUploader.postEvent(eventBuilder.build());
                eventUploader.flush();
            }
            catch (ConfigurationException | IOException | RuntimeException e) {
                LogUtil.CLog.w("failed to execute cluster command [%s]: %s", commandTask.getTaskId(), e);
                LogUtil.CLog.w(e);
                eventUploader = this.getClusterClient().getCommandEventUploader();
                eventBuilder = ClusterCommandEvent.createEventBuilder(commandTask).setHostName(ClusterHostUtil.getHostName()).setType(ClusterCommandEvent.Type.ConfigurationError).setData("error", StreamUtil.getStackTrace(e));
                if (e instanceof IHarnessException && ((IHarnessException)((Object)e)).getErrorId() != null) {
                    ErrorIdentifier errorId = ((IHarnessException)((Object)e)).getErrorId();
                    eventBuilder.setData("error_name", errorId.name());
                    eventBuilder.setData("error_code", errorId.code());
                    eventBuilder.setData("error_status", ErrorStorageUtil.mapStatus(errorId.status()));
                }
                eventUploader.postEvent(eventBuilder.build());
                eventUploader.flush();
            }
            ++commandIdx;
        }
    }

    void execClusterCommand(ClusterCommand commandTask, InvocationEventHandler handler) throws ConfigurationException, IllegalArgumentException, NoDeviceException {
        String cmdLine = commandTask.getCommandLine();
        String[] args = QuotationAwareTokenizer.tokenizeLine(cmdLine);
        if (this.dryRunCommand(handler, args)) {
            return;
        }
        if (commandTask.getTargetDeviceSerials() != null) {
            for (String serial : commandTask.getTargetDeviceSerials()) {
                cmdLine = cmdLine + " --serial ";
                cmdLine = cmdLine + ClusterHostUtil.getLocalDeviceSerial(serial);
            }
        }
        LogUtil.CLog.i("executing cluster command: [%s] %s", commandTask.getTaskId(), cmdLine);
        this.execCommand(handler, QuotationAwareTokenizer.tokenizeLine(cmdLine));
    }

    ClusterCommandConfigBuilder getClusterCommandConfigBuilder() {
        return new ClusterCommandConfigBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void execManagedClusterCommand(ClusterCommand commandTask, InvocationEventHandler handler) throws IOException, ConfigurationException, NoDeviceException {
        File workDir = null;
        try {
            workDir = new File(System.getProperty("java.io.tmpdir"), commandTask.getAttemptId());
            workDir.mkdirs();
            String requestId = commandTask.getRequestId();
            String commandId = commandTask.getCommandId();
            IClusterClient client = this.getClusterClient();
            TestEnvironment testEnvironment = client.getTestEnvironment(requestId);
            List<TestResource> testResources = client.getTestResources(requestId);
            TestContext testContext = client.getTestContext(requestId, commandId);
            testResources.addAll(testContext.getTestResources());
            File configFile = this.getClusterCommandConfigBuilder().setWorkDir(workDir).setClusterCommand(commandTask).setTestEnvironment(testEnvironment).setTestResources(testResources).setTestContext(testContext).build();
            LogUtil.CLog.i("executing cluster command: [%s] %s", commandTask.getTaskId(), configFile);
            LogUtil.CLog.d("configFile: %s", FileUtil.readStringFromFile(configFile));
            handler.setWorkDir(workDir);
            this.execCommand(handler, new String[]{configFile.getAbsolutePath()});
            return;
        }
        catch (JSONException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (workDir == null) throw throwable;
                FileUtil.recursiveDelete(workDir);
                throw throwable;
            }
        }
    }

    protected boolean dryRunCommand(InvocationEventHandler handler, String[] args) throws ConfigurationException {
        IConfiguration config = null;
        try {
            config = this.createConfiguration(args);
        }
        catch (Throwable e) {
            throw new ConfigurationException("Failed to create dry-run config", e);
        }
        if (config.getCommandOptions().isDryRunMode()) {
            InvocationContext context = new InvocationContext();
            context.addDeviceBuildInfo("stub", new BuildInfo());
            handler.invocationStarted(context);
            config.validateOptions();
            handler.invocationEnded(0L);
            IInvocationContext nullMeta = null;
            handler.invocationComplete(nullMeta, null);
            return true;
        }
        return false;
    }

    IClusterOptions getClusterOptions() {
        if (this.mClusterOptions == null) {
            this.mClusterOptions = ClusterHostUtil.getClusterOptions();
        }
        return this.mClusterOptions;
    }

    IClusterClient getClusterClient() {
        if (this.mClusterClient == null) {
            this.mClusterClient = ClusterHostUtil.getClusterClient();
        }
        return this.mClusterClient;
    }

    private void UploadHostEventWithState(CommandScheduler.HostState state) {
        try {
            IClusterEventUploader<ClusterHostEvent> Uploader = this.getClusterClient().getHostEventUploader();
            ClusterHostEvent.Builder builder = new ClusterHostEvent.Builder().setHostEventType(ClusterHostEvent.HostEventType.HostStateChanged).setHostState(state);
            LogUtil.CLog.d("event uploading with state %s", state.toString());
            ClusterHostEvent event = builder.build();
            Uploader.postEvent(event);
            LogUtil.CLog.d("event %s uploaded with state %s", event.toString(), state.toString());
            Uploader.flush();
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("failed to upload host state %s to TFC: %s", state.toString(), e);
        }
    }

    private synchronized void unleaseCommands(List<ClusterCommand> commands) {
        IClusterEventUploader<ClusterCommandEvent> eventUploader = this.getClusterClient().getCommandEventUploader();
        for (ClusterCommand command : commands) {
            ClusterCommandEvent.Builder eventBuilder = ClusterCommandEvent.createEventBuilder(command).setHostName(ClusterHostUtil.getHostName()).setType(ClusterCommandEvent.Type.Unleased);
            eventUploader.postEvent(eventBuilder.build());
        }
        eventUploader.flush();
    }

    private static class HeartbeatThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup HB_GROUP;

        private HeartbeatThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(HB_GROUP, r);
            thread.setDaemon(true);
            return thread;
        }

        static {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            HB_GROUP = new ThreadGroup(tg, "ClusterCommandScheduler.heartbeat");
        }
    }

    class InvocationEventHandler
    extends CollectingTestListener
    implements ICommandScheduler.IScheduledInvocationListener,
    ITestSummaryListener {
        private ScheduledFuture<?> mHeartbeat;
        private final ClusterCommand mCommandTask;
        private Set<String> mDeviceSerials = new HashSet<String>();
        private String mSummary;
        private Set<String> processedSummaries = new HashSet<String>();
        private FailureDescription mFailureDescription;
        private String mError;
        private String mSubprocessCommandError;
        private File mWorkDir;
        private InvocationStatus mInvocationStatus;
        private boolean mCanceled = false;

        public InvocationEventHandler(ClusterCommand commandTask) {
            this.mCommandTask = commandTask;
        }

        public void setWorkDir(File dir) {
            this.mWorkDir = dir;
        }

        void setCanceled(boolean value) {
            this.mCanceled = value;
        }

        private ClusterCommandEvent.Builder createEventBuilder() {
            ClusterCommandEvent.Builder builder = ClusterCommandEvent.createEventBuilder(this.mCommandTask).setHostName(ClusterHostUtil.getHostName());
            if (!this.mDeviceSerials.isEmpty()) {
                builder.setDeviceSerials(this.mDeviceSerials);
            }
            return builder;
        }

        private void updateInvocationStatus() {
            if (!ClusterCommandScheduler.this.getClusterOptions().shouldUploadInvocationStatus().booleanValue()) {
                return;
            }
            InvocationStatus obj = new InvocationStatus();
            List<TestRunResult> testRunResults = this.getMergedTestRunResults();
            for (TestRunResult result : testRunResults) {
                TestGroupStatus testGroupStatus = new TestGroupStatus(result.getName(), result.getNumTests(), result.getNumCompleteTests(), result.getNumAllFailedTests(), result.getNumTestsInState(TestResult.TestStatus.PASSED), result.isRunComplete(), result.getElapsedTime());
                obj.addTestGroupStatus(testGroupStatus);
            }
            this.mInvocationStatus = obj;
        }

        @Override
        public void invocationInitiated(IInvocationContext context) {
            for (ITestDevice device : context.getDevices()) {
                this.mDeviceSerials.add(device.getSerialNumber());
            }
            ClusterCommandEvent event = this.createEventBuilder().setType(ClusterCommandEvent.Type.InvocationInitiated).build();
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().postEvent(event);
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().flush();
            this.mHeartbeat = this.startHeartbeat();
            for (ITestDevice device : context.getDevices()) {
                try {
                    IBatteryInfo info;
                    IBatteryInfo.BatteryState state = BatteryController.getDeviceChargingState(device);
                    if (!IBatteryInfo.BatteryState.NOT_CHARGING.equals((Object)state) || (info = BatteryController.getBatteryInfoForDevice(device)) == null) continue;
                    info.enableCharging(device);
                }
                catch (DeviceNotAvailableException e) {
                    LogUtil.CLog.e(e);
                }
            }
        }

        @Override
        public void invocationStarted(IInvocationContext context) {
            super.invocationStarted(context);
            ClusterCommandEvent event = this.createEventBuilder().setType(ClusterCommandEvent.Type.InvocationStarted).build();
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().postEvent(event);
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().flush();
        }

        @Override
        public void testRunStarted(String name, int numTests) {
            this.testRunStarted(name, numTests, 0);
        }

        @Override
        public void testRunStarted(String name, int numTests, int attemptNumber) {
            this.testRunStarted(name, numTests, attemptNumber, System.currentTimeMillis());
        }

        @Override
        public void testRunStarted(String name, int numTests, int attemptNumber, long startTime) {
            super.testRunStarted(name, numTests, attemptNumber, startTime);
            this.updateInvocationStatus();
        }

        @Override
        public void invocationFailed(Throwable cause) {
            super.invocationFailed(cause);
            this.mError = StreamUtil.getStackTrace(cause);
            if (cause instanceof SubprocessCommandException && cause.getCause() != null) {
                this.mSubprocessCommandError = cause.getCause().getMessage();
            }
        }

        @Override
        public void invocationFailed(FailureDescription failure) {
            super.invocationFailed(failure);
            this.mFailureDescription = failure;
            this.mError = failure.getErrorMessage();
            if (failure.getCause() != null) {
                Throwable cause = failure.getCause();
                this.mError = StreamUtil.getStackTrace(cause);
                if (cause instanceof HarnessRuntimeException && InfraErrorIdentifier.TRADEFED_SKIPPED_TESTS_DURING_SHUTDOWN.equals(((HarnessRuntimeException)cause).getErrorId())) {
                    ClusterCommandScheduler.this.unleaseCommands(Arrays.asList(this.mCommandTask));
                }
            }
        }

        @Override
        public void invocationEnded(long elapsedTime) {
            super.invocationEnded(elapsedTime);
            ClusterCommandEvent event = this.createEventBuilder().setType(ClusterCommandEvent.Type.InvocationEnded).setData("error", this.mError).setData("subprocess_command_error", this.mSubprocessCommandError).build();
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().postEvent(event);
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().flush();
        }

        @Override
        public void invocationComplete(IInvocationContext metadata, Map<ITestDevice, FreeDeviceState> devicesStates) {
            LogUtil.CLog.d("ClusterCommand invocationComplete start.");
            if (this.mWorkDir != null) {
                FileUtil.recursiveDelete(this.mWorkDir);
            }
            ErrorIdentifier errorId = null;
            if (this.getPrimaryBuildInfo() == null && this.mError == null) {
                this.mError = "build not found";
                try {
                    File f = FileUtil.createTempFile("test-filesystem", ".txt");
                    FileUtil.deleteFile(f);
                }
                catch (IOException e) {
                    errorId = InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR;
                    this.mError = String.format("[%s] Filesystem error on %s. Please notify lab admin.", errorId.name(), ClusterHostUtil.getHostName());
                }
            }
            if (errorId == null && this.mFailureDescription != null) {
                errorId = this.mFailureDescription.getErrorIdentifier();
            }
            String fetchBuildTimeMillis = "-1";
            String setupTimeMillis = "-1";
            String lostDevice = null;
            if (metadata != null) {
                fetchBuildTimeMillis = metadata.getAttributes().getUniqueMap().get(InvocationMetricLogger.InvocationMetricKey.FETCH_BUILD.toString());
                setupTimeMillis = metadata.getAttributes().getUniqueMap().get(InvocationMetricLogger.InvocationMetricKey.SETUP.toString());
                lostDevice = metadata.getAttributes().getUniqueMap().get(InvocationMetricLogger.InvocationMetricKey.DEVICE_LOST_DETECTED.toString());
            }
            if (this.mHeartbeat != null) {
                this.mHeartbeat.cancel(true);
            }
            this.updateInvocationStatus();
            ClusterCommandEvent.Builder eventBuilder = this.createEventBuilder().setType(ClusterCommandEvent.Type.InvocationCompleted).setInvocationStatus(this.mInvocationStatus).setData("error", this.mError).setData("subprocess_command_error", this.mSubprocessCommandError).setData("summary", this.mSummary).setData("fetch_build_time_millis", fetchBuildTimeMillis).setData("setup_time_millis", setupTimeMillis).setData("total_test_count", Integer.toString(this.getNumTotalTests())).setData("failed_test_count", Integer.toString(this.getNumAllFailedTests())).setData("passed_test_count", Integer.toString(this.getNumTestsInState(TestResult.TestStatus.PASSED))).setData("failed_test_run_count", Integer.toString(this.getNumAllFailedTestRuns()));
            if (errorId != null) {
                if (NONE_RETRIABLE_CONFIG_ERRORS.contains(errorId)) {
                    eventBuilder.setType(ClusterCommandEvent.Type.ConfigurationError);
                }
                eventBuilder.setData("error_name", errorId.name());
                eventBuilder.setData("error_code", errorId.code());
                eventBuilder.setData("error_status", ErrorStorageUtil.mapStatus(errorId.status()));
            }
            if (lostDevice != null) {
                eventBuilder.setData("device_lost_detected", lostDevice);
            }
            ClusterCommandEvent event = eventBuilder.build();
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().postEvent(event);
            ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().flush();
            LogUtil.CLog.d("ClusterCommand invocationComplete done.");
        }

        @Override
        public void putEarlySummary(List<TestSummary> summaries) {
            if (ClusterCommandScheduler.this.getClusterOptions().shouldCollectEarlyTestSummary()) {
                this.putSummary(summaries);
            }
        }

        @Override
        public void putSummary(List<TestSummary> summaries) {
            StringBuilder sb = new StringBuilder();
            for (TestSummary summary : summaries) {
                String summaryString = summary.getSummary().toString();
                if (this.processedSummaries.contains(summaryString)) continue;
                this.processedSummaries.add(summaryString);
                sb.append(summaryString);
                sb.append("\n");
            }
            this.mSummary = this.mSummary == null ? sb.toString() : this.mSummary + sb.toString();
        }

        private ScheduledFuture<?> startHeartbeat() {
            return ClusterCommandScheduler.this.getHeartbeatThreadPool().scheduleAtFixedRate(new HeartbeatSender(), 0L, ClusterCommandScheduler.this.getClusterOptions().getInvocationHeartbeatInterval(), TimeUnit.MILLISECONDS);
        }

        class HeartbeatSender
        implements Runnable {
            HeartbeatSender() {
            }

            @Override
            public void run() {
                try {
                    if (ClusterCommandScheduler.this.getClusterOptions().checkCommandState() && !InvocationEventHandler.this.mCanceled) {
                        ClusterCommandStatus commandStatus = ClusterCommandScheduler.this.getClusterClient().getCommandStatus(InvocationEventHandler.this.mCommandTask.getRequestId(), InvocationEventHandler.this.mCommandTask.getCommandId());
                        if (ClusterCommand.State.CANCELED.equals((Object)commandStatus.getState())) {
                            InvocationEventHandler.this.mCanceled = true;
                            String cause = String.format("The cluster client %s has marked command (requestId=%s, commandId=%s) canceled with reason: %s", ClusterCommandScheduler.this.getClusterClient().getClass().getSimpleName(), InvocationEventHandler.this.mCommandTask.getRequestId(), InvocationEventHandler.this.mCommandTask.getCommandId(), commandStatus.getCancelReason());
                            LogUtil.CLog.w("Stop invocation due to: %s", cause);
                            Optional.ofNullable(InvocationEventHandler.this.getInvocationContext()).map(IInvocationContext::getInvocationId).map(Ints::tryParse).ifPresent(invocationId -> ClusterCommandScheduler.this.stopInvocation((int)invocationId, cause));
                        } else if (ClusterCommand.State.COMPLETED.equals((Object)commandStatus.getState())) {
                            LogUtil.CLog.d("Invocation completed, skip reporting heartbeat.");
                            return;
                        }
                    }
                    ClusterCommandEvent event = InvocationEventHandler.this.createEventBuilder().setType(ClusterCommandEvent.Type.TestRunInProgress).setInvocationStatus(InvocationEventHandler.this.mInvocationStatus).build();
                    ClusterCommandScheduler.this.getClusterClient().getCommandEventUploader().postEvent(event);
                }
                catch (Exception e) {
                    LogUtil.CLog.e("Error sending heartbeat to TFC:");
                    LogUtil.CLog.e(e);
                }
            }
        }
    }
}

