/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.ClusterHostUtil;
import com.android.tradefed.command.remote.DeviceDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClusterDeviceInfo {
    private String mRunTarget;
    private String mGroupName;
    private DeviceDescriptor mDeviceDescriptor;
    private Map<String, String> mExtraInfo;

    private ClusterDeviceInfo(DeviceDescriptor deviceDescriptor, String runTarget, String groupName, Map<String, String> extraInfo) {
        this.mDeviceDescriptor = deviceDescriptor;
        this.mRunTarget = runTarget;
        this.mGroupName = groupName;
        this.mExtraInfo = new LinkedHashMap<String, String>(extraInfo);
    }

    public String getRunTarget() {
        return this.mRunTarget;
    }

    public String getGroupName() {
        return this.mGroupName;
    }

    public DeviceDescriptor getDeviceDescriptor() {
        return this.mDeviceDescriptor;
    }

    public Map<String, String> getExtraInfo() {
        return new LinkedHashMap<String, String>(this.mExtraInfo);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("device_serial", ClusterHostUtil.getUniqueDeviceSerial(this.mDeviceDescriptor));
        json.put("run_target", this.mRunTarget);
        json.put("build_id", this.mDeviceDescriptor.getBuildId());
        json.put("product", this.mDeviceDescriptor.getProduct());
        json.put("product_variant", this.mDeviceDescriptor.getProductVariant());
        json.put("sdk_version", this.mDeviceDescriptor.getSdkVersion());
        json.put("battery_level", this.mDeviceDescriptor.getBatteryLevel());
        json.put("mac_address", this.mDeviceDescriptor.getMacAddress());
        json.put("sim_state", this.mDeviceDescriptor.getSimState());
        json.put("sim_operator", this.mDeviceDescriptor.getSimOperator());
        json.put("state", this.mDeviceDescriptor.getState());
        json.put("is_stub_device", this.mDeviceDescriptor.isStubDevice());
        json.put("preconfigured_ip", this.mDeviceDescriptor.getPreconfiguredIp());
        json.put("preconfigured_device_num_offset", this.mDeviceDescriptor.getPreconfiguredDeviceNumOffset());
        json.put("group_name", this.mGroupName);
        JSONArray extraInfoKeyValuePairs = new JSONArray();
        for (Map.Entry<String, String> entry : this.mExtraInfo.entrySet()) {
            extraInfoKeyValuePairs.put(new JSONObject().put("key", entry.getKey()).put("value", entry.getValue()));
        }
        json.put("extra_info", extraInfoKeyValuePairs);
        return json;
    }

    public static class Builder {
        private DeviceDescriptor mDeviceDescriptor;
        private String mRunTarget;
        private String mGroupName;
        private Map<String, String> mExtraInfo = new LinkedHashMap<String, String>();

        public Builder setRunTarget(String runTarget) {
            this.mRunTarget = runTarget;
            return this;
        }

        public Builder setGroupName(String groupName) {
            this.mGroupName = groupName;
            return this;
        }

        public Builder setDeviceDescriptor(DeviceDescriptor deviceDescriptor) {
            this.mDeviceDescriptor = deviceDescriptor;
            this.mExtraInfo.put("hardware_revision", deviceDescriptor.getHardwareRevision());
            return this;
        }

        public Builder addExtraInfo(Map<String, String> extraInfo) {
            this.mExtraInfo.putAll(extraInfo);
            return this;
        }

        public ClusterDeviceInfo build() {
            ClusterDeviceInfo deviceInfo = new ClusterDeviceInfo(this.mDeviceDescriptor, this.mRunTarget, this.mGroupName, this.mExtraInfo);
            return deviceInfo;
        }
    }
}

