/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.ClusterDeviceInfo;
import com.android.tradefed.cluster.ClusterHostEvent;
import com.android.tradefed.cluster.ClusterHostUtil;
import com.android.tradefed.cluster.IClusterEventUploader;
import com.android.tradefed.cluster.IClusterOptions;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.monitoring.LabResourceDeviceMonitor;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.MonitoredEntity;
import com.google.dualhomelab.monitoringagent.resourcemonitoring.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@OptionClass(alias="cluster-device-monitor")
public class ClusterDeviceMonitor
extends LabResourceDeviceMonitor {
    @Option(name="host-info-cmd", description="A label and command to run periodically, to collect and send host info to the backend. May be repeated. Commands containing spaces should be double-quoted.")
    private Map<String, String> mHostInfoCmds = new HashMap<String, String>();
    private Map<String, String[]> mTokenizedHostInfoCmds = null;
    @Option(name="host-info-cmd-timeout", description="How long to wait for each host-info-cmd to complete, in millis. If the command times out, a (null) value will be passed to the backend for that particular command.")
    private long mHostInfoCmdTimeout = 5000L;
    private EventDispatcher mDispatcher;
    private IDeviceMonitor.DeviceLister mDeviceLister;

    @Override
    public void run() {
        super.run();
        if (ClusterHostUtil.getClusterOptions().isDeviceMonitorDisabled()) {
            return;
        }
        this.mDispatcher = this.getEventDispatcher();
        this.mDispatcher.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.mDispatcher != null && this.mDispatcher.isAlive()) {
            this.mDispatcher.cancel();
        }
    }

    @Override
    public void setDeviceLister(IDeviceMonitor.DeviceLister lister) {
        if (lister == null) {
            throw new NullPointerException();
        }
        super.setDeviceLister(lister);
        this.mDeviceLister = lister;
    }

    @Override
    public void notifyDeviceStateChange(String serial, DeviceAllocationState oldState, DeviceAllocationState newState) {
        super.notifyDeviceStateChange(serial, oldState, newState);
    }

    @VisibleForTesting
    EventDispatcher getEventDispatcher() {
        if (this.mDispatcher == null) {
            this.mDispatcher = new EventDispatcher();
        }
        return this.mDispatcher;
    }

    @VisibleForTesting
    List<DeviceDescriptor> listDevices() {
        return this.mDeviceLister.listDevices();
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    void tokenizeCommands() {
        if (this.mTokenizedHostInfoCmds != null && !this.mTokenizedHostInfoCmds.isEmpty()) {
            return;
        }
        this.mTokenizedHostInfoCmds = new HashMap<String, String[]>(this.mHostInfoCmds.size());
        for (Map.Entry<String, String> entry : this.mHostInfoCmds.entrySet()) {
            String key = entry.getKey();
            String cmd = entry.getValue();
            LogUtil.CLog.d("Tokenized key %s command: %s", key, cmd);
            this.mTokenizedHostInfoCmds.put(key, QuotationAwareTokenizer.tokenizeLine(cmd));
        }
    }

    Map<String, String> getAdditionalHostInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        this.tokenizeCommands();
        for (Map.Entry<String, String[]> entry : this.mTokenizedHostInfoCmds.entrySet()) {
            String key = entry.getKey();
            String[] cmd = entry.getValue();
            String cmdString = this.mHostInfoCmds.get(key);
            CommandResult result = this.getRunUtil().runTimedCmdSilently(this.mHostInfoCmdTimeout, cmd);
            LogUtil.CLog.d("Command %s result: %s", cmdString, result.getStatus().toString());
            if (result.getStatus() == CommandStatus.SUCCESS) {
                info.put(key, result.getStdout());
                continue;
            }
            info.put(key, result.getStderr());
        }
        return info;
    }

    class EventDispatcher
    extends Thread {
        private boolean mIsCanceled;
        private IClusterEventUploader<ClusterHostEvent> mEventUploader;
        private IClusterOptions mClusterOptions;

        public EventDispatcher() {
            super("ClusterDeviceMonitor.EventDispatcher");
            this.mIsCanceled = false;
            this.mEventUploader = null;
            this.mClusterOptions = null;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!this.mIsCanceled) {
                    this.dispatch();
                    ClusterDeviceMonitor.this.getRunUtil().sleep(ClusterHostUtil.getClusterOptions().getDeviceMonitorSnapshotInterval());
                }
            }
            catch (Exception e) {
                LogUtil.CLog.e(e);
            }
        }

        IClusterEventUploader<ClusterHostEvent> getEventUploader() {
            if (this.mEventUploader == null) {
                this.mEventUploader = ClusterHostUtil.getClusterClient().getHostEventUploader();
            }
            return this.mEventUploader;
        }

        IClusterOptions getClusterOptions() {
            if (this.mClusterOptions == null) {
                this.mClusterOptions = ClusterHostUtil.getClusterOptions();
            }
            return this.mClusterOptions;
        }

        void dispatch() {
            LogUtil.CLog.d("Start device snapshot.");
            IClusterEventUploader<ClusterHostEvent> eventUploader = this.getEventUploader();
            List<DeviceDescriptor> devices = ClusterDeviceMonitor.this.listDevices();
            ClusterHostEvent.Builder builder = new ClusterHostEvent.Builder().setHostEventType(ClusterHostEvent.HostEventType.DeviceSnapshot).setData(ClusterDeviceMonitor.this.getAdditionalHostInfo()).setData("label", String.join((CharSequence)",", this.getClusterOptions().getLabels())).setClusterId(this.getClusterOptions().getClusterId()).setNextClusterIds(this.getClusterOptions().getNextClusterIds()).setLabName(this.getClusterOptions().getLabName());
            Map<String, Map<String, String>> extraInfoByDevice = this.getExtraInfoByDevice();
            for (DeviceDescriptor device : devices) {
                if (device.isTemporary() || ClusterHostUtil.isLocalhostIpPort(device.getSerial())) continue;
                ClusterDeviceInfo.Builder deviceBuilder = new ClusterDeviceInfo.Builder();
                String runTargetFormat = this.getClusterOptions().getRunTargetFormat();
                deviceBuilder.setDeviceDescriptor(device);
                deviceBuilder.setRunTarget(ClusterHostUtil.getRunTarget(device, runTargetFormat, this.getClusterOptions().getDeviceTag()));
                if (extraInfoByDevice.containsKey(device.getSerial())) {
                    deviceBuilder.addExtraInfo(extraInfoByDevice.get(device.getSerial()));
                }
                builder.addDeviceInfo(deviceBuilder.build());
            }
            LogUtil.CLog.d("Dispatched devicesnapshot.");
            eventUploader.postEvent(builder.build());
            eventUploader.flush();
        }

        private Map<String, Map<String, String>> getExtraInfoByDevice() {
            return ClusterDeviceMonitor.this.getCachedLabResource().getDeviceList().stream().collect(Collectors.toMap(deviceEntity -> deviceEntity.getIdentifierMap().get("device_serial"), this::getExtraInfoFromDeviceEntity));
        }

        private Map<String, String> getExtraInfoFromDeviceEntity(MonitoredEntity deviceEntity) {
            return deviceEntity.getResourceList().stream().map(this::getExtraInfoFromResource).reduce(new HashMap(), this::mergeMap);
        }

        private Map<String, String> mergeMap(Map<String, String> m1, Map<String, String> m2) {
            m1.putAll(m2);
            return m1;
        }

        private Map<String, String> getExtraInfoFromResource(Resource resource) {
            return resource.getMetricList().stream().collect(Collectors.toMap(metric -> resource.getResourceName().toString() + "-" + metric.getTag().toString(), metric -> String.valueOf(metric.getValue())));
        }

        void cancel() {
            this.mIsCanceled = true;
        }

        boolean isCanceled() {
            return this.mIsCanceled;
        }
    }
}

