/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.IClusterEvent;
import com.android.tradefed.cluster.IClusterEventUploader;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ClusterEventUploader<T extends IClusterEvent>
implements IClusterEventUploader<T> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 200;
    private static final long DEFAULT_EVENT_UPLOAD_INTERVAL = 60000L;
    private int mMaxBatchSize = 200;
    private long mEventUploadInterval = 60000L;
    private long mLastEventUploadTime = 0L;
    private Queue<T> mEventQueue = new ConcurrentLinkedQueue<T>();

    @Override
    public void setMaxBatchSize(int batchSize) {
        this.mMaxBatchSize = batchSize;
    }

    @Override
    public int getMaxBatchSize() {
        return this.mMaxBatchSize;
    }

    @Override
    public void setEventUploadInterval(long interval) {
        this.mEventUploadInterval = interval;
    }

    @Override
    public long getEventUploadInterval() {
        return this.mEventUploadInterval;
    }

    @Override
    public void postEvent(T event) {
        this.mEventQueue.add(event);
        this.uploadEvents(false);
    }

    @Override
    public void flush() {
        this.uploadEvents(true);
    }

    private void uploadEvents(boolean uploadNow) {
        long now = System.currentTimeMillis();
        if (!uploadNow && now - this.mLastEventUploadTime < this.getEventUploadInterval()) {
            return;
        }
        this.uploadEvents();
    }

    private synchronized void uploadEvents() {
        this.mLastEventUploadTime = System.currentTimeMillis();
        ArrayList<IClusterEvent> events = new ArrayList<IClusterEvent>();
        try {
            while (!this.mEventQueue.isEmpty()) {
                int batchSize = this.getMaxBatchSize();
                while (!this.mEventQueue.isEmpty() && events.size() < batchSize) {
                    events.add((IClusterEvent)this.mEventQueue.poll());
                }
                this.doUploadEvents(events);
                events.clear();
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w("failed to upload events: %s", e);
            LogUtil.CLog.w("events will be uploaded with the next event.");
            this.mEventQueue.addAll(events);
        }
    }

    protected abstract void doUploadEvents(List<T> var1) throws IOException;
}

