/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.ClusterDeviceInfo;
import com.android.tradefed.cluster.ClusterHostUtil;
import com.android.tradefed.cluster.IClusterEvent;
import com.android.tradefed.command.CommandScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClusterHostEvent
implements IClusterEvent {
    private long mTimestamp;
    private String mClusterId;
    private List<String> mNextClusterIds;
    private List<ClusterDeviceInfo> mDeviceInfos = new ArrayList<ClusterDeviceInfo>();
    private Map<String, String> mData = new HashMap<String, String>();
    private String mLabName;
    public static final String EVENT_QUEUE = "host-event-queue";
    public static final String LABEL_KEY = "label";
    public static final String HOST_IP_KEY = "host_ip";
    public static final String TEST_HARNESS_START_TIME_KEY = "test_harness_start_time_ms";
    public static final String TRADEFED = "TRADEFED";
    private HostEventType mType;
    private CommandScheduler.HostState mHostState = CommandScheduler.HostState.UNKNOWN;

    private ClusterHostEvent() {
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public String getHostName() {
        return ClusterHostUtil.getHostName();
    }

    @Deprecated
    public String getTfVersion() {
        return this.getTestHarnessVersion();
    }

    public String getTestHarnessVersion() {
        return ClusterHostUtil.getTfVersion();
    }

    public String getTestHarness() {
        return TRADEFED;
    }

    public String getClusterId() {
        return this.mClusterId;
    }

    public CommandScheduler.HostState getHostState() {
        return this.mHostState;
    }

    public List<ClusterDeviceInfo> getDeviceInfos() {
        return this.mDeviceInfos;
    }

    public Map<String, String> getData() {
        return this.mData;
    }

    public HostEventType getType() {
        return this.mType;
    }

    public List<String> getNextClusterIds() {
        return this.mNextClusterIds;
    }

    public String getLabName() {
        return this.mLabName;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("time", this.getTimestamp() / 1000L);
        if (this.getType() != null) {
            json.put("type", this.getType().toString());
        }
        json.put("hostname", this.getHostName());
        json.put("tf_version", this.getTestHarnessVersion());
        json.put("test_harness_version", this.getTestHarnessVersion());
        json.put("test_harness", this.getTestHarness());
        json.put("cluster", this.getClusterId());
        JSONArray deviceInfos = new JSONArray();
        for (ClusterDeviceInfo d : this.getDeviceInfos()) {
            deviceInfos.put(d.toJSON());
        }
        json.put("device_infos", deviceInfos);
        json.put("data", new JSONObject(this.getData()));
        if (this.getNextClusterIds() != null) {
            json.put("next_cluster_ids", new JSONArray(this.getNextClusterIds()));
        }
        if (this.getLabName() != null) {
            json.put("lab_name", this.getLabName());
        }
        json.put("state", this.getHostState().toString());
        return json;
    }

    public static enum HostEventType {
        DeviceSnapshot("DeviceSnapshot", "DEVICE_SNAPSHOT"),
        HostStateChanged("HostStateChanged", "HOST_STATE_CHANGED");

        private final String mName;
        private final String mAndroidEngProdAPIName;

        private HostEventType(String name, String androidEngProdAPIName) {
            this.mName = name;
            this.mAndroidEngProdAPIName = androidEngProdAPIName;
        }

        public String toString() {
            return this.mName;
        }

        public String getAndroidEngProdAPIName() {
            return this.mAndroidEngProdAPIName;
        }
    }

    public static class Builder {
        private HostEventType mType;
        private long mTimestamp = System.currentTimeMillis();
        private String mClusterId;
        private List<String> mNextClusterIds;
        private List<ClusterDeviceInfo> mDeviceInfos = new ArrayList<ClusterDeviceInfo>();
        private Map<String, String> mData = new HashMap<String, String>();
        private CommandScheduler.HostState mHostState = CommandScheduler.HostState.UNKNOWN;
        private String mLabName;

        public Builder() {
            this.mData.put(ClusterHostEvent.HOST_IP_KEY, ClusterHostUtil.getHostIpAddress());
            this.mData.put(ClusterHostEvent.TEST_HARNESS_START_TIME_KEY, String.valueOf(ClusterHostUtil.getTfStartTimeMillis()));
        }

        public Builder setHostEventType(HostEventType type) {
            this.mType = type;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        public Builder setClusterId(String clusterId) {
            this.mClusterId = clusterId;
            return this;
        }

        public Builder addDeviceInfo(ClusterDeviceInfo deviceInfo) {
            this.mDeviceInfos.add(deviceInfo);
            return this;
        }

        public Builder addDeviceInfos(List<ClusterDeviceInfo> deviceInfos) {
            this.mDeviceInfos.addAll(deviceInfos);
            return this;
        }

        public Builder setData(String name, String value) {
            this.mData.put(name, value);
            return this;
        }

        public Builder setData(Map<String, String> data) {
            this.mData.putAll(data);
            return this;
        }

        public Builder setNextClusterIds(List<String> nexClusterIds) {
            this.mNextClusterIds = nexClusterIds;
            return this;
        }

        public Builder setHostState(CommandScheduler.HostState state) {
            this.mHostState = state;
            return this;
        }

        public Builder setLabName(String labName) {
            this.mLabName = labName;
            return this;
        }

        public ClusterHostEvent build() {
            ClusterHostEvent event = new ClusterHostEvent();
            event.mType = this.mType;
            event.mTimestamp = this.mTimestamp;
            event.mClusterId = this.mClusterId;
            event.mDeviceInfos = new ArrayList<ClusterDeviceInfo>(this.mDeviceInfos);
            event.mData = new HashMap<String, String>(this.mData);
            event.mNextClusterIds = this.mNextClusterIds;
            event.mHostState = this.mHostState;
            event.mLabName = this.mLabName;
            return event;
        }
    }
}

