/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.IClusterClient;
import com.android.tradefed.cluster.IClusterOptions;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.VersionParser;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Longs;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClusterHostUtil {
    private static String sHostName = null;
    private static String sHostIpAddress = null;
    static final String DEFAULT_TF_VERSION = "(unknown)";
    static final String EMULATOR_SERIAL_PREFIX = "emulator-";
    static final String NULL_DEVICE_SERIAL_PLACEHOLDER = "(no device serial)";
    static final String UNKNOWN = "UNKNOWN";
    static final String TRADEFED = "TRADEFED";
    static final String LOCALHOST_IP = "127.0.0.1";
    static final String LOCALHOST_NAME = "localhost";
    private static long sTfStartTime = ClusterHostUtil.getCurrentTimeMillis();

    public static String getHostName() {
        if (sHostName != null) {
            return sHostName;
        }
        try {
            sHostName = InetAddress.getLocalHost().getHostName();
            return sHostName;
        }
        catch (UnknownHostException e) {
            LogUtil.CLog.w("Failed to get hostname from InetAddress: %s", e);
            LogUtil.CLog.i("Get hostname from HOSTNAME env.");
            sHostName = System.getenv("HOSTNAME");
            if (!Strings.isNullOrEmpty(sHostName)) {
                return sHostName;
            }
            sHostName = "unknown-" + UUID.randomUUID().toString();
            LogUtil.CLog.i("No HOSTNAME env set. Generate hostname: %s.", sHostName);
            return sHostName;
        }
    }

    public static String getUniqueDeviceSerial(DeviceDescriptor device) {
        String serial = device.getSerial();
        if (Strings.isNullOrEmpty(serial)) {
            return String.format("%s:%s", ClusterHostUtil.getHostName(), NULL_DEVICE_SERIAL_PLACEHOLDER);
        }
        if (device.isStubDevice() && !DeviceManager.FastbootDevice.class.getSimpleName().equals(device.getDeviceClass()) || serial.startsWith(EMULATOR_SERIAL_PREFIX)) {
            return String.format("%s:%s", ClusterHostUtil.getHostName(), serial);
        }
        return serial;
    }

    public static String getLocalDeviceSerial(String serial) {
        String prefix = ClusterHostUtil.getHostName() + ":";
        if (serial.startsWith(prefix)) {
            return serial.substring(prefix.length());
        }
        return serial;
    }

    public static String getHostIpAddress() {
        if (sHostIpAddress == null) {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces == null) {
                    return UNKNOWN;
                }
                for (NetworkInterface networkInterface : Collections.list(interfaces)) {
                    if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                    for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                        if (address.isLinkLocalAddress() || address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                        addresses.add(address);
                    }
                }
            }
            catch (SocketException e) {
                LogUtil.CLog.w(e);
            }
            if (!addresses.isEmpty()) {
                sHostIpAddress = ((InetAddress)addresses.get(0)).getHostAddress();
            }
        }
        return sHostIpAddress == null ? UNKNOWN : sHostIpAddress;
    }

    public static String getTfVersion() {
        String version = VersionParser.fetchVersion();
        return ClusterHostUtil.toValidTfVersion(version);
    }

    protected static String toValidTfVersion(String version) {
        if (Strings.isNullOrEmpty(version) || Longs.tryParse(version) == null) {
            return DEFAULT_TF_VERSION;
        }
        return version;
    }

    public static String getRunTarget(DeviceDescriptor device, String runTargetFormat, Map<String, String> deviceTags) {
        if (runTargetFormat != null) {
            Pattern p = Pattern.compile("\\{([^:\\}]+)(:.*)?\\}");
            Matcher m = p.matcher(runTargetFormat);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String pattern = m.group(1);
                String key = null;
                String txt = null;
                switch (pattern) {
                    case "PRODUCT": {
                        txt = device.getProduct();
                        break;
                    }
                    case "PRODUCT_OR_DEVICE_CLASS": {
                        txt = device.getProduct();
                        if (!device.isStubDevice()) break;
                        String deviceClass = device.getDeviceClass();
                        if (DeviceManager.FastbootDevice.class.getSimpleName().equals(deviceClass)) break;
                        txt = deviceClass;
                        break;
                    }
                    case "PRODUCT_VARIANT": {
                        txt = device.getProductVariant();
                        break;
                    }
                    case "API_LEVEL": {
                        txt = device.getSdkVersion();
                        break;
                    }
                    case "DEVICE_CLASS": {
                        txt = device.getDeviceClass();
                        break;
                    }
                    case "SERIAL": {
                        txt = ClusterHostUtil.getUniqueDeviceSerial(device);
                        break;
                    }
                    case "TAG": {
                        if (deviceTags == null || deviceTags.isEmpty()) {
                            txt = "";
                            break;
                        }
                        txt = deviceTags.get(device.getSerial());
                        if (txt != null) break;
                        txt = "";
                        break;
                    }
                    case "DEVICE_PROP": {
                        key = m.group(2).substring(1);
                        txt = device.getProperty(key);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(String.format("Unsupported pattern '%s' found for run target '%s'", pattern, runTargetFormat));
                    }
                }
                if (txt == null || "unknown".equals(txt)) {
                    return "unknown";
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(txt));
            }
            m.appendTail(sb);
            return sb.toString();
        }
        String runTarget = device.getProduct();
        if (!runTarget.equals(device.getProductVariant())) {
            runTarget = runTarget + ":" + device.getProductVariant();
        }
        return runTarget;
    }

    public static boolean isLocalhostIpPort(String input) {
        try {
            HostAndPort hostAndPort = HostAndPort.fromString(input);
            return LOCALHOST_IP.equals(hostAndPort.getHost()) || LOCALHOST_NAME.equals(hostAndPort.getHost());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getTfStartTimeMillis() {
        return sTfStartTime;
    }

    public static IClusterOptions getClusterOptions() {
        IClusterOptions clusterOptions = (IClusterOptions)GlobalConfiguration.getInstance().getConfigurationObject("cluster_options");
        if (clusterOptions == null) {
            throw new IllegalStateException("cluster_options not defined. You must add this object to your global config. See google/atp/cluster.xml.");
        }
        return clusterOptions;
    }

    public static IClusterClient getClusterClient() {
        IClusterClient ClusterClient2 = (IClusterClient)GlobalConfiguration.getInstance().getConfigurationObject("cluster_client");
        if (ClusterClient2 == null) {
            throw new IllegalStateException("cluster_client not defined. You must add this object to your global config. See google/atp/cluster.xml.");
        }
        return ClusterClient2;
    }

    public static String getTestHarness() {
        return TRADEFED;
    }
}

