/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.IClusterClient;
import com.android.tradefed.cluster.TestContext;
import com.android.tradefed.cluster.TestOutputUploader;
import com.android.tradefed.cluster.TestResource;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONException;

@OptionClass(alias="cluster", global_namespace=false)
public class ClusterLogSaver
implements ILogSaver {
    public static final String FILE_NAMES_FILE_NAME = "FILES";
    public static final String TOOL_LOG_PATH = "tool-logs";
    @Option(name="root-dir", description="A root directory", mandatory=true)
    private File mRootDir;
    @Option(name="request-id", description="A request ID", mandatory=true)
    private String mRequestId;
    @Option(name="command-id", description="A command ID", mandatory=true)
    private String mCommandId;
    @Option(name="attempt-id", description="A command attempt ID", mandatory=true)
    private String mAttemptId;
    @Option(name="output-file-upload-url", description="URL to upload output files to", mandatory=true)
    private String mOutputFileUploadUrl;
    @Option(name="output-file-pattern", description="Output file patterns")
    private List<String> mOutputFilePatterns = new ArrayList<String>();
    @Option(name="context-file-pattern", description="A regex pattern for test context file(s). A test context file is a file to be used in successive invocations to pass context information.")
    private String mContextFilePattern = null;
    @Option(name="file-picking-strategy", description="A picking strategy for file(s)")
    private FilePickingStrategy mFilePickingStrategy = FilePickingStrategy.PICK_LAST;
    @Option(name="extra-context-file", description="Additional files to include in the context file. Context file must be a ZIP archive.")
    private List<String> mExtraContextFiles = new ArrayList<String>();
    @Option(name="retry-command-line", description="A command line to store in test context. This will replace the original command line in a retry invocation.")
    private String mRetryCommandLine = null;
    private File mLogDir;
    private LogFileSaver mLogFileSaver = null;
    private IClusterClient mClusterClient = null;

    @Override
    public void invocationStarted(IInvocationContext context) {
        this.mLogDir = new File(this.mRootDir, "logs");
        this.mLogFileSaver = new LogFileSaver(this.mLogDir);
    }

    private Path getRelativePath(Path p) {
        return this.mRootDir.toPath().relativize(p);
    }

    private Stream<Path> getPathStream(File dir, Pattern pattern) throws IOException {
        return Files.find(dir.toPath(), Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && pattern.matcher(this.getRelativePath((Path)path).toString()).matches(), FileVisitOption.FOLLOW_LINKS);
    }

    private Set<File> findFilesRecursively(File dir, String regex) {
        Set<File> set;
        block8: {
            Pattern pattern = Pattern.compile(regex);
            Stream<Path> stream = this.getPathStream(dir, pattern);
            try {
                set = stream.map(Path::toFile).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to collect output files", e);
                }
            }
            stream.close();
        }
        return set;
    }

    private Set<String> getGroupNames(String regex) {
        TreeSet<String> names = new TreeSet<String>();
        Matcher m = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>").matcher(regex);
        while (m.find()) {
            names.add(m.group(1));
        }
        return names;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    File findTestContextFile(File dir, String regex, FilePickingStrategy strategy, Map<String, String> envVars) {
        Pattern pattern = Pattern.compile(regex);
        try (Stream<Path> stream = this.getPathStream(dir, pattern);){
            Optional<Path> op = null;
            switch (strategy) {
                case PICK_FIRST: {
                    op = stream.sorted().findFirst();
                    break;
                }
                case PICK_LAST: {
                    op = stream.sorted(Comparator.reverseOrder()).findFirst();
                    break;
                }
            }
            if (op == null || !op.isPresent()) {
                File file3 = null;
                return file3;
            }
            Path p = op.get();
            Set<String> groupNames = this.getGroupNames(regex);
            LogUtil.CLog.d("Context var names: %s", groupNames);
            Path relPath = dir.toPath().relativize(p);
            Matcher matcher = pattern.matcher(relPath.toString());
            matcher.matches();
            for (String name : groupNames) {
                String value = matcher.group(name);
                if (value == null) continue;
                envVars.put(name, value);
            }
            File file2 = p.toFile();
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to collect a context file", e);
        }
    }

    private String getDestinationPath(String prefix, File file2) {
        String filename = file2.getName();
        return prefix == null ? filename : Paths.get(prefix, filename).toString();
    }

    private void writeFilenamesToFile(Set<String> filenames, File destFile) throws IOException {
        String content = filenames.stream().sorted().collect(Collectors.joining("\n"));
        FileUtil.writeToFile(content, destFile);
    }

    private Map<File, String> uploadFiles(Map<File, String> fileMap, FilePickingStrategy strategy) {
        Map<String, File> destinationMap = fileMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toMap(e -> this.getDestinationPath((String)e.getValue(), (File)e.getKey()), Map.Entry::getKey, (first, second) -> strategy == FilePickingStrategy.PICK_FIRST ? first : second));
        fileMap.keySet().retainAll(destinationMap.values());
        LogUtil.CLog.i("Collected %d files to upload", fileMap.size());
        fileMap.keySet().forEach(f -> LogUtil.CLog.i(f.getAbsolutePath()));
        File fileNamesFile = new File(this.mRootDir, FILE_NAMES_FILE_NAME);
        try {
            this.writeFilenamesToFile(destinationMap.keySet(), fileNamesFile);
        }
        catch (IOException e2) {
            LogUtil.CLog.e("Failed to write %s", fileNamesFile.getAbsolutePath());
        }
        TestOutputUploader uploader = this.getTestOutputUploader();
        try {
            uploader.setUploadUrl(this.mOutputFileUploadUrl);
        }
        catch (MalformedURLException e3) {
            throw new RuntimeException("Failed to set upload URL", e3);
        }
        fileMap.put(fileNamesFile, null);
        TreeMap<File, String> fileUrls = new TreeMap<File, String>();
        int index = 1;
        for (Map.Entry<File, String> entry : fileMap.entrySet()) {
            File file2 = entry.getKey();
            LogUtil.CLog.i("Uploading file %d of %d: %s", index, fileMap.size(), file2.getAbsolutePath());
            try {
                fileUrls.put(file2, uploader.uploadFile(file2, entry.getValue()));
            }
            catch (IOException | RuntimeException e4) {
                LogUtil.CLog.e("Failed to upload %s: %s", file2, e4);
            }
            ++index;
        }
        return fileUrls;
    }

    void appendFilesToContext(File contextFile, List<String> filesToAdd) {
        if (filesToAdd.isEmpty()) {
            return;
        }
        URI uri = URI.create("jar:" + contextFile.toURI());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem zip = FileSystems.newFileSystem(uri, env);){
            for (String filename : filesToAdd) {
                Path path = Paths.get(filename, new String[0]);
                if (!path.isAbsolute()) {
                    path = this.mRootDir.toPath().resolve(path);
                }
                if (!path.toFile().exists()) {
                    LogUtil.CLog.w("File %s not found", path);
                    continue;
                }
                Path zipPath = zip.getPath(path.getFileName().toString(), new String[0]);
                Files.copy(path, zipPath, new CopyOption[0]);
            }
        }
        catch (IOException | RuntimeException e) {
            LogUtil.CLog.w("Failed to append files to context");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        HashMap<File, String> outputFiles = new HashMap<File, String>();
        File contextFile = null;
        TreeMap<String, String> envVars = new TreeMap<String, String>();
        this.findFilesRecursively(this.mLogDir, "^((?!host_log_\\d+).)*$").forEach(file2 -> outputFiles.put((File)file2, TOOL_LOG_PATH));
        if (0 < this.mOutputFilePatterns.size()) {
            String regex = this.mOutputFilePatterns.stream().map(s -> "(" + s + ")").collect(Collectors.joining("|"));
            LogUtil.CLog.i("Collecting output files matching regex: " + regex);
            this.findFilesRecursively(this.mRootDir, regex).forEach(file2 -> outputFiles.put((File)file2, (String)null));
        }
        if (this.mContextFilePattern != null) {
            LogUtil.CLog.i("Collecting context file matching regex: " + this.mContextFilePattern);
            contextFile = this.findTestContextFile(this.mRootDir, this.mContextFilePattern, this.mFilePickingStrategy, envVars);
            if (contextFile != null) {
                LogUtil.CLog.i("Context file = %s", contextFile.getAbsolutePath());
                outputFiles.put(contextFile, null);
                this.appendFilesToContext(contextFile, this.mExtraContextFiles);
            } else {
                LogUtil.CLog.i("No context file found");
            }
        }
        Map<File, String> outputFileUrls = this.uploadFiles(outputFiles, this.mFilePickingStrategy);
        if (contextFile != null && outputFileUrls.containsKey(contextFile)) {
            IClusterClient client = this.getClusterClient();
            TestContext testContext = new TestContext();
            testContext.setCommandLine(this.mRetryCommandLine);
            testContext.addEnvVars(envVars);
            String name = this.getRelativePath(contextFile.toPath()).toString();
            testContext.addTestResource(new TestResource(name, outputFileUrls.get(contextFile)));
            try {
                LogUtil.CLog.i("Updating test context: %s", testContext.toString());
                client.updateTestContext(this.mRequestId, this.mCommandId, testContext);
            }
            catch (IOException | JSONException e) {
                throw new RuntimeException("failed to update test context", e);
            }
        }
    }

    TestOutputUploader getTestOutputUploader() {
        return new TestOutputUploader();
    }

    IClusterClient getClusterClient() {
        if (this.mClusterClient == null) {
            this.mClusterClient = (IClusterClient)GlobalConfiguration.getInstance().getConfigurationObject("cluster_client");
            if (this.mClusterClient == null) {
                throw new IllegalStateException("cluster_client not defined in TF global config.");
            }
        }
        return this.mClusterClient;
    }

    @Override
    public LogFile saveLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        File log = this.mLogFileSaver.saveLogData(dataName, dataType, dataStream);
        return new LogFile(log.getAbsolutePath(), null, dataType);
    }

    @Override
    public LogFile getLogReportDir() {
        return new LogFile(this.mLogDir.getAbsolutePath(), null, LogDataType.DIR);
    }

    String getAttemptId() {
        return this.mAttemptId;
    }

    String getOutputFileUploadUrl() {
        return this.mOutputFileUploadUrl;
    }

    List<String> getOutputFilePatterns() {
        return this.mOutputFilePatterns;
    }

    public static enum FilePickingStrategy {
        PICK_LAST,
        PICK_FIRST;

    }
}

