/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.IClusterOptions;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.util.MultiMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@OptionClass(alias="cluster", global_namespace=false)
public class ClusterOptions
implements IClusterOptions {
    public static final String TYPE_NAME = "cluster_options";
    @Option(name="service-url", description="the base url of the tradefed cluster REST API")
    public String mServiceUrl = null;
    @Option(name="service-account-keyfile", description="The service account json key file. This is used by tradefed test scheduler (e.g. Tradefed Cluster) to authenticate the tradefed host. See google doc for the definition and how service account key works. https://cloud.google.com/iam/docs/service-accounts ")
    private File mSchedulerServiceAccountKeyfile = null;
    @Option(name="cluster", description="the cluster id for this TF instance", mandatory=true)
    public String mClusterId = null;
    @Option(name="next-cluster", description="seconadary clusters for this TF instance to run commands from. If this option is set, TF will try to lease commands from these clusters in the order they are specified if it still has available devices after leasing commands from the primary cluster.")
    public List<String> mNextClusterIds = new ArrayList<String>();
    @Option(name="run-target-format", description="the format for labelling run targets.")
    private String mRunTargetFormat = null;
    @Option(name="disable-device-monitor", description="disable Cluster device reporting")
    private boolean mIsDeviceMonitorDisabled = false;
    @Option(name="device-monitor-interval", isTimeVal=true, description="the time interval between each device snapshot")
    private long mDeviceMonitorSnapshotInterval = 60000L;
    @Option(name="device-group", description="A multi-map from device group to device serials. The key is a device group name and value is device serial.")
    private MultiMap<String, String> mDeviceGroup = new MultiMap();
    @Option(name="device-tag", description="A map for tagging device serials; each device may have one tag. This can be used for reporting in run-target")
    private Map<String, String> mDeviceTag = new HashMap<String, String>();
    @Option(name="check-permits-on-lease", description="Check all available permits types when leasing tasks")
    private boolean mCheckPermitsOnLease = true;
    @Option(name="invocation-heartbeat-interval", isTimeVal=true, description="The time interval between invocation heartbeats")
    private long mInvocationHeartbeatInterval = 300000L;
    @Option(name="upload-invocation-status", description="Upload invocation status to TFC")
    private Boolean mShouldUploadInvocationStatus = false;
    @Option(name="check-command-state", description="Check cluster command state to detect canceled invocations")
    private boolean mCheckCommandState = false;
    @Option(name="connect-timeout", description="HTTP connect timeout.", isTimeVal=true)
    private int mConnectTimeout = 60000;
    @Option(name="read-timeout", description="HTTP read timeout.", isTimeVal=true)
    private int mReadTimeout = 60000;
    @Option(name="label", description="Labels to describe the host.")
    private List<String> mLabels = new ArrayList<String>();
    @Option(name="lab-name", description="The name of the lab the host belong to.")
    private String mLabName;
    @Option(name="collect-early-test-summary", description="Collect early test summary from ITestSummaryListener to scheduler.")
    private boolean mCollectEarlyTestSummary = false;
    @Option(name="max-disk-usage", description="Percentage allowed disk usage before we stop leasing tasks.")
    private long mMaximalDiskUsagePercentage = 100L;

    @Override
    public String getServiceUrl() {
        return this.mServiceUrl;
    }

    @Override
    public String getClusterId() {
        return this.mClusterId;
    }

    @Override
    public List<String> getNextClusterIds() {
        return this.mNextClusterIds;
    }

    @Override
    public MultiMap<String, String> getDeviceGroup() {
        return this.mDeviceGroup;
    }

    @Override
    public Map<String, String> getDeviceTag() {
        return this.mDeviceTag;
    }

    @Override
    public boolean checkPermitsOnLease() {
        return this.mCheckPermitsOnLease;
    }

    @Override
    public String getRunTargetFormat() {
        return this.mRunTargetFormat;
    }

    @Override
    public boolean isDeviceMonitorDisabled() {
        return this.mIsDeviceMonitorDisabled;
    }

    @Override
    public long getDeviceMonitorSnapshotInterval() {
        return this.mDeviceMonitorSnapshotInterval;
    }

    void setServiceUrl(String url) {
        this.mServiceUrl = url;
    }

    void setClusterId(String id) {
        this.mClusterId = id;
    }

    void setRunTargetFormat(String format) {
        this.mRunTargetFormat = format;
    }

    void setDeviceMonitorDisabled(boolean disabled) {
        this.mIsDeviceMonitorDisabled = disabled;
    }

    void setDeviceMonitorSnapshotInterval(long interval) {
        this.mDeviceMonitorSnapshotInterval = interval;
    }

    void setCollectEarlyTestSummary(boolean collectEarlyTestSummary) {
        this.mCollectEarlyTestSummary = collectEarlyTestSummary;
    }

    @Override
    public long getInvocationHeartbeatInterval() {
        return this.mInvocationHeartbeatInterval;
    }

    @Override
    public Boolean shouldUploadInvocationStatus() {
        return this.mShouldUploadInvocationStatus;
    }

    @VisibleForTesting
    void setSchedulerServiceAccountKeyfile(File keyFile) {
        this.mSchedulerServiceAccountKeyfile = keyFile;
    }

    @Override
    public File getSchedulerServiceAccountKeyfile() {
        return this.mSchedulerServiceAccountKeyfile;
    }

    @Override
    public String getSchedulerServiceUrl() {
        return this.mServiceUrl;
    }

    @Override
    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    @Override
    public boolean checkCommandState() {
        return this.mCheckCommandState;
    }

    @VisibleForTesting
    void setCheckCommandState(boolean checkCommandState) {
        this.mCheckCommandState = checkCommandState;
    }

    @Override
    public List<String> getLabels() {
        return new ArrayList<String>(this.mLabels);
    }

    @Override
    public String getLabName() {
        return this.mLabName;
    }

    @Override
    public boolean shouldCollectEarlyTestSummary() {
        return this.mCollectEarlyTestSummary;
    }

    @Override
    public long maxDiskUsagePercentage() {
        if (this.mMaximalDiskUsagePercentage > 100L) {
            return 100L;
        }
        if (this.mMaximalDiskUsagePercentage < 0L) {
            return 0L;
        }
        return this.mMaximalDiskUsagePercentage;
    }
}

