/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.result.LegacySubprocessResultsReporter;
import com.android.tradefed.util.FileUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SubprocessConfigBuilder {
    private static final String REPORTER_CLASS = LegacySubprocessResultsReporter.class.getName();
    private static final String OPTION_KEY = "subprocess-report-port";
    private String mClasspath;
    private File mWorkDir;
    private String mOriginalConfig;
    private String mPort;

    public SubprocessConfigBuilder setClasspath(String classpath) {
        this.mClasspath = classpath;
        return this;
    }

    public SubprocessConfigBuilder setWorkingDir(File dir) {
        this.mWorkDir = dir;
        return this;
    }

    public SubprocessConfigBuilder setOriginalConfig(String config) {
        this.mOriginalConfig = config;
        return this;
    }

    public SubprocessConfigBuilder setPort(String port) {
        this.mPort = port;
        return this;
    }

    public static String createConfigName(String originalConfigName) {
        return "_" + originalConfigName.replace("/", "$") + ".xml";
    }

    public File build() throws IOException {
        File f;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : this.mClasspath.split(File.pathSeparator)) {
            if (path.endsWith("*")) {
                File dir = new File(path.substring(0, path.length() - 1));
                if (!dir.exists()) continue;
                for (File file2 : dir.listFiles((parent, name) -> name.toLowerCase().endsWith(".jar"))) {
                    urls.add(file2.toURI().toURL());
                }
                continue;
            }
            urls.add(new File(path).toURI().toURL());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try (URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);){
            DocumentBuilder builder = factory.newDocumentBuilder();
            String ext = FileUtil.getExtension(this.mOriginalConfig);
            InputStream in = null;
            in = Strings.isNullOrEmpty(ext) ? loader.getResourceAsStream(String.format("config/%s.xml", this.mOriginalConfig)) : loader.getResourceAsStream(String.format("config/%s", this.mOriginalConfig));
            if (in == null) {
                File f2 = new File(this.mOriginalConfig);
                if (!f2.isAbsolute()) {
                    f2 = new File(this.mWorkDir, this.mOriginalConfig);
                }
                try {
                    in = new FileInputStream(f2);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(String.format("Could not find configuration '%s'", this.mOriginalConfig));
                }
            }
            doc = builder.parse(in);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        if (this.mPort != null) {
            Node root = doc.getElementsByTagName("configuration").item(0);
            Element reporter = doc.createElement("result_reporter");
            reporter.setAttribute("class", REPORTER_CLASS);
            Element options = doc.createElement("option");
            options.setAttribute("name", OPTION_KEY);
            options.setAttribute("value", this.mPort);
            reporter.appendChild(options);
            root.appendChild(reporter);
        }
        if (!(f = new File(this.mWorkDir, this.mOriginalConfig)).exists() || !f.isFile()) {
            f = File.createTempFile("subprocess_config_", ".xml", this.mWorkDir);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(f));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return f;
    }
}

