/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.SubprocessConfigBuilder;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.LegacySubprocessResultsReporter;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil2;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class SubprocessReportingHelper {
    private static final String REPORTER_JAR_NAME = "subprocess-results-reporter.jar";
    private static final String CLASS_FILTER = String.format("(^%s|^%s|^%s|^%s|^%s|^%s).*class$", "ErrorIdentifier", "LegacySubprocessResultsReporter", "SubprocessTestResultsParser", "SubprocessEventHelper", "SubprocessResultsReporter", "ISupportGranularResults");
    private String mCommandLine;
    private String mClasspath;
    private File mWorkDir;
    private String mPort;

    public SubprocessReportingHelper(String commandLine, String classpath, File workDir, String port) {
        this.mCommandLine = commandLine;
        this.mClasspath = classpath;
        this.mWorkDir = workDir;
        this.mPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File buildSubprocessReporterJar() throws IOException {
        String configFileName;
        String[] tokens = QuotationAwareTokenizer.tokenizeLine(this.mCommandLine);
        String configName = tokens[0];
        SubprocessConfigBuilder builder = new SubprocessConfigBuilder();
        builder.setWorkingDir(this.mWorkDir).setOriginalConfig(configName).setClasspath(this.mClasspath).setPort(this.mPort);
        File patchedConfigFile = builder.build();
        LogUtil.CLog.i("Generating new configuration:\n %s", FileUtil.readStringFromFile(patchedConfigFile));
        File reporterJar = new File(this.mWorkDir, REPORTER_JAR_NAME);
        File tfJar = new File(LegacySubprocessResultsReporter.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String ext = FileUtil.getExtension(configName);
        String string = configFileName = Strings.isNullOrEmpty(ext) ? configName + ".xml" : configName;
        if (tfJar.isDirectory()) {
            Set<File> classFiles = FileUtil.findFilesObject(tfJar, CLASS_FILTER);
            Manifest manifest = new Manifest();
            this.createJar(reporterJar, manifest, classFiles, configFileName, patchedConfigFile);
        } else {
            File extractedJar = ZipUtil2.extractZipToTemp(tfJar, "tmp-jar");
            try {
                Set<File> classFiles = FileUtil.findFilesObject(extractedJar, CLASS_FILTER);
                File mf = FileUtil.findFile(extractedJar, "MANIFEST.MF");
                Manifest manifest = new Manifest(new FileInputStream(mf));
                this.createJar(reporterJar, manifest, classFiles, configFileName, patchedConfigFile);
            }
            finally {
                FileUtil.recursiveDelete(extractedJar);
            }
        }
        return reporterJar;
    }

    private void createJar(File jar, Manifest manifest, Set<File> classFiles, String configName, File configFile) throws IOException {
        try (JarOutputStream jarOutput = new JarOutputStream((OutputStream)new FileOutputStream(jar), manifest);){
            for (File file2 : classFiles) {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file2));){
                    String path = file2.getPath();
                    JarEntry entry = new JarEntry(path.substring(path.indexOf("com")));
                    entry.setTime(file2.lastModified());
                    jarOutput.putNextEntry(entry);
                    StreamUtil.copyStreams(in, jarOutput);
                    jarOutput.closeEntry();
                }
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(configFile));){
                JarEntry entry = new JarEntry(String.format("config/%s", configName));
                entry.setTime(configFile.lastModified());
                jarOutput.putNextEntry(entry);
                StreamUtil.copyStreams(in, jarOutput);
                jarOutput.closeEntry();
            }
        }
    }
}

