/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.TestResource;
import com.android.tradefed.log.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestContext {
    String mCommandLine = null;
    final Map<String, String> mEnvVars = new TreeMap<String, String>();
    final List<TestResource> mTestResources = new ArrayList<TestResource>();

    public String getCommandLine() {
        return this.mCommandLine;
    }

    public void setCommandLine(String commandLine) {
        this.mCommandLine = commandLine;
    }

    public Map<String, String> getEnvVars() {
        return Collections.unmodifiableMap(this.mEnvVars);
    }

    public void addEnvVars(Map<String, String> envVars) {
        this.mEnvVars.putAll(envVars);
    }

    public List<TestResource> getTestResources() {
        return Collections.unmodifiableList(this.mTestResources);
    }

    public void addTestResource(TestResource testResource) {
        this.mTestResources.add(testResource);
    }

    public static TestContext fromJson(JSONObject json) throws JSONException {
        JSONArray testResources;
        TestContext obj = new TestContext();
        obj.mCommandLine = json.optString("command_line");
        JSONArray envVars = json.optJSONArray("env_vars");
        if (envVars != null) {
            for (int i = 0; i < envVars.length(); ++i) {
                JSONObject pair = envVars.getJSONObject(i);
                obj.mEnvVars.put(pair.getString("key"), pair.getString("value"));
            }
        }
        if ((testResources = json.optJSONArray("test_resources")) != null) {
            obj.mTestResources.addAll(TestResource.fromJsonArray(testResources));
        }
        return obj;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("command_line", this.mCommandLine);
        JSONArray envVars = new JSONArray();
        for (Map.Entry<String, String> entry : this.mEnvVars.entrySet()) {
            JSONObject pair = new JSONObject();
            pair.put("key", entry.getKey());
            pair.put("value", entry.getValue());
            envVars.put(pair);
        }
        json.put("env_vars", envVars);
        JSONArray testResources = new JSONArray();
        for (TestResource obj : this.mTestResources) {
            testResources.put(obj.toJson());
        }
        json.put("test_resources", testResources);
        return json;
    }

    public String toString() {
        try {
            return this.toJson().toString();
        }
        catch (JSONException e) {
            LogUtil.CLog.w("Failed to convert to JSON: %s", e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestContext)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }
}

