/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.cluster.TradefedConfigObject;
import com.android.tradefed.log.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestEnvironment {
    final Map<String, String> mEnvVars = new HashMap<String, String>();
    final List<String> mSetupScripts = new ArrayList<String>();
    final List<String> mOutputFilePatterns = new ArrayList<String>();
    String mOutputFileUploadUrl = null;
    boolean mUseSubprocessReporting = false;
    long mInvocationTimeout = 0L;
    long mOutputIdleTimeout = 0L;
    final List<String> mJvmOptions = new ArrayList<String>();
    final Map<String, String> mJavaProperties = new HashMap<String, String>();
    String mContextFilePattern = null;
    private final List<String> mExtraContextFiles = new ArrayList<String>();
    String mRetryCommandLine = null;
    String mLogLevel = null;
    final List<TradefedConfigObject> mTradefedConfigObjects = new ArrayList<TradefedConfigObject>();
    boolean mUseParallelSetup = false;
    private final List<String> mExcludedFilesInJavaClasspath = new ArrayList<String>();

    public void addEnvVar(String name, String value) {
        this.mEnvVars.put(name, value);
    }

    public Map<String, String> getEnvVars() {
        return Collections.unmodifiableMap(this.mEnvVars);
    }

    public void addSetupScripts(String s) {
        this.mSetupScripts.add(s);
    }

    public List<String> getSetupScripts() {
        return Collections.unmodifiableList(this.mSetupScripts);
    }

    public void addOutputFilePattern(String s) {
        this.mOutputFilePatterns.add(s);
    }

    public List<String> getOutputFilePatterns() {
        return Collections.unmodifiableList(this.mOutputFilePatterns);
    }

    public void setOutputFileUploadUrl(String s) {
        this.mOutputFileUploadUrl = s;
    }

    public String getOutputFileUploadUrl() {
        return this.mOutputFileUploadUrl;
    }

    public boolean useSubprocessReporting() {
        return this.mUseSubprocessReporting;
    }

    public void setUseSubprocessReporting(boolean f) {
        this.mUseSubprocessReporting = f;
    }

    public long getInvocationTimeout() {
        return this.mInvocationTimeout;
    }

    public void setInvocationTimeout(long value) {
        this.mInvocationTimeout = value;
    }

    public long getOutputIdleTimeout() {
        return this.mOutputIdleTimeout;
    }

    public void setOutputIdleTimeout(long outputIdleTimeout) {
        this.mOutputIdleTimeout = outputIdleTimeout;
    }

    public void addJvmOption(String s) {
        this.mJvmOptions.add(s);
    }

    public List<String> getJvmOptions() {
        return Collections.unmodifiableList(this.mJvmOptions);
    }

    public void addJavaProperty(String name, String value) {
        this.mJavaProperties.put(name, value);
    }

    public Map<String, String> getJavaProperties() {
        return Collections.unmodifiableMap(this.mJavaProperties);
    }

    public String getContextFilePattern() {
        return this.mContextFilePattern;
    }

    public void addExtraContextFile(String path) {
        this.mExtraContextFiles.add(path);
    }

    public List<String> getExtraContextFiles() {
        return Collections.unmodifiableList(this.mExtraContextFiles);
    }

    public String getRetryCommandLine() {
        return this.mRetryCommandLine;
    }

    public String getLogLevel() {
        return this.mLogLevel;
    }

    public List<TradefedConfigObject> getTradefedConfigObjects() {
        return Collections.unmodifiableList(this.mTradefedConfigObjects);
    }

    void addTradefedConfigObject(TradefedConfigObject obj) {
        this.mTradefedConfigObjects.add(obj);
    }

    public boolean useParallelSetup() {
        return this.mUseParallelSetup;
    }

    public void setUseParallelSetup(boolean f) {
        this.mUseParallelSetup = f;
    }

    public void addExcludedFileInJavaClasspath(String s) {
        this.mExcludedFilesInJavaClasspath.add(s);
    }

    public List<String> getExcludedFilesInJavaClasspath() {
        return Collections.unmodifiableList(this.mExcludedFilesInJavaClasspath);
    }

    public static TestEnvironment fromJson(JSONObject json) throws JSONException {
        TestEnvironment obj = new TestEnvironment();
        JSONArray envVars = json.optJSONArray("env_vars");
        if (envVars != null) {
            for (int i = 0; i < envVars.length(); ++i) {
                JSONObject envVar = envVars.getJSONObject(i);
                obj.addEnvVar(envVar.getString("key"), envVar.getString("value"));
            }
        } else {
            LogUtil.CLog.w("env_vars is null");
        }
        JSONArray jvmOptions = json.optJSONArray("jvm_options");
        if (jvmOptions != null) {
            for (int i = 0; i < jvmOptions.length(); ++i) {
                obj.addJvmOption(jvmOptions.getString(i));
            }
        } else {
            LogUtil.CLog.w("jvm_options is null");
        }
        JSONArray javaProperties = json.optJSONArray("java_properties");
        if (javaProperties != null) {
            for (int i = 0; i < javaProperties.length(); ++i) {
                JSONObject javaProperty = javaProperties.getJSONObject(i);
                obj.addJavaProperty(javaProperty.getString("key"), javaProperty.getString("value"));
            }
        } else {
            LogUtil.CLog.w("java_properties is null");
        }
        JSONArray scripts = json.optJSONArray("setup_scripts");
        if (scripts != null) {
            for (int i = 0; i < scripts.length(); ++i) {
                obj.addSetupScripts(scripts.getString(i));
            }
        } else {
            LogUtil.CLog.w("setup_scripts is null");
        }
        JSONArray patterns = json.optJSONArray("output_file_patterns");
        if (patterns != null) {
            for (int i = 0; i < patterns.length(); ++i) {
                obj.addOutputFilePattern(patterns.getString(i));
            }
        } else {
            LogUtil.CLog.w("output_file_patterns is null");
        }
        String url = json.optString("output_file_upload_url");
        if (url != null) {
            obj.setOutputFileUploadUrl(url);
        } else {
            LogUtil.CLog.w("output_file_upload_url is null");
        }
        obj.mUseSubprocessReporting = json.optBoolean("use_subprocess_reporting", true);
        obj.mInvocationTimeout = json.optLong("invocation_timeout_millis", 0L);
        obj.mOutputIdleTimeout = json.optLong("output_idle_timeout_millis", 0L);
        obj.mContextFilePattern = json.optString("context_file_pattern");
        JSONArray extraContextFiles = json.optJSONArray("extra_context_files");
        if (extraContextFiles != null) {
            for (int i = 0; i < extraContextFiles.length(); ++i) {
                obj.addExtraContextFile(extraContextFiles.getString(i));
            }
        } else {
            LogUtil.CLog.w("extra_context_files is null");
        }
        obj.mRetryCommandLine = json.optString("retry_command_line");
        obj.mLogLevel = json.optString("log_level");
        JSONArray arr = json.optJSONArray("tradefed_config_objects");
        if (arr != null) {
            obj.mTradefedConfigObjects.addAll(TradefedConfigObject.fromJsonArray(arr));
        }
        obj.mUseParallelSetup = json.optBoolean("use_parallel_setup", true);
        JSONArray excludedFiles = json.optJSONArray("excluded_files_in_java_classpath");
        if (excludedFiles != null) {
            for (int i = 0; i < excludedFiles.length(); ++i) {
                obj.addExcludedFileInJavaClasspath(excludedFiles.getString(i));
            }
        } else {
            LogUtil.CLog.w("exclude_files_in_java_classpath is null");
        }
        return obj;
    }
}

