/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TestOutputUploader {
    static final long UPLOAD_TIMEOUT_MS = 1800000L;
    static final long RETRY_INTERVAL_MS = 10000L;
    static final int MAX_RETRY_COUNT = 2;
    static final String FILE_PROTOCOL = "file";
    static final String GCS_PROTOCOL = "gs";
    static final String HTTP_PROTOCOL = "http";
    static final String HTTPS_PROTOCOL = "https";
    private String mUploadUrl = null;
    private String mProtocol = null;
    private IRunUtil mRunUtil = null;

    public void setUploadUrl(String url) throws MalformedURLException {
        this.mUploadUrl = url;
        URL urlObj = new URL(url);
        this.mProtocol = urlObj.getProtocol();
    }

    public String uploadFile(File file2, String destPath) throws IOException {
        if (this.mUploadUrl == null) {
            throw new IllegalStateException("Upload URL is not set");
        }
        String uploadUrl = this.joinSegments(this.mUploadUrl, destPath);
        LogUtil.CLog.i("Uploading %s to %s", file2.getAbsolutePath(), uploadUrl);
        switch (this.mProtocol) {
            case "file": {
                File destDir = new File(new URL(uploadUrl).getPath());
                destDir.mkdirs();
                File destFile = new File(destDir, file2.getName());
                FileUtil.copyFile(file2, destFile);
                return this.joinSegments(uploadUrl, file2.getName());
            }
            case "gs": {
                this.executeUploadCommand(file2, "gsutil", "cp", file2.getAbsolutePath(), uploadUrl);
                return this.joinSegments(uploadUrl, file2.getName());
            }
            case "http": 
            case "https": {
                String fullPath = this.joinSegments(destPath, file2.getName());
                String encodedPath = UrlEscapers.urlFragmentEscaper().escape(fullPath);
                uploadUrl = this.joinSegments(this.mUploadUrl, encodedPath);
                this.executeUploadCommand(file2, "curl", "--request", "POST", "--form", "file=@" + file2.getAbsolutePath(), "--fail", "--location", uploadUrl);
                return uploadUrl;
            }
        }
        throw new IllegalArgumentException(String.format("Protocol '%s' is not supported", this.mProtocol));
    }

    private void executeUploadCommand(File file2, String ... cmdArgs) {
        CommandResult result = this.getRunUtil().runTimedCmdRetry(1800000L, 10000L, 2, cmdArgs);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            String error = String.format("Failed to upload %s, status = %s, stdout = [%s], stderr = [%s].", new Object[]{file2.getAbsolutePath(), result.getStatus(), result.getStdout(), result.getStderr()});
            LogUtil.CLog.e(error);
            throw new RuntimeException(error);
        }
    }

    private String joinSegments(String ... segments) {
        return Stream.of(segments).filter(Objects::nonNull).map(s -> s.replaceAll("^/|/$", "")).collect(Collectors.joining("/"));
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = RunUtil.getDefault();
        }
        return this.mRunUtil;
    }
}

