/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestResource {
    private final String mName;
    private final String mUrl;
    private final boolean mDecompress;
    private final String mDecompressDir;
    private final boolean mMountZip;
    private final TestResourceParameters mParams;

    TestResource(String name, String url) {
        this(name, url, false, null, false, (List<String>)null);
    }

    TestResource(String name, String url, boolean decompress, String decompressDir, boolean mountZip, List<String> decompressFiles) {
        this(name, url, decompress, decompressDir, mountZip, new TestResourceParameters(decompressFiles));
    }

    private TestResource(String name, String url, boolean decompress, String decompressDir, boolean mountZip, TestResourceParameters params) {
        this.mName = name;
        this.mUrl = url;
        this.mDecompress = decompress;
        this.mDecompressDir = decompressDir != null ? decompressDir : "";
        this.mMountZip = mountZip;
        this.mParams = params;
    }

    public String getName() {
        return this.mName;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean getDecompress() {
        return this.mDecompress;
    }

    public String getDecompressDir() {
        return this.mDecompressDir;
    }

    public File getDecompressDir(File parentDir) {
        return new File(parentDir, this.mDecompressDir);
    }

    public File getFile(File parentDir) {
        return new File(parentDir, this.mName);
    }

    public boolean mountZip() {
        return this.mMountZip;
    }

    public List<String> getDecompressFiles() {
        return Collections.unmodifiableList(this.mParams.mDecompressFiles);
    }

    public JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("name", this.mName);
        json.put("url", this.mUrl);
        json.put("decompress", this.mDecompress);
        json.put("decompress_dir", this.mDecompressDir);
        json.put("mount_zip", this.mMountZip);
        json.put("params", this.mParams.toJson());
        return json;
    }

    public static TestResource fromJson(JSONObject json) {
        return new TestResource(json.optString("name"), json.optString("url"), json.optBoolean("decompress"), json.optString("decompress_dir"), json.optBoolean("mount_zip"), TestResourceParameters.fromJson(json.optJSONObject("params")));
    }

    public static List<TestResource> fromJsonArray(JSONArray jsonArray) throws JSONException {
        ArrayList<TestResource> objs = new ArrayList<TestResource>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            objs.add(TestResource.fromJson(jsonArray.getJSONObject(i)));
        }
        return objs;
    }

    private static class TestResourceParameters {
        private final List<String> mDecompressFiles;

        TestResourceParameters(List<String> decompressFiles) {
            this.mDecompressFiles = decompressFiles != null ? decompressFiles : new ArrayList();
        }

        JSONObject toJson() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("decompress_files", new JSONArray(this.mDecompressFiles));
            return json;
        }

        static TestResourceParameters fromJson(JSONObject json) {
            JSONArray jsonDecompressFiles;
            ArrayList<String> decompressFiles = new ArrayList<String>();
            if (json != null && (jsonDecompressFiles = json.optJSONArray("decompress_files")) != null) {
                for (int i = 0; i < jsonDecompressFiles.length(); ++i) {
                    decompressFiles.add(jsonDecompressFiles.optString(i));
                }
            }
            return new TestResourceParameters(decompressFiles);
        }
    }
}

