/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.loganalysis.util.ArrayUtil;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class TestResourceDownloader {
    private static final long DOWNLOAD_TIMEOUT_MS = 3600000L;
    private static final long RETRY_INTERVAL_MS = 10000L;
    private static final int MAX_RETRY_COUNT = 2;
    private IRunUtil mRunUtil = null;

    public void download(String urlString, File dest) throws IOException {
        URL url = new URL(urlString);
        String protocol = url.getProtocol();
        File parent = dest.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if ("file".equals(protocol)) {
            File src = new File(url.getPath());
            FileUtil.hardlinkFile(src, dest);
            return;
        }
        List<String> cmdArgs = this.buildDownloadCommandArgs(url, dest);
        CommandResult result = this.getRunUtil().runTimedCmdRetry(3600000L, 10000L, 3, cmdArgs.toArray(new String[0]));
        if (!result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            String msg = String.format("Failed to download %s: command status=%s", new Object[]{url, result.getStatus()});
            LogUtil.CLog.e(msg);
            LogUtil.CLog.e("stdout:\n'''\n%s'''\n", result.getStdout());
            LogUtil.CLog.e("stderr:\n'''\n%s'''\n", result.getStderr());
            throw new RuntimeException(msg);
        }
    }

    private List<String> buildDownloadCommandArgs(URL url, File file2) {
        String protocol = url.getProtocol();
        if ("gs".equals(protocol)) {
            return ArrayUtil.list((Object[])new String[]{"gsutil", "cp", url.toString(), file2.getAbsolutePath()});
        }
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return ArrayUtil.list((Object[])new String[]{"curl", "-o", file2.getAbsolutePath(), "-fL", url.toString()});
        }
        throw new UnsupportedOperationException("protocol " + protocol + " is not supported");
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }
}

