/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.cluster;

import com.android.tradefed.util.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TradefedConfigObject {
    private final Type mType;
    private final String mClassName;
    private final MultiMap<String, String> mOptionValues;

    TradefedConfigObject(Type type, String className, MultiMap<String, String> optionValues) {
        this.mType = type;
        this.mClassName = className;
        this.mOptionValues = optionValues;
    }

    public Type getType() {
        return this.mType;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public MultiMap<String, String> getOptionValues() {
        return this.mOptionValues;
    }

    public static TradefedConfigObject fromJson(JSONObject json) throws JSONException {
        MultiMap<String, String> optionValues = new MultiMap<String, String>();
        JSONArray arr = json.optJSONArray("option_values");
        if (arr != null) {
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject pair = arr.getJSONObject(i);
                String key = pair.getString("key");
                JSONArray valueArr = pair.optJSONArray("values");
                if (valueArr == null) {
                    optionValues.put(key, null);
                    continue;
                }
                for (int j = 0; j < valueArr.length(); ++j) {
                    optionValues.put(key, valueArr.getString(j));
                }
            }
        }
        Type type = Type.valueOf(json.optString("type", Type.UNKNOWN.name()));
        return new TradefedConfigObject(type, json.getString("class_name"), optionValues);
    }

    public static List<TradefedConfigObject> fromJsonArray(JSONArray arr) throws JSONException {
        ArrayList<TradefedConfigObject> objs = new ArrayList<TradefedConfigObject>();
        for (int i = 0; i < arr.length(); ++i) {
            objs.add(TradefedConfigObject.fromJson(arr.getJSONObject(i)));
        }
        return objs;
    }

    public static enum Type {
        UNKNOWN,
        TARGET_PREPARER,
        RESULT_REPORTER;

    }
}

