/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.command.CommandFileParser;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CommandFileWatcher
extends Thread {
    private static final long POLL_TIME_MS = 20000L;
    private Map<String, CommandFile> mCmdFileMap = new Hashtable<String, CommandFile>();
    boolean mCancelled = false;
    private final ICommandFileListener mListener;

    public CommandFileWatcher(ICommandFileListener listener) {
        super("CommandFileWatcher");
        this.mListener = listener;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.isCancelled()) {
            this.checkForUpdates();
            this.getRunUtil().sleep(20000L);
        }
    }

    @VisibleForTesting
    void addCmdFile(File cmdFile, List<String> extraArgs, List<File> dependencies) {
        CommandFile f = new CommandFile(cmdFile, extraArgs, dependencies);
        this.mCmdFileMap.put(cmdFile.getAbsolutePath(), f);
    }

    public void addCmdFile(File cmdFile, List<String> extraArgs, Collection<String> includedFiles) {
        ArrayList<File> includesAsFiles = new ArrayList<File>(includedFiles.size());
        for (String p : includedFiles) {
            includesAsFiles.add(new File(p));
        }
        this.addCmdFile(cmdFile, extraArgs, (List<File>)includesAsFiles);
    }

    public boolean isFileWatched(File cmdFile) {
        return this.mCmdFileMap.containsKey(cmdFile.getAbsolutePath());
    }

    public void cancel() {
        this.mCancelled = true;
        this.interrupt();
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForUpdates() {
        ArrayList<CommandFile> cmdCopy;
        HashSet<File> checkedFiles = new HashSet<File>();
        Map<String, CommandFile> map = this.mCmdFileMap;
        synchronized (map) {
            cmdCopy = new ArrayList<CommandFile>(this.mCmdFileMap.values());
        }
        for (CommandFile cmd : cmdCopy) {
            if (!this.checkCommandFileForUpdate(cmd, checkedFiles)) continue;
            this.mListener.notifyFileChanged(cmd.file, cmd.extraArgs);
        }
    }

    boolean checkCommandFileForUpdate(CommandFile cmd, Set<File> checkedFiles) {
        if (checkedFiles.contains(cmd.file)) {
            return false;
        }
        checkedFiles.add(cmd.file);
        long curModTime = cmd.file.lastModified();
        if (curModTime != 0L && curModTime != cmd.modTime) {
            LogUtil.CLog.w("Found update in monitored cmdfile %s (%d -> %d)", cmd.file, cmd.modTime, curModTime);
            return true;
        }
        for (CommandFile dep : cmd.dependencies) {
            if (!this.checkCommandFileForUpdate(dep, checkedFiles)) continue;
            return true;
        }
        return false;
    }

    CommandFileParser createCommandFileParser() {
        return new CommandFileParser();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void removeAllFiles() {
        this.mCmdFileMap.clear();
    }

    public List<String> getExtraArgsForFile(String cmdPath) {
        CommandFile cmdFile = this.mCmdFileMap.get(cmdPath);
        if (cmdFile != null) {
            return cmdFile.extraArgs;
        }
        LogUtil.CLog.w("Could not find cmdfile %s", cmdPath);
        return Collections.emptyList();
    }

    static interface ICommandFileListener {
        public void notifyFileChanged(File var1, List<String> var2);
    }

    static class CommandFile {
        public final File file;
        public final long modTime;
        public final List<String> extraArgs;
        public final List<CommandFile> dependencies;

        public CommandFile(File cmdFile) {
            if (cmdFile == null) {
                throw new NullPointerException();
            }
            this.file = cmdFile;
            this.modTime = cmdFile.lastModified();
            this.extraArgs = Collections.emptyList();
            this.dependencies = Collections.emptyList();
        }

        public CommandFile(File cmdFile, List<String> extraArgs, List<File> dependencies) {
            if (cmdFile == null) {
                throw new NullPointerException();
            }
            this.file = cmdFile;
            this.modTime = cmdFile.lastModified();
            this.extraArgs = extraArgs == null ? Collections.emptyList() : extraArgs;
            if (dependencies == null) {
                this.dependencies = Collections.emptyList();
            } else {
                this.dependencies = new ArrayList<CommandFile>(dependencies.size());
                for (File f : dependencies) {
                    this.dependencies.add(new CommandFile(f));
                }
            }
        }
    }
}

