/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.RunInterruptedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class CommandInterrupter {
    public static final CommandInterrupter INSTANCE = new CommandInterrupter();
    private final ScheduledExecutorService mExecutor = Executors.newScheduledThreadPool(0);
    private ConcurrentMap<Thread, Boolean> mInterruptible = new MapMaker().weakKeys().makeMap();
    private ConcurrentMap<Thread, MessageAndErrorId> mInterruptMessage = new MapMaker().weakKeys().makeMap();

    @VisibleForTesting
    public CommandInterrupter() {
    }

    public void allowInterrupt() {
        LogUtil.CLog.i("Interrupt allowed");
        this.mInterruptible.put(Thread.currentThread(), true);
        this.checkInterrupted();
    }

    public void blockInterrupt() {
        LogUtil.CLog.i("Interrupt blocked");
        this.mInterruptible.put(Thread.currentThread(), false);
        this.checkInterrupted();
    }

    public boolean isInterruptible() {
        return this.isInterruptible(Thread.currentThread());
    }

    public boolean isInterruptible(@Nonnull Thread thread) {
        return Boolean.TRUE.equals(this.mInterruptible.get(thread));
    }

    public Future<?> allowInterruptAsync(@Nonnull Thread thread, long delay, @Nonnull TimeUnit unit) {
        if (this.isInterruptible(thread)) {
            LogUtil.CLog.v("Thread already interruptible");
            return CompletableFuture.completedFuture(null);
        }
        LogUtil.CLog.w("Allowing interrupt in %d ms", unit.toMillis(delay));
        return this.mExecutor.schedule(() -> {
            LogUtil.CLog.e("Interrupt allowed asynchronously");
            this.mInterruptible.put(thread, true);
        }, delay, unit);
    }

    public void interrupt(@Nonnull Thread thread, @Nonnull String message2, ErrorIdentifier errorId) {
        if (message2 == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        this.mInterruptMessage.put(thread, new MessageAndErrorId(message2, errorId));
        if (this.isInterruptible(thread)) {
            thread.interrupt();
        }
    }

    public void checkInterrupted() throws RunInterruptedException {
        MessageAndErrorId error;
        Thread thread = Thread.currentThread();
        if (this.isInterruptible() && (error = (MessageAndErrorId)this.mInterruptMessage.remove(thread)) != null) {
            throw new RunInterruptedException(error.message, error.errorId);
        }
    }

    private class MessageAndErrorId {
        public String message;
        public ErrorIdentifier errorId;

        MessageAndErrorId(String message2, ErrorIdentifier errorId) {
            this.message = message2;
            this.errorId = errorId;
        }
    }
}

