/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.metric.AutoLogCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.UniqueMultiMap;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandOptions
implements ICommandOptions {
    @Option(name="help", description="display the help text for the most important/critical options.", importance=Option.Importance.ALWAYS)
    private boolean mHelpMode = false;
    @Option(name="help-all", description="display the full help text for all options.", importance=Option.Importance.ALWAYS)
    private boolean mFullHelpMode = false;
    public static final String DRY_RUN_OPTION = "dry-run";
    public static final String NOISY_DRY_RUN_OPTION = "noisy-dry-run";
    @Option(name="dry-run", description="build but don't actually run the command.  Intended as a quick check to ensure that a command is runnable.", importance=Option.Importance.ALWAYS)
    private boolean mDryRunMode = false;
    @Option(name="noisy-dry-run", description="build but don't actually run the command.  This version prints the command to the console.  Intended for cmdfile debugging.", importance=Option.Importance.ALWAYS)
    private boolean mNoisyDryRunMode = false;
    @Option(name="min-loop-time", description="the minimum invocation time in ms when in loop mode.")
    private Long mMinLoopTime = 600000L;
    public static final String TEST_TAG_OPTION = "test-tag";
    @Option(name="test-tag", description="Identifier for the invocation during reporting.")
    private String mTestTag = "stub";
    @Option(name="test-tag-suffix", description="suffix for test-tag. appended to test-tag to represents some variants of one test.")
    private String mTestTagSuffix = null;
    @Option(name="loop", description="keep running continuously.", importance=Option.Importance.ALWAYS)
    private boolean mLoopMode = false;
    @Option(name="max-loops", description="the maximum number of loops.")
    private long mMaxLoopCount = Long.MAX_VALUE;
    @Option(name="all-devices", description="fork this command to run on all connected devices.")
    private boolean mAllDevices = false;
    @Option(name="bugreport-on-invocation-ended", description="take a bugreport when the test invocation has ended")
    private boolean mTakeBugreportOnInvocationEnded = false;
    @Option(name="bugreportz-on-invocation-ended", description="Attempt to take a bugreportz instead of bugreport during the test invocation final bugreport.")
    private boolean mTakeBugreportzOnInvocationEnded = false;
    @Option(name="disable-conditional-bugreport", description="Disable the optimization to capture ANR instead of bugreport if no failure.")
    private boolean mDisableConditionalBugreport = false;
    @Option(name="invocation-timeout", description="the maximum time to wait for an invocation to terminate before attempting to forcestop it.", isTimeVal=true)
    private long mInvocationTimeout = 0L;
    @Option(name="shard-count", description="the number of total shards to run. Without --shard-index option, this will cause the command to spawn multiple shards in the current TF instance. With --shard-index option, it will cause the command to run a single shard of tests only.")
    private Integer mShardCount;
    @Option(name="shard-index", description="the index of shard to run. Only set if shard-count > 1 and the value is in range [0, shard-count)")
    private Integer mShardIndex;
    @Option(name="optimize-mainline-test", description="Whether or not to optimize the list of test modules for mainline.")
    private boolean mOptimizeMainlineTest;
    @Option(name="enable-token-sharding", description="Whether or not to allow sharding with the token support enabled.")
    private boolean mTokenSharding = false;
    @Option(name="dynamic-sharding", description="Allow to dynamically move IRemoteTest from one shard to another. Only for local sharding.")
    private boolean mDynamicSharding = true;
    @Option(name="remote-dynamic-sharding", description="Enable use of the dynamic sharding service to load balance across multiple hosts.")
    private boolean mRemoteDynamicSharding = false;
    @Option(name="use-even-module-sharding", description="Enable use of a strategy that attempts to distribute number of modules evenly across shards")
    private boolean mEvenModuleSharding = false;
    public static final String INVOCATION_DATA = "invocation-data";
    @Option(name="invocation-data", description="A map of values that describe the invocation, these values will be added to the invocation context.")
    private UniqueMultiMap<String, String> mInvocationData = new UniqueMultiMap();
    public static final String USE_SANDBOX = "use-sandbox";
    public static final String ENABLE_SANDBOX_TEST_MODE = "sandbox-test-mode";
    public static final String USE_REMOTE_SANDBOX = "use-remote-sandbox";
    @Option(name="remote-files", description="A list of files references to store in build info")
    private Set<String> mRemoteFiles = new LinkedHashSet<String>();
    @Option(name="use-sandbox", description="Set if the invocation should use a sandbox to run or not.")
    private boolean mUseSandbox = false;
    @Option(name="sandbox-test-mode", description="Sandbox test mode where the sandbox will use itself to generate another layer of sandboxing. This is used for the sandbox to validate itself.")
    private boolean mSandboxTestMode = false;
    @Option(name="use-remote-sandbox", description="Whether or not to trigger --use-sandbox in the remote invocation.")
    private boolean mUseRemoteSandbox = false;
    @Option(name="deviceless-remote-exec", description="Whether or not to trigger --null-deviec in the remote invocation.")
    private boolean mDevicelessRemoteExecution = false;
    @Deprecated
    @Option(name="parallel-remote-setup", description="For remote sharded invocation, whether or not to attempt the setup in parallel.")
    private boolean mUseParallelRemoteSetup = false;
    @Option(name="parallel-setup", description="Whether to attempt the setup in parallel.")
    private boolean mUseParallelSetup = false;
    @Option(name="parallel-setup-timeout", description="Timeout to use during parallel setup.")
    private Duration mParallelSetupTimeout = Duration.ofMinutes(30L);
    @Option(name="replicate-parent-setup", description="For remote sharded invocation, whether or not to replicate parent setup on all devices.")
    private boolean mReplicateParentSetup = false;
    @Option(name="report-module-progression", description="For remote invocation, whether or not to report progress at module level.")
    private boolean mReportModuleProgression = false;
    @Deprecated
    @Option(name="extra-postsubmit-remote-instance", description="Option that allows to run more instances in the remote VM in postsubmit. Used for experimentation.")
    private int mExtraRemoteInstancePostsubmit = 0;
    @Option(name="auto-collect", description="Specify a set of collectors that will be automatically managed by the harness to collect logs.")
    private Set<AutoLogCollector> mAutoCollectors = new LinkedHashSet<AutoLogCollector>();
    @Option(name="experiment-enabled", description="A feature flag used to enable experimental flags.")
    private boolean mExperimentEnabled = false;
    @Option(name="experimental-flags", description="Map of experimental flags that can be used for feature gating projects.")
    private Map<String, String> mExperimentalFlags = new LinkedHashMap<String, String>();
    @Deprecated
    @Option(name="logcat-on-failure", description="take a logcat snapshot on every test failure.")
    private boolean mLogcatOnFailure = false;
    @Deprecated
    @Option(name="screenshot-on-failure", description="Take a screenshot on every test failure")
    private boolean mScreenshotOnFailure = false;
    @Option(name="host-log-suffix", description="Suffix to add to Tradefed host_log before logging it.")
    private String mHostLogSuffix = null;
    @Option(name="early-device-release", description="Feature flag to release the device as soon as done with it.")
    private boolean mEnableEarlyDeviceRelease = true;
    @Option(name="delegated-early-device-release", description="Feature flag to enable early device release when running in delegated mode.")
    private boolean mEnableDelegatedEarlyDeviceRelease = true;
    @Option(name="dynamic-download-args", description="Extra args passed to the IRemoteFileResolver interface for dynamic download in the queryArgs.")
    private Map<String, String> mDynamicDownloadArgs = new LinkedHashMap<String, String>();
    @Option(name="report-counted-test-cases", description="Whether or not to report the number of test cases per test types.")
    private boolean mCountTestCases = true;
    @Option(name="report-passed-tests", description="Whether or not to report the passed tests in a file.")
    private boolean mReportPassedTests = true;
    @Option(name="filter-previous-passed", description="Feature flag to test filtering previously passed tests.")
    private boolean mTestFilterPassed = true;
    @Option(name="report-invocation-complete-logs", description="Whether or not to attempt to report the logs until invocationComplete.")
    private boolean mReportInvocationCompleteLogs = true;
    @Option(name="disable-invocation-setup-and-teardown", description="Disable the pre-invocation setup and post-invocation teardown phases.")
    private boolean mDisableInvocationSetupAndTeardown = false;
    @Option(name="multi-device-count", description="The number of devices for multi-device tests. For a new feature under developing, not for other uses.")
    private Integer mMultiDeviceCount;
    @Option(name="enable-tracing", description="Enable test invocation tracing.")
    private boolean mTracingEnabled = true;
    public static final String JDK_FOLDER_OPTION_NAME = "jdk-folder-for-subprocess";
    @Option(name="parallel-dynamic-download", description="Enable parallel download of dynamic files when supported.")
    private boolean mEnableParallelDynamicDownload = false;
    @Option(name="jdk-folder-for-subprocess", description="Whenever the java execution is forked to another subprocess, use this jdk folder instead of current one.")
    private File mJdkFolder;

    void setHelpMode(boolean helpMode) {
        this.mHelpMode = helpMode;
    }

    @Override
    public boolean isHelpMode() {
        return this.mHelpMode;
    }

    @Override
    public boolean isFullHelpMode() {
        return this.mFullHelpMode;
    }

    void setDryRunMode(boolean dryRunMode) {
        this.mDryRunMode = dryRunMode;
    }

    @Override
    public boolean isDryRunMode() {
        return this.mDryRunMode || this.mNoisyDryRunMode;
    }

    @Override
    public boolean isNoisyDryRunMode() {
        return this.mNoisyDryRunMode;
    }

    @Override
    public void setLoopMode(boolean loopMode) {
        this.mLoopMode = loopMode;
    }

    @Override
    public boolean isLoopMode() {
        return this.mLoopMode;
    }

    void setMinLoopTime(long loopTime) {
        this.mMinLoopTime = loopTime;
    }

    @Override
    public long getLoopTime() {
        return this.mMinLoopTime;
    }

    @Override
    public long getMaxLoopCount() {
        return this.mMaxLoopCount;
    }

    @Override
    public ICommandOptions clone() {
        CommandOptions clone = new CommandOptions();
        try {
            OptionCopier.copyOptions(this, clone);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e("failed to clone command options: %s", e.getMessage());
        }
        return clone;
    }

    @Override
    public boolean runOnAllDevices() {
        return this.mAllDevices;
    }

    @Override
    public boolean takeBugreportOnInvocationEnded() {
        return this.mTakeBugreportOnInvocationEnded;
    }

    @Override
    public void setBugreportOnInvocationEnded(boolean takeBugreport) {
        this.mTakeBugreportOnInvocationEnded = takeBugreport;
    }

    @Override
    public boolean takeBugreportzOnInvocationEnded() {
        return this.mTakeBugreportzOnInvocationEnded;
    }

    @Override
    public void setBugreportzOnInvocationEnded(boolean takeBugreportz) {
        this.mTakeBugreportzOnInvocationEnded = takeBugreportz;
    }

    @Override
    public boolean isConditionalBugreportDisabled() {
        return this.mDisableConditionalBugreport;
    }

    @Override
    public long getInvocationTimeout() {
        return this.mInvocationTimeout;
    }

    @Override
    public void setInvocationTimeout(Long invocationTimeout) {
        this.mInvocationTimeout = invocationTimeout;
    }

    @Override
    public boolean getOptimizeMainlineTest() {
        return this.mOptimizeMainlineTest;
    }

    @Override
    public Integer getShardCount() {
        return this.mShardCount;
    }

    @Override
    public void setShardCount(Integer shardCount) {
        this.mShardCount = shardCount;
    }

    @Override
    public Integer getShardIndex() {
        return this.mShardIndex;
    }

    @Override
    public void setShardIndex(Integer shardIndex) {
        this.mShardIndex = shardIndex;
    }

    @Override
    public boolean shouldUseTokenSharding() {
        return this.mTokenSharding;
    }

    @Override
    public void setTestTag(String testTag) {
        this.mTestTag = testTag;
    }

    @Override
    public String getTestTag() {
        return this.mTestTag;
    }

    @Override
    public String getTestTagSuffix() {
        return this.mTestTagSuffix;
    }

    @Override
    public boolean shouldUseDynamicSharding() {
        return this.mDynamicSharding;
    }

    @Override
    public UniqueMultiMap<String, String> getInvocationData() {
        return this.mInvocationData;
    }

    @Override
    public Set<String> getRemoteFiles() {
        return this.mRemoteFiles;
    }

    @Override
    public boolean shouldUseSandboxing() {
        return this.mUseSandbox;
    }

    @Override
    public void setShouldUseSandboxing(boolean use) {
        this.mUseSandbox = use;
    }

    @Override
    public boolean shouldUseSandboxTestMode() {
        return this.mSandboxTestMode;
    }

    @Override
    public void setUseSandboxTestMode(boolean use) {
        this.mSandboxTestMode = use;
    }

    @Override
    public boolean shouldUseRemoteSandboxMode() {
        return this.mUseRemoteSandbox;
    }

    @Override
    public boolean isRemoteInvocationDeviceless() {
        return this.mDevicelessRemoteExecution;
    }

    @Override
    public Set<AutoLogCollector> getAutoLogCollectors() {
        return this.mAutoCollectors;
    }

    @Override
    public void setAutoLogCollectors(Set<AutoLogCollector> autoLogCollectors) {
        this.mAutoCollectors = autoLogCollectors;
    }

    @Override
    public boolean isExperimentEnabled() {
        return this.mExperimentEnabled;
    }

    @Override
    public Map<String, String> getExperimentalFlags() {
        return this.mExperimentalFlags;
    }

    @Override
    public boolean captureScreenshotOnFailure() {
        return this.mScreenshotOnFailure;
    }

    @Override
    public boolean captureLogcatOnFailure() {
        return this.mLogcatOnFailure;
    }

    @Override
    public String getHostLogSuffix() {
        return this.mHostLogSuffix;
    }

    @Override
    public void setHostLogSuffix(String suffix) {
        this.mHostLogSuffix = suffix;
    }

    @Override
    public boolean shouldUseParallelRemoteSetup() {
        return this.mUseParallelRemoteSetup;
    }

    @Override
    public boolean shouldUseParallelSetup() {
        return this.mUseParallelSetup;
    }

    @Override
    public Duration getParallelSetupTimeout() {
        return this.mParallelSetupTimeout;
    }

    @Override
    public boolean shouldUseReplicateSetup() {
        return this.mReplicateParentSetup;
    }

    @Override
    public void setReplicateSetup(boolean replicate) {
        this.mReplicateParentSetup = replicate;
    }

    @Override
    public boolean shouldReportModuleProgression() {
        return this.mReportModuleProgression;
    }

    @Override
    public int getExtraRemotePostsubmitInstance() {
        return this.mExtraRemoteInstancePostsubmit;
    }

    @Override
    public boolean earlyDeviceRelease() {
        return this.mEnableEarlyDeviceRelease;
    }

    @Override
    public boolean delegatedEarlyDeviceRelease() {
        return this.mEnableDelegatedEarlyDeviceRelease;
    }

    @Override
    public void setDelegatedEarlyDeviceRelease(boolean earlyRelease) {
        this.mEnableDelegatedEarlyDeviceRelease = earlyRelease;
    }

    @Override
    public Map<String, String> getDynamicDownloadArgs() {
        return this.mDynamicDownloadArgs;
    }

    @Override
    public boolean reportTestCaseCount() {
        return this.mCountTestCases;
    }

    @Override
    public void setReportTestCaseCount(boolean report) {
        this.mCountTestCases = report;
    }

    @Override
    public boolean reportPassedTests() {
        return this.mReportPassedTests;
    }

    @Override
    public boolean filterPreviousPassedTests() {
        return this.mTestFilterPassed;
    }

    @Override
    public boolean reportInvocationComplete() {
        return this.mReportInvocationCompleteLogs;
    }

    @Override
    public void setReportInvocationComplete(boolean reportInvocationCompleteLogs) {
        this.mReportInvocationCompleteLogs = reportInvocationCompleteLogs;
    }

    @Override
    public List<String> reportingTags() {
        ArrayList<String> tags = new ArrayList<String>();
        if (this.mAutoCollectors.contains((Object)AutoLogCollector.DEVICE_TRACE)) {
            tags.add("device_tracing_enable");
        }
        return tags;
    }

    @Override
    public boolean shouldDisableInvocationSetupAndTeardown() {
        return this.mDisableInvocationSetupAndTeardown;
    }

    @Override
    public Integer getMultiDeviceCount() {
        return this.mMultiDeviceCount;
    }

    @Override
    public void setMultiDeviceCount(int count) {
        this.mMultiDeviceCount = count;
    }

    @Override
    public boolean isTracingEnabled() {
        return this.mTracingEnabled;
    }

    @Override
    public File getJdkFolderForSubprocess() {
        return this.mJdkFolder;
    }

    @Override
    public boolean shouldRemoteDynamicShard() {
        return this.mRemoteDynamicSharding;
    }

    @Override
    public void setShouldRemoteDynamicShard(boolean shouldRemoteDynamicShard) {
        this.mRemoteDynamicSharding = shouldRemoteDynamicShard;
    }

    @Override
    public boolean shouldUseEvenModuleSharding() {
        return this.mEvenModuleSharding;
    }

    @Override
    public void setShouldUseEvenModuleSharding(boolean useEvenModuleSharding) {
        this.mEvenModuleSharding = useEvenModuleSharding;
    }
}

