/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.clearcut.ClearcutClient;
import com.android.tradefed.clearcut.TerminateClearcutClient;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.NoDeviceException;
import com.android.tradefed.invoker.tracing.ActiveTrace;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.invoker.tracing.TracingLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.service.TradefedFeatureServer;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.SerializationUtil;
import com.android.tradefed.util.SystemUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class CommandRunner {
    private ICommandScheduler mScheduler;
    private ExitCode mErrorCode = ExitCode.NO_ERROR;
    public static final String EXCEPTION_KEY = "serialized_exception";
    public static final String START_FEATURE_SERVER = "START_FEATURE_SERVER";
    private static final long CHECK_DEVICE_TIMEOUT = 60000L;

    public ExitCode getErrorCode() {
        return this.mErrorCode;
    }

    @VisibleForTesting
    void initGlobalConfig(String[] args) throws ConfigurationException {
        GlobalConfiguration.createGlobalConfiguration(args);
        GlobalConfiguration.getInstance().setup();
    }

    @VisibleForTesting
    ICommandScheduler getCommandScheduler() {
        return GlobalConfiguration.getInstance().getCommandScheduler();
    }

    @VisibleForTesting
    void printStackTrace(Throwable e) {
        e.printStackTrace();
        File serializedException = null;
        try {
            serializedException = SerializationUtil.serialize(e);
            JSONObject json = new JSONObject();
            json.put(EXCEPTION_KEY, serializedException.getAbsolutePath());
            System.err.println(json.toString());
            System.err.flush();
        }
        catch (IOException | JSONException io) {
            io.printStackTrace();
            FileUtil.deleteFile(serializedException);
        }
    }

    @VisibleForTesting
    long getCheckDeviceTimeout() {
        return 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            CompletableFuture<ClearcutClient> futureClient = CompletableFuture.supplyAsync(() -> this.createClient());
            try (CloseableTraceScope ignored = new CloseableTraceScope("initGlobalConfig");){
                this.initGlobalConfig(args);
            }
            ClearcutClient client = futureClient.get();
            Runtime.getRuntime().addShutdownHook(new TerminateClearcutClient(client));
            client.notifyTradefedStartEvent();
            if (System.getenv(START_FEATURE_SERVER) != null) {
                CompletableFuture.supplyAsync(() -> this.startFeatureSever());
            }
            this.mScheduler = this.getCommandScheduler();
            this.mScheduler.setClearcutClient(client);
            this.mScheduler.start();
            SignalHandler handler = new SignalHandler(){

                @Override
                public void handle(Signal sig) {
                    LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, String.format("Received signal %s. Shutting down.", sig.getName()));
                    CommandRunner.this.mScheduler.shutdownHard(false);
                }
            };
            Signal.handle(new Signal("TERM"), handler);
            this.mScheduler.addCommand(args);
        }
        catch (ConfigurationException | InterruptedException | RuntimeException | ExecutionException e) {
            this.printStackTrace(e);
            this.mErrorCode = ExitCode.CONFIG_EXCEPTION;
            return;
        }
        finally {
            if (this.mScheduler != null) {
                this.mScheduler.shutdownOnEmpty();
            }
        }
        try {
            this.mScheduler.join(this.getCheckDeviceTimeout());
            if (this.mScheduler.getReadyCommandCount() > 0 && this.mScheduler.getExecutingCommandCount() == 0) {
                this.printStackTrace(new NoDeviceException("No device was allocated for the command.", InfraErrorIdentifier.RUNNER_ALLOCATION_ERROR));
                this.mErrorCode = ExitCode.NO_DEVICE_ALLOCATED;
                this.mScheduler.removeAllCommands();
                this.mScheduler.shutdown();
                return;
            }
            this.mScheduler.join();
            if (ExitCode.NO_ERROR.equals((Object)this.mErrorCode)) {
                this.mErrorCode = this.mScheduler.getLastInvocationExitCode();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.mErrorCode = ExitCode.THROWABLE_EXCEPTION;
        }
        finally {
            GlobalConfiguration.getInstance().cleanup();
        }
        if (!ExitCode.NO_ERROR.equals((Object)this.mErrorCode) && this.mScheduler.getLastInvocationThrowable() != null) {
            this.printStackTrace(this.mScheduler.getLastInvocationThrowable());
        }
    }

    protected ClearcutClient createClient() {
        try (CloseableTraceScope ignored = new CloseableTraceScope("createClient");){
            ClearcutClient clearcutClient = new ClearcutClient(TestSuiteInfo.getInstance().didLoadFromProperties() ? TestSuiteInfo.getInstance().getName() : "");
            return clearcutClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] mainArgs) {
        long pid = ProcessHandle.current().pid();
        long tid = Thread.currentThread().getId();
        ActiveTrace trace = null;
        if (SystemUtil.isLocalMode()) {
            trace = TracingLogger.createActiveTrace(pid, tid, true);
            trace.startTracing(false);
        }
        CommandRunner console = new CommandRunner();
        try (CloseableTraceScope ignored = new CloseableTraceScope("end_to_end_command");){
            console.run(mainArgs);
        }
        finally {
            if (trace != null) {
                trace.finalizeTracing();
            }
        }
        System.exit(console.getErrorCode().getCodeValue());
    }

    private boolean startFeatureSever() {
        try (CloseableTraceScope f = new CloseableTraceScope("start_fr_client");){
            TradefedFeatureServer server = new TradefedFeatureServer();
            server.start();
            GlobalConfiguration.getInstance().setTradefedFeatureServer(server);
        }
        catch (RuntimeException e) {
            System.out.println(String.format("Error starting feature server: %s", e));
        }
        return true;
    }

    public static enum ExitCode {
        NO_ERROR(0),
        CONFIG_EXCEPTION(1),
        NO_BUILD(2),
        DEVICE_UNRESPONSIVE(3),
        DEVICE_UNAVAILABLE(4),
        FATAL_HOST_ERROR(5),
        THROWABLE_EXCEPTION(6),
        NO_DEVICE_ALLOCATED(7),
        WRONG_JAVA_VERSION(8);

        private final int mCodeValue;

        private ExitCode(int codeValue) {
            this.mCodeValue = codeValue;
        }

        public int getCodeValue() {
            return this.mCodeValue;
        }
    }
}

