/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.clearcut.ClearcutClient;
import com.android.tradefed.command.CommandFileParser;
import com.android.tradefed.command.CommandFileWatcher;
import com.android.tradefed.command.CommandRunner;
import com.android.tradefed.command.DeviceAllocationResult;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.RetryConfigurationFactory;
import com.android.tradefed.config.SandboxConfigurationFactory;
import com.android.tradefed.config.proxy.ProxyConfiguration;
import com.android.tradefed.config.proxy.TradefedDelegator;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NoDeviceException;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.invoker.shard.ParentShardReplicate;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ConsoleResultReporter;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogSaverResultForwarder;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.suite.SuiteResultReporter;
import com.android.tradefed.sandbox.ISandbox;
import com.android.tradefed.service.TradefedFeatureServer;
import com.android.tradefed.service.management.DeviceManagementGrpcServer;
import com.android.tradefed.service.management.TestInvocationManagementServer;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.retry.RetryRescheduler;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.Pair;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TableFormatter;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.hostmetric.IHostMonitor;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.android.tradefed.util.keystore.IKeyStoreFactory;
import com.android.tradefed.util.keystore.KeyStoreException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CommandScheduler
extends Thread
implements ICommandScheduler,
CommandFileWatcher.ICommandFileListener {
    private List<ExecutableCommand> mReadyCommands;
    private Set<ExecutableCommand> mUnscheduledWarning;
    private Set<ExecutableCommand> mSleepingCommands;
    private Set<ExecutableCommand> mExecutingCommands;
    private Map<IInvocationContext, InvocationThread> mInvocationThreadMap;
    private Map<IInvocationContext, InvocationThread> mInvocationThreadMapTerminating;
    private ScheduledThreadPoolExecutor mCommandTimer;
    private CommandFileWatcher mCommandFileWatcher = null;
    private final CountDownLatch mRunLatch;
    private static final long ADB_INIT_TIME_MS = 25L;
    private int mCurrentCommandId = 0;
    private boolean mShutdownOnEmpty = false;
    private boolean mStopScheduling = false;
    private boolean mStarted = false;
    private WaitObj mCommandProcessWait = new WaitObj();
    private CommandRunner.ExitCode mLastInvocationExitCode = CommandRunner.ExitCode.NO_ERROR;
    private Throwable mLastInvocationThrowable = null;
    private ClearcutClient mClient = null;
    @Option(name="reload-cmdfiles", description="Whether to enable the command file autoreload mechanism")
    private boolean mReloadCmdfiles = false;
    @Option(name="max-poll-time", description="ms between forced command scheduler execution time")
    private long mPollTime = 30000L;
    @Option(name="shutdown-on-cmdfile-error", description="terminate TF session if a configuration exception on command file occurs")
    private boolean mShutdownOnCmdfileError = false;
    @Option(name="shutdown-delay", description="maximum time to wait before allowing final interruption of scheduler to terminate TF session. If value is zero, interruption will only be triggered when Invocation become interruptible. (Default behavior).", isTimeVal=true)
    private long mShutdownTimeout = 0L;
    private HostState mHostState = HostState.UNKNOWN;

    private void setHostState(HostState state) {
        this.mHostState = state;
    }

    public HostState getHostState() {
        return this.mHostState;
    }

    public static Map<ITestDevice, FreeDeviceState> createReleaseMap(IInvocationContext context, Throwable e) {
        LinkedHashMap<ITestDevice, FreeDeviceState> deviceStates = new LinkedHashMap<ITestDevice, FreeDeviceState>();
        for (ITestDevice device : context.getDevices()) {
            deviceStates.put(device, FreeDeviceState.AVAILABLE);
        }
        if (context.wasReleasedEarly()) {
            return deviceStates;
        }
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice && !(device.getIDevice() instanceof DeviceManager.FastbootDevice) || device instanceof RemoteAndroidDevice) {
                deviceStates.put(device, FreeDeviceState.AVAILABLE);
            } else {
                TestDeviceState deviceState = device.getDeviceState();
                LogUtil.CLog.d("TestDeviceState for releasing '%s(%s)' is '%s'", new Object[]{device.getSerialNumber(), device.getClass(), deviceState});
                if (SystemUtil.isLocalMode()) {
                    deviceStates.put(device, FreeDeviceState.AVAILABLE);
                } else if (!TestDeviceState.ONLINE.equals((Object)deviceState)) {
                    deviceStates.put(device, FreeDeviceState.UNAVAILABLE);
                } else if (!device.waitForDeviceShell(30000L)) {
                    deviceStates.put(device, FreeDeviceState.UNAVAILABLE);
                }
            }
            device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
        }
        if (e instanceof DeviceFailedToBootError && e.getCause() instanceof DeviceNotAvailableException) {
            e = e.getCause();
        }
        DeviceNotAvailableException dnae = null;
        FreeDeviceState unavailable = null;
        if (e instanceof DeviceUnresponsiveException) {
            dnae = (DeviceUnresponsiveException)e;
            unavailable = FreeDeviceState.UNRESPONSIVE;
        } else if (e instanceof DeviceNotAvailableException) {
            dnae = (DeviceNotAvailableException)e;
            unavailable = FreeDeviceState.UNAVAILABLE;
        }
        if (dnae != null) {
            if (!InfraErrorIdentifier.INVOCATION_CANCELLED.equals(dnae.getErrorId())) {
                ITestDevice badDevice = context.getDeviceBySerial(dnae.getSerial());
                if (badDevice != null && !(badDevice.getIDevice() instanceof StubDevice)) {
                    deviceStates.put(badDevice, unavailable);
                }
            } else {
                LogUtil.CLog.d("Invocation cancelled detected.");
            }
        }
        LogUtil.CLog.d("Release map of the devices: %s", deviceStates);
        return deviceStates;
    }

    public CommandScheduler() {
        super("CommandScheduler");
        this.mReadyCommands = new LinkedList<ExecutableCommand>();
        this.mUnscheduledWarning = new HashSet<ExecutableCommand>();
        this.mSleepingCommands = new HashSet<ExecutableCommand>();
        this.mExecutingCommands = new HashSet<ExecutableCommand>();
        this.mInvocationThreadMap = new HashMap<IInvocationContext, InvocationThread>();
        this.mInvocationThreadMapTerminating = new HashMap<IInvocationContext, InvocationThread>();
        this.mCommandTimer = new ScheduledThreadPoolExecutor(1);
        this.mRunLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            if (this.mStarted) {
                throw new IllegalStateException("scheduler has already been started");
            }
            this.initLogging();
            try (CloseableTraceScope ignored = new CloseableTraceScope("initDeviceManager");){
                this.initDeviceManager();
            }
            this.mStarted = true;
        }
        super.start();
        this.setHostState(HostState.RUNNING);
    }

    @Override
    public synchronized CommandFileWatcher getCommandFileWatcher() {
        this.assertStarted();
        if (this.mCommandFileWatcher == null) {
            this.mCommandFileWatcher = new CommandFileWatcher(this);
            this.mCommandFileWatcher.start();
        }
        return this.mCommandFileWatcher;
    }

    void initDeviceManager() {
        this.getDeviceManager().init();
        if (this.getDeviceManager().waitForFirstDeviceAdded(25L)) {
            RunUtil.getDefault().sleep(25L);
        }
    }

    ITestInvocation createRunInstance() {
        return new TestInvocation();
    }

    protected IDeviceManager getDeviceManager() {
        return GlobalConfiguration.getDeviceManagerInstance();
    }

    protected IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    List<IHostMonitor> getHostMonitor() {
        return GlobalConfiguration.getHostMonitorInstances();
    }

    protected IConfigurationFactory getConfigFactory() {
        return ConfigurationFactory.getInstance();
    }

    protected TradefedFeatureServer getFeatureServer() {
        return GlobalConfiguration.getInstance().getFeatureServer();
    }

    protected TestInvocationManagementServer getTestInvocationManagementServer() {
        return GlobalConfiguration.getInstance().getTestInvocationManagementSever();
    }

    protected DeviceManagementGrpcServer getDeviceManagementServer() {
        return GlobalConfiguration.getInstance().getDeviceManagementServer();
    }

    protected IKeyStoreClient getKeyStoreClient() {
        try {
            IKeyStoreFactory f = GlobalConfiguration.getInstance().getKeyStoreFactory();
            if (f != null) {
                try {
                    return f.createKeyStoreClient();
                }
                catch (KeyStoreException e) {
                    LogUtil.CLog.e("Failed to create key store client");
                    LogUtil.CLog.e(e);
                }
            }
        }
        catch (IllegalStateException e) {
            LogUtil.CLog.w("Global configuration has not been created, failed to get keystore");
            LogUtil.CLog.e(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.assertStarted();
        try {
            IDeviceManager manager = this.getDeviceManager();
            this.mRunLatch.countDown();
            manager.addDeviceMonitor(new AvailDeviceMonitor());
            while (!this.isShutdown()) {
                this.mCommandProcessWait.waitAndReset(this.mPollTime);
                this.checkInvocations();
                try {
                    this.processReadyCommands(manager);
                }
                catch (RuntimeException e) {
                    LogUtil.CLog.e(e);
                    HashMap<String, String> information = new HashMap<String, String>();
                    information.put("Exception", "CommandScheduler");
                    information.put("stack", StreamUtil.getStackTrace(e));
                    this.logEvent(ILogRegistry.EventType.UNEXPECTED_EXCEPTION, information);
                }
            }
            this.mCommandTimer.shutdown();
            manager.terminateDeviceRecovery();
            manager.terminateDeviceMonitor();
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Waiting for invocation threads to complete");
            this.waitForAllInvocationThreads();
            this.waitForTerminatingInvocationThreads();
            this.exit(manager);
            this.cleanUp();
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "All done");
            if (this.getFeatureServer() != null) {
                try {
                    this.getFeatureServer().shutdown();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (this.getDeviceManagementServer() != null) {
                try {
                    this.getDeviceManagementServer().shutdown();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (this.getTestInvocationManagementServer() != null) {
                try {
                    this.getTestInvocationManagementServer().shutdown();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (this.mClient != null) {
                this.mClient.notifyTradefedFinishedEvent();
                this.mClient.stop();
            }
        }
        finally {
            System.err.flush();
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInvocations() {
        ArrayList<InvocationThread> copy;
        LogUtil.CLog.d("Checking invocations...");
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            copy = new ArrayList<InvocationThread>(this.mInvocationThreadMap.values());
        }
        for (InvocationThread thread : copy) {
            thread.checkDeviceBatteryLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReadyCommands(IDeviceManager manager) {
        ExecutableCommand cmd;
        LogUtil.CLog.d("processReadyCommands...");
        HashMap<ExecutableCommand, InvocationContext> scheduledCommandMap = new HashMap<ExecutableCommand, InvocationContext>();
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            Collections.sort(this.mReadyCommands, new ExecutableCommandComparator());
            Iterator<ExecutableCommand> iterator2 = this.mReadyCommands.iterator();
            while (iterator2.hasNext()) {
                cmd = iterator2.next();
                IConfiguration config = cmd.getConfiguration();
                InvocationContext context = new InvocationContext();
                context.setConfigurationDescriptor(config.getConfigurationDescription());
                DeviceAllocationResult allocationResults = this.allocateDevices(config, manager);
                if (allocationResults.wasAllocationSuccessful()) {
                    Map<String, ITestDevice> devices = allocationResults.getAllocatedDevices();
                    iterator2.remove();
                    this.mExecutingCommands.add(cmd);
                    context.addAllocatedDevice(devices);
                    scheduledCommandMap.put(cmd, context);
                    this.mUnscheduledWarning.remove(cmd);
                    continue;
                }
                if (this.mUnscheduledWarning.contains(cmd)) continue;
                LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "No available device matching all the config's requirements for cmd id %d.", cmd.getCommandTracker().getId());
                System.out.println(String.format("Command will be rescheduled: %s", Arrays.toString(cmd.getCommandTracker().getArgs())));
                this.mUnscheduledWarning.add(cmd);
            }
        }
        for (Map.Entry entry : scheduledCommandMap.entrySet()) {
            cmd = (ExecutableCommand)entry.getKey();
            try (CloseableTraceScope ignored = new CloseableTraceScope("startInvocation");){
                this.startInvocation((IInvocationContext)entry.getValue(), cmd, new FreeDeviceHandler(this.getDeviceManager(), new ICommandScheduler.IScheduledInvocationListener[0]));
            }
            cmd.getCommandTracker().incrementScheduledCount();
            if (!cmd.isLoopMode() || cmd.getCommandTracker().getScheduledCount() >= cmd.getMaxLoopCount()) continue;
            this.addNewExecCommandToQueue(cmd.getCommandTracker());
        }
        LogUtil.CLog.d("done processReadyCommands...");
    }

    @Override
    public void await() throws InterruptedException {
        while (this.mRunLatch.getCount() > 0L) {
            this.mRunLatch.await();
        }
    }

    private void waitForThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            this.waitForThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllInvocationThreads() {
        ArrayList<InvocationThread> threadListCopy;
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            threadListCopy = new ArrayList<InvocationThread>();
            threadListCopy.addAll(this.mInvocationThreadMap.values());
        }
        for (Thread thread : threadListCopy) {
            this.waitForThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTerminatingInvocationThreads() {
        ArrayList<InvocationThread> threadListCopy;
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            threadListCopy = new ArrayList<InvocationThread>();
            threadListCopy.addAll(this.mInvocationThreadMapTerminating.values());
        }
        for (Thread thread : threadListCopy) {
            this.waitForThread(thread);
        }
    }

    private void exit(IDeviceManager manager) {
        if (manager != null) {
            manager.terminate();
        }
    }

    @Override
    public Pair<Boolean, Integer> addCommand(String[] args) throws ConfigurationException {
        Integer cmdTracker = this.internalAddCommand(args, null);
        return Pair.create(cmdTracker >= 0, cmdTracker);
    }

    private boolean isCommandSandboxed(String[] args) {
        boolean foundSandbox = false;
        for (String arg : args) {
            if ("--use-sandbox".equals(arg)) {
                foundSandbox = true;
                continue;
            }
            if (!"--no-use-sandbox".equals(arg)) continue;
            foundSandbox = false;
        }
        return foundSandbox;
    }

    private boolean isProxyCommand(String[] args) throws ConfigurationException {
        ProxyConfiguration proxy = new ProxyConfiguration();
        ArgsOptionParser argsParser = new ArgsOptionParser(proxy);
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        argsList.remove(0);
        argsParser.parseBestEffort(argsList, true);
        return proxy.isProxySet();
    }

    private IConfiguration handleProxyCommand(String[] originalArgs) throws ConfigurationException {
        IConfiguration config = ((ConfigurationFactory)this.getConfigFactory()).createPartialConfigurationFromArgs(originalArgs, this.getKeyStoreClient(), ImmutableSet.of("proxy-config"), null);
        try {
            config.resolveDynamicOptions(new DynamicRemoteFileResolver());
        }
        catch (BuildRetrievalError e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        ProxyConfiguration proxy = (ProxyConfiguration)config.getConfigurationObject("proxy-config");
        if (proxy.getProxyConfig() == null) {
            throw new ConfigurationException("No proxy configuration found.");
        }
        originalArgs[0] = proxy.getProxyConfig().getAbsolutePath();
        return config;
    }

    private boolean isRetryCommand(IConfiguration config) {
        if (config.getTests().size() != 1) {
            return false;
        }
        IRemoteTest rerunner = config.getTests().get(0);
        return rerunner instanceof RetryRescheduler;
    }

    public ISandbox createSandbox() {
        return GlobalConfiguration.getInstance().getSandboxFactory().createSandbox();
    }

    protected IConfiguration createConfiguration(String[] args) throws ConfigurationException {
        TradefedDelegator delegator = CommandScheduler.checkDelegation(args);
        if (delegator.shouldUseDelegation()) {
            args = TradefedDelegator.clearCommandline(args);
            if (!delegator.isStaging()) {
                delegator.setCommandLine(args);
                LogUtil.CLog.d("Using commandline arguments as starting command: %s", Arrays.asList(args));
                IConfiguration config = ((ConfigurationFactory)this.getConfigFactory()).createPartialConfigurationFromArgs(args, this.getKeyStoreClient(), ImmutableSet.of("device_requirements", "logger", "log_saver", "result_reporter"), delegator);
                this.setDelegateLevelReporting(config);
                return config;
            }
        }
        if (this.isCommandSandboxed(args)) {
            ISandbox sandbox = this.createSandbox();
            return SandboxConfigurationFactory.getInstance().createConfigurationFromArgs(args, this.getKeyStoreClient(), sandbox, new RunUtil());
        }
        if (this.isProxyCommand(args)) {
            IConfiguration proxyConfig = this.handleProxyCommand(args);
            String[] argsWithoutDelegation = ProxyConfiguration.clearCommandline(args);
            IConfiguration resolvedConfig = null;
            try {
                resolvedConfig = this.getConfigFactory().createConfigurationFromArgs(argsWithoutDelegation, null, this.getKeyStoreClient());
            }
            catch (ConfigurationException e) {
                proxyConfig.cleanConfigurationData();
                throw e;
            }
            resolvedConfig.addFilesToClean(proxyConfig.getFilesToClean());
            return resolvedConfig;
        }
        IConfiguration config = this.getConfigFactory().createConfigurationFromArgs(args, null, this.getKeyStoreClient());
        if (this.isRetryCommand(config)) {
            return RetryConfigurationFactory.getInstance().createRetryConfiguration(config);
        }
        return config;
    }

    public static TradefedDelegator checkDelegation(String[] args) throws ConfigurationException {
        TradefedDelegator delegator = new TradefedDelegator();
        ArgsOptionParser argsParser = new ArgsOptionParser(delegator);
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        argsList.remove(0);
        argsParser.parseBestEffort(argsList, true);
        return delegator;
    }

    private void setDelegateLevelReporting(IConfiguration config) {
        Class<?> objectClass;
        ArrayList<ITestInvocationListener> delegateReporters = new ArrayList<ITestInvocationListener>();
        delegateReporters.add(new ConsoleResultReporter());
        delegateReporters.add(new SuiteResultReporter());
        try {
            objectClass = Class.forName("com.google.android.tradefed.result.teststorage.ResultReporter");
            Object infraReporter = objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            delegateReporters.add((ITestInvocationListener)infraReporter);
        }
        catch (Exception e) {
            LogUtil.CLog.e(e);
        }
        config.setTestInvocationListeners(delegateReporters);
        try {
            objectClass = Class.forName("com.google.android.tradefed.result.AndroidBuildApiLogSaver");
            Object infraLogger = objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            config.setLogSaver((ILogSaver)infraLogger);
        }
        catch (Exception e) {
            LogUtil.CLog.e(e);
        }
    }

    private Integer internalAddCommand(String[] args, String cmdFilePath) throws ConfigurationException {
        this.assertStarted();
        IConfiguration config = this.createConfiguration(args);
        if (config.getCommandOptions().isHelpMode()) {
            this.getConfigFactory().printHelpForConfig(args, true, System.out);
        } else if (config.getCommandOptions().isFullHelpMode()) {
            this.getConfigFactory().printHelpForConfig(args, false, System.out);
        } else if (config.getCommandOptions().isDryRunMode()) {
            config.validateOptions();
            String cmdLine = QuotationAwareTokenizer.combineTokens(args);
            LogUtil.CLog.d("Dry run mode; skipping adding command: %s", cmdLine);
            if (config.getCommandOptions().isNoisyDryRunMode()) {
                System.out.println(cmdLine.replace("--noisy-dry-run", ""));
                System.out.println("");
            }
        } else {
            config.validateOptions();
            if (config.getCommandOptions().runOnAllDevices()) {
                this.addCommandForAllDevices(args, cmdFilePath);
                return 0;
            }
            CommandTracker cmdTracker = this.createCommandTracker(args, cmdFilePath);
            ExecutableCommand cmdInstance = this.createExecutableCommand(cmdTracker, config, false);
            this.addExecCommandToQueue(cmdInstance, 0L);
            return cmdTracker.getId();
        }
        return -1;
    }

    @Override
    public void addCommandFile(String cmdFilePath, List<String> extraArgs) throws ConfigurationException {
        File cmdFile = new File(cmdFilePath);
        if (this.mReloadCmdfiles && this.getCommandFileWatcher().isFileWatched(cmdFile)) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "cmd file %s is already running and being watched for changes. Reloading", cmdFilePath);
            this.removeCommandsFromFile(cmdFile);
        }
        this.internalAddCommandFile(cmdFile, extraArgs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalAddCommandFile(File cmdFile, List<String> extraArgs) throws ConfigurationException {
        try {
            CommandFileParser parser = this.createCommandFileParser();
            List<CommandFileParser.CommandLine> commands = parser.parseFile(cmdFile);
            if (this.mReloadCmdfiles) {
                this.getCommandFileWatcher().addCmdFile(cmdFile, extraArgs, parser.getIncludedFiles());
            }
            for (CommandFileParser.CommandLine command : commands) {
                command.addAll(extraArgs);
                String[] arrayCommand = command.asArray();
                String prettyCmdLine = QuotationAwareTokenizer.combineTokens(arrayCommand);
                LogUtil.CLog.d("Adding command %s", prettyCmdLine);
                try {
                    this.internalAddCommand(arrayCommand, cmdFile.getAbsolutePath());
                }
                catch (ConfigurationException e) {
                    throw new ConfigurationException(String.format("Failed to add command '%s': %s", prettyCmdLine, e.getMessage()), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to read file " + cmdFile.getAbsolutePath(), e, InfraErrorIdentifier.CONFIGURATION_NOT_FOUND);
        }
    }

    CommandFileParser createCommandFileParser() {
        return new CommandFileParser();
    }

    private void addCommandForAllDevices(String[] args, String cmdFilePath) throws ConfigurationException {
        List<DeviceDescriptor> deviceDescs = this.getDeviceManager().listAllDevices();
        for (DeviceDescriptor deviceDesc : deviceDescs) {
            if (deviceDesc.isStubDevice()) continue;
            String device = deviceDesc.getSerial();
            String[] argsWithDevice = Arrays.copyOf(args, args.length + 2);
            argsWithDevice[argsWithDevice.length - 2] = "-s";
            argsWithDevice[argsWithDevice.length - 1] = device;
            CommandTracker cmdTracker = this.createCommandTracker(argsWithDevice, cmdFilePath);
            IConfiguration config = this.getConfigFactory().createConfigurationFromArgs(cmdTracker.getArgs(), null, this.getKeyStoreClient());
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Scheduling '%s' on '%s'", cmdTracker.getArgs()[0], device);
            config.getDeviceRequirements().setSerial(device);
            ExecutableCommand execCmd = this.createExecutableCommand(cmdTracker, config, false);
            this.addExecCommandToQueue(execCmd, 0L);
        }
    }

    private synchronized CommandTracker createCommandTracker(String[] args, String commandFilePath) {
        ++this.mCurrentCommandId;
        LogUtil.CLog.d("Creating command tracker id %d for command args: '%s'", this.mCurrentCommandId, ArrayUtil.join(" ", args));
        return new CommandTracker(this.mCurrentCommandId, args, commandFilePath);
    }

    private ExecutableCommand createExecutableCommand(CommandTracker cmdTracker, IConfiguration config, boolean rescheduled) {
        ExecutableCommand cmd = new ExecutableCommand(cmdTracker, config, rescheduled);
        LogUtil.CLog.d("creating exec command for id %d", cmdTracker.getId());
        return cmd;
    }

    private void addNewExecCommandToQueue(CommandTracker commandTracker) {
        try {
            IConfiguration config = this.createConfiguration(commandTracker.getArgs());
            ExecutableCommand execCmd = this.createExecutableCommand(commandTracker, config, false);
            this.addExecCommandToQueue(execCmd, config.getCommandOptions().getLoopTime());
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e(e);
        }
    }

    private synchronized boolean addExecCommandToQueue(final ExecutableCommand cmd, long delayTime) {
        if (this.isShutdown() && cmd.getConfiguration().getConfigurationDescription().getMetaData("sharded") == null) {
            return false;
        }
        if (delayTime > 0L) {
            this.mSleepingCommands.add(cmd);
            Runnable delayCommand = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CommandScheduler commandScheduler = CommandScheduler.this;
                    synchronized (commandScheduler) {
                        if (CommandScheduler.this.mSleepingCommands.remove(cmd)) {
                            CommandScheduler.this.mReadyCommands.add(cmd);
                            CommandScheduler.this.mCommandProcessWait.signalEventReceived();
                        }
                    }
                }
            };
            this.mCommandTimer.schedule(delayCommand, delayTime, TimeUnit.MILLISECONDS);
        } else {
            this.mReadyCommands.add(cmd);
            this.mCommandProcessWait.signalEventReceived();
        }
        return true;
    }

    private String getArgString(String[] args) {
        return ArrayUtil.join(" ", args);
    }

    @Override
    public long execCommand(IInvocationContext context, ICommandScheduler.IScheduledInvocationListener listener, String[] args) throws ConfigurationException, NoDeviceException {
        return this.execCommand(context, listener, new ArrayList<ITestDevice>(), args);
    }

    @Override
    public long execCommand(ICommandScheduler.IScheduledInvocationListener listener, List<ITestDevice> reservedDevices, String[] args) throws ConfigurationException {
        return this.execCommand(null, listener, reservedDevices, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected long execCommand(IInvocationContext context, ICommandScheduler.IScheduledInvocationListener listener, List<ITestDevice> reservedDevices, String[] args) throws ConfigurationException {
        this.assertStarted();
        IDeviceManager manager = this.getDeviceManager();
        CommandTracker cmdTracker = this.createCommandTracker(args, null);
        IConfiguration config = this.createConfiguration(cmdTracker.getArgs());
        config.validateOptions();
        if (this.isShuttingDown()) {
            if (context != null) {
                LogUtil.CLog.w("Tradefed is shutting down, ignoring command.");
                return -1L;
            }
            throw new ConfigurationException("Tradefed shutting down, skip scheduling.");
        }
        Map<Object, Object> allocatedDevices = new LinkedHashMap();
        if (!reservedDevices.isEmpty()) {
            allocatedDevices = this.getAllocatedDevices(config.getDeviceConfig(), reservedDevices);
        }
        if (reservedDevices.size() < config.getDeviceConfig().size()) {
            LogUtil.CLog.d("%s of %s devices reserved.", reservedDevices.size(), config.getDeviceConfig().size());
            DeviceAllocationResult allocationResults = this.allocateDevices(config, manager, new ArrayList<Object>(allocatedDevices.keySet()));
            if (!allocationResults.wasAllocationSuccessful()) {
                if (this.getDeviceManager() instanceof DeviceManager) {
                    String adbOutput = ((DeviceManager)this.getDeviceManager()).executeGlobalAdbCommand("devices");
                    LogUtil.CLog.e("'adb devices' output:\n%s", adbOutput);
                }
                throw new NoDeviceException(String.format("No device match for allocation. Reason: %s.\ncommand: %s", allocationResults.formattedReason(), Arrays.asList(args)), InfraErrorIdentifier.SCHEDULER_ALLOCATION_ERROR);
            }
            LinkedHashMap<String, ITestDevice> orderedDevices = new LinkedHashMap<String, ITestDevice>();
            for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
                String deviceName = deviceConfig.getDeviceName();
                ITestDevice device = (ITestDevice)allocatedDevices.get(deviceName);
                if (device == null) {
                    device = allocationResults.getAllocatedDevices().get(deviceName);
                }
                orderedDevices.put(deviceName, device);
            }
            allocatedDevices = orderedDevices;
        }
        ExecutableCommand execCmd = this.createExecutableCommand(cmdTracker, config, false);
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            this.mExecutingCommands.add(execCmd);
        }
        context = context != null ? context : this.createInvocationContext();
        context.setConfigurationDescriptor(config.getConfigurationDescription());
        context.addAllocatedDevice(allocatedDevices);
        LogUtil.CLog.d("Executing '%s' on '%s'", cmdTracker.getArgs()[0], allocatedDevices);
        if (reservedDevices.isEmpty()) {
            this.startInvocation(context, execCmd, listener, new FreeDeviceHandler(manager, new ICommandScheduler.IScheduledInvocationListener[0]));
        } else {
            this.startInvocation(context, execCmd, listener, new FreeNullDeviceHandler(manager, new ICommandScheduler.IScheduledInvocationListener[0]));
        }
        return execCmd.getCommandTracker().getId();
    }

    Map<String, ITestDevice> getAllocatedDevices(List<IDeviceConfiguration> deviceConfig, List<ITestDevice> reservedDevices) {
        LinkedHashMap<String, ITestDevice> allocatedDevices = new LinkedHashMap<String, ITestDevice>();
        int iReserved = 0;
        for (IDeviceConfiguration config : deviceConfig) {
            if (config.getDeviceRequirements().nullDeviceRequested()) continue;
            if (iReserved >= reservedDevices.size()) {
                throw new NoDeviceException(String.format("Reserved devices (%s) fewer than required.", reservedDevices.size()), InfraErrorIdentifier.SCHEDULER_ALLOCATION_ERROR);
            }
            allocatedDevices.put(config.getDeviceName(), reservedDevices.get(iReserved++));
        }
        if (iReserved < reservedDevices.size()) {
            throw new NoDeviceException(String.format("Reserved devices (%s) more than required (%s).", reservedDevices.size(), iReserved), InfraErrorIdentifier.SCHEDULER_ALLOCATION_ERROR);
        }
        return allocatedDevices;
    }

    @Override
    public long execCommand(ICommandScheduler.IScheduledInvocationListener listener, ITestDevice device, String[] args) throws ConfigurationException {
        return this.execCommand(listener, Arrays.asList(device), args);
    }

    @Override
    public long execCommand(ICommandScheduler.IScheduledInvocationListener listener, String[] args) throws ConfigurationException, NoDeviceException {
        return this.execCommand(this.createInvocationContext(), listener, args);
    }

    DeviceAllocationResult allocateDevices(IConfiguration config, IDeviceManager manager) {
        return this.allocateDevices(config, manager, new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeviceAllocationResult allocateDevices(IConfiguration config, IDeviceManager manager, ArrayList<String> excludeDevices) {
        LinkedHashMap<String, ITestDevice> devices = new LinkedHashMap<String, ITestDevice>();
        ITestDevice device = null;
        if (config.getDeviceConfig().isEmpty()) {
            return null;
        }
        ParentShardReplicate.replicatedSetup(config, this.getKeyStoreClient());
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            DeviceAllocationResult allocationResults = new DeviceAllocationResult();
            for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
                if (excludeDevices.contains(deviceConfig.getDeviceName())) continue;
                device = manager.allocateDevice(deviceConfig.getDeviceRequirements(), deviceConfig.isFake());
                if (device != null) {
                    devices.put(deviceConfig.getDeviceName(), device);
                    continue;
                }
                allocationResults.addAllocationFailureReason(deviceConfig.getDeviceName(), deviceConfig.getDeviceRequirements().getNoMatchReason());
                for (ITestDevice allocatedDevice : devices.values()) {
                    FreeDeviceState deviceState = FreeDeviceState.AVAILABLE;
                    if (allocatedDevice.getIDevice() instanceof StubDevice) {
                        deviceState = FreeDeviceState.AVAILABLE;
                    } else if (!TestDeviceState.ONLINE.equals((Object)allocatedDevice.getDeviceState())) {
                        deviceState = FreeDeviceState.UNAVAILABLE;
                    }
                    manager.freeDevice(allocatedDevice, deviceState);
                }
                devices.clear();
                break;
            }
            allocationResults.addAllocatedDevices(devices);
            return allocationResults;
        }
    }

    @VisibleForTesting
    protected IInvocationContext createInvocationContext() {
        return new InvocationContext();
    }

    private void startInvocation(IInvocationContext context, ExecutableCommand cmd, ICommandScheduler.IScheduledInvocationListener ... listeners) {
        try {
            this.throwIfDeviceInInvocationThread(context.getDevices());
        }
        catch (Exception e) {
            this.setLastInvocationExitCode(CommandRunner.ExitCode.THROWABLE_EXCEPTION, e);
            for (ITestDevice device : context.getDevices()) {
                this.getDeviceManager().freeDevice(device, FreeDeviceState.AVAILABLE);
            }
            throw e;
        }
        int invocationId = cmd.getCommandTracker().getId();
        LogUtil.CLog.d("starting invocation for command id %d", invocationId);
        String invocationName = String.format("Invocation-%s", context.getSerials().get(0));
        InvocationThread invocationThread = new InvocationThread(invocationName, context, cmd, listeners);
        if (this.getFeatureServer() != null) {
            this.getFeatureServer().registerInvocation(cmd.getConfiguration(), invocationThread.getThreadGroup(), Arrays.asList(listeners));
        }
        context.addInvocationAttribute("invocation-id", Integer.toString(invocationId));
        this.logInvocationStartedEvent(cmd.getCommandTracker(), context);
        invocationThread.start();
        this.addInvocationThread(invocationThread);
    }

    private void logInvocationStartedEvent(CommandTracker tracker, IInvocationContext context) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("id", Integer.toString(tracker.getId()));
        int i = 0;
        for (String serial : context.getSerials()) {
            args.put("serial" + i, serial);
            ++i;
        }
        args.put("args", ArrayUtil.join(" ", Arrays.asList(tracker.getArgs())));
        this.logEvent(ILogRegistry.EventType.INVOCATION_START, args);
    }

    private synchronized void removeInvocationThread(InvocationThread invThread) {
        this.mInvocationThreadMap.remove(invThread.getInvocationContext());
        this.mInvocationThreadMapTerminating.put(invThread.getInvocationContext(), invThread);
    }

    private synchronized void clearTerminating(InvocationThread invThread) {
        this.mInvocationThreadMapTerminating.remove(invThread.getInvocationContext());
    }

    private synchronized void throwIfDeviceInInvocationThread(List<ITestDevice> devices) {
        for (ITestDevice device : devices) {
            if (!this.isDeviceInInvocationThread(device)) continue;
            throw new HarnessRuntimeException(String.format("Attempting invocation on device %s when one is already running", device.getSerialNumber()), InfraErrorIdentifier.SCHEDULING_ERROR);
        }
    }

    private synchronized void addInvocationThread(InvocationThread invThread) {
        this.mInvocationThreadMap.put(invThread.getInvocationContext(), invThread);
    }

    protected synchronized boolean isShutdown() {
        return this.mCommandTimer.isShutdown() || this.mShutdownOnEmpty && this.getAllCommandsSize() == 0;
    }

    public synchronized boolean isShuttingDown() {
        return this.mCommandTimer.isShutdown() || this.mShutdownOnEmpty || this.mStopScheduling;
    }

    @Override
    public synchronized void stopScheduling() {
        this.mStopScheduling = true;
        this.setHostState(HostState.QUITTING);
    }

    @Override
    public synchronized void shutdown(boolean notifyStop) {
        this.setHostState(HostState.QUITTING);
        this.doShutdown();
        if (notifyStop) {
            String reason = "Tradefed is notified to stop";
            for (InvocationThread thread : this.mInvocationThreadMap.values()) {
                thread.notifyInvocationStop(reason);
            }
        }
    }

    private synchronized void doShutdown() {
        this.assertStarted();
        if (!this.isShuttingDown()) {
            LogUtil.CLog.d("initiating shutdown");
            this.removeAllCommands();
            if (this.mCommandFileWatcher != null) {
                this.mCommandFileWatcher.cancel();
            }
            if (this.mCommandTimer != null) {
                this.mCommandTimer.shutdownNow();
            }
            this.mCommandProcessWait.signalEventReceived();
        }
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Received shutdown request.");
    }

    @Override
    public synchronized void shutdownOnEmpty() {
        if (!this.mStarted) {
            LogUtil.CLog.w("Scheduler was not started, yet shutdownOnEmpty was called.");
            return;
        }
        this.setHostState(HostState.QUITTING);
        if (!this.isShuttingDown()) {
            LogUtil.CLog.d("initiating shutdown on empty");
            this.mShutdownOnEmpty = true;
            this.mCommandProcessWait.signalEventReceived();
        }
    }

    @Override
    public synchronized void removeAllCommands() {
        this.assertStarted();
        LogUtil.CLog.d("removing all commands");
        if (this.mReloadCmdfiles) {
            this.getCommandFileWatcher().removeAllFiles();
        }
        if (this.mCommandTimer != null) {
            for (Runnable task : this.mCommandTimer.getQueue()) {
                this.mCommandTimer.remove(task);
            }
        }
        this.mReadyCommands.clear();
        this.mSleepingCommands.clear();
        if (this.isShuttingDown()) {
            this.mCommandProcessWait.signalEventReceived();
        }
    }

    private synchronized void removeCommandsFromFile(File cmdFile) {
        String path;
        ExecutableCommand cmd;
        Iterator<ExecutableCommand> cmdIter = this.mReadyCommands.iterator();
        while (cmdIter.hasNext()) {
            cmd = cmdIter.next();
            path = cmd.getCommandFilePath();
            if (path == null || !path.equals(cmdFile.getAbsolutePath())) continue;
            cmdIter.remove();
        }
        cmdIter = this.mSleepingCommands.iterator();
        while (cmdIter.hasNext()) {
            cmd = cmdIter.next();
            path = cmd.getCommandFilePath();
            if (path == null || !path.equals(cmdFile.getAbsolutePath())) continue;
            cmdIter.remove();
        }
        if (this.isShuttingDown()) {
            this.mCommandProcessWait.signalEventReceived();
        }
    }

    List<CommandTracker> getCommandTrackers() {
        List<ExecutableCommandState> cmdCopy = this.getAllCommands();
        LinkedHashSet<CommandTracker> cmdTrackers = new LinkedHashSet<CommandTracker>();
        for (ExecutableCommandState cmdState : cmdCopy) {
            cmdTrackers.add(cmdState.cmd.getCommandTracker());
        }
        return new ArrayList<CommandTracker>(cmdTrackers);
    }

    @Override
    public synchronized void shutdownHard() {
        this.shutdownHard(true);
    }

    private synchronized void shutdownHard(boolean killAdb, String reason, ErrorIdentifier error) {
        this.setHostState(HostState.KILLING);
        this.doShutdown();
        LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, "Stopping invocation threads...");
        for (InvocationThread thread : this.mInvocationThreadMap.values()) {
            thread.disableReporters();
            thread.stopInvocation(reason, error);
        }
        if (killAdb) {
            this.getDeviceManager().terminateHard(reason);
        } else {
            this.getDeviceManager().terminate();
        }
    }

    @Override
    public synchronized void shutdownHard(boolean killAdb) {
        String reason = "Tradefed is shutting down";
        this.shutdownHard(killAdb, reason, InfraErrorIdentifier.TRADEFED_SHUTTING_DOWN);
    }

    protected void initLogging() {
        DdmPreferences.setLogLevel(Log.LogLevel.VERBOSE.getStringValue());
        Log.setLogOutput(LogRegistry.getLogRegistry());
    }

    protected void cleanUp() {
        LogRegistry.getLogRegistry().closeAndRemoveAllLogs();
    }

    @VisibleForTesting
    void logEvent(ILogRegistry.EventType event, Map<String, String> args) {
        LogRegistry.getLogRegistry().logEvent(Log.LogLevel.DEBUG, event, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayInvocationsInfo(PrintWriter printWriter) {
        this.assertStarted();
        if (this.mInvocationThreadMap == null || this.mInvocationThreadMap.size() == 0) {
            return;
        }
        ArrayList<InvocationThread> copy = new ArrayList<InvocationThread>();
        CommandScheduler commandScheduler = this;
        synchronized (commandScheduler) {
            copy.addAll(this.mInvocationThreadMap.values());
        }
        ArrayList<List<String>> displayRows = new ArrayList<List<String>>();
        displayRows.add(Arrays.asList("Command Id", "Exec Time", "Device", "State"));
        long curTime = System.currentTimeMillis();
        for (InvocationThread invThread : copy) {
            displayRows.add(Arrays.asList(Integer.toString(invThread.mCmd.getCommandTracker().getId()), this.getTimeString(curTime - invThread.getStartTime()), invThread.getInvocationContext().getSerials().toString(), invThread.getInvocation().toString()));
        }
        new TableFormatter().displayTable(displayRows, printWriter);
    }

    private String getTimeString(long elapsedTime) {
        long duration = elapsedTime / 1000L;
        long secs = duration % 60L;
        long mins = duration / 60L % 60L;
        long hrs = duration / 3600L;
        String time = "unknown";
        time = hrs > 0L ? String.format("%dh:%02d:%02d", hrs, mins, secs) : String.format("%dm:%02d", mins, secs);
        return time;
    }

    @Override
    public synchronized boolean stopInvocation(ITestInvocation invocation) {
        for (InvocationThread thread : this.mInvocationThreadMap.values()) {
            if (thread.getInvocation() != invocation) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean stopInvocation(int invocationId, String cause) {
        for (InvocationThread thread : this.mInvocationThreadMap.values()) {
            if (thread.mCmd.getCommandTracker().mId != invocationId) continue;
            if (cause == null) {
                cause = "User requested stopping invocation " + invocationId;
            }
            thread.stopInvocation(cause);
            return true;
        }
        LogUtil.CLog.w("No invocation found matching the id: %s", invocationId);
        return false;
    }

    @Override
    public synchronized String getInvocationInfo(int invocationId) {
        for (InvocationThread thread : this.mInvocationThreadMap.values()) {
            if (thread.mCmd.getCommandTracker().mId != invocationId) continue;
            String info = Arrays.toString(thread.mCmd.getCommandTracker().getArgs());
            return info;
        }
        LogUtil.CLog.w("No invocation found matching the id: %s", invocationId);
        return null;
    }

    @Override
    public void displayCommandsInfo(PrintWriter printWriter, String regex) {
        this.assertStarted();
        Pattern regexPattern = null;
        if (regex != null) {
            regexPattern = Pattern.compile(regex);
        }
        List<CommandTracker> cmds = this.getCommandTrackers();
        Collections.sort(cmds, new CommandTrackerIdComparator());
        for (CommandTracker cmd : cmds) {
            String argString = this.getArgString(cmd.getArgs());
            if (regexPattern != null && !regexPattern.matcher(argString).find()) continue;
            String cmdDesc = String.format("Command %d: [%s] %s", cmd.getId(), this.getTimeString(cmd.getTotalExecTime()), argString);
            printWriter.println(cmdDesc);
        }
    }

    @Override
    public void dumpCommandsXml(PrintWriter printWriter, String regex) {
        this.assertStarted();
        Pattern regexPattern = null;
        if (regex != null) {
            regexPattern = Pattern.compile(regex);
        }
        List<ExecutableCommandState> cmdCopy = this.getAllCommands();
        for (ExecutableCommandState cmd : cmdCopy) {
            String[] args = cmd.cmd.getCommandTracker().getArgs();
            String argString = this.getArgString(args);
            if (regexPattern != null && !regexPattern.matcher(argString).find()) continue;
            String xmlPrefix = "config__" + args[0].replace("/", "__") + "__";
            boolean templateIncludeFound = false;
            boolean testFound = false;
            for (String arg : args) {
                if ("--template:map".equals(arg)) {
                    templateIncludeFound = true;
                    continue;
                }
                if (templateIncludeFound && "test".equals(arg)) {
                    testFound = true;
                    continue;
                }
                if (templateIncludeFound && testFound) {
                    xmlPrefix = "config__" + arg.replace("/", "__") + "__";
                }
                templateIncludeFound = false;
                testFound = false;
            }
            try {
                File xmlFile = FileUtil.createTempFile(xmlPrefix, ".xml");
                PrintWriter writer = new PrintWriter(xmlFile);
                cmd.cmd.getConfiguration().dumpXml(writer);
                printWriter.println(String.format("Saved command dump to %s", xmlFile.getAbsolutePath()));
            }
            catch (IOException e) {
                LogUtil.CLog.e("Could not dump config xml");
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void displayCommandQueue(PrintWriter printWriter) {
        this.assertStarted();
        List<ExecutableCommandState> cmdCopy = this.getAllCommands();
        if (cmdCopy.size() == 0) {
            return;
        }
        ArrayList<List<String>> displayRows = new ArrayList<List<String>>();
        displayRows.add(Arrays.asList("Id", "Config", "Created", "Exec time", "State", "Sleep time", "Rescheduled", "Loop"));
        long curTime = System.currentTimeMillis();
        for (ExecutableCommandState cmd : cmdCopy) {
            this.dumpCommand(curTime, cmd, displayRows);
        }
        new TableFormatter().displayTable(displayRows, printWriter);
    }

    private void dumpCommand(long curTime, ExecutableCommandState cmdAndState, ArrayList<List<String>> displayRows) {
        ExecutableCommand cmd = cmdAndState.cmd;
        String sleepTime = cmd.getSleepTime() == null ? "N/A" : this.getTimeString(cmd.getSleepTime());
        displayRows.add(Arrays.asList(Integer.toString(cmd.getCommandTracker().getId()), cmd.getCommandTracker().getArgs()[0], this.getTimeString(curTime - cmd.getCreationTime()), this.getTimeString(cmd.mCmdTracker.getTotalExecTime()), cmdAndState.state.getDisplayName(), sleepTime, Boolean.toString(cmd.isRescheduled()), Boolean.toString(cmd.isLoopMode())));
    }

    private synchronized void assertStarted() {
        if (!this.mStarted) {
            throw new IllegalStateException("start() must be called before this method");
        }
    }

    @Override
    public void notifyFileChanged(File cmdFile, List<String> extraArgs) {
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Detected update for cmdfile '%s'. Reloading", cmdFile.getAbsolutePath());
        this.removeCommandsFromFile(cmdFile);
        try {
            this.internalAddCommandFile(cmdFile, extraArgs);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.wtf(String.format("Failed to automatically reload cmdfile %s", cmdFile.getAbsolutePath()), e);
        }
    }

    @VisibleForTesting
    void setCommandFileReload(boolean b) {
        this.mReloadCmdfiles = b;
    }

    synchronized int getAllCommandsSize() {
        return this.mReadyCommands.size() + this.mExecutingCommands.size() + this.mSleepingCommands.size();
    }

    synchronized List<ExecutableCommandState> getAllCommands() {
        ArrayList<ExecutableCommandState> cmds = new ArrayList<ExecutableCommandState>(this.getAllCommandsSize());
        for (ExecutableCommand cmd : this.mExecutingCommands) {
            cmds.add(new ExecutableCommandState(cmd, CommandState.EXECUTING));
        }
        for (ExecutableCommand cmd : this.mReadyCommands) {
            cmds.add(new ExecutableCommandState(cmd, CommandState.WAITING_FOR_DEVICE));
        }
        for (ExecutableCommand cmd : this.mSleepingCommands) {
            cmds.add(new ExecutableCommandState(cmd, CommandState.SLEEPING));
        }
        return cmds;
    }

    @Override
    public boolean shouldShutdownOnCmdfileError() {
        return this.mShutdownOnCmdfileError;
    }

    public long getShutdownTimeout() {
        return this.mShutdownTimeout;
    }

    @Override
    public CommandRunner.ExitCode getLastInvocationExitCode() {
        return this.mLastInvocationExitCode;
    }

    @Override
    public Throwable getLastInvocationThrowable() {
        return this.mLastInvocationThrowable;
    }

    private void setLastInvocationExitCode(CommandRunner.ExitCode code, Throwable throwable) {
        this.mLastInvocationExitCode = code;
        this.mLastInvocationThrowable = throwable;
    }

    @Override
    public synchronized int getReadyCommandCount() {
        return this.mReadyCommands.size();
    }

    @Override
    public synchronized int getExecutingCommandCount() {
        return this.mExecutingCommands.size();
    }

    @Override
    public void setClearcutClient(ClearcutClient client) {
        this.mClient = client;
    }

    @Override
    public synchronized boolean isDeviceInInvocationThread(ITestDevice device) {
        for (IInvocationContext context : this.mInvocationThreadMap.keySet()) {
            if (!context.getDevices().contains(device)) continue;
            return !context.wasReleasedEarly();
        }
        return false;
    }

    public static enum HostState {
        UNKNOWN,
        RUNNING,
        QUITTING,
        KILLING;

    }

    private static class WaitObj {
        boolean mEventReceived = false;

        private WaitObj() {
        }

        public synchronized boolean waitForEvent(long maxWaitTime) {
            if (maxWaitTime == 0L) {
                return this.waitForEvent();
            }
            long startTime = System.currentTimeMillis();
            long remainingTime = maxWaitTime;
            while (!this.mEventReceived && remainingTime > 0L) {
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.w("interrupted");
                }
                remainingTime = maxWaitTime - (System.currentTimeMillis() - startTime);
            }
            return this.mEventReceived;
        }

        public synchronized boolean waitForEvent() {
            if (!this.mEventReceived) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.w("interrupted");
                }
            }
            return this.mEventReceived;
        }

        public synchronized void reset() {
            this.mEventReceived = false;
        }

        public synchronized void waitAndReset(long maxWaitTime) {
            this.waitForEvent(maxWaitTime);
            this.reset();
        }

        public synchronized void signalEventReceived() {
            this.mEventReceived = true;
            this.notifyAll();
        }
    }

    private class AvailDeviceMonitor
    implements IDeviceMonitor {
        private AvailDeviceMonitor() {
        }

        @Override
        public void run() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void setDeviceLister(IDeviceMonitor.DeviceLister lister) {
        }

        @Override
        public void notifyDeviceStateChange(String serial, DeviceAllocationState oldState, DeviceAllocationState newState) {
            if (newState.equals(DeviceAllocationState.Available)) {
                CommandScheduler.this.mCommandProcessWait.signalEventReceived();
            }
        }
    }

    private class InvocationThread
    extends Thread {
        private static final int EXPECTED_THREAD_COUNT = 1;
        private static final String INVOC_END_EVENT_ID_KEY = "id";
        private static final String INVOC_END_EVENT_ELAPSED_KEY = "elapsed-time";
        private static final String INVOC_END_EVENT_TAG_KEY = "test-tag";
        private final ICommandScheduler.IScheduledInvocationListener[] mListeners;
        private final IInvocationContext mInvocationContext;
        private final ExecutableCommand mCmd;
        private final ITestInvocation mInvocation;
        private final InvocationThreadMonitor mInvocationThreadMonitor;
        private final Timer mExecutionTimer;
        private long mStartTime;

        public InvocationThread(String name, IInvocationContext invocationContext, ExecutableCommand command, ICommandScheduler.IScheduledInvocationListener ... listeners) {
            super(new ThreadGroup(name), name);
            this.mStartTime = -1L;
            this.mListeners = listeners;
            this.mInvocationContext = invocationContext;
            this.mCmd = command;
            this.mInvocation = CommandScheduler.this.createRunInstance();
            this.mExecutionTimer = new Timer(true);
            this.mInvocationThreadMonitor = new InvocationThreadMonitor(this);
        }

        public long getStartTime() {
            return this.mStartTime;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void logTrace(File traceFile, IConfiguration config) {
            if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
                LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Sending trace from subprocess");
                LogFile perfettoTrace = new LogFile(traceFile.getAbsolutePath(), null, LogDataType.PERFETTO);
                for (ITestInvocationListener listener : config.getTestInvocationListeners()) {
                    try {
                        if (!(listener instanceof ILogSaverListener)) continue;
                        ((ILogSaverListener)listener).logAssociation("invocation-trace", perfettoTrace);
                    }
                    catch (Exception e) {
                        LogUtil.CLog.logAndDisplay(Log.LogLevel.ERROR, e.getMessage());
                        LogUtil.CLog.e(e);
                    }
                }
            } else {
                try (FileInputStreamSource source = new FileInputStreamSource(traceFile, true);){
                    LogSaverResultForwarder.logFile(config.getTestInvocationListeners(), config.getLogSaver(), source, "invocation-trace", LogDataType.PERFETTO);
                }
            }
        }

        private void checkStrayThreads() {
            int numThread = this.getThreadGroup().activeCount();
            if (numThread == 1) {
                return;
            }
            List<Thread> listThreads = this.getListOfThreadsExcludingForkJoinWorkers(numThread);
            if ((numThread = listThreads.size()) == 1) {
                return;
            }
            List<String> cmd = Arrays.asList(this.mCmd.getCommandTracker().getArgs());
            LogUtil.CLog.e("Stray thread detected for command %d, %s. %d threads instead of %d", this.mCmd.getCommandTracker().getId(), cmd, numThread, 1);
            LogUtil.CLog.e("List of remaining threads: %s", listThreads);
            List<IHostMonitor> hostMonitors = GlobalConfiguration.getHostMonitorInstances();
            if (hostMonitors != null) {
                for (IHostMonitor hm : hostMonitors) {
                    IHostMonitor.HostDataPoint data = new IHostMonitor.HostDataPoint("numThread", numThread, cmd.toString());
                    hm.addHostEvent(IHostMonitor.HostMetricType.INVOCATION_STRAY_THREAD, data);
                }
            }
            System.err.println(String.format("We have %s threads instead of 1: %s. Check the logs for list of threads.", numThread, listThreads));
        }

        private List<Thread> getListOfThreadsExcludingForkJoinWorkers(int numThread) {
            Thread[] listThreads = new Thread[numThread];
            this.getThreadGroup().enumerate(listThreads);
            return Arrays.asList(listThreads).stream().filter(t -> !(t instanceof ForkJoinWorkerThread)).collect(Collectors.toList());
        }

        private void logInvocationEndedEvent(int invocId, long elapsedTime, IInvocationContext context) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put(INVOC_END_EVENT_ID_KEY, Integer.toString(invocId));
            args.put(INVOC_END_EVENT_ELAPSED_KEY, TimeUtil.formatElapsedTime(elapsedTime));
            args.put(INVOC_END_EVENT_TAG_KEY, context.getTestTag());
            for (String key : context.getAttributes().keySet()) {
                args.put(key, context.getAttributes().get(key).get(0));
            }
            CommandScheduler.this.logEvent(ILogRegistry.EventType.INVOCATION_END, args);
        }

        ITestInvocation getInvocation() {
            return this.mInvocation;
        }

        IInvocationContext getInvocationContext() {
            return this.mInvocationContext;
        }

        public void notifyInvocationStop(String message2) {
            this.getInvocation().notifyInvocationStopped(message2);
        }

        public void stopInvocation(String message2) {
            this.stopInvocation(message2, null);
        }

        public void stopInvocation(String message2, ErrorIdentifier errorId) {
            this.getInvocation().notifyInvocationForceStopped(message2, errorId);
            for (ITestDevice device : this.mInvocationContext.getDevices()) {
                if (TestDeviceState.ONLINE.equals((Object)device.getDeviceState()) && !(device.getIDevice() instanceof StubDevice)) {
                    try {
                        device.executeShellCommand("am kill-all");
                    }
                    catch (DeviceNotAvailableException e) {
                        LogUtil.CLog.e("failed to kill process on device %s", device.getSerialNumber());
                        LogUtil.CLog.e(e);
                    }
                }
                LogUtil.CLog.d("Attempting postInvocationTearDown in stopInvocation");
                device.postInvocationTearDown(null);
            }
            if (CommandScheduler.this.getShutdownTimeout() != 0L) {
                RunUtil.getDefault().setInterruptibleInFuture(this, CommandScheduler.this.getShutdownTimeout());
            }
            RunUtil.getDefault().interrupt(this, message2, errorId);
        }

        public void disableReporters() {
            for (ITestInvocationListener listener : this.mCmd.getConfiguration().getTestInvocationListeners()) {
                listener.invocationInterrupted();
            }
        }

        public void checkDeviceBatteryLevel() {
            for (String deviceName : this.mInvocationContext.getDeviceConfigNames()) {
                if (this.mCmd.getConfiguration().getDeviceConfigByName(deviceName).getDeviceOptions() == null) {
                    LogUtil.CLog.d("No deviceOptions in the configuration, cannot do Battery level check");
                    return;
                }
                Integer cutoffBattery = this.mCmd.getConfiguration().getDeviceConfigByName(deviceName).getDeviceOptions().getCutoffBattery();
                if (this.mInvocationContext.getDevice(deviceName) == null || cutoffBattery == null) continue;
                ITestDevice device = this.mInvocationContext.getDevice(deviceName);
                Integer batteryLevel = device.getBattery();
                if (batteryLevel == null) {
                    return;
                }
                LogUtil.CLog.d("device %s: battery level=%d%%", device.getSerialNumber(), batteryLevel);
                if (0 >= batteryLevel || batteryLevel >= cutoffBattery) continue;
                if (RunUtil.getDefault().isInterruptAllowed()) {
                    LogUtil.CLog.i("Stopping %s: battery too low (%d%% < %d%%)", this.getName(), batteryLevel, cutoffBattery);
                    this.stopInvocation(String.format("battery too low (%d%% < %d%%)", batteryLevel, cutoffBattery));
                    continue;
                }
                LogUtil.CLog.w("device: %s has a low battery but is in uninterruptible state.", device.getSerialNumber());
            }
        }

        private boolean isPresubmitBuild(IInvocationContext context) {
            return "WORK_NODE".equals(context.getAttribute("trigger"));
        }
    }

    private static class ExecutableCommandComparator
    implements Comparator<ExecutableCommand> {
        CommandTrackerTimeComparator mTrackerComparator = new CommandTrackerTimeComparator();

        private ExecutableCommandComparator() {
        }

        @Override
        public int compare(ExecutableCommand c1, ExecutableCommand c2) {
            return this.mTrackerComparator.compare(c1.getCommandTracker(), c2.getCommandTracker());
        }
    }

    private class ExecutableCommand {
        private final CommandTracker mCmdTracker;
        private final IConfiguration mConfig;
        private final boolean mRescheduled;
        private final long mCreationTime;
        private Long mSleepTime;

        private ExecutableCommand(CommandTracker tracker, IConfiguration config, boolean rescheduled) {
            this.mConfig = config;
            this.mCmdTracker = tracker;
            this.mRescheduled = rescheduled;
            this.mCreationTime = System.currentTimeMillis();
        }

        public IConfiguration getConfiguration() {
            return this.mConfig;
        }

        CommandTracker getCommandTracker() {
            return this.mCmdTracker;
        }

        void commandStarted() {
            this.mSleepTime = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandFinished(long elapsedTime) {
            this.getCommandTracker().incrementExecTime(elapsedTime);
            LogUtil.CLog.d("removing exec command for id %d", this.getCommandTracker().getId());
            CommandScheduler commandScheduler = CommandScheduler.this;
            synchronized (commandScheduler) {
                CommandScheduler.this.mExecutingCommands.remove(this);
            }
            if (CommandScheduler.this.isShuttingDown()) {
                CommandScheduler.this.mCommandProcessWait.signalEventReceived();
            }
        }

        public boolean isRescheduled() {
            return this.mRescheduled;
        }

        public long getCreationTime() {
            return this.mCreationTime;
        }

        public boolean isLoopMode() {
            return this.mConfig.getCommandOptions().isLoopMode();
        }

        public long getMaxLoopCount() {
            return this.mConfig.getCommandOptions().getMaxLoopCount();
        }

        public Long getSleepTime() {
            return this.mSleepTime;
        }

        public String getCommandFilePath() {
            return this.mCmdTracker.getCommandFilePath();
        }
    }

    static class CommandTracker {
        private final int mId;
        private final String[] mArgs;
        private final String mCommandFilePath;
        private long mCount;
        private long mTotalExecTime = 0L;

        CommandTracker(int id, String[] args, String commandFilePath) {
            this.mId = id;
            this.mArgs = args;
            this.mCommandFilePath = commandFilePath;
            this.mCount = 0L;
        }

        synchronized void incrementExecTime(long execTime) {
            this.mTotalExecTime += execTime;
        }

        synchronized long getTotalExecTime() {
            return this.mTotalExecTime;
        }

        String[] getArgs() {
            return this.mArgs;
        }

        int getId() {
            return this.mId;
        }

        String getCommandFilePath() {
            return this.mCommandFilePath;
        }

        public void incrementScheduledCount() {
            ++this.mCount;
        }

        public long getScheduledCount() {
            return this.mCount;
        }
    }

    private class FreeDeviceHandler
    extends ResultForwarder
    implements ICommandScheduler.IScheduledInvocationListener {
        private final IDeviceManager mDeviceManager;
        private boolean mDeviceReleased;
        private Map<ITestDevice, FreeDeviceState> mDevicesStates;

        FreeDeviceHandler(IDeviceManager deviceManager, ICommandScheduler.IScheduledInvocationListener ... listeners) {
            super(listeners);
            this.mDeviceReleased = false;
            this.mDevicesStates = null;
            this.mDeviceManager = deviceManager;
        }

        @Override
        public void releaseDevices(IInvocationContext context, Map<ITestDevice, FreeDeviceState> devicesStates) {
            if (this.mDeviceReleased) {
                return;
            }
            this.mDevicesStates = devicesStates;
            for (ITestDevice device : context.getDevices()) {
                this.mDeviceManager.freeDevice(device, devicesStates.get(device));
            }
            this.mDeviceReleased = true;
        }

        @Override
        public void invocationComplete(IInvocationContext context, Map<ITestDevice, FreeDeviceState> devicesStates) {
            if (this.mDevicesStates != null) {
                devicesStates = this.mDevicesStates;
            }
            for (ITestInvocationListener listener : this.getListeners()) {
                try {
                    ((ICommandScheduler.IScheduledInvocationListener)listener).invocationComplete(context, devicesStates);
                }
                catch (Exception e) {
                    LogUtil.CLog.e("Exception during invocationComplete:");
                    LogUtil.CLog.e(e);
                }
            }
            this.releaseDevices(context, devicesStates);
        }
    }

    private class FreeNullDeviceHandler
    extends FreeDeviceHandler {
        private final IDeviceManager mDeviceManager;
        private boolean mDeviceReleased;

        FreeNullDeviceHandler(IDeviceManager deviceManager, ICommandScheduler.IScheduledInvocationListener ... listeners) {
            super(deviceManager, listeners);
            this.mDeviceReleased = false;
            this.mDeviceManager = deviceManager;
        }

        @Override
        public void releaseDevices(IInvocationContext context, Map<ITestDevice, FreeDeviceState> devicesStates) {
            if (this.mDeviceReleased) {
                return;
            }
            for (ITestDevice device : context.getDevices()) {
                if (!(device.getIDevice() instanceof NullDevice)) continue;
                this.mDeviceManager.freeDevice(device, devicesStates.get(device));
            }
            this.mDeviceReleased = true;
        }
    }

    private static class ExecutableCommandState {
        final ExecutableCommand cmd;
        final CommandState state;

        ExecutableCommandState(ExecutableCommand cmd, CommandState state) {
            this.cmd = cmd;
            this.state = state;
        }
    }

    static class CommandTrackerIdComparator
    implements Comparator<CommandTracker> {
        CommandTrackerIdComparator() {
        }

        @Override
        public int compare(CommandTracker c1, CommandTracker c2) {
            if (c1.getId() == c2.getId()) {
                return 0;
            }
            if (c1.getId() < c2.getId()) {
                return -1;
            }
            return 1;
        }
    }

    private static enum CommandState {
        WAITING_FOR_DEVICE("Wait_for_device"),
        EXECUTING("Executing"),
        SLEEPING("Sleeping");

        private final String mDisplayName;

        private CommandState(String displayName) {
            this.mDisplayName = displayName;
        }

        public String getDisplayName() {
            return this.mDisplayName;
        }
    }

    private class InvocationThreadMonitor
    extends TimerTask {
        private InvocationThread mInvocationThread = null;
        private boolean mTriggered = false;

        public InvocationThreadMonitor(InvocationThread toMonitor) {
            this.mInvocationThread = toMonitor;
        }

        @Override
        public void run() {
            if (this.mInvocationThread != null) {
                this.mTriggered = true;
                this.mInvocationThread.stopInvocation("Invocation Timeout Reached.", InfraErrorIdentifier.INVOCATION_TIMEOUT);
            }
        }

        public boolean isTriggered() {
            return this.mTriggered;
        }
    }

    private static class CommandTrackerTimeComparator
    implements Comparator<CommandTracker> {
        private CommandTrackerTimeComparator() {
        }

        @Override
        public int compare(CommandTracker c1, CommandTracker c2) {
            if (c1.getTotalExecTime() == c2.getTotalExecTime()) {
                return 0;
            }
            if (c1.getTotalExecTime() < c2.getTotalExecTime()) {
                return -1;
            }
            return 1;
        }
    }

    private class Rescheduler
    implements IRescheduler {
        private CommandTracker mCmdTracker;

        Rescheduler(CommandTracker cmdTracker) {
            this.mCmdTracker = cmdTracker;
        }

        @Override
        public boolean scheduleConfig(IConfiguration config) {
            config.getCommandOptions().setLoopMode(false);
            ExecutableCommand rescheduledCmd = CommandScheduler.this.createExecutableCommand(this.mCmdTracker, config, true);
            return CommandScheduler.this.addExecCommandToQueue(rescheduledCmd, 0L);
        }

        @Override
        public boolean rescheduleCommand() {
            try {
                LogUtil.CLog.d("rescheduling for command %d", this.mCmdTracker.getId());
                IConfiguration config = CommandScheduler.this.getConfigFactory().createConfigurationFromArgs(this.mCmdTracker.getArgs());
                ExecutableCommand execCmd = CommandScheduler.this.createExecutableCommand(this.mCmdTracker, config, true);
                return CommandScheduler.this.addExecCommandToQueue(execCmd, config.getCommandOptions().getLoopTime());
            }
            catch (ConfigurationException e) {
                System.out.println(String.format("Error while processing args: %s", Arrays.toString(this.mCmdTracker.getArgs())));
                System.out.println(e.getMessage());
                System.out.println();
                return false;
            }
        }
    }
}

