/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.clearcut.ClearcutClient;
import com.android.tradefed.clearcut.TerminateClearcutClient;
import com.android.tradefed.command.CommandRunner;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.command.console.ConfigCompleter;
import com.android.tradefed.command.console.ConsoleReaderOutputStream;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.service.TradefedFeatureServer;
import com.android.tradefed.service.management.DeviceManagementGrpcServer;
import com.android.tradefed.service.management.TestInvocationManagementServer;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.VersionParser;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.keystore.IKeyStoreFactory;
import com.android.tradefed.util.keystore.KeyStoreException;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.TerminalBuilder;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Console
extends Thread {
    private static final String APPNAME = "Tradefed";
    private static final String CONSOLE_PROMPT = "\u001b[0;32mtf >\u001b[0;0m";
    protected static final String HELP_PATTERN = "\\?|h|help";
    protected static final String LIST_PATTERN = "l(?:ist)?";
    protected static final String DUMP_PATTERN = "d(?:ump)?";
    protected static final String RUN_PATTERN = "r(?:un)?";
    protected static final String EXIT_PATTERN = "(?:q|exit)";
    protected static final String SET_PATTERN = "s(?:et)?";
    protected static final String INVOC_PATTERN = "i(?:nvocation)?";
    protected static final String VERSION_PATTERN = "version";
    protected static final String REMOVE_PATTERN = "remove";
    protected static final String DEBUG_PATTERN = "debug";
    protected static final String LIST_COMMANDS_PATTERN = "c(?:ommands)?";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static ConsoleReaderOutputStream sConsoleStream = null;
    protected ICommandScheduler mScheduler;
    protected IKeyStoreFactory mKeyStoreFactory;
    protected LineReader mConsoleReader;
    private RegexTrie<Runnable> mCommandTrie = new RegexTrie();
    private AtomicBoolean mShouldExit = new AtomicBoolean(false);
    private List<String> mMainArgs = new ArrayList<String>(0);
    private long mConsoleStartTime = System.currentTimeMillis();

    RegexTrie<Runnable> getCommandTrie() {
        return this.mCommandTrie;
    }

    protected static LineReader getReader() {
        try {
            if (sConsoleStream == null) {
                LineReader reader = LineReaderBuilder.builder().appName(APPNAME).terminal(TerminalBuilder.builder().system(true).dumb(true).build()).completer(new ConfigCompleter(ConfigurationFactory.getInstance().getConfigList())).history(new DefaultHistory()).build();
                sConsoleStream = new ConsoleReaderOutputStream(reader);
                System.setOut(new PrintStream(sConsoleStream, true));
            }
            return sConsoleStream.getConsoleReader();
        }
        catch (IOException e) {
            System.err.format("Failed to initialize LineReader: %s\n", e.getMessage());
            return null;
        }
    }

    protected Console() {
        this(Console.getReader());
    }

    Console(LineReader reader) {
        super("TfConsole");
        this.mConsoleReader = reader;
        LinkedList<String> genericHelp = new LinkedList<String>();
        LinkedHashMap<String, String> commandHelp = new LinkedHashMap<String, String>();
        this.addDefaultCommands(this.mCommandTrie, genericHelp, commandHelp);
        this.setCustomCommands(this.mCommandTrie, genericHelp, commandHelp);
        this.generateHelpListings(this.mCommandTrie, genericHelp, commandHelp);
    }

    void setCommandScheduler(ICommandScheduler scheduler) {
        this.mScheduler = scheduler;
    }

    void setKeyStoreFactory(IKeyStoreFactory factory) {
        this.mKeyStoreFactory = factory;
    }

    void registerShutdownSignals() {
        Signal.handle(new Signal("TSTP"), new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, String.format("Received signal %s. Quit.", sig.getName()));
                new QuitRunnable().run(new CaptureList());
            }
        });
        Signal.handle(new Signal("TERM"), new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, String.format("Received signal %s. Kill.", sig.getName()));
                new ForceQuitRunnable().run(new CaptureList());
            }
        });
    }

    protected void setCustomCommands(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
    }

    void generateHelpListings(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
        final String genHelpString = this.getGenericHelpString(genericHelp);
        final ArgRunnable<CaptureList> genericHelpRunnable = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                Console.this.printLine(genHelpString);
            }
        };
        trie.put((Runnable)genericHelpRunnable, HELP_PATTERN);
        StringBuilder allHelpBuilder = new StringBuilder();
        for (Map.Entry<String, String> helpPair : commandHelp.entrySet()) {
            String key = helpPair.getKey();
            final String helpText = helpPair.getValue();
            trie.put(new Runnable(){

                @Override
                public void run() {
                    Console.this.printLine(helpText);
                }
            }, HELP_PATTERN, key);
            allHelpBuilder.append(helpText);
            allHelpBuilder.append(LINE_SEPARATOR);
        }
        final String allHelpText = allHelpBuilder.toString();
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.printLine(allHelpText);
            }
        }, HELP_PATTERN, "all");
        trie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                Console.this.printLine(String.format("No help for '%s'; command is unknown or undocumented", ((List)args.get(1)).get(0)));
                genericHelpRunnable.run(args);
            }
        }, HELP_PATTERN, null);
        trie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                if (args.isEmpty()) {
                    return;
                }
                Console.this.printLine(String.format("Unknown command: '%s'", ((List)args.get(0)).get(0)));
                genericHelpRunnable.run(args);
            }
        }, new Pattern[]{null});
    }

    protected String getGenericHelpString(List<String> genericHelp) {
        return ArrayUtil.join(LINE_SEPARATOR, genericHelp);
    }

    static List<String> getFlatArgs(int argIdx, CaptureList cl) {
        if (argIdx < 0 || argIdx >= cl.size()) {
            throw new IndexOutOfBoundsException(String.format("argIdx is %d, cl size is %d", argIdx, cl.size()));
        }
        ArrayList<String> flat = new ArrayList<String>(cl.size() - argIdx);
        ListIterator iter = cl.listIterator(argIdx);
        while (iter.hasNext()) {
            List single = (List)iter.next();
            int len = single.size();
            if (len != 1) {
                throw new IllegalArgumentException(String.format("Expected a singleton List, but got a List with %d elements: %s", len, single.toString()));
            }
            flat.add((String)single.get(0));
        }
        return flat;
    }

    void runCmdfile(String cmdfileName, List<String> extraArgs) {
        try {
            this.mScheduler.addCommandFile(cmdfileName, extraArgs);
        }
        catch (ConfigurationException e) {
            this.printLine(String.format("Failed to run %s: %s", cmdfileName, e));
            if (this.mScheduler.shouldShutdownOnCmdfileError()) {
                this.printLine("shutdownOnCmdFileError is enabled, stopping TF");
                this.mScheduler.shutdown();
            }
            this.reportProtoResults(e);
        }
    }

    private void reportProtoResults(Exception e) {
        String protoRes = System.getenv("PROTO_REPORTING_FILE");
        if (protoRes == null) {
            this.printLine(String.format("No %s specified to output results", "PROTO_REPORTING_FILE"));
            return;
        }
        if (new File(protoRes).exists()) {
            this.printLine(String.format("File %s already exists", protoRes));
            return;
        }
        FileProtoResultReporter reporter = new FileProtoResultReporter();
        reporter.setOutputFile(new File(protoRes));
        reporter.setDelimitedOutput(false);
        reporter.invocationStarted(new InvocationContext());
        FailureDescription failure = TestInvocation.createFailureFromException(e, TestRecordProto.FailureStatus.INFRA_FAILURE);
        reporter.invocationFailed(failure);
        reporter.invocationEnded(0L);
    }

    void addDefaultCommands(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
        genericHelp.add("Enter 'q' or 'exit' to exit. Use '--wait-for-command|-c' to exit only after all commands have executed.");
        genericHelp.add("Enter 'kill' to attempt to forcibly exit, by shutting down adb");
        genericHelp.add("");
        genericHelp.add("Enter 'help all' to see all embedded documentation at once.");
        genericHelp.add("");
        genericHelp.add("Enter 'help list'       for help with 'list' commands");
        genericHelp.add("Enter 'help run'        for help with 'run' commands");
        genericHelp.add("Enter 'help invocation' for help with 'invocation' commands");
        genericHelp.add("Enter 'help dump'       for help with 'dump' commands");
        genericHelp.add("Enter 'help set'        for help with 'set' commands");
        genericHelp.add("Enter 'help remove'     for help with 'remove' commands");
        genericHelp.add("Enter 'help debug'      for help with 'debug' commands");
        genericHelp.add("Enter 'version'  to get the current version of Tradefed");
        commandHelp.put(LIST_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ti[nvocations]         List all invocation threads" + LINE_SEPARATOR + "\td[evices]             List all detected or known devices" + LINE_SEPARATOR + "\td[devices] all        List all devices including placeholders" + LINE_SEPARATOR + "\tc[ommands]            List all commands currently waiting to be executed" + LINE_SEPARATOR + "\tc[ommands] [pattern]  List all commands matching the pattern and currently waiting to be executed" + LINE_SEPARATOR + "\tconfigs               List all known configurations" + LINE_SEPARATOR, LIST_PATTERN));
        commandHelp.put(DUMP_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ts[tack]             Dump the stack traces of all threads" + LINE_SEPARATOR + "\tl[ogs]              Dump the logs of all invocations to files" + LINE_SEPARATOR + "\tb[ugreport]         Dump a bugreport for the running Tradefed instance" + LINE_SEPARATOR + "\tc[onfig] <config>   Dump the content of the specified config" + LINE_SEPARATOR + "\tcommandQueue        Dump the contents of the commmand execution queue" + LINE_SEPARATOR + "\tcommands            Dump all the config XML for the commands waiting to be executed" + LINE_SEPARATOR + "\tcommands [pattern]  Dump all the config XML for the commands matching the pattern and waiting to be executed" + LINE_SEPARATOR + "\te[nv]               Dump the environment variables available to test harness process" + LINE_SEPARATOR + "\tu[ptime]            Dump how long the TradeFed process has been running" + LINE_SEPARATOR, DUMP_PATTERN));
        commandHelp.put(RUN_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tcommand <config> [options]        Run the specified command" + LINE_SEPARATOR + "\t<config> [options]                Shortcut for the above: run specified command" + LINE_SEPARATOR + "\tcmdfile <cmdfile.txt>             Run the specified commandfile" + LINE_SEPARATOR + "\tcommandAndExit <config> [options] Run the specified command, and run 'exit -c' immediately afterward" + LINE_SEPARATOR + "\tcmdfileAndExit <cmdfile.txt>      Run the specified commandfile, and run 'exit -c' immediately afterward" + LINE_SEPARATOR, RUN_PATTERN));
        commandHelp.put(SET_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tlog-level-display <level>  Sets the global display log level to <level>" + LINE_SEPARATOR, SET_PATTERN));
        commandHelp.put(REMOVE_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tremove allCommands  Remove all commands currently waiting to be executed" + LINE_SEPARATOR, REMOVE_PATTERN));
        commandHelp.put(DEBUG_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tgc      Attempt to force a GC" + LINE_SEPARATOR, DEBUG_PATTERN));
        commandHelp.put(INVOC_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\ti[nvocation] [Command Id]        Information of the invocation thread" + LINE_SEPARATOR + "\ti[nvocation] [Command Id] stop   Notify to stop the invocation" + LINE_SEPARATOR, INVOC_PATTERN));
        trie.put((Runnable)new QuitRunnable(), EXIT_PATTERN, null);
        trie.put((Runnable)new QuitRunnable(), EXIT_PATTERN);
        trie.put((Runnable)new ForceQuitRunnable(), "kill");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.mScheduler.displayInvocationsInfo(new PrintWriter(System.out, true));
            }
        }, LIST_PATTERN, "i(?:nvocations)?");
        trie.put(new Runnable(){

            @Override
            public void run() {
                IDeviceManager manager = GlobalConfiguration.getDeviceManagerInstance();
                manager.displayDevicesInfo(new PrintWriter(System.out, true), false);
            }
        }, LIST_PATTERN, "d(?:evices)?");
        trie.put(new Runnable(){

            @Override
            public void run() {
                IDeviceManager manager = GlobalConfiguration.getDeviceManagerInstance();
                manager.displayDevicesInfo(new PrintWriter(System.out, true), true);
            }
        }, LIST_PATTERN, "d(?:evices)?", "all");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.mScheduler.displayCommandsInfo(new PrintWriter(System.out, true), null);
            }
        }, LIST_PATTERN, LIST_COMMANDS_PATTERN);
        ArgRunnable<CaptureList> listCmdRun = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String pattern = (String)((List)args.get(2)).get(0);
                Console.this.mScheduler.displayCommandsInfo(new PrintWriter(System.out, true), pattern);
            }
        };
        trie.put((Runnable)listCmdRun, LIST_PATTERN, LIST_COMMANDS_PATTERN, "(.*)");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.printLine("Use 'run command <configuration_name> --help' to get list of options for a configuration");
                Console.this.printLine("Use 'dump config <configuration_name>' to display the configuration's XML content.");
                Console.this.printLine("");
                Console.this.printLine("Available configurations include:");
                Console.this.getConfigurationFactory().printHelp(System.out);
            }
        }, LIST_PATTERN, "configs");
        trie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                int invocId = Integer.parseInt((String)((List)args.get(1)).get(0));
                String info = Console.this.mScheduler.getInvocationInfo(invocId);
                if (info != null) {
                    Console.this.printLine(String.format("invocation %s: %s", invocId, info));
                } else {
                    Console.this.printLine(String.format("No information found for invocation %s.", invocId));
                }
            }
        }, INVOC_PATTERN, "([0-9]*)");
        trie.put((Runnable)new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                int invocId = Integer.parseInt((String)((List)args.get(1)).get(0));
                if (Console.this.mScheduler.stopInvocation(invocId)) {
                    Console.this.printLine(String.format("Invocation %s has been requested to stop. It may take some times.", invocId));
                } else {
                    Console.this.printLine(String.format("Could not stop invocation %s, try 'list invocation' or 'invocation %s' for more information.", invocId, invocId));
                }
            }
        }, INVOC_PATTERN, "([0-9]*)", "stop");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.dumpStacks(System.out);
            }
        }, DUMP_PATTERN, "s(?:tacks?)?");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.dumpLogs();
            }
        }, DUMP_PATTERN, "l(?:ogs?)?");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.dumpTfBugreport();
            }
        }, DUMP_PATTERN, "b(?:ugreport?)?");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.printElapsedTime();
            }
        }, DUMP_PATTERN, "u(?:ptime?)?");
        ArgRunnable<CaptureList> dumpConfigRun = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String configArg = (String)((List)args.get(2)).get(0);
                Console.this.getConfigurationFactory().dumpConfig(configArg, System.out);
            }
        };
        trie.put((Runnable)dumpConfigRun, DUMP_PATTERN, "c(?:onfig?)?", "(.*)");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.mScheduler.displayCommandQueue(new PrintWriter(System.out, true));
            }
        }, DUMP_PATTERN, "commandQueue");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.mScheduler.dumpCommandsXml(new PrintWriter(System.out, true), null);
            }
        }, DUMP_PATTERN, LIST_COMMANDS_PATTERN);
        ArgRunnable<CaptureList> dumpCmdRun = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String pattern = (String)((List)args.get(2)).get(0);
                Console.this.mScheduler.dumpCommandsXml(new PrintWriter(System.out, true), pattern);
            }
        };
        trie.put((Runnable)dumpCmdRun, DUMP_PATTERN, LIST_COMMANDS_PATTERN, "(.*)");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.dumpEnv();
            }
        }, DUMP_PATTERN, "e(?:nv)?");
        ArgRunnable<CaptureList> runRunCommand = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                int startIdx = 1;
                if (((List)args.get(1)).isEmpty()) {
                    startIdx = 2;
                }
                String[] flatArgs = new String[args.size() - startIdx];
                for (int i = startIdx; i < args.size(); ++i) {
                    flatArgs[i - startIdx] = (String)((List)args.get(i)).get(0);
                }
                try {
                    Console.this.mScheduler.addCommand(flatArgs);
                }
                catch (ConfigurationException e) {
                    Console.this.printLine(String.format("Failed to run command: %s\n%s", e.toString(), StreamUtil.getStackTrace(e)));
                }
            }
        };
        trie.put((Runnable)runRunCommand, RUN_PATTERN, "c(?:ommand)?", null);
        trie.put((Runnable)runRunCommand, RUN_PATTERN, null);
        trie.put(new Runnable(){

            @Override
            public void run() {
                String version = VersionParser.fetchVersion();
                if (version != null) {
                    Console.this.printLine(version);
                } else {
                    Console.this.printLine("Failed to fetch version information for Tradefed.");
                }
            }
        }, VERSION_PATTERN);
        ArgRunnable<CaptureList> runAndExitCommand = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String[] flatArgs = new String[args.size() - 2];
                for (int i = 2; i < args.size(); ++i) {
                    flatArgs[i - 2] = (String)((List)args.get(i)).get(0);
                }
                try {
                    if (((Boolean)Console.this.mScheduler.addCommand((String[])flatArgs).first).booleanValue()) {
                        Console.this.mScheduler.shutdownOnEmpty();
                    }
                }
                catch (ConfigurationException e) {
                    Console.this.printLine("Failed to run command: " + e.toString());
                }
                Console.this.mShouldExit.set(true);
            }
        };
        trie.put((Runnable)runAndExitCommand, RUN_PATTERN, "s(?:ingleCommand)?", null);
        trie.put((Runnable)runAndExitCommand, RUN_PATTERN, "commandAndExit", null);
        final ArgRunnable<CaptureList> runRunCmdfile = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                int startIdx = 2;
                List<String> flatArgs = Console.getFlatArgs(startIdx, args);
                String file2 = flatArgs.get(0);
                List<String> extraArgs = flatArgs.subList(1, flatArgs.size());
                Console.this.printLine(String.format("Attempting to run cmdfile %s with args %s", file2, extraArgs.toString()));
                Console.this.runCmdfile(file2, extraArgs);
            }
        };
        trie.put((Runnable)runRunCmdfile, RUN_PATTERN, "cmdfile", "(.*)");
        trie.put((Runnable)runRunCmdfile, RUN_PATTERN, "cmdfile", "(.*)", null);
        ArgRunnable<CaptureList> runRunCmdfileAndExit = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                runRunCmdfile.run(args);
                Console.this.mScheduler.shutdownOnEmpty();
            }
        };
        trie.put((Runnable)runRunCmdfileAndExit, RUN_PATTERN, "cmdfileAndExit", "(.*)");
        trie.put((Runnable)runRunCmdfileAndExit, RUN_PATTERN, "cmdfileAndExit", "(.*)", null);
        ArgRunnable<CaptureList> runRunAllCmdfilesAndExit = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                if (args.size() <= 2) {
                    Console.this.printLine("No cmdfiles specified!");
                } else {
                    for (String cmdfile : Console.getFlatArgs(2, args)) {
                        Console.this.runCmdfile(cmdfile, new ArrayList<String>(0));
                    }
                }
                Console.this.mScheduler.shutdownOnEmpty();
            }
        };
        trie.put((Runnable)runRunAllCmdfilesAndExit, RUN_PATTERN, "allCmdfilesAndExit");
        trie.put((Runnable)runRunAllCmdfilesAndExit, RUN_PATTERN, "allCmdfilesAndExit", null);
        ArgRunnable<CaptureList> runSetLog = new ArgRunnable<CaptureList>(){

            @Override
            public void run(CaptureList args) {
                String logLevelStr = (String)((List)args.get(2)).get(0);
                Log.LogLevel newLogLevel = Log.LogLevel.getByString(logLevelStr);
                Log.LogLevel currentLogLevel = LogRegistry.getLogRegistry().getGlobalLogDisplayLevel();
                if (newLogLevel != null) {
                    LogRegistry.getLogRegistry().setGlobalLogDisplayLevel(newLogLevel);
                    currentLogLevel = LogRegistry.getLogRegistry().getGlobalLogDisplayLevel();
                    if (currentLogLevel != null) {
                        Console.this.printLine(String.format("Log level now set to '%s'.", new Object[]{currentLogLevel}));
                    }
                } else if (currentLogLevel == null) {
                    Console.this.printLine(String.format("Invalid log level '%s'.", new Object[]{newLogLevel}));
                } else {
                    Console.this.printLine(String.format("Invalid log level '%s'; log level remains at '%s'.", new Object[]{newLogLevel, currentLogLevel}));
                }
            }
        };
        trie.put((Runnable)runSetLog, SET_PATTERN, "log-level-display", "(.*)");
        trie.put(new Runnable(){

            @Override
            public void run() {
                System.gc();
            }
        }, DEBUG_PATTERN, "gc");
        trie.put(new Runnable(){

            @Override
            public void run() {
                Console.this.mScheduler.removeAllCommands();
            }
        }, REMOVE_PATTERN, "allCommands");
    }

    private void printElapsedTime() {
        long elapsedTime = System.currentTimeMillis() - this.mConsoleStartTime;
        String elapsed = String.format("TF has been running for %s", TimeUtil.formatElapsedTime(elapsedTime));
        this.printLine(elapsed);
    }

    @VisibleForTesting
    String getConsoleInput() throws IOException {
        if (this.mConsoleReader != null) {
            try {
                return this.mConsoleReader.readLine(this.getConsolePrompt());
            }
            catch (EndOfFileException e) {
                return null;
            }
        }
        return null;
    }

    protected String getConsolePrompt() {
        return CONSOLE_PROMPT;
    }

    protected void printLine(String output) {
        System.out.print(output);
        System.out.println();
    }

    protected void printLine(String output, PrintStream pw) {
        pw.print(output);
        pw.println();
    }

    void executeCmdRunnable(Runnable command, CaptureList groups) {
        try {
            if (command instanceof ArgRunnable) {
                ((ArgRunnable)command).run(groups);
            } else {
                command.run();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    boolean isConsoleFunctional() {
        return System.console() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<String> arrrgs = this.mMainArgs;
        if (this.mScheduler == null) {
            throw new IllegalStateException("command scheduler hasn't been set");
        }
        try {
            if (!this.isConsoleFunctional()) {
                if (arrrgs.isEmpty()) {
                    this.printLine("No commands for non-interactive mode; exiting.");
                    this.mScheduler.start();
                    this.mScheduler.await();
                    return;
                }
                this.printLine("Non-interactive mode: Running initial command then exiting.");
                this.mShouldExit.set(true);
            }
            this.mScheduler.start();
            this.mScheduler.await();
            String input = "";
            CaptureList groups = new CaptureList();
            do {
                Runnable command;
                String[] tokens;
                if (arrrgs.isEmpty()) {
                    input = this.getConsoleInput();
                    if (input == null) {
                        this.printLine("");
                        this.printLine("Received EOF; quitting...");
                        this.mShouldExit.set(true);
                        break;
                    }
                    tokens = null;
                    try {
                        tokens = QuotationAwareTokenizer.tokenizeLine(input);
                    }
                    catch (IllegalArgumentException e) {
                        this.printLine(String.format("Invalid input: %s.", input));
                        continue;
                    }
                    if (tokens == null || tokens.length == 0) {
                        continue;
                    }
                } else {
                    this.printLine(String.format("Using commandline arguments as starting command: %s", arrrgs));
                    if (this.mConsoleReader != null) {
                        String cmd = ArrayUtil.join(" ", arrrgs);
                        this.mConsoleReader.getHistory().add(cmd);
                    }
                    tokens = arrrgs.toArray(new String[0]);
                    if (arrrgs.get(0).matches(HELP_PATTERN)) {
                        this.mShouldExit.set(true);
                    }
                    arrrgs = Collections.emptyList();
                }
                if ((command = this.mCommandTrie.retrieve(groups, tokens)) != null) {
                    this.executeCmdRunnable(command, groups);
                } else {
                    this.printLine(String.format("Unable to handle command '%s'.  Enter 'help' for help.", tokens[0]));
                }
                RunUtil.getDefault().sleep(100L);
            } while (!this.mShouldExit.get());
        }
        catch (Exception e) {
            this.printLine("Console received an unexpected exception (shown below); shutting down TF.");
            e.printStackTrace();
        }
        finally {
            this.mScheduler.shutdown();
            GlobalConfiguration.getInstance().cleanup();
            System.err.flush();
            System.out.flush();
        }
    }

    @VisibleForTesting
    void exitConsole() {
        this.mShouldExit.set(true);
    }

    void awaitScheduler() throws InterruptedException {
        this.mScheduler.await();
    }

    IConfigurationFactory getConfigurationFactory() {
        return ConfigurationFactory.getInstance();
    }

    private void dumpStacks(PrintStream ps) {
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threadMap.entrySet()) {
            this.dumpThreadStack(threadEntry.getKey(), threadEntry.getValue(), ps);
        }
    }

    private void dumpThreadStack(Thread thread, StackTraceElement[] trace, PrintStream ps) {
        this.printLine(String.format("%s", thread), ps);
        for (int i = 0; i < trace.length; ++i) {
            this.printLine(String.format("\t%s", trace[i]), ps);
        }
        this.printLine("", ps);
    }

    private void dumpLogs() {
        LogRegistry.getLogRegistry().dumpLogs();
    }

    private void dumpEnv() {
        TreeMap<String, String> env = new TreeMap<String, String>(System.getenv());
        for (Map.Entry entry : env.entrySet()) {
            this.printLine(String.format("\t%s=%s", entry.getKey(), entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpTfBugreport() {
        File tmpBugreportDir = null;
        PrintStream ps = null;
        try {
            tmpBugreportDir = FileUtil.createNamedTempDir("bugreport_tf");
            File tmpStackFile = FileUtil.createTempFile("dump_stacks_", ".log", tmpBugreportDir);
            ps = new PrintStream(tmpStackFile);
            this.dumpStacks(ps);
            ps.flush();
            ((LogRegistry)LogRegistry.getLogRegistry()).dumpLogsToDir(tmpBugreportDir);
            File zippedBugreport = ZipUtil.createZip(tmpBugreportDir, "tradefed_bugreport_");
            this.printLine(String.format("Output bugreport zip in %s", zippedBugreport.getAbsolutePath()));
        }
        catch (IOException io) {
            this.printLine("Error when trying to dump bugreport");
        }
        finally {
            ps.close();
            FileUtil.recursiveDelete(tmpBugreportDir);
        }
    }

    public void setArgs(List<String> mainArgs) {
        this.mMainArgs = mainArgs;
    }

    public static void main(String[] mainArgs) throws InterruptedException, ConfigurationException {
        Console console = new Console();
        try {
            Console.startConsole(console, mainArgs);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            System.exit(CommandRunner.ExitCode.CONFIG_EXCEPTION.getCodeValue());
        }
        catch (InterruptedException interrupt) {
            interrupt.printStackTrace();
            System.exit(CommandRunner.ExitCode.THROWABLE_EXCEPTION.getCodeValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startConsole(Console console, String[] args) throws InterruptedException, ConfigurationException {
        ClearcutClient client = new ClearcutClient(TestSuiteInfo.getInstance().didLoadFromProperties() ? TestSuiteInfo.getInstance().getName() : "");
        Runtime.getRuntime().addShutdownHook(new TerminateClearcutClient(client));
        client.notifyTradefedStartEvent();
        TradefedFeatureServer server = null;
        try {
            server = new TradefedFeatureServer();
            server.start();
        }
        catch (RuntimeException e) {
            System.out.println(String.format("Error starting feature server: %s", e));
        }
        TestInvocationManagementServer invocationManagementServer = null;
        DeviceManagementGrpcServer deviceManagementServer = null;
        try {
            Integer port;
            List<String> nonGlobalArgs = GlobalConfiguration.createGlobalConfiguration(args);
            GlobalConfiguration.getInstance().setup();
            if (server != null) {
                GlobalConfiguration.getInstance().setTradefedFeatureServer(server);
            }
            console.setArgs(nonGlobalArgs);
            console.setCommandScheduler(GlobalConfiguration.getInstance().getCommandScheduler());
            console.setKeyStoreFactory(GlobalConfiguration.getInstance().getKeyStoreFactory());
            console.setDaemon(true);
            GlobalConfiguration.getInstance().getCommandScheduler().setClearcutClient(client);
            GlobalConfiguration.getInstance().getHostOptions().initConcurrentLocks();
            console.start();
            console.awaitScheduler();
            console.registerShutdownSignals();
            Integer deviceManagementPort = DeviceManagementGrpcServer.getPort();
            if (deviceManagementPort != null) {
                try {
                    deviceManagementServer = new DeviceManagementGrpcServer(deviceManagementPort, GlobalConfiguration.getDeviceManagerInstance(), GlobalConfiguration.getInstance().getCommandScheduler());
                    GlobalConfiguration.getInstance().setDeviceManagementServer(deviceManagementServer);
                    deviceManagementServer.start();
                }
                catch (RuntimeException e) {
                    System.out.println(String.format("Error starting device management server: %s", e));
                }
            }
            if ((port = TestInvocationManagementServer.getPort()) != null) {
                try {
                    invocationManagementServer = new TestInvocationManagementServer(port, GlobalConfiguration.getInstance().getCommandScheduler(), deviceManagementServer);
                    GlobalConfiguration.getInstance().setInvocationServer(invocationManagementServer);
                    invocationManagementServer.start();
                }
                catch (RuntimeException e) {
                    System.out.println(String.format("Error starting invocation server: %s", e));
                }
            }
            Runtime.getRuntime().addShutdownHook(new TerminateGRPCServers(server, invocationManagementServer, deviceManagementServer));
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().addShutdownHook(new TerminateGRPCServers(server, invocationManagementServer, deviceManagementServer));
            throw throwable;
        }
    }

    protected static abstract class ArgRunnable<T>
    implements Runnable {
        protected ArgRunnable() {
        }

        @Override
        public void run() {
            this.run(null);
        }

        public abstract void run(T var1);
    }

    protected static class CaptureList
    extends LinkedList<List<String>> {
        CaptureList() {
        }

        CaptureList(Collection<? extends List<String>> c) {
            super(c);
        }
    }

    private class QuitRunnable
    extends ArgRunnable<CaptureList> {
        @Option(name="wait-for-commands", shortName=99, description="only exit after all commands have executed ")
        private boolean mExitOnEmpty = false;

        private QuitRunnable() {
        }

        @Override
        public void run(CaptureList args) {
            try {
                if (args.size() >= 2 && !((List)args.get(1)).isEmpty()) {
                    List<String> optionArgs = Console.getFlatArgs(1, args);
                    ArgsOptionParser parser = new ArgsOptionParser(this);
                    if (Console.this.mKeyStoreFactory != null) {
                        parser.setKeyStore(Console.this.mKeyStoreFactory.createKeyStoreClient());
                    }
                    parser.parse(optionArgs);
                }
                String exitMode = "invocations";
                if (this.mExitOnEmpty) {
                    exitMode = "commands";
                    Console.this.mScheduler.shutdownOnEmpty();
                } else {
                    Console.this.mScheduler.shutdown(true);
                }
                Console.this.printLine("Signalling command scheduler for shutdown.");
                Console.this.printLine(String.format("TF will exit without warning when remaining %s complete.", exitMode));
            }
            catch (ConfigurationException e) {
                Console.this.printLine(e.toString());
            }
            catch (KeyStoreException e) {
                Console.this.printLine(e.toString());
            }
        }
    }

    private class ForceQuitRunnable
    extends QuitRunnable {
        private ForceQuitRunnable() {
        }

        @Override
        public void run(CaptureList args) {
            Console.this.mScheduler.shutdownHard();
        }
    }

    private static class TerminateGRPCServers
    extends Thread {
        private final TradefedFeatureServer mFeatureServer;
        private final TestInvocationManagementServer mInvocationServer;
        private final DeviceManagementGrpcServer mDeviceServer;

        public TerminateGRPCServers(TradefedFeatureServer featureServer, TestInvocationManagementServer invocationServer, DeviceManagementGrpcServer deviceServer) {
            this.mFeatureServer = featureServer;
            this.mInvocationServer = invocationServer;
            this.mDeviceServer = deviceServer;
        }

        @Override
        public void run() {
            if (this.mFeatureServer != null) {
                try {
                    this.mFeatureServer.shutdown();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (this.mInvocationServer != null) {
                try {
                    this.mInvocationServer.shutdown();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (this.mDeviceServer != null) {
                try {
                    this.mDeviceServer.shutdown();
                }
                catch (InterruptedException e) {
                    LogUtil.CLog.e(e);
                }
            }
        }
    }
}

