/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.device.ITestDevice;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeviceAllocationResult {
    private Map<String, String> mNotAllocatedReason = new LinkedHashMap<String, String>();
    private Map<String, ITestDevice> mAllocatedDevices = new LinkedHashMap<String, ITestDevice>();

    public boolean wasAllocationSuccessful() {
        return !this.mAllocatedDevices.isEmpty();
    }

    public void addAllocatedDevices(Map<String, ITestDevice> devices) {
        this.mAllocatedDevices.putAll(devices);
    }

    public void addAllocationFailureReason(String deviceConfigName, Map<String, String> reasons) {
        this.mNotAllocatedReason.put(deviceConfigName, this.createReasonMessage(reasons));
    }

    public Map<String, ITestDevice> getAllocatedDevices() {
        return this.mAllocatedDevices;
    }

    public String formattedReason() {
        if (this.mNotAllocatedReason.size() == 1) {
            return this.mNotAllocatedReason.values().iterator().next().toString();
        }
        return this.mNotAllocatedReason.toString();
    }

    private String createReasonMessage(Map<String, String> reasons) {
        StringBuilder sb = new StringBuilder();
        for (String serial : reasons.keySet()) {
            String reason = reasons.get(serial);
            if (reason == null) {
                reason = "No reason provided";
            }
            sb.append(String.format("device '%s': %s", serial, reason));
        }
        if (reasons.isEmpty()) {
            sb.append("No reason returned.");
        }
        return sb.toString();
    }
}

