/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command.console;

import java.io.IOException;
import java.io.OutputStream;
import org.jline.reader.LineReader;

public class ConsoleReaderOutputStream
extends OutputStream {
    private final LineReader mConsoleReader;
    private String unfinishedLine = "";

    public ConsoleReaderOutputStream(LineReader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.mConsoleReader = reader;
    }

    public LineReader getConsoleReader() {
        return this.mConsoleReader;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        String str = this.unfinishedLine + new String(b, off, len);
        int indexOfLastNewLine = str.lastIndexOf("\n");
        if (indexOfLastNewLine == -1) {
            this.unfinishedLine = new String(str);
        } else {
            this.unfinishedLine = new String(str.substring(indexOfLastNewLine + 1));
            this.mConsoleReader.printAbove(str.substring(0, indexOfLastNewLine));
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        char[] str = new char[]{(char)(b & 0xFF)};
        this.mConsoleReader.printAbove(new String(str));
    }
}

