/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command.remote;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.TestDeviceState;
import java.io.Serializable;

public class DeviceDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String mSerial;
    private final String mDisplaySerial;
    private final boolean mIsStubDevice;
    private final IDevice.DeviceState mDeviceState;
    private final DeviceAllocationState mState;
    private final TestDeviceState mTestDeviceState;
    private final String mProduct;
    private final String mProductVariant;
    private final String mSdkVersion;
    private final String mBuildId;
    private final String mHardwareRevision;
    private final String mBatteryLevel;
    private final String mDeviceClass;
    private final String mMacAddress;
    private final String mSimState;
    private final String mSimOperator;
    private final IDevice mIDevice;
    private final boolean mIsTemporary;
    private final String mPreconfiguredIp;
    private final Integer mPreconfiguredDeviceNumOffset;

    public DeviceDescriptor() {
        this(null, false, null, null, null, null, null, null);
    }

    public DeviceDescriptor(String serial, boolean isStubDevice, DeviceAllocationState state, String product, String productVariant, String sdkVersion, String buildId, String batteryLevel) {
        this(serial, isStubDevice, state, product, productVariant, sdkVersion, buildId, batteryLevel, "", "", "", "");
    }

    public DeviceDescriptor(String serial, boolean isStubDevice, DeviceAllocationState state, String product, String productVariant, String sdkVersion, String buildId, String batteryLevel, String deviceClass, String macAddress, String simState, String simOperator) {
        this(serial, null, isStubDevice, null, state, null, product, productVariant, sdkVersion, buildId, null, batteryLevel, deviceClass, macAddress, simState, simOperator, false, null, null, null);
    }

    public DeviceDescriptor(String serial, boolean isStubDevice, DeviceAllocationState state, String product, String productVariant, String sdkVersion, String buildId, String batteryLevel, String deviceClass, String macAddress, String simState, String simOperator, IDevice idevice) {
        this(serial, null, isStubDevice, null, state, null, product, productVariant, sdkVersion, buildId, null, batteryLevel, deviceClass, macAddress, simState, simOperator, false, null, null, idevice);
    }

    public DeviceDescriptor(String serial, boolean isStubDevice, IDevice.DeviceState deviceState, DeviceAllocationState state, String product, String productVariant, String sdkVersion, String buildId, String batteryLevel, String deviceClass, String macAddress, String simState, String simOperator, IDevice idevice) {
        this(serial, null, isStubDevice, deviceState, state, null, product, productVariant, sdkVersion, buildId, null, batteryLevel, deviceClass, macAddress, simState, simOperator, false, null, null, idevice);
    }

    public DeviceDescriptor(String serial, String displaySerial, boolean isStubDevice, IDevice.DeviceState deviceState, DeviceAllocationState state, TestDeviceState testDeviceState, String product, String productVariant, String sdkVersion, String buildId, String hardwareRevision, String batteryLevel, String deviceClass, String macAddress, String simState, String simOperator, boolean isTemporary, String preconfiguredIp, Integer preconfiguredDeviceNumOffset, IDevice idevice) {
        this.mSerial = serial;
        this.mDisplaySerial = displaySerial;
        this.mIsStubDevice = isStubDevice;
        this.mDeviceState = deviceState;
        this.mTestDeviceState = testDeviceState;
        this.mState = state;
        this.mProduct = product;
        this.mProductVariant = productVariant;
        this.mSdkVersion = sdkVersion;
        this.mBuildId = buildId;
        this.mHardwareRevision = hardwareRevision;
        this.mBatteryLevel = batteryLevel;
        this.mDeviceClass = deviceClass;
        this.mMacAddress = macAddress;
        this.mSimState = simState;
        this.mSimOperator = simOperator;
        this.mIsTemporary = isTemporary;
        this.mPreconfiguredIp = preconfiguredIp;
        this.mPreconfiguredDeviceNumOffset = preconfiguredDeviceNumOffset;
        this.mIDevice = idevice;
    }

    public DeviceDescriptor(DeviceDescriptor d, DeviceAllocationState state) {
        this(d.getSerial(), d.getDisplaySerial(), d.isStubDevice(), d.getDeviceState(), state, d.getTestDeviceState(), d.getProduct(), d.getProductVariant(), d.getSdkVersion(), d.getBuildId(), null, d.getBatteryLevel(), d.getDeviceClass(), d.getMacAddress(), d.getSimState(), d.getSimOperator(), d.isTemporary(), d.getPreconfiguredIp(), d.getPreconfiguredDeviceNumOffset(), d.getIDevice());
    }

    public DeviceDescriptor(DeviceDescriptor d, String serial, String displaySerial) {
        this(serial, displaySerial, d.isStubDevice(), d.getDeviceState(), d.getState(), d.getTestDeviceState(), d.getProduct(), d.getProductVariant(), d.getSdkVersion(), d.getBuildId(), null, d.getBatteryLevel(), d.getDeviceClass(), d.getMacAddress(), d.getSimState(), d.getSimOperator(), d.isTemporary(), d.getPreconfiguredIp(), d.getPreconfiguredDeviceNumOffset(), d.getIDevice());
    }

    public DeviceDescriptor(DeviceDescriptor d, String preconfiguredIp, Integer preconfiguredDeviceNumOffset) {
        this(d.getSerial(), d.getDisplaySerial(), d.isStubDevice(), d.getDeviceState(), d.getState(), d.getTestDeviceState(), d.getProduct(), d.getProductVariant(), d.getSdkVersion(), d.getBuildId(), null, d.getBatteryLevel(), d.getDeviceClass(), d.getMacAddress(), d.getSimState(), d.getSimOperator(), d.isTemporary(), preconfiguredIp, preconfiguredDeviceNumOffset, d.getIDevice());
    }

    public String getSerial() {
        return this.mSerial;
    }

    public String getDisplaySerial() {
        return this.mDisplaySerial;
    }

    public boolean isStubDevice() {
        return this.mIsStubDevice;
    }

    public IDevice.DeviceState getDeviceState() {
        return this.mDeviceState;
    }

    public DeviceAllocationState getState() {
        return this.mState;
    }

    public TestDeviceState getTestDeviceState() {
        return this.mTestDeviceState;
    }

    public String getProduct() {
        return this.mProduct;
    }

    public String getProductVariant() {
        return this.mProductVariant;
    }

    public String getDeviceClass() {
        return this.mDeviceClass;
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public String getBuildId() {
        return this.mBuildId;
    }

    public String getHardwareRevision() {
        return this.mHardwareRevision;
    }

    public String getBatteryLevel() {
        return this.mBatteryLevel;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public String getSimState() {
        return this.mSimState;
    }

    public String getSimOperator() {
        return this.mSimOperator;
    }

    public boolean isTemporary() {
        return this.mIsTemporary;
    }

    public String getPreconfiguredIp() {
        return this.mPreconfiguredIp;
    }

    public Integer getPreconfiguredDeviceNumOffset() {
        return this.mPreconfiguredDeviceNumOffset;
    }

    private IDevice getIDevice() {
        return this.mIDevice;
    }

    public String getProperty(String name) {
        if (this.mIDevice == null) {
            throw new UnsupportedOperationException("this descriptor does not have IDevice");
        }
        return this.mIDevice.getProperty(name);
    }

    public String toString() {
        return String.format("[%s %s:%s %s]", this.mSerial, this.mProduct, this.mProductVariant, this.mBuildId);
    }
}

