/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.keystore.DryRunKeyStore;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgsOptionParser
extends OptionSetter {
    static final String SHORT_NAME_PREFIX = "-";
    static final String OPTION_NAME_PREFIX = "--";
    static final Pattern BOOL_FALSE_DEVICE_PATTERN = Pattern.compile("(\\{.*\\})(.*:)?(no-)(.+)");
    static final Pattern BOOL_FALSE_PATTERN = Pattern.compile("(.*:)(.*:)(no-)(.+)");
    private static final int OPTION_DESCRIPTION_INDENT = 25;
    private Set<String> inopOptions = new HashSet<String>();

    public Set<String> getInopOptions() {
        return this.inopOptions;
    }

    public ArgsOptionParser(Collection<Object> optionSources) throws ConfigurationException {
        super(optionSources);
    }

    public ArgsOptionParser(Object ... optionSources) throws ConfigurationException {
        super(optionSources);
    }

    public List<String> parse(String ... args) throws ConfigurationException {
        return this.parse(Arrays.asList(args));
    }

    public List<String> parse(List<String> args) throws ConfigurationException {
        ArrayList<String> leftovers = new ArrayList<String>();
        ListIterator<String> argsIter = args.listIterator();
        while (argsIter.hasNext() && this.parseArg(argsIter.next(), argsIter, leftovers)) {
        }
        while (argsIter.hasNext()) {
            leftovers.add(argsIter.next());
        }
        return leftovers;
    }

    public List<String> parseBestEffort(String ... args) {
        return this.parseBestEffort(Arrays.asList(args));
    }

    public List<String> parseBestEffort(List<String> args) {
        return this.parseBestEffort(args, false);
    }

    public List<String> parseBestEffort(List<String> args, boolean forceContinue) {
        ArrayList<String> leftovers = new ArrayList<String>(args.size());
        ListIterator<String> argsIter = args.listIterator();
        int lastProcessedIdx = -1;
        boolean lastCheckThrew = false;
        while (argsIter.hasNext()) {
            lastProcessedIdx = argsIter.nextIndex();
            String arg = argsIter.next();
            try {
                if (!this.parseArg(arg, argsIter, leftovers) && !lastCheckThrew) break;
                lastCheckThrew = false;
            }
            catch (ConfigurationException e) {
                lastCheckThrew = true;
                if (!forceContinue) {
                    leftovers.addAll(args.subList(lastProcessedIdx, args.size()));
                    return leftovers;
                }
                leftovers.add(arg);
            }
        }
        while (argsIter.hasNext()) {
            leftovers.add(argsIter.next());
        }
        return leftovers;
    }

    public void validateMandatoryOptions() throws ConfigurationException {
        ArrayList<String> missingOptions = new ArrayList<String>(this.getUnsetMandatoryOptions());
        if (!missingOptions.isEmpty()) {
            throw new ConfigurationException(String.format("Found missing mandatory options: %s", ArrayUtil.join(", ", missingOptions)));
        }
    }

    private boolean parseArg(String arg, ListIterator<String> args, List<String> leftovers) throws ConfigurationException {
        if (arg.equals(OPTION_NAME_PREFIX)) {
            return false;
        }
        if (arg.startsWith(OPTION_NAME_PREFIX)) {
            this.parseLongOption(arg, args);
            return true;
        }
        if (arg.startsWith(SHORT_NAME_PREFIX)) {
            this.parseGroupedShortOptions(arg, args);
            return true;
        }
        leftovers.add(arg);
        return false;
    }

    private void parseLongOption(String arg, ListIterator<String> args) throws ConfigurationException {
        List<OptionSetter.FieldDef> modifiedField;
        String name = arg.replaceFirst("^--", "");
        String key = null;
        String value = null;
        int equalsIndex = name.indexOf(61);
        if (equalsIndex != -1) {
            value = name.substring(equalsIndex + 1);
            name = name.substring(0, equalsIndex);
        }
        if (this.isBooleanOption(name)) {
            int idx = name.indexOf(58);
            Matcher m = BOOL_FALSE_DEVICE_PATTERN.matcher(name);
            if (m.find()) {
                value = "false";
            } else {
                Matcher boolNamespace;
                String nextArg;
                if (value == null) {
                    value = "true";
                }
                String string = nextArg = args.hasNext() ? args.next() : null;
                if (nextArg != null) {
                    if (nextArg.equalsIgnoreCase("true") || nextArg.equalsIgnoreCase("false")) {
                        value = nextArg.toLowerCase();
                    } else {
                        args.previous();
                    }
                }
                if ((boolNamespace = BOOL_FALSE_PATTERN.matcher(name)).find()) {
                    value = "false";
                } else if (name.startsWith("no-", idx + 1)) {
                    if (value.equals("false")) {
                        throw new ConfigurationException(String.format("Can not use 'no-' prefix on a boolean flag with a 'false' value. Please use '--%1$s' instead of '--%2$s false'", name.substring("no-".length() + idx + 1), name), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                    }
                    value = "false";
                }
            }
        }
        if (value == null) {
            if (this.isMapOption(name)) {
                String tmp = this.grabNextValue(args, name, "for its key");
                Pattern p = Pattern.compile("(?<!\\\\)=");
                String[] parts = p.split(tmp, -1);
                if (parts.length == 2) {
                    key = parts[0].replaceAll("\\\\=", "=");
                    value = parts[1].replaceAll("\\\\=", "=");
                } else {
                    if (parts.length > 2) {
                        throw new ConfigurationException(String.format("option '%s' has an invalid format for value %s:w", name, tmp), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                    }
                    key = tmp.replaceAll("\\\\=", "=");
                    value = this.grabNextValue(args, name, "for its value").replaceAll("\\\\=", "=");
                }
            } else {
                value = this.grabNextValue(args, name);
            }
        }
        if ((modifiedField = this.setOptionValue(name, key, value = this.getKeyStoreValueIfNeeded(value, this.getTypeForOption(name)))).isEmpty()) {
            this.inopOptions.add(name);
        }
    }

    private void parseGroupedShortOptions(String arg, ListIterator<String> args) throws ConfigurationException {
        for (int i = 1; i < arg.length(); ++i) {
            String value;
            String name = String.valueOf(arg.charAt(i));
            if (this.isBooleanOption(name)) {
                value = "true";
            } else if (i + 1 < arg.length()) {
                value = arg.substring(i + 1);
                i = arg.length() - 1;
            } else {
                value = this.grabNextValue(args, name);
            }
            value = this.getKeyStoreValueIfNeeded(value, this.getTypeForOption(name));
            List<OptionSetter.FieldDef> modifiedField = this.setOptionValue(name, value);
            if (!modifiedField.isEmpty()) continue;
            this.inopOptions.add(name);
        }
    }

    private String grabNextValue(ListIterator<String> args, String name) throws ConfigurationException {
        return this.grabNextValue(args, name, "");
    }

    private String grabNextValue(ListIterator<String> args, String name, String detail) throws ConfigurationException {
        if (!args.hasNext()) {
            String type = this.getTypeForOption(name);
            throw new ConfigurationException(String.format("option '%s' requires a '%s' argument%s", name, type, detail));
        }
        return args.next();
    }

    public static String getOptionHelp(boolean importantOnly, Object optionObject) {
        StringBuilder out = new StringBuilder();
        Collection<Field> optionFields = OptionSetter.getOptionFieldsForClass(optionObject.getClass());
        String eol = System.getProperty("line.separator");
        for (Field field : optionFields) {
            Option option = field.getAnnotation(Option.class);
            String defaultValue = OptionSetter.getFieldValueAsString(field, optionObject);
            String optionNameHelp = ArgsOptionParser.buildOptionNameHelp(field, option);
            if (!ArgsOptionParser.shouldOutputHelpForOption(importantOnly, option, defaultValue)) continue;
            out.append(optionNameHelp);
            int wsChars = 0;
            if (optionNameHelp.length() >= 25) {
                out.append(eol);
                wsChars = 25;
            } else {
                wsChars = 25 - optionNameHelp.length();
            }
            for (int i = 0; i < wsChars; ++i) {
                out.append(' ');
            }
            out.append(option.description());
            out.append(ArgsOptionParser.getDefaultValueHelp(defaultValue));
            out.append(OptionSetter.getEnumFieldValuesAsString(field));
            out.append(eol);
        }
        return out.toString();
    }

    private static boolean shouldOutputHelpForOption(boolean importantOnly, Option option, String defaultValue) {
        if (!importantOnly) {
            return true;
        }
        switch (option.importance()) {
            case NEVER: {
                return false;
            }
            case IF_UNSET: {
                return defaultValue == null;
            }
            case ALWAYS: {
                return true;
            }
        }
        LogUtil.CLog.e("Unrecognized importance setting '%s'", option.importance().toString());
        return false;
    }

    private static String buildOptionNameHelp(Field field, Option option) {
        StringBuilder optionNameBuilder = new StringBuilder();
        optionNameBuilder.append("    ");
        if (option.shortName() != '0') {
            optionNameBuilder.append(SHORT_NAME_PREFIX);
            optionNameBuilder.append(option.shortName());
            optionNameBuilder.append(", ");
        }
        optionNameBuilder.append(OPTION_NAME_PREFIX);
        try {
            if (OptionSetter.isBooleanField(field)) {
                optionNameBuilder.append("[no-]");
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        optionNameBuilder.append(option.name());
        return optionNameBuilder.toString();
    }

    private static String getDefaultValueHelp(String defaultValue) {
        if (defaultValue == null) {
            return "";
        }
        return String.format(" Default: %s.", defaultValue);
    }

    private String getKeyStoreValueIfNeeded(String valueText, String optionType) throws ConfigurationException {
        Matcher m = USE_KEYSTORE_REGEX.matcher(valueText);
        if (m.matches() && m.groupCount() > 0) {
            IKeyStoreClient c = this.getKeyStore();
            if (c == null) {
                throw new ConfigurationException("Key store is null, but we tried to fetch a key", (ErrorIdentifier)InfraErrorIdentifier.KEYSTORE_CONFIG_ERROR);
            }
            if (!c.isAvailable()) {
                throw new ConfigurationException(String.format("Key store '%s' is unavailable, but we tried to fetch a key", c.getClass()), (ErrorIdentifier)InfraErrorIdentifier.KEYSTORE_CONFIG_ERROR);
            }
            String key = m.group(1);
            String v = null;
            v = c instanceof DryRunKeyStore ? ((DryRunKeyStore)c).fetchKey(key, optionType) : c.fetchKey(key);
            if (v == null) {
                throw new ConfigurationException(String.format("Failed to fetch key %s in keystore", key), (ErrorIdentifier)InfraErrorIdentifier.KEYSTORE_CONFIG_ERROR);
            }
            return v;
        }
        return valueText;
    }
}

