/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IFileResolverLoader;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@VisibleForTesting
public class BootstrapServiceFileResolverLoader
implements IFileResolverLoader {
    private final Supplier<ClassLoader> mClassLoaderSupplier;

    BootstrapServiceFileResolverLoader() {
        this.mClassLoaderSupplier = () -> Thread.currentThread().getContextClassLoader();
    }

    BootstrapServiceFileResolverLoader(ClassLoader classLoader) {
        this.mClassLoaderSupplier = () -> classLoader;
    }

    @Override
    public synchronized IRemoteFileResolver load(String scheme, Map<String, String> config) {
        ServiceLoader<IRemoteFileResolver> serviceLoader = ServiceLoader.load(IRemoteFileResolver.class, this.mClassLoaderSupplier.get());
        for (IRemoteFileResolver resolver : serviceLoader) {
            if (!scheme.equals(resolver.getSupportedProtocol())) continue;
            try {
                OptionSetter setter = new OptionSetter(resolver);
                Collection<String> missingOptions = setter.getUnsetMandatoryOptions();
                if (!missingOptions.isEmpty()) {
                    throw new IFileResolverLoader.ResolverLoadingException(String.format("Mandatory options for resolver %s are not allowed in a bootstrap context", resolver.toString()), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
            }
            catch (ConfigurationException e) {
                throw new IFileResolverLoader.ResolverLoadingException("Failed to load resolver", e);
            }
            return resolver;
        }
        throw new IFileResolverLoader.ResolverLoadingException(String.format("Unsupported protocol for dynamic download %s", scheme), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
    }
}

