/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.command.CommandOptions;
import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationUtil;
import com.android.tradefed.config.DeviceConfigurationHolder;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.config.OptionDef;
import com.android.tradefed.config.OptionNotAllowedException;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.config.filter.GlobalTestFilter;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.log.StdoutLogger;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.postprocessor.IPostProcessor;
import com.android.tradefed.result.FileSystemLogSaver;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TextResultReporter;
import com.android.tradefed.result.skipped.SkipManager;
import com.android.tradefed.retry.BaseRetryDecision;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.sandbox.SandboxOptions;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.StubTest;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IDisableable;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kxml2.io.KXmlSerializer;

public class Configuration
implements IConfiguration {
    public static final String BUILD_PROVIDER_TYPE_NAME = "build_provider";
    public static final String TARGET_PREPARER_TYPE_NAME = "target_preparer";
    public static final String LAB_PREPARER_TYPE_NAME = "lab_preparer";
    public static final String MULTI_PRE_TARGET_PREPARER_TYPE_NAME = "multi_pre_target_preparer";
    public static final String MULTI_PREPARER_TYPE_NAME = "multi_target_preparer";
    public static final String TEST_TYPE_NAME = "test";
    public static final String DEVICE_RECOVERY_TYPE_NAME = "device_recovery";
    public static final String LOGGER_TYPE_NAME = "logger";
    public static final String LOG_SAVER_TYPE_NAME = "log_saver";
    public static final String RESULT_REPORTER_TYPE_NAME = "result_reporter";
    public static final String CMD_OPTIONS_TYPE_NAME = "cmd_options";
    public static final String DEVICE_REQUIREMENTS_TYPE_NAME = "device_requirements";
    public static final String DEVICE_OPTIONS_TYPE_NAME = "device_options";
    public static final String SYSTEM_STATUS_CHECKER_TYPE_NAME = "system_checker";
    public static final String CONFIGURATION_DESCRIPTION_TYPE_NAME = "config_desc";
    public static final String DEVICE_NAME = "device";
    public static final String DEVICE_METRICS_COLLECTOR_TYPE_NAME = "metrics_collector";
    public static final String METRIC_POST_PROCESSOR_TYPE_NAME = "metric_post_processor";
    public static final String SANDBOX_TYPE_NAME = "sandbox";
    public static final String SANBOX_OPTIONS_TYPE_NAME = "sandbox_options";
    public static final String RETRY_DECISION_TYPE_NAME = "retry_decision";
    public static final String COVERAGE_OPTIONS_TYPE_NAME = "coverage";
    public static final String GLOBAL_FILTERS_TYPE_NAME = "global_filters";
    public static final String SKIP_MANAGER_TYPE_NAME = "skip_manager";
    private static Map<String, ObjTypeInfo> sObjTypeMap = null;
    private static Set<String> sMultiDeviceSupportedTag = ImmutableSet.of("build_provider", "target_preparer", "lab_preparer", "device_recovery", "device_requirements", "device_options", new String[0]);
    private static final Pattern OPTION_KEY_VALUE_PATTERN = Pattern.compile("(?<!\\\\)=");
    private static final Pattern CONFIG_EXCEPTION_PATTERN = Pattern.compile("Could not find option with name '(.*)'");
    private Map<String, List<Object>> mConfigMap;
    private final String mName;
    private final String mDescription;
    private String[] mCommandLine;
    private Set<String> mInopOptions = new HashSet<String>();
    private Set<File> mRemoteFiles = new HashSet<File>();

    static boolean isBuiltInObjType(String typeName) {
        return Configuration.getObjTypeMap().containsKey(typeName);
    }

    private static synchronized Map<String, ObjTypeInfo> getObjTypeMap() {
        if (sObjTypeMap == null) {
            sObjTypeMap = new HashMap<String, ObjTypeInfo>();
            sObjTypeMap.put(BUILD_PROVIDER_TYPE_NAME, new ObjTypeInfo(IBuildProvider.class, false));
            sObjTypeMap.put(TARGET_PREPARER_TYPE_NAME, new ObjTypeInfo(ITargetPreparer.class, true));
            sObjTypeMap.put(LAB_PREPARER_TYPE_NAME, new ObjTypeInfo(ILabPreparer.class, true));
            sObjTypeMap.put(MULTI_PRE_TARGET_PREPARER_TYPE_NAME, new ObjTypeInfo(IMultiTargetPreparer.class, true));
            sObjTypeMap.put(MULTI_PREPARER_TYPE_NAME, new ObjTypeInfo(IMultiTargetPreparer.class, true));
            sObjTypeMap.put(TEST_TYPE_NAME, new ObjTypeInfo(IRemoteTest.class, true));
            sObjTypeMap.put(DEVICE_RECOVERY_TYPE_NAME, new ObjTypeInfo(IDeviceRecovery.class, false));
            sObjTypeMap.put(LOGGER_TYPE_NAME, new ObjTypeInfo(ILeveledLogOutput.class, false));
            sObjTypeMap.put(LOG_SAVER_TYPE_NAME, new ObjTypeInfo(ILogSaver.class, false));
            sObjTypeMap.put(RESULT_REPORTER_TYPE_NAME, new ObjTypeInfo(ITestInvocationListener.class, true));
            sObjTypeMap.put(CMD_OPTIONS_TYPE_NAME, new ObjTypeInfo(ICommandOptions.class, false));
            sObjTypeMap.put(DEVICE_REQUIREMENTS_TYPE_NAME, new ObjTypeInfo(IDeviceSelection.class, false));
            sObjTypeMap.put(DEVICE_OPTIONS_TYPE_NAME, new ObjTypeInfo(TestDeviceOptions.class, false));
            sObjTypeMap.put(DEVICE_NAME, new ObjTypeInfo(IDeviceConfiguration.class, true));
            sObjTypeMap.put(SYSTEM_STATUS_CHECKER_TYPE_NAME, new ObjTypeInfo(ISystemStatusChecker.class, true));
            sObjTypeMap.put(CONFIGURATION_DESCRIPTION_TYPE_NAME, new ObjTypeInfo(ConfigurationDescriptor.class, false));
            sObjTypeMap.put(DEVICE_METRICS_COLLECTOR_TYPE_NAME, new ObjTypeInfo(IMetricCollector.class, true));
            sObjTypeMap.put(METRIC_POST_PROCESSOR_TYPE_NAME, new ObjTypeInfo(BasePostProcessor.class, true));
            sObjTypeMap.put(SANBOX_OPTIONS_TYPE_NAME, new ObjTypeInfo(SandboxOptions.class, false));
            sObjTypeMap.put(RETRY_DECISION_TYPE_NAME, new ObjTypeInfo(IRetryDecision.class, false));
            sObjTypeMap.put(COVERAGE_OPTIONS_TYPE_NAME, new ObjTypeInfo(CoverageOptions.class, false));
            sObjTypeMap.put(GLOBAL_FILTERS_TYPE_NAME, new ObjTypeInfo(GlobalTestFilter.class, false));
            sObjTypeMap.put(SKIP_MANAGER_TYPE_NAME, new ObjTypeInfo(SkipManager.class, false));
        }
        return sObjTypeMap;
    }

    static boolean doesBuiltInObjSupportMultiDevice(String typeName) {
        return Configuration.getMultiDeviceSupportedTag().contains(typeName);
    }

    public static synchronized Set<String> getMultiDeviceSupportedTag() {
        return sMultiDeviceSupportedTag;
    }

    public Configuration(String name, String description) {
        this.mName = name;
        this.mDescription = description;
        this.mConfigMap = new LinkedHashMap<String, List<Object>>();
        this.setDeviceConfig(new DeviceConfigurationHolder("DEFAULT_DEVICE"));
        this.setCommandOptions(new CommandOptions());
        this.setTest(new StubTest());
        this.setLogOutput(new StdoutLogger());
        this.setLogSaver(new FileSystemLogSaver());
        this.setTestInvocationListener(new TextResultReporter());
        this.setConfigurationObjectListNoThrow(TARGET_PREPARER_TYPE_NAME, new ArrayList());
        this.setConfigurationObjectListNoThrow(LAB_PREPARER_TYPE_NAME, new ArrayList());
        this.setMultiPreTargetPreparers(new ArrayList<IMultiTargetPreparer>());
        this.setMultiTargetPreparers(new ArrayList<IMultiTargetPreparer>());
        this.setSystemStatusCheckers(new ArrayList<ISystemStatusChecker>());
        this.setConfigurationDescriptor(new ConfigurationDescriptor());
        this.setDeviceMetricCollectors(new ArrayList<IMetricCollector>());
        this.setPostProcessors(new ArrayList<IPostProcessor>());
        this.setCoverageOptions(new CoverageOptions());
        this.setConfigurationObjectNoThrow(SANBOX_OPTIONS_TYPE_NAME, new SandboxOptions());
        this.setConfigurationObjectNoThrow(RETRY_DECISION_TYPE_NAME, new BaseRetryDecision());
        this.setConfigurationObjectNoThrow(GLOBAL_FILTERS_TYPE_NAME, new GlobalTestFilter());
        this.setConfigurationObjectNoThrow(SKIP_MANAGER_TYPE_NAME, new SkipManager());
    }

    private void notAllowedInMultiMode(String function) {
        if (this.getConfigurationObjectList(DEVICE_NAME).size() > 1) {
            throw new UnsupportedOperationException(String.format("Calling %s is not allowed in multi device mode", function));
        }
        if (this.getConfigurationObjectList(DEVICE_NAME).isEmpty()) {
            throw new UnsupportedOperationException("We should always have at least 1 Device config");
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setCommandLine(String[] arrayArgs) {
        this.mCommandLine = arrayArgs;
    }

    @Override
    public String getCommandLine() {
        if (this.mCommandLine != null && this.mCommandLine.length != 0) {
            return QuotationAwareTokenizer.combineTokens(this.mCommandLine);
        }
        return null;
    }

    @Override
    public IBuildProvider getBuildProvider() {
        this.notAllowedInMultiMode("getBuildProvider");
        return ((IDeviceConfiguration)this.getConfigurationObjectList(DEVICE_NAME).get(0)).getBuildProvider();
    }

    @Override
    public List<ITargetPreparer> getTargetPreparers() {
        this.notAllowedInMultiMode("getTargetPreparers");
        return ((IDeviceConfiguration)this.getConfigurationObjectList(DEVICE_NAME).get(0)).getTargetPreparers();
    }

    @Override
    public List<ITargetPreparer> getLabPreparers() {
        this.notAllowedInMultiMode("getLabPreparers");
        return ((IDeviceConfiguration)this.getConfigurationObjectList(DEVICE_NAME).get(0)).getLabPreparers();
    }

    @Override
    public List<IRemoteTest> getTests() {
        return this.getConfigurationObjectList(TEST_TYPE_NAME);
    }

    @Override
    public IDeviceRecovery getDeviceRecovery() {
        this.notAllowedInMultiMode("getDeviceRecovery");
        return ((IDeviceConfiguration)this.getConfigurationObjectList(DEVICE_NAME).get(0)).getDeviceRecovery();
    }

    @Override
    public ILeveledLogOutput getLogOutput() {
        return (ILeveledLogOutput)this.getConfigurationObject(LOGGER_TYPE_NAME);
    }

    @Override
    public ILogSaver getLogSaver() {
        return (ILogSaver)this.getConfigurationObject(LOG_SAVER_TYPE_NAME);
    }

    @Override
    public IRetryDecision getRetryDecision() {
        return (IRetryDecision)this.getConfigurationObject(RETRY_DECISION_TYPE_NAME);
    }

    @Override
    public List<IMultiTargetPreparer> getMultiTargetPreparers() {
        return this.getConfigurationObjectList(MULTI_PREPARER_TYPE_NAME);
    }

    @Override
    public List<IMultiTargetPreparer> getMultiPreTargetPreparers() {
        return this.getConfigurationObjectList(MULTI_PRE_TARGET_PREPARER_TYPE_NAME);
    }

    @Override
    public List<ISystemStatusChecker> getSystemStatusCheckers() {
        return this.getConfigurationObjectList(SYSTEM_STATUS_CHECKER_TYPE_NAME);
    }

    @Override
    public List<ITestInvocationListener> getTestInvocationListeners() {
        return this.getConfigurationObjectList(RESULT_REPORTER_TYPE_NAME);
    }

    @Override
    public List<IMetricCollector> getMetricCollectors() {
        return this.getConfigurationObjectList(DEVICE_METRICS_COLLECTOR_TYPE_NAME);
    }

    @Override
    public List<IPostProcessor> getPostProcessors() {
        return this.getConfigurationObjectList(METRIC_POST_PROCESSOR_TYPE_NAME);
    }

    @Override
    public ICommandOptions getCommandOptions() {
        return (ICommandOptions)this.getConfigurationObject(CMD_OPTIONS_TYPE_NAME);
    }

    @Override
    public ConfigurationDescriptor getConfigurationDescription() {
        return (ConfigurationDescriptor)this.getConfigurationObject(CONFIGURATION_DESCRIPTION_TYPE_NAME);
    }

    @Override
    public IDeviceSelection getDeviceRequirements() {
        this.notAllowedInMultiMode("getDeviceRequirements");
        return ((IDeviceConfiguration)this.getConfigurationObjectList(DEVICE_NAME).get(0)).getDeviceRequirements();
    }

    @Override
    public TestDeviceOptions getDeviceOptions() {
        this.notAllowedInMultiMode("getDeviceOptions");
        return ((IDeviceConfiguration)this.getConfigurationObjectList(DEVICE_NAME).get(0)).getDeviceOptions();
    }

    @Override
    public List<?> getConfigurationObjectList(String typeName) {
        return this.mConfigMap.get(typeName);
    }

    @Override
    public IDeviceConfiguration getDeviceConfigByName(String nameDevice) {
        for (IDeviceConfiguration deviceHolder : this.getConfigurationObjectList(DEVICE_NAME)) {
            if (!deviceHolder.getDeviceName().equals(nameDevice)) continue;
            return deviceHolder;
        }
        return null;
    }

    @Override
    public List<IDeviceConfiguration> getDeviceConfig() {
        return this.getConfigurationObjectList(DEVICE_NAME);
    }

    @Override
    public CoverageOptions getCoverageOptions() {
        return (CoverageOptions)this.getConfigurationObject(COVERAGE_OPTIONS_TYPE_NAME);
    }

    @Override
    public GlobalTestFilter getGlobalFilters() {
        return (GlobalTestFilter)this.getConfigurationObject(GLOBAL_FILTERS_TYPE_NAME);
    }

    @Override
    public SkipManager getSkipManager() {
        return (SkipManager)this.getConfigurationObject(SKIP_MANAGER_TYPE_NAME);
    }

    @Override
    public Object getConfigurationObject(String typeName) {
        List<?> configObjects = this.getConfigurationObjectList(typeName);
        if (configObjects == null) {
            return null;
        }
        ObjTypeInfo typeInfo = Configuration.getObjTypeMap().get(typeName);
        if (typeInfo != null && typeInfo.mIsListSupported) {
            throw new IllegalStateException(String.format("Wrong method call for type %s. Used getConfigurationObject() for a config object that is stored as a list", typeName));
        }
        if (configObjects.size() != 1) {
            throw new IllegalStateException(String.format("Attempted to retrieve single object for %s, but %d are present", typeName, configObjects.size()));
        }
        return configObjects.get(0);
    }

    @Override
    public Collection<Object> getAllConfigurationObjectsOfType(String configType) {
        ArrayList<Object> objectsCopy = new ArrayList<Object>();
        if (Configuration.doesBuiltInObjSupportMultiDevice(configType)) {
            for (IDeviceConfiguration deviceConfig : this.getDeviceConfig()) {
                objectsCopy.addAll(deviceConfig.getAllObjectOfType(configType));
            }
        } else {
            List<?> configObjects = this.getConfigurationObjectList(configType);
            if (configObjects != null) {
                objectsCopy.addAll(configObjects);
            }
        }
        return objectsCopy;
    }

    private Collection<Object> getAllConfigurationObjects() {
        return this.getAllConfigurationObjects(null, true);
    }

    private Collection<Object> getAllConfigurationObjects(String excludedConfigName, boolean includeDisabled) {
        ArrayList<Object> objectsCopy = new ArrayList<Object>();
        for (Map.Entry<String, List<Object>> entryList : this.mConfigMap.entrySet()) {
            if (excludedConfigName != null && excludedConfigName.equals(entryList.getKey())) continue;
            if (includeDisabled) {
                objectsCopy.addAll((Collection<Object>)entryList.getValue());
                continue;
            }
            for (Object o : entryList.getValue()) {
                if (o instanceof IDisableable && ((IDisableable)o).isDisabled()) continue;
                objectsCopy.add(o);
            }
        }
        return objectsCopy;
    }

    private Collection<Object> getAllNonDisabledConfigurationObjects() {
        String excluded = null;
        if (System.getenv("SANDBOX_ENABLED") != null) {
            excluded = LAB_PREPARER_TYPE_NAME;
        }
        return this.getAllConfigurationObjects(excluded, false);
    }

    private OptionSetter createOptionSetter() throws ConfigurationException {
        return new OptionSetter(this.getAllConfigurationObjects());
    }

    private void internalInjectOptionValue(OptionSetter optionSetter, String optionName, String optionKey, String optionValue, String source) throws ConfigurationException {
        if (optionSetter == null) {
            throw new IllegalArgumentException("optionSetter cannot be null");
        }
        List<OptionSetter.FieldDef> affectedFields = optionSetter.setOptionValue(optionName, optionKey, optionValue);
        boolean requiredForRerun = false;
        for (OptionSetter.FieldDef field : affectedFields) {
            if (!(requiredForRerun |= field.field.getAnnotation(Option.class).requiredForRerun())) continue;
            break;
        }
        if (requiredForRerun) {
            OptionDef optionDef = new OptionDef(optionName, optionKey, optionValue, source, null);
            this.getConfigurationDescription().addRerunOption(optionDef);
        }
    }

    private void internalInjectOptionValue(OptionSetter optionSetter, String optionName, String optionValue) throws ConfigurationException {
        if (optionSetter == null) {
            throw new IllegalArgumentException("optionSetter cannot be null");
        }
        if (!optionSetter.isMapOption(optionName)) {
            this.internalInjectOptionValue(optionSetter, optionName, null, optionValue, null);
            return;
        }
        String[] parts = OPTION_KEY_VALUE_PATTERN.split(optionValue);
        if (parts.length != 2) {
            throw new ConfigurationException(String.format("option '%s' has an invalid format for value %s:w", optionName, optionValue));
        }
        this.internalInjectOptionValue(optionSetter, optionName, parts[0].replace("\\\\=", "="), parts[1].replace("\\\\=", "="), null);
    }

    @Override
    public void injectOptionValue(String optionName, String optionValue) throws ConfigurationException {
        this.internalInjectOptionValue(this.createOptionSetter(), optionName, optionValue);
    }

    @Override
    public void injectOptionValue(String optionName, String optionKey, String optionValue) throws ConfigurationException {
        this.internalInjectOptionValue(this.createOptionSetter(), optionName, optionKey, optionValue, null);
    }

    @Override
    public void injectOptionValueWithSource(String optionName, String optionKey, String optionValue, String source) throws ConfigurationException {
        this.internalInjectOptionValue(this.createOptionSetter(), optionName, optionKey, optionValue, source);
    }

    @Override
    public void injectOptionValues(List<OptionDef> optionDefs) throws ConfigurationException {
        OptionSetter optionSetter = this.createOptionSetter();
        for (OptionDef optionDef : optionDefs) {
            this.internalInjectOptionValue(optionSetter, optionDef.name, optionDef.key, optionDef.value, optionDef.source);
        }
    }

    @Override
    public void safeInjectOptionValues(List<OptionDef> optionDefs) throws ConfigurationException {
        OptionSetter optionSetter = this.createOptionSetter();
        for (OptionDef optionDef : optionDefs) {
            try {
                this.internalInjectOptionValue(optionSetter, optionDef.name, optionDef.key, optionDef.value, optionDef.source);
            }
            catch (ConfigurationException configurationException) {}
        }
    }

    @Override
    public Configuration clone() {
        Configuration clone = new Configuration(this.getName(), this.getDescription());
        for (Map.Entry<String, List<Object>> entry : this.mConfigMap.entrySet()) {
            if (DEVICE_NAME.equals(entry.getKey())) {
                ArrayList<IDeviceConfiguration> newDeviceConfigList = new ArrayList<IDeviceConfiguration>();
                for (Object deviceConfig : entry.getValue()) {
                    IDeviceConfiguration config = (IDeviceConfiguration)deviceConfig;
                    IDeviceConfiguration newDeviceConfig = config.clone();
                    newDeviceConfigList.add(newDeviceConfig);
                }
                clone.setConfigurationObjectListNoThrow(entry.getKey(), newDeviceConfigList);
                continue;
            }
            clone.setConfigurationObjectListNoThrow(entry.getKey(), entry.getValue());
        }
        clone.setCommandLine(this.mCommandLine);
        return clone;
    }

    @Override
    public IConfiguration partialDeepClone(List<String> objectToDeepClone, IKeyStoreClient client) throws ConfigurationException {
        Configuration clonedConfig = this.clone();
        ArrayList<String> objToDeepClone = new ArrayList<String>(objectToDeepClone);
        if (objectToDeepClone.contains(DEVICE_NAME)) {
            objToDeepClone.remove(DEVICE_NAME);
            objToDeepClone.addAll(Configuration.getMultiDeviceSupportedTag());
        }
        for (String objType : objToDeepClone) {
            if (Configuration.doesBuiltInObjSupportMultiDevice(objType)) {
                for (int i = 0; i < clonedConfig.getDeviceConfig().size(); ++i) {
                    IDeviceConfiguration deepCopyConfig = clonedConfig.getDeviceConfig().get(i);
                    List<?> listOfType = this.cloneListTFObject(deepCopyConfig.getAllObjectOfType(objType));
                    clonedConfig.getDeviceConfig().get(i).removeObjectType(objType);
                    for (Object o : listOfType) {
                        clonedConfig.getDeviceConfig().get(i).addSpecificConfig(o, objType);
                        if (!(o instanceof IConfigurationReceiver)) continue;
                        ((IConfigurationReceiver)o).setConfiguration(clonedConfig);
                    }
                }
                continue;
            }
            clonedConfig.setConfigurationObjectList(objType, this.cloneListTFObject(clonedConfig.getConfigurationObjectList(objType)));
        }
        return clonedConfig;
    }

    private List<?> cloneListTFObject(List<?> objects) throws ConfigurationException {
        ArrayList<Object> copiedList = new ArrayList<Object>();
        for (Object o : objects) {
            copiedList.add(this.cloneTFobject(o));
        }
        return copiedList;
    }

    private Object cloneTFobject(Object o) throws ConfigurationException {
        try {
            Object clone = o.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            OptionCopier.copyOptions(o, clone);
            return clone;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ConfigurationException(String.format("Failed to copy %s", o), e);
        }
    }

    private void addToDefaultDeviceConfig(Object obj, String type) {
        try {
            this.getDeviceConfigByName("DEFAULT_DEVICE").addSpecificConfig(obj, type);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setBuildProvider(IBuildProvider provider) {
        this.notAllowedInMultiMode("setBuildProvider");
        this.addToDefaultDeviceConfig(provider, BUILD_PROVIDER_TYPE_NAME);
    }

    @Override
    public void setTestInvocationListeners(List<ITestInvocationListener> listeners) {
        this.setConfigurationObjectListNoThrow(RESULT_REPORTER_TYPE_NAME, listeners);
    }

    @Override
    public void setDeviceMetricCollectors(List<IMetricCollector> collectors) {
        this.setConfigurationObjectListNoThrow(DEVICE_METRICS_COLLECTOR_TYPE_NAME, collectors);
    }

    @Override
    public void setPostProcessors(List<IPostProcessor> processors) {
        this.setConfigurationObjectListNoThrow(METRIC_POST_PROCESSOR_TYPE_NAME, processors);
    }

    @Override
    public void setTestInvocationListener(ITestInvocationListener listener) {
        this.setConfigurationObjectNoThrow(RESULT_REPORTER_TYPE_NAME, listener);
    }

    @Override
    public void setDeviceConfig(IDeviceConfiguration deviceConfig) {
        this.setConfigurationObjectNoThrow(DEVICE_NAME, deviceConfig);
    }

    @Override
    public void setDeviceConfigList(List<IDeviceConfiguration> deviceConfigs) {
        this.setConfigurationObjectListNoThrow(DEVICE_NAME, deviceConfigs);
    }

    @Override
    public void setCoverageOptions(CoverageOptions coverageOptions) {
        this.setConfigurationObjectNoThrow(COVERAGE_OPTIONS_TYPE_NAME, coverageOptions);
    }

    @Override
    public void setTest(IRemoteTest test) {
        this.setConfigurationObjectNoThrow(TEST_TYPE_NAME, test);
    }

    @Override
    public void setTests(List<IRemoteTest> tests) {
        this.setConfigurationObjectListNoThrow(TEST_TYPE_NAME, tests);
    }

    @Override
    public void setMultiTargetPreparers(List<IMultiTargetPreparer> multiTargPreps) {
        this.setConfigurationObjectListNoThrow(MULTI_PREPARER_TYPE_NAME, multiTargPreps);
    }

    @Override
    public void setMultiTargetPreparer(IMultiTargetPreparer multiTargPrep) {
        this.setConfigurationObjectNoThrow(MULTI_PREPARER_TYPE_NAME, multiTargPrep);
    }

    @Override
    public void setMultiPreTargetPreparers(List<IMultiTargetPreparer> multiPreTargPreps) {
        this.setConfigurationObjectListNoThrow(MULTI_PRE_TARGET_PREPARER_TYPE_NAME, multiPreTargPreps);
    }

    @Override
    public void setMultiPreTargetPreparer(IMultiTargetPreparer multiPreTargPrep) {
        this.setConfigurationObjectNoThrow(MULTI_PRE_TARGET_PREPARER_TYPE_NAME, multiPreTargPrep);
    }

    @Override
    public void setSystemStatusCheckers(List<ISystemStatusChecker> systemCheckers) {
        this.setConfigurationObjectListNoThrow(SYSTEM_STATUS_CHECKER_TYPE_NAME, systemCheckers);
    }

    @Override
    public void setSystemStatusChecker(ISystemStatusChecker systemChecker) {
        this.setConfigurationObjectNoThrow(SYSTEM_STATUS_CHECKER_TYPE_NAME, systemChecker);
    }

    @Override
    public void setLogOutput(ILeveledLogOutput logger) {
        this.setConfigurationObjectNoThrow(LOGGER_TYPE_NAME, logger);
    }

    @Override
    public void setLogSaver(ILogSaver logSaver) {
        this.setConfigurationObjectNoThrow(LOG_SAVER_TYPE_NAME, logSaver);
    }

    @Override
    public void setRetryDecision(IRetryDecision decisionRetry) {
        this.setConfigurationObjectNoThrow(RETRY_DECISION_TYPE_NAME, decisionRetry);
    }

    private void setConfigurationDescriptor(ConfigurationDescriptor configDescriptor) {
        this.setConfigurationObjectNoThrow(CONFIGURATION_DESCRIPTION_TYPE_NAME, configDescriptor);
    }

    @Override
    public void setDeviceRecovery(IDeviceRecovery recovery) {
        this.notAllowedInMultiMode("setDeviceRecovery");
        this.addToDefaultDeviceConfig(recovery, DEVICE_RECOVERY_TYPE_NAME);
    }

    @Override
    public void setTargetPreparer(ITargetPreparer preparer) {
        this.notAllowedInMultiMode("setTargetPreparer");
        this.addToDefaultDeviceConfig(preparer, TARGET_PREPARER_TYPE_NAME);
    }

    @Override
    public void setTargetPreparers(List<ITargetPreparer> preparers) {
        this.notAllowedInMultiMode("setTargetPreparers");
        this.getDeviceConfigByName("DEFAULT_DEVICE").getTargetPreparers().clear();
        for (ITargetPreparer prep : preparers) {
            this.addToDefaultDeviceConfig(prep, TARGET_PREPARER_TYPE_NAME);
        }
    }

    @Override
    public void setLabPreparer(ITargetPreparer preparer) {
        this.notAllowedInMultiMode("setLabPreparer");
        this.addToDefaultDeviceConfig(preparer, LAB_PREPARER_TYPE_NAME);
    }

    @Override
    public void setLabPreparers(List<ITargetPreparer> preparers) {
        this.notAllowedInMultiMode("setLabPreparers");
        this.getDeviceConfigByName("DEFAULT_DEVICE").getLabPreparers().clear();
        for (ITargetPreparer prep : preparers) {
            this.addToDefaultDeviceConfig(prep, LAB_PREPARER_TYPE_NAME);
        }
    }

    @Override
    public void setCommandOptions(ICommandOptions cmdOptions) {
        this.setConfigurationObjectNoThrow(CMD_OPTIONS_TYPE_NAME, cmdOptions);
    }

    @Override
    public void setDeviceRequirements(IDeviceSelection devRequirements) {
        this.notAllowedInMultiMode("setDeviceRequirements");
        this.addToDefaultDeviceConfig(devRequirements, DEVICE_REQUIREMENTS_TYPE_NAME);
    }

    @Override
    public void setDeviceOptions(TestDeviceOptions devOptions) {
        this.notAllowedInMultiMode("setDeviceOptions");
        this.addToDefaultDeviceConfig(devOptions, DEVICE_OPTIONS_TYPE_NAME);
    }

    @Override
    public synchronized void setConfigurationObject(String typeName, Object configObject) throws ConfigurationException {
        if (configObject == null) {
            throw new IllegalArgumentException("configObject cannot be null");
        }
        this.mConfigMap.remove(typeName);
        this.addObject(typeName, configObject);
    }

    @Override
    public synchronized void setConfigurationObjectList(String typeName, List<?> configList) throws ConfigurationException {
        if (configList == null) {
            throw new IllegalArgumentException("configList cannot be null");
        }
        this.mConfigMap.remove(typeName);
        this.mConfigMap.put(typeName, new ArrayList(1));
        for (Object configObject : configList) {
            this.addObject(typeName, configObject);
        }
    }

    @Override
    public boolean isDeviceConfiguredFake(String deviceName) {
        IDeviceConfiguration deviceConfig = this.getDeviceConfigByName(deviceName);
        if (deviceConfig == null) {
            return false;
        }
        return deviceConfig.isFake();
    }

    private synchronized void addObject(String typeName, Object configObject) throws ConfigurationException {
        ObjTypeInfo typeInfo;
        List<Object> objList = this.mConfigMap.get(typeName);
        if (objList == null) {
            objList = new ArrayList<Object>(1);
            this.mConfigMap.put(typeName, objList);
        }
        if ((typeInfo = Configuration.getObjTypeMap().get(typeName)) != null && !typeInfo.mExpectedType.isInstance(configObject)) {
            throw new ConfigurationException(String.format("The config object %s is not the correct type. Expected %s, received %s", typeName, typeInfo.mExpectedType.getCanonicalName(), configObject.getClass().getCanonicalName()));
        }
        if (typeInfo != null && !typeInfo.mIsListSupported && objList.size() > 0) {
            throw new ConfigurationException(String.format("Only one config object allowed for %s, but multiple were specified.", typeName));
        }
        objList.add(configObject);
        if (configObject instanceof IConfigurationReceiver) {
            ((IConfigurationReceiver)configObject).setConfiguration(this);
        }
        if (configObject instanceof IDeviceConfiguration) {
            for (Object obj : ((IDeviceConfiguration)configObject).getAllObjects()) {
                if (!(obj instanceof IConfigurationReceiver)) continue;
                ((IConfigurationReceiver)obj).setConfiguration(this);
            }
        }
    }

    private void setConfigurationObjectNoThrow(String typeName, Object configObject) {
        try {
            this.setConfigurationObject(typeName, configObject);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setConfigurationObjectListNoThrow(String typeName, List<?> configList) {
        try {
            this.setConfigurationObjectList(typeName, configList);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public List<String> setOptionsFromCommandLineArgs(List<String> listArgs) throws ConfigurationException {
        return this.setOptionsFromCommandLineArgs(listArgs, null);
    }

    @Override
    public List<String> setOptionsFromCommandLineArgs(List<String> listArgs, IKeyStoreClient keyStoreClient) throws ConfigurationException {
        ArgsOptionParser parser = new ArgsOptionParser(this.getAllConfigurationObjects(CONFIGURATION_DESCRIPTION_TYPE_NAME, true));
        if (keyStoreClient != null) {
            parser.setKeyStore(keyStoreClient);
        }
        try {
            List<String> leftOver = parser.parse(listArgs);
            this.mInopOptions.addAll(parser.getInopOptions());
            return leftOver;
        }
        catch (ConfigurationException e) {
            Matcher m = CONFIG_EXCEPTION_PATTERN.matcher(e.getMessage());
            if (!m.matches()) {
                throw e;
            }
            String optionName = m.group(1);
            try {
                OptionSetter setter = new OptionSetter(this.getConfigurationDescription());
                setter.getTypeForOption(optionName);
            }
            catch (ConfigurationException stillThrowing) {
                throw e;
            }
            throw new OptionNotAllowedException(String.format("Option '%s' cannot be specified via command line. Only in the configuration xml.", optionName));
        }
    }

    @Override
    public List<String> setBestEffortOptionsFromCommandLineArgs(List<String> listArgs, IKeyStoreClient keyStoreClient) throws ConfigurationException {
        ArgsOptionParser parser = new ArgsOptionParser(this.getAllConfigurationObjects(CONFIGURATION_DESCRIPTION_TYPE_NAME, true));
        if (keyStoreClient != null) {
            parser.setKeyStore(keyStoreClient);
        }
        return parser.parseBestEffort(listArgs, true);
    }

    @Override
    public void printCommandUsage(boolean importantOnly, PrintStream out) throws ConfigurationException {
        out.println(String.format("'%s' configuration: %s", this.getName(), this.getDescription()));
        out.println();
        if (importantOnly) {
            out.println("Printing help for only the important options. To see help for all options, use the --help-all flag");
            out.println();
        }
        for (Map.Entry<String, List<Object>> configObjectsEntry : this.mConfigMap.entrySet()) {
            for (Object configObject : configObjectsEntry.getValue()) {
                if (configObject instanceof IDeviceConfiguration) {
                    for (Object subconfigObject : ((IDeviceConfiguration)configObject).getAllObjects()) {
                        this.printCommandUsageForObject(importantOnly, out, configObjectsEntry.getKey(), subconfigObject);
                    }
                    continue;
                }
                this.printCommandUsageForObject(importantOnly, out, configObjectsEntry.getKey(), configObject);
            }
        }
    }

    private void printCommandUsageForObject(boolean importantOnly, PrintStream out, String key, Object obj) throws ConfigurationException {
        String optionHelp = this.printOptionsForObject(importantOnly, key, obj);
        if (optionHelp.length() > 0) {
            String classAlias = "";
            if (obj.getClass().isAnnotationPresent(OptionClass.class)) {
                OptionClass classAnnotation = obj.getClass().getAnnotation(OptionClass.class);
                classAlias = String.format("'%s' ", classAnnotation.alias());
            }
            out.printf("  %s%s options:", classAlias, key);
            out.println();
            out.print(optionHelp);
            out.println();
        }
    }

    private String printOptionsForObject(boolean importantOnly, String objectTypeName, Object configObject) throws ConfigurationException {
        return ArgsOptionParser.getOptionHelp(importantOnly, configObject);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        ArgsOptionParser argsParser = new ArgsOptionParser(this.getAllNonDisabledConfigurationObjects());
        argsParser.validateMandatoryOptions();
        ICommandOptions options = this.getCommandOptions();
        if (options.getShardCount() != null && options.getShardCount() < 1) {
            throw new ConfigurationException("a shard count must be a positive number");
        }
        if (options.getShardIndex() != null && (options.getShardCount() == null || options.getShardIndex() < 0 || options.getShardIndex() >= options.getShardCount())) {
            throw new ConfigurationException("a shard index must be in range [0, shard count)");
        }
    }

    @Override
    public void resolveDynamicOptions(DynamicRemoteFileResolver resolver) throws ConfigurationException, BuildRetrievalError {
        ArrayList<Object> configObjects = new ArrayList<Object>(this.getAllNonDisabledConfigurationObjects());
        if (!this.isRemoteEnvironment()) {
            ICommandOptions options = this.getCommandOptions();
            if (this.getConfigurationObject("DELEGATE") != null) {
                configObjects.clear();
                configObjects.add(this.getConfigurationObject("DELEGATE"));
                LogUtil.CLog.d("Resolving only delegator object dynamic download.");
            } else if (options.getShardCount() != null && options.getShardCount() > 1 && options.getShardIndex() == null && !this.getCommandOptions().shouldUseSandboxing()) {
                LogUtil.CLog.w("Skipping dynamic download due to local sharding detected.");
                return;
            }
        }
        ArgsOptionParser argsParser = new ArgsOptionParser(configObjects);
        LogUtil.CLog.d("Resolve and download remote files from @Option");
        this.mRemoteFiles.addAll(argsParser.validateRemoteFilePath(resolver));
    }

    @VisibleForTesting
    protected boolean isRemoteEnvironment() {
        return SystemUtil.isRemoteEnvironment();
    }

    @Override
    public void cleanConfigurationData() {
        for (File file2 : this.mRemoteFiles) {
            FileUtil.recursiveDelete(file2);
        }
        this.mRemoteFiles.clear();
    }

    @Override
    public void addFilesToClean(Set<File> toBeCleaned) {
        this.mRemoteFiles.addAll(toBeCleaned);
    }

    @Override
    public Set<File> getFilesToClean() {
        return this.mRemoteFiles;
    }

    @Override
    public Set<String> getInopOptions() {
        return this.mInopOptions;
    }

    @Override
    public void dumpXml(PrintWriter output) throws IOException {
        this.dumpXml(output, new ArrayList<String>());
    }

    @Override
    public void dumpXml(PrintWriter output, List<String> excludeFilters) throws IOException {
        this.dumpXml(output, excludeFilters, true, true);
    }

    @Override
    public void dumpXml(PrintWriter output, List<String> excludeFilters, boolean printDeprecatedOptions, boolean printUnchangedOptions) throws IOException {
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(output);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startDocument("UTF-8", null);
        serializer.startTag(null, "configuration");
        for (IMultiTargetPreparer multiPreTargerPrep : this.getMultiPreTargetPreparers()) {
            ConfigurationUtil.dumpClassToXml(serializer, MULTI_PRE_TARGET_PREPARER_TYPE_NAME, multiPreTargerPrep, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        for (IMultiTargetPreparer multipreparer : this.getMultiTargetPreparers()) {
            ConfigurationUtil.dumpClassToXml(serializer, MULTI_PREPARER_TYPE_NAME, multipreparer, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        if (this.getDeviceConfig().size() > 1) {
            for (IDeviceConfiguration deviceConfig : this.getDeviceConfig()) {
                serializer.startTag(null, DEVICE_NAME);
                serializer.attribute(null, "name", deviceConfig.getDeviceName());
                if (deviceConfig.isFake()) {
                    serializer.attribute(null, "isFake", "true");
                }
                ConfigurationUtil.dumpClassToXml(serializer, BUILD_PROVIDER_TYPE_NAME, deviceConfig.getBuildProvider(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
                for (ITargetPreparer preparer : deviceConfig.getTargetPreparers()) {
                    ConfigurationUtil.dumpClassToXml(serializer, TARGET_PREPARER_TYPE_NAME, preparer, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
                }
                for (ITargetPreparer preparer : deviceConfig.getLabPreparers()) {
                    ConfigurationUtil.dumpClassToXml(serializer, LAB_PREPARER_TYPE_NAME, preparer, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
                }
                ConfigurationUtil.dumpClassToXml(serializer, DEVICE_RECOVERY_TYPE_NAME, deviceConfig.getDeviceRecovery(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
                ConfigurationUtil.dumpClassToXml(serializer, DEVICE_REQUIREMENTS_TYPE_NAME, deviceConfig.getDeviceRequirements(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
                ConfigurationUtil.dumpClassToXml(serializer, DEVICE_OPTIONS_TYPE_NAME, deviceConfig.getDeviceOptions(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
                serializer.endTag(null, DEVICE_NAME);
            }
        } else {
            ConfigurationUtil.dumpClassToXml(serializer, BUILD_PROVIDER_TYPE_NAME, this.getBuildProvider(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
            for (ITargetPreparer preparer : this.getLabPreparers()) {
                ConfigurationUtil.dumpClassToXml(serializer, LAB_PREPARER_TYPE_NAME, preparer, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
            }
            for (ITargetPreparer preparer : this.getTargetPreparers()) {
                ConfigurationUtil.dumpClassToXml(serializer, TARGET_PREPARER_TYPE_NAME, preparer, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
            }
            ConfigurationUtil.dumpClassToXml(serializer, DEVICE_RECOVERY_TYPE_NAME, this.getDeviceRecovery(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
            ConfigurationUtil.dumpClassToXml(serializer, DEVICE_REQUIREMENTS_TYPE_NAME, this.getDeviceRequirements(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
            ConfigurationUtil.dumpClassToXml(serializer, DEVICE_OPTIONS_TYPE_NAME, this.getDeviceOptions(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        for (IRemoteTest test : this.getTests()) {
            ConfigurationUtil.dumpClassToXml(serializer, TEST_TYPE_NAME, test, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        ConfigurationUtil.dumpClassToXml(serializer, CONFIGURATION_DESCRIPTION_TYPE_NAME, this.getConfigurationDescription(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        ConfigurationUtil.dumpClassToXml(serializer, LOGGER_TYPE_NAME, this.getLogOutput(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        ConfigurationUtil.dumpClassToXml(serializer, LOG_SAVER_TYPE_NAME, this.getLogSaver(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        for (ITestInvocationListener listener : this.getTestInvocationListeners()) {
            ConfigurationUtil.dumpClassToXml(serializer, RESULT_REPORTER_TYPE_NAME, listener, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        ConfigurationUtil.dumpClassToXml(serializer, CMD_OPTIONS_TYPE_NAME, this.getCommandOptions(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        for (IMetricCollector collector : this.getMetricCollectors()) {
            ConfigurationUtil.dumpClassToXml(serializer, DEVICE_METRICS_COLLECTOR_TYPE_NAME, collector, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        for (IPostProcessor processor : this.getPostProcessors()) {
            ConfigurationUtil.dumpClassToXml(serializer, METRIC_POST_PROCESSOR_TYPE_NAME, processor, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        for (ISystemStatusChecker checker : this.getSystemStatusCheckers()) {
            ConfigurationUtil.dumpClassToXml(serializer, SYSTEM_STATUS_CHECKER_TYPE_NAME, checker, excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        }
        ConfigurationUtil.dumpClassToXml(serializer, SANBOX_OPTIONS_TYPE_NAME, this.getConfigurationObject(SANBOX_OPTIONS_TYPE_NAME), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        ConfigurationUtil.dumpClassToXml(serializer, RETRY_DECISION_TYPE_NAME, this.getRetryDecision(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        ConfigurationUtil.dumpClassToXml(serializer, COVERAGE_OPTIONS_TYPE_NAME, this.getCoverageOptions(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        ConfigurationUtil.dumpClassToXml(serializer, GLOBAL_FILTERS_TYPE_NAME, this.getGlobalFilters(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        ConfigurationUtil.dumpClassToXml(serializer, SKIP_MANAGER_TYPE_NAME, this.getSkipManager(), excludeFilters, printDeprecatedOptions, printUnchangedOptions);
        serializer.endTag(null, "configuration");
        serializer.endDocument();
    }

    private static class ObjTypeInfo {
        final Class<?> mExpectedType;
        final boolean mIsListSupported;

        ObjTypeInfo(Class<?> expectedType, boolean isList) {
            this.mExpectedType = expectedType;
            this.mIsListSupported = isList;
        }
    }
}

