/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ClassNotFoundConfigurationException;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DeviceConfigurationHolder;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.config.OptionDef;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.ITargetPreparer;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigurationDef {
    private final Map<String, List<ConfigObjectDef>> mObjectClassMap = new LinkedHashMap<String, List<ConfigObjectDef>>();
    private final List<OptionDef> mOptionList = new ArrayList<OptionDef>();
    private final Map<String, Integer> mClassFrequency = new HashMap<String, Integer>();
    private final Map<File, Long> mSourceFiles = new HashMap<File, Long>();
    private boolean mMultiDeviceMode = false;
    private boolean mFilteredObjects = false;
    private Map<String, Boolean> mExpectedDevices = new LinkedHashMap<String, Boolean>();
    private static final Pattern MULTI_PATTERN = Pattern.compile("(.*):(.*)");
    public static final String DEFAULT_DEVICE_NAME = "DEFAULT_DEVICE";
    private final String mName;
    private String mDescription = "";

    public ConfigurationDef(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public int addConfigObjectDef(String typeName, String className) {
        Integer freq;
        List<ConfigObjectDef> classList = this.mObjectClassMap.get(typeName);
        if (classList == null) {
            classList = new ArrayList<ConfigObjectDef>();
            this.mObjectClassMap.put(typeName, classList);
        }
        freq = (freq = this.mClassFrequency.get(className)) == null ? 1 : freq + 1;
        this.mClassFrequency.put(className, freq);
        classList.add(new ConfigObjectDef(className, freq));
        return freq;
    }

    public void addOptionDef(String optionName, String optionKey, String optionValue, String optionSource, String type) {
        this.mOptionList.add(new OptionDef(optionName, optionKey, optionValue, optionSource, type));
    }

    void addOptionDef(String optionName, String optionKey, String optionValue, String optionSource) {
        this.mOptionList.add(new OptionDef(optionName, optionKey, optionValue, optionSource, null));
    }

    void registerSource(File source) {
        this.mSourceFiles.put(source, source.lastModified());
    }

    boolean isStale() {
        for (Map.Entry<File, Long> entry : this.mSourceFiles.entrySet()) {
            if (entry.getKey().lastModified() <= entry.getValue()) continue;
            return true;
        }
        return false;
    }

    Map<String, List<ConfigObjectDef>> getObjectClassMap() {
        return this.mObjectClassMap;
    }

    List<OptionDef> getOptionList() {
        return this.mOptionList;
    }

    public IConfiguration createConfiguration() throws ConfigurationException {
        return this.createConfiguration(null);
    }

    public IConfiguration createConfiguration(Set<String> allowedObjects) throws ConfigurationException {
        this.mFilteredObjects = false;
        Configuration config = new Configuration(this.getName(), this.getDescription());
        ArrayList<IDeviceConfiguration> deviceObjectList = new ArrayList<IDeviceConfiguration>();
        DeviceConfigurationHolder defaultDeviceConfig = new DeviceConfigurationHolder(DEFAULT_DEVICE_NAME);
        boolean hybridMultiDeviceHandling = false;
        if (!this.mMultiDeviceMode) {
            deviceObjectList.add(defaultDeviceConfig);
        } else {
            Long numDut = this.mExpectedDevices.values().stream().filter(value -> value == false).collect(Collectors.counting());
            Long numNonDut = this.mExpectedDevices.values().stream().filter(value -> value == true).collect(Collectors.counting());
            if (numDut == 0L && numNonDut == 0L) {
                throw new ConfigurationException("No device detected. Should not happen.");
            }
            if (numNonDut > 0L && numDut == 0L) {
                Iterator<String> copy = new LinkedHashMap();
                copy.put(DEFAULT_DEVICE_NAME, false);
                copy.putAll(this.mExpectedDevices);
                this.mExpectedDevices = copy;
                Long l = numDut;
                numDut = numDut + 1L;
            }
            if (numNonDut > 0L && numDut == 1L) {
                LogUtil.CLog.d("One device is under tests while config '%s' requires some fake=true devices. Using hybrid parsing of config.", this.getName());
                hybridMultiDeviceHandling = true;
            }
            for (String name : this.mExpectedDevices.keySet()) {
                deviceObjectList.add(new DeviceConfigurationHolder(name, this.mExpectedDevices.get(name)));
            }
        }
        HashMap<String, String> rejectedObjects = new HashMap<String, String>();
        Throwable cause = null;
        for (Map.Entry<String, List<ConfigObjectDef>> objClassEntry : this.mObjectClassMap.entrySet()) {
            ArrayList<Object> objectList = new ArrayList<Object>(objClassEntry.getValue().size());
            String entryName = objClassEntry.getKey();
            boolean shouldAddToFlatConfig = true;
            for (ConfigObjectDef configDef : objClassEntry.getValue()) {
                if (allowedObjects != null && !allowedObjects.contains(objClassEntry.getKey())) {
                    LogUtil.CLog.d("Skipping creation of %s", objClassEntry.getKey());
                    this.mFilteredObjects = true;
                    continue;
                }
                Object configObject = null;
                try {
                    configObject = this.createObject(objClassEntry.getKey(), configDef.mClassName);
                }
                catch (ClassNotFoundConfigurationException e) {
                    cause = e.getCause();
                    rejectedObjects.putAll(e.getRejectedObjects());
                    LogUtil.CLog.e(e);
                    shouldAddToFlatConfig = false;
                    continue;
                }
                Matcher matcher = null;
                if (this.mMultiDeviceMode) {
                    matcher = MULTI_PATTERN.matcher(entryName);
                }
                if (this.mMultiDeviceMode && matcher.find()) {
                    IDeviceConfiguration multiDev = null;
                    shouldAddToFlatConfig = false;
                    for (IDeviceConfiguration iDevConfig : deviceObjectList) {
                        if (!matcher.group(1).equals(iDevConfig.getDeviceName())) continue;
                        multiDev = iDevConfig;
                        break;
                    }
                    if (multiDev == null) {
                        multiDev = new DeviceConfigurationHolder(matcher.group(1));
                        deviceObjectList.add(multiDev);
                    }
                    multiDev.addSpecificConfig(configObject, matcher.group(2));
                    multiDev.addFrequency(configObject, configDef.mAppearanceNum);
                    continue;
                }
                if (Configuration.doesBuiltInObjSupportMultiDevice(entryName)) {
                    if (hybridMultiDeviceHandling) {
                        List realDevice = deviceObjectList.stream().filter(object -> !object.isFake()).collect(Collectors.toList());
                        if (realDevice.size() != 1) {
                            throw new ConfigurationException(String.format("Something went very bad, we found '%s' Dut device while expecting one only.", realDevice.size()));
                        }
                        ((IDeviceConfiguration)realDevice.get(0)).addSpecificConfig(configObject, entryName);
                        ((IDeviceConfiguration)realDevice.get(0)).addFrequency(configObject, configDef.mAppearanceNum);
                        continue;
                    }
                    defaultDeviceConfig.addSpecificConfig(configObject, entryName);
                    defaultDeviceConfig.addFrequency(configObject, configDef.mAppearanceNum);
                    continue;
                }
                objectList.add(configObject);
            }
            if (!shouldAddToFlatConfig) continue;
            config.setConfigurationObjectList(entryName, objectList);
        }
        this.checkRejectedObjects(rejectedObjects, cause);
        config.setConfigurationObjectList("device", deviceObjectList);
        this.injectOptions(config, this.mOptionList);
        ArrayList<ITargetPreparer> notILab = new ArrayList<ITargetPreparer>();
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            for (ITargetPreparer labPreparer : deviceConfig.getLabPreparers()) {
                if (labPreparer instanceof ILabPreparer) continue;
                notILab.add(labPreparer);
            }
        }
        if (!notILab.isEmpty()) {
            throw new ConfigurationException(String.format("The following were specified as lab_preparer but aren't ILabPreparer: %s", notILab), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        return config;
    }

    protected void checkRejectedObjects(Map<String, String> rejectedObjects, Throwable cause) throws ClassNotFoundConfigurationException {
        if (!rejectedObjects.isEmpty()) {
            throw new ClassNotFoundConfigurationException(String.format("Failed to load some objects in the configuration '%s': %s", this.getName(), rejectedObjects), cause, InfraErrorIdentifier.CLASS_NOT_FOUND, rejectedObjects);
        }
    }

    protected void injectOptions(IConfiguration config, List<OptionDef> optionList) throws ConfigurationException {
        if (this.mFilteredObjects) {
            config.safeInjectOptionValues(optionList);
        } else {
            config.injectOptionValues(optionList);
        }
    }

    IGlobalConfiguration createGlobalConfiguration() throws ConfigurationException {
        GlobalConfiguration config = new GlobalConfiguration(this.getName(), this.getDescription());
        for (Map.Entry<String, List<ConfigObjectDef>> objClassEntry : this.mObjectClassMap.entrySet()) {
            ArrayList<Object> objectList = new ArrayList<Object>(objClassEntry.getValue().size());
            for (ConfigObjectDef configDef : objClassEntry.getValue()) {
                Object configObject = this.createObject(objClassEntry.getKey(), configDef.mClassName);
                objectList.add(configObject);
            }
            config.setConfigurationObjectList(objClassEntry.getKey(), objectList);
        }
        for (OptionDef optionEntry : this.mOptionList) {
            config.injectOptionValue(optionEntry.name, optionEntry.key, optionEntry.value);
        }
        return config;
    }

    public String getName() {
        return this.mName;
    }

    public void setMultiDeviceMode(boolean multiDeviceMode) {
        this.mMultiDeviceMode = multiDeviceMode;
    }

    public boolean isMultiDeviceMode() {
        return this.mMultiDeviceMode;
    }

    public String addExpectedDevice(String deviceName, boolean isFake) {
        Boolean previous = this.mExpectedDevices.put(deviceName, isFake);
        if (previous != null && previous != isFake) {
            return String.format("Mismatch for device '%s'. It was defined once as isFake=false, once as isFake=true", deviceName);
        }
        return null;
    }

    public Map<String, Boolean> getExpectedDevices() {
        return this.mExpectedDevices;
    }

    private Object createObject(String objectTypeName, String className) throws ConfigurationException {
        try {
            Class<?> objectClass = this.getClassForObject(objectTypeName, className);
            Object configObject = objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.checkObjectValid(objectTypeName, className, configObject);
            return configObject;
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(String.format("Could not instantiate class %s for config object type %s", className, objectTypeName), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Could not access class %s for config object type %s", className, objectTypeName), e);
        }
    }

    private Class<?> getClassForObject(String objectTypeName, String className) throws ClassNotFoundConfigurationException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundConfigurationException exception = new ClassNotFoundConfigurationException(String.format("Could not find class %s for config object type %s", className, objectTypeName), e, InfraErrorIdentifier.CLASS_NOT_FOUND, className, objectTypeName);
            throw exception;
        }
    }

    private void checkObjectValid(String objectTypeName, String className, Object configObject) throws ConfigurationException {
        if (configObject == null) {
            throw new ConfigurationException(String.format("Class %s for type %s didn't instantiate properly", className, objectTypeName), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if ("result_reporter".equals(objectTypeName) && configObject instanceof IMetricCollector) {
            throw new ConfigurationException(String.format("Object of type %s was declared as %s.", "metrics_collector", "result_reporter"), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
    }

    public static class ConfigObjectDef {
        final String mClassName;
        final Integer mAppearanceNum;

        ConfigObjectDef(String className, Integer appearance) {
            this.mClassName = className;
            this.mAppearanceNum = appearance;
        }
    }
}

