/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionDef;
import com.android.tradefed.config.proto.ConfigurationDescription;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.util.MultiMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="config-descriptor")
public class ConfigurationDescriptor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String LOCAL_SHARDED_KEY = "sharded";
    public static final String ACTIVE_PARAMETER_KEY = "active-parameter";
    @Option(name="test-suite-tag", description="A membership tag to suite. Can be repeated.")
    private List<String> mSuiteTags = new ArrayList<String>();
    @Option(name="metadata", description="Metadata associated with this configuration, can be free formed key value pairs, and a key may be associated with multiple values.")
    private MultiMap<String, String> mMetaData = new MultiMap();
    @Option(name="not-shardable", description="A metadata that allows a suite configuration to specify that it cannot be sharded. Not because it doesn't support it but because it doesn't make sense.")
    private boolean mNotShardable = false;
    @Option(name="not-strict-shardable", description="A metadata to allows a suite configuration to specify that it cannot be sharded in a strict context (independent shards). If a config is already not-shardable, it will be not-strict-shardable.")
    private boolean mNotStrictShardable = false;
    @Option(name="not-iremotetest-shardable", description="A metadata to allows a suite configuration to specify that it cannot be sharded in a strict context (independent shards). If a config is already not-shardable, it will be not-strict-shardable.")
    private boolean mNotIRemoteTestShardable = false;
    @Option(name="use-sandboxing", description="Option used to notify an invocation that it is running in a sandbox.")
    private boolean mUseSandboxing = false;
    private IAbi mAbi = null;
    private String mModuleName = null;
    private Integer mShardIndex = null;
    private final List<OptionDef> mRerunOptions = new ArrayList<OptionDef>();

    public List<String> getSuiteTags() {
        return this.mSuiteTags;
    }

    public void setSuiteTags(List<String> suiteTags) {
        this.mSuiteTags = suiteTags;
    }

    public MultiMap<String, String> getAllMetaData() {
        MultiMap<String, String> copy = new MultiMap<String, String>();
        copy.putAll(this.mMetaData);
        return copy;
    }

    public List<String> getMetaData(String name) {
        List<String> entry = this.mMetaData.get(name);
        if (entry == null) {
            return null;
        }
        return new ArrayList<String>(entry);
    }

    @VisibleForTesting
    public void setMetaData(MultiMap<String, String> metadata) {
        this.mMetaData = metadata;
    }

    public void addMetadata(String key, String value) {
        this.mMetaData.put(key, value);
    }

    public void addMetadata(String key, List<String> values2) {
        for (String source : values2) {
            this.mMetaData.put(key, source);
        }
    }

    public List<String> removeMetadata(String key) {
        return this.mMetaData.remove(key);
    }

    public boolean isNotShardable() {
        return this.mNotShardable;
    }

    public boolean isNotStrictShardable() {
        return this.mNotStrictShardable;
    }

    public boolean isNotIRemoteTestShardable() {
        return this.mNotIRemoteTestShardable;
    }

    public void setNotIRemoteTestShardable(boolean notIRemoteTestShardable) {
        this.mNotIRemoteTestShardable = notIRemoteTestShardable;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setModuleName(String name) {
        this.mModuleName = name;
    }

    public String getModuleName() {
        return this.mModuleName;
    }

    public boolean shouldUseSandbox() {
        return this.mUseSandboxing;
    }

    public void setSandboxed(boolean useSandboxed) {
        this.mUseSandboxing = useSandboxed;
    }

    public void setShardIndex(int index) {
        this.mShardIndex = index;
    }

    public Integer getShardIndex() {
        return this.mShardIndex;
    }

    public void addRerunOption(OptionDef optionDef) {
        this.mRerunOptions.add(optionDef);
    }

    public List<OptionDef> getRerunOptions() {
        return this.mRerunOptions;
    }

    public ConfigurationDescription.Descriptor toProto() {
        ConfigurationDescription.Descriptor.Builder descriptorBuilder = ConfigurationDescription.Descriptor.newBuilder();
        descriptorBuilder.addAllTestSuiteTag(this.mSuiteTags);
        ArrayList<ConfigurationDescription.Metadata> metadatas = new ArrayList<ConfigurationDescription.Metadata>();
        for (String key : this.mMetaData.keySet()) {
            ConfigurationDescription.Metadata value = ConfigurationDescription.Metadata.newBuilder().setKey(key).addAllValue(this.mMetaData.get(key)).build();
            metadatas.add(value);
        }
        descriptorBuilder.addAllMetadata(metadatas);
        descriptorBuilder.setShardable(!this.mNotShardable);
        descriptorBuilder.setStrictShardable(!this.mNotStrictShardable);
        descriptorBuilder.setUseSandboxing(this.mUseSandboxing);
        if (this.mModuleName != null) {
            descriptorBuilder.setModuleName(this.mModuleName);
        }
        if (this.mAbi != null) {
            descriptorBuilder.setAbi(this.mAbi.toProto());
        }
        return descriptorBuilder.build();
    }

    public static ConfigurationDescriptor fromProto(ConfigurationDescription.Descriptor protoDescriptor) {
        ConfigurationDescriptor configDescriptor = new ConfigurationDescriptor();
        configDescriptor.mSuiteTags.addAll(protoDescriptor.getTestSuiteTagList());
        for (ConfigurationDescription.Metadata meta : protoDescriptor.getMetadataList()) {
            for (String value : meta.getValueList()) {
                configDescriptor.mMetaData.put(meta.getKey(), value);
            }
        }
        configDescriptor.mNotShardable = !protoDescriptor.getShardable();
        configDescriptor.mNotStrictShardable = !protoDescriptor.getStrictShardable();
        configDescriptor.mUseSandboxing = protoDescriptor.getUseSandboxing();
        if (!protoDescriptor.getModuleName().isEmpty()) {
            configDescriptor.mModuleName = protoDescriptor.getModuleName();
        }
        if (protoDescriptor.hasAbi()) {
            configDescriptor.mAbi = Abi.fromProto(protoDescriptor.getAbi());
        }
        return configDescriptor;
    }

    public ConfigurationDescriptor clone() {
        return ConfigurationDescriptor.fromProto(this.toProto());
    }

    public static enum LocalTestRunner {
        NONE,
        ATEST;

    }
}

