/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationUtil;
import com.android.tradefed.config.ConfigurationXmlParser;
import com.android.tradefed.config.ConfigurationXmlParserSettings;
import com.android.tradefed.config.IConfigDefLoader;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.config.RemoteFileResolver;
import com.android.tradefed.config.TemplateResolutionError;
import com.android.tradefed.config.proxy.TradefedDelegator;
import com.android.tradefed.config.remote.ExtendedFile;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.config.yaml.ConfigurationYamlParser;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.ClassPathScanner;
import com.android.tradefed.util.DirectedGraph;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.keystore.DryRunKeyStore;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ConfigurationFactory
implements IConfigurationFactory {
    private static final Set<String> SUPPORTED_EXTENSIONS = ImmutableSortedSet.of(".xml", ".config");
    private static IConfigurationFactory sInstance = null;
    private static final String CONFIG_PREFIX = "config/";
    private static final String DRY_RUN_TEMPLATE_CONFIG = "empty";
    private static final String CONFIG_ERROR_PATTERN = "(Could not find option with name )(.*)";
    private static final String DIRECT_CONFIG_PATTERN = "^(gs|file|http|https)://.*";
    private Map<ConfigId, ConfigurationDef> mConfigDefMap = new Hashtable<ConfigId, ConfigurationDef>();

    @VisibleForTesting
    List<File> getExternalTestCasesDirs() {
        return SystemUtil.getExternalTestCasesDirs();
    }

    @VisibleForTesting
    File getTestCaseConfigPath(String name) {
        String[] possibleConfigFileNames = new String[]{name};
        if (Strings.isNullOrEmpty(FileUtil.getExtension(name))) {
            possibleConfigFileNames = new String[SUPPORTED_EXTENSIONS.size()];
            int i = 0;
            for (String supportedExtension : SUPPORTED_EXTENSIONS) {
                possibleConfigFileNames[i] = name + supportedExtension;
                ++i;
            }
        }
        for (File testCasesDir : this.getExternalTestCasesDirs()) {
            for (String configFileName : possibleConfigFileNames) {
                File config = FileUtil.findFile(testCasesDir, configFileName);
                if (config == null) continue;
                LogUtil.CLog.d("Using config: %s/%s", testCasesDir.getAbsoluteFile(), configFileName);
                return config;
            }
        }
        return null;
    }

    protected ConfigurationFactory() {
    }

    public static IConfigurationFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ConfigurationFactory();
        }
        return sInstance;
    }

    protected ConfigurationDef getConfigurationDef(String name, boolean isGlobal, Map<String, String> templateMap) throws ConfigurationException {
        return new ConfigLoader(isGlobal).getConfigurationDef(name, templateMap);
    }

    @Override
    public IConfiguration createConfigurationFromArgs(String[] arrayArgs) throws ConfigurationException {
        return this.createConfigurationFromArgs(arrayArgs, null);
    }

    @Override
    public IConfiguration createConfigurationFromArgs(String[] arrayArgs, List<String> unconsumedArgs) throws ConfigurationException {
        return this.createConfigurationFromArgs(arrayArgs, unconsumedArgs, null);
    }

    @Override
    public IConfiguration createConfigurationFromArgs(String[] arrayArgs, List<String> unconsumedArgs, IKeyStoreClient keyStoreClient) throws ConfigurationException {
        if (arrayArgs.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified");
        }
        ArrayList<String> listArgs = new ArrayList<String>(arrayArgs.length);
        String[] reorderedArrayArgs = this.reorderArgs(arrayArgs);
        IConfiguration config = this.internalCreateConfigurationFromArgs(reorderedArrayArgs, listArgs, keyStoreClient, null);
        config.setCommandLine(arrayArgs);
        if (listArgs.contains("--dry-run") || listArgs.contains("--noisy-dry-run")) {
            LogUtil.CLog.w("dry-run detected, we are using a dryrun keystore");
            keyStoreClient = new DryRunKeyStore();
        }
        List<String> tmpUnconsumedArgs = config.setOptionsFromCommandLineArgs(listArgs, keyStoreClient);
        if (unconsumedArgs == null && tmpUnconsumedArgs.size() > 0) {
            throw new ConfigurationException(String.format("Invalid arguments provided. Unprocessed arguments: %s", tmpUnconsumedArgs), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (unconsumedArgs != null) {
            unconsumedArgs.addAll(tmpUnconsumedArgs);
        }
        return config;
    }

    @Override
    public IConfiguration createPartialConfigurationFromArgs(String[] arrayArgs, IKeyStoreClient keyStoreClient, Set<String> allowedObjects, TradefedDelegator delegator) throws ConfigurationException {
        if (arrayArgs.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified", (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        ArrayList<String> listArgs = new ArrayList<String>(arrayArgs.length);
        String[] reorderedArrayArgs = this.reorderArgs(arrayArgs);
        IConfiguration config = this.internalCreateConfigurationFromArgs(reorderedArrayArgs, listArgs, keyStoreClient, allowedObjects);
        if (delegator != null) {
            config.setConfigurationObject("DELEGATE", delegator);
        }
        config.setCommandLine(arrayArgs);
        List<String> leftOver = config.setBestEffortOptionsFromCommandLineArgs(listArgs, keyStoreClient);
        LogUtil.CLog.d("Non-applied arguments: %s", leftOver);
        return config;
    }

    @VisibleForTesting
    protected boolean isDirectConfiguration(String configName) {
        return Pattern.matches(DIRECT_CONFIG_PATTERN, configName);
    }

    private IConfiguration internalCreateConfigurationFromArgs(String[] arrayArgs, List<String> optionArgsRef, IKeyStoreClient keyStoreClient, Set<String> allowedObjects) throws ConfigurationException {
        ArrayList<String> listArgs = new ArrayList<String>(Arrays.asList(arrayArgs));
        String configName = (String)listArgs.remove(0);
        if (this.isDirectConfiguration(configName)) {
            return this.internalCreateDirectConfiguration(configName, listArgs, optionArgsRef, keyStoreClient, allowedObjects);
        }
        Map<String, String> uniqueMap = this.extractTemplates(configName, listArgs, optionArgsRef, keyStoreClient);
        if (allowedObjects != null && !allowedObjects.isEmpty()) {
            ConfigLoader tmpLoader = new ConfigLoader(false);
            for (String key : uniqueMap.keySet()) {
                try {
                    tmpLoader.findConfigName(uniqueMap.get(key), null);
                }
                catch (ConfigurationException e) {
                    uniqueMap.put(key, DRY_RUN_TEMPLATE_CONFIG);
                }
            }
        }
        ConfigurationDef configDef = this.getConfigurationDef(configName, false, uniqueMap);
        if (!uniqueMap.isEmpty()) {
            for (ConfigId cid : this.mConfigDefMap.keySet()) {
                if (this.mConfigDefMap.get(cid) != configDef) continue;
                LogUtil.CLog.d("Cleaning the cache for this configdef");
                this.mConfigDefMap.remove(cid);
                break;
            }
            throw new ConfigurationException(String.format("Unused template:map parameters: %s", uniqueMap.toString()), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        return configDef.createConfiguration(allowedObjects);
    }

    private Map<String, String> extractTemplates(String configName, List<String> listArgs, List<String> optionArgsRef, IKeyStoreClient keyStoreClient) throws ConfigurationException {
        String extension;
        switch (extension = FileUtil.getExtension(configName)) {
            case ".xml": 
            case ".config": 
            case "": {
                ConfigurationXmlParserSettings parserSettings = new ConfigurationXmlParserSettings();
                ArgsOptionParser templateArgParser = new ArgsOptionParser(parserSettings);
                if (keyStoreClient != null) {
                    templateArgParser.setKeyStore(keyStoreClient);
                }
                optionArgsRef.addAll(templateArgParser.parseBestEffort(listArgs));
                for (String key : parserSettings.templateMap.keySet()) {
                    if (parserSettings.templateMap.get(key).size() <= 1) continue;
                    throw new ConfigurationException(String.format("More than one template specified for key '%s'", key), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
                return parserSettings.templateMap.getUniqueMap();
            }
            case ".tf_yaml": {
                ArgsOptionParser allArgsParser = new ArgsOptionParser(new Object[0]);
                if (keyStoreClient != null) {
                    allArgsParser.setKeyStore(keyStoreClient);
                }
                optionArgsRef.addAll(allArgsParser.parseBestEffort(listArgs));
                return new HashMap<String, String>();
            }
        }
        return new HashMap<String, String>();
    }

    @VisibleForTesting
    private IConfiguration internalCreateDirectConfiguration(String configName, List<String> listArgs, List<String> optionArgsRef, IKeyStoreClient keyStoreClient, Set<String> allowedObjects) throws ConfigurationException {
        IConfiguration iConfiguration;
        URI configURI = new URI(configName);
        String name = Arrays.stream(configURI.getPath().split("/")).reduce((first, second) -> second).orElseThrow();
        LogUtil.CLog.i("Determined the config name was %s", name);
        File destDir = FileUtil.createTempDir("tf-configs");
        IRemoteFileResolver.ResolvedFile resolvedConfigFile = this.resolveRemoteFile(configURI, destDir.toURI());
        File configFile = resolvedConfigFile.getResolvedFile();
        if (configFile instanceof ExtendedFile) {
            ((ExtendedFile)configFile).waitForDownload();
        }
        LogUtil.CLog.i("Attempting to read from file: %s", configFile.getPath());
        BufferedInputStream configInputStream = new BufferedInputStream(new FileInputStream(configFile));
        try {
            ConfigurationDef configDef = new ConfigurationDef(configName);
            switch (FileUtil.getExtension(configFile.getPath())) {
                case ".xml": 
                case ".config": 
                case "": {
                    ExceptionLoader exceptionLoader = new ExceptionLoader(false);
                    ConfigurationXmlParser parser = new ConfigurationXmlParser(exceptionLoader, null);
                    parser.parse(configDef, configName, configInputStream, new HashMap<String, String>(), new HashSet<String>());
                    break;
                }
                case ".tf_yaml": {
                    ConfigurationYamlParser yamlParser = new ConfigurationYamlParser();
                    yamlParser.parse(configDef, configName, configInputStream, false);
                    break;
                }
                default: {
                    throw new ConfigurationException(String.format("The config format for %s is not supported.", configName), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
            }
            if (resolvedConfigFile.shouldCleanUp()) {
                FileUtil.deleteFile(configFile);
            }
            FileUtil.recursiveDelete(destDir);
            ConfigurationXmlParserSettings parserSettings = new ConfigurationXmlParserSettings();
            ArgsOptionParser cmdArgParser = new ArgsOptionParser(parserSettings);
            if (keyStoreClient != null) {
                cmdArgParser.setKeyStore(keyStoreClient);
            }
            optionArgsRef.addAll(cmdArgParser.parseBestEffort(listArgs));
            iConfiguration = configDef.createConfiguration(allowedObjects);
        }
        catch (Throwable throwable) {
            try {
                try {
                    configInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(e.toString(), e);
            }
            catch (BuildRetrievalError e) {
                throw new ConfigurationException(e.toString(), e);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException(String.format("Invalid URI specified: %s", configName), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temp dir for config", e);
            }
        }
        configInputStream.close();
        return iConfiguration;
    }

    @VisibleForTesting
    protected IRemoteFileResolver.ResolvedFile resolveRemoteFile(URI configURI, URI destDir) throws BuildRetrievalError {
        return RemoteFileResolver.resolveRemoteFile(configURI, destDir);
    }

    @Override
    public IGlobalConfiguration createGlobalConfigurationFromArgs(String[] arrayArgs, List<String> remainingArgs) throws ConfigurationException {
        ArrayList<String> listArgs = new ArrayList<String>(arrayArgs.length);
        IGlobalConfiguration config = this.internalCreateGlobalConfigurationFromArgs(arrayArgs, listArgs);
        remainingArgs.addAll(config.setOptionsFromCommandLineArgs(listArgs));
        return config;
    }

    private IGlobalConfiguration internalCreateGlobalConfigurationFromArgs(String[] arrayArgs, List<String> optionArgsRef) throws ConfigurationException {
        if (arrayArgs.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified");
        }
        optionArgsRef.addAll(Arrays.asList(arrayArgs));
        String configName = optionArgsRef.remove(0);
        ConfigurationDef configDef = this.getConfigurationDef(configName, true, null);
        IGlobalConfiguration config = configDef.createGlobalConfiguration();
        config.setOriginalConfig(configName);
        config.setConfigurationFactory(this);
        return config;
    }

    @Override
    public void printHelp(PrintStream out) {
        try {
            this.loadAllConfigs(true);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        TreeSet<ConfigurationDef> configDefs = new TreeSet<ConfigurationDef>(new ConfigDefComparator());
        configDefs.addAll(this.mConfigDefMap.values());
        StringBuilder sb = new StringBuilder();
        for (ConfigurationDef def : configDefs) {
            sb.append(String.format("  %s: %s\n", def.getName(), def.getDescription()));
        }
        out.printf(sb.toString(), new Object[0]);
    }

    @Override
    public List<String> getConfigList() {
        return this.getConfigList(null, true);
    }

    @Override
    public List<String> getConfigList(String subPath, boolean loadFromEnv) {
        Set<String> configNames = this.getConfigSetFromClasspath(subPath);
        if (loadFromEnv) {
            configNames.addAll(this.getConfigNamesFromTestCases(subPath));
        }
        TreeSet<String> configDefs = new TreeSet<String>();
        configDefs.addAll(configNames);
        ArrayList<String> configs = new ArrayList<String>();
        configs.addAll(configDefs);
        return configs;
    }

    private Set<String> getConfigSetFromClasspath(String subPath) {
        ClassPathScanner cpScanner = new ClassPathScanner();
        return cpScanner.getClassPathEntries(new ConfigClasspathFilter(subPath));
    }

    @VisibleForTesting
    Set<String> getConfigNamesFromTestCases(String subPath) {
        return ConfigurationUtil.getConfigNamesFromDirs(subPath, this.getExternalTestCasesDirs());
    }

    @VisibleForTesting
    Map<String, String> getConfigSetFromClasspathFromJar(String subPath) {
        ClassPathScanner cpScanner = new ClassPathScanner();
        return cpScanner.getClassPathEntriesFromJar(new ConfigClasspathFilter(subPath));
    }

    public void loadAllConfigs(boolean discardExceptions) throws ConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        boolean failed = false;
        Set<String> configNames = this.getConfigSetFromClasspath(null);
        configNames.addAll(this.getConfigNamesFromTestCases(null));
        for (String configName : configNames) {
            ConfigId configId = new ConfigId(configName);
            try {
                ConfigurationDef configDef = this.attemptLoad(configId, null);
                this.mConfigDefMap.put(configId, configDef);
            }
            catch (ConfigurationException e) {
                ps.printf("Failed to load %s: %s", configName, e.getMessage());
                ps.println();
                failed = true;
            }
        }
        if (failed) {
            if (discardExceptions) {
                LogUtil.CLog.e("Failure loading configs");
                LogUtil.CLog.e(baos.toString());
            } else {
                throw new ConfigurationException(baos.toString());
            }
        }
    }

    private ConfigurationDef attemptLoad(ConfigId configId, Map<String, String> templateMap) throws ConfigurationException {
        ConfigurationDef configDef = null;
        try {
            configDef = this.getConfigurationDef(configId.name, false, templateMap);
            return configDef;
        }
        catch (TemplateResolutionError tre) {
            HashMap<String, String> fakeTemplateMap = new HashMap<String, String>();
            if (templateMap != null) {
                fakeTemplateMap.putAll(templateMap);
            }
            fakeTemplateMap.put(tre.getTemplateKey(), DRY_RUN_TEMPLATE_CONFIG);
            return this.attemptLoad(configId, fakeTemplateMap);
        }
    }

    @Override
    public void printHelpForConfig(String[] args, boolean importantOnly, PrintStream out) {
        try {
            IConfiguration config = this.internalCreateConfigurationFromArgs(args, new ArrayList<String>(args.length), null, null);
            config.printCommandUsage(importantOnly, out);
        }
        catch (ConfigurationException e) {
            this.printHelp(out);
        }
    }

    @Override
    public void dumpConfig(String configName, PrintStream out) {
        try {
            BufferedInputStream configStream = this.getConfigStream(configName);
            StreamUtil.copyStreams(configStream, out);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e(e);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    protected String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    protected BufferedInputStream getConfigStream(String name) throws ConfigurationException {
        InputStream configStream = this.getBundledConfigStream(name);
        if (configStream == null) {
            try {
                configStream = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(String.format("Could not find configuration '%s'", name));
            }
        }
        return new BufferedInputStream(configStream);
    }

    protected InputStream getBundledConfigStream(String name) {
        String extension = FileUtil.getExtension(name);
        if (Strings.isNullOrEmpty(extension)) {
            for (String supportExtension : SUPPORTED_EXTENSIONS) {
                InputStream res = this.getClass().getResourceAsStream(String.format("/%s%s%s", this.getConfigPrefix(), name, supportExtension));
                if (res == null) continue;
                return res;
            }
            return null;
        }
        return this.getClass().getResourceAsStream(String.format("/%s%s", this.getConfigPrefix(), name));
    }

    public void loadAndPrintAllConfigs() throws ConfigurationException {
        this.loadAllConfigs(false);
        boolean failed = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        for (ConfigurationDef def : this.mConfigDefMap.values()) {
            try {
                def.createConfiguration().printCommandUsage(false, new PrintStream(StreamUtil.nullOutputStream()));
            }
            catch (ConfigurationException e) {
                if (e.getCause() != null && e.getCause() instanceof ClassNotFoundException) {
                    ClassNotFoundException cnfe = (ClassNotFoundException)e.getCause();
                    String className = cnfe.getLocalizedMessage();
                    if (className != null && className.startsWith("com.android.cts.")) {
                        LogUtil.CLog.w("Could not confirm %s: %s because not part of Trade Federation packages.", def.getName(), e.getMessage());
                        continue;
                    }
                } else if (Pattern.matches(CONFIG_ERROR_PATTERN, e.getMessage()) && !e.getMessage().contains("com.android.") && !e.getMessage().contains("com.google.android.")) {
                    LogUtil.CLog.w("Could not confirm %s: %s", def.getName(), e.getMessage());
                    continue;
                }
                ps.printf("Failed to print %s: %s", def.getName(), e.getMessage());
                ps.println();
                failed = true;
            }
        }
        if (failed) {
            throw new ConfigurationException(baos.toString());
        }
    }

    protected Map<ConfigId, ConfigurationDef> getMapConfig() {
        return new HashMap<ConfigId, ConfigurationDef>(this.mConfigDefMap);
    }

    @VisibleForTesting
    public void clearMapConfig() {
        this.mConfigDefMap.clear();
    }

    @VisibleForTesting
    protected String[] reorderArgs(String[] args) {
        ArrayList<String> nonTemplateArgs = new ArrayList<String>();
        ArrayList<String> reorderedArgs = new ArrayList<String>();
        String[] reorderedArgsArray = new String[args.length];
        if (args.length > 0) {
            reorderedArgs.add(args[0]);
        }
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--template:map")) {
                reorderedArgs.add(arg);
                for (int j = i + 1; j < args.length && !args[j].startsWith("-"); ++j) {
                    reorderedArgs.add(args[j]);
                    ++i;
                }
                continue;
            }
            nonTemplateArgs.add(arg);
        }
        reorderedArgs.addAll(nonTemplateArgs);
        return reorderedArgs.toArray(reorderedArgsArray);
    }

    protected class ConfigLoader
    implements IConfigDefLoader {
        private final boolean mIsGlobalConfig;
        private DirectedGraph<String> mConfigGraph = new DirectedGraph();

        public ConfigLoader(boolean isGlobalConfig) {
            this.mIsGlobalConfig = isGlobalConfig;
        }

        @Override
        public ConfigurationDef getConfigurationDef(String name, Map<String, String> templateMap) throws ConfigurationException {
            String configName = this.findConfigName(name, null);
            ConfigId configId = new ConfigId(name, templateMap);
            ConfigurationDef def = ConfigurationFactory.this.mConfigDefMap.get(configId);
            if (def == null || def.isStale()) {
                def = new ConfigurationDef(configName);
                this.loadConfiguration(configName, def, null, templateMap, null);
                ConfigurationFactory.this.mConfigDefMap.put(configId, def);
            } else if (templateMap != null) {
                templateMap.clear();
            }
            return def;
        }

        protected boolean isBundledConfig(String name) {
            InputStream configStream = ConfigurationFactory.this.getBundledConfigStream(name);
            return configStream != null;
        }

        private String getAbsolutePath(String root, String name) throws ConfigurationException {
            File file2 = new File(name);
            if (!file2.isAbsolute()) {
                if (root == null) {
                    root = System.getProperty("user.dir");
                }
                file2 = new File(root, name);
            }
            try {
                return file2.getCanonicalPath();
            }
            catch (IOException e) {
                throw new ConfigurationException(String.format("Failure when trying to determine local file canonical path %s", e), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURATION_NOT_FOUND);
            }
        }

        protected String findConfigName(String name, String parentName) throws ConfigurationException {
            if (this.isBundledConfig(name)) {
                return name;
            }
            if (parentName == null || this.isBundledConfig(parentName)) {
                String configName = this.getAbsolutePath(null, name);
                File localConfig = new File(configName);
                if (!localConfig.exists()) {
                    localConfig = ConfigurationFactory.this.getTestCaseConfigPath(name);
                }
                if (localConfig != null) {
                    return localConfig.getAbsolutePath();
                }
                if (parentName == null) {
                    throw new ConfigurationException(String.format("Can not find local config %s.", name), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURATION_NOT_FOUND);
                }
                throw new ConfigurationException(String.format("Bundled config '%s' is including a config '%s' that's neither local nor bundled.", parentName, name), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURATION_NOT_FOUND);
            }
            try {
                String parentRoot = new File(parentName).getParentFile().getCanonicalPath();
                return this.getAbsolutePath(parentRoot, name);
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), e.getCause(), InfraErrorIdentifier.CONFIGURATION_NOT_FOUND);
            }
        }

        @Override
        public void loadIncludedConfiguration(ConfigurationDef def, String parentName, String name, String deviceTagObject, Map<String, String> templateMap, Set<String> templateSeen) throws ConfigurationException {
            String config_name = this.findConfigName(name, parentName);
            this.mConfigGraph.addEdge(parentName, config_name);
            if (!this.mConfigGraph.isDag()) {
                LogUtil.CLog.e("%s", this.mConfigGraph);
                throw new ConfigurationException(String.format("Circular configuration include: config '%s' is already included", config_name), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            this.loadConfiguration(config_name, def, deviceTagObject, templateMap, templateSeen);
        }

        void loadConfiguration(String name, ConfigurationDef def, String deviceTagObject, Map<String, String> templateMap, Set<String> templateSeen) throws ConfigurationException {
            String extension;
            BufferedInputStream bufStream = ConfigurationFactory.this.getConfigStream(name);
            switch (extension = FileUtil.getExtension(name)) {
                case ".xml": 
                case ".config": 
                case "": {
                    ConfigurationXmlParser parser = new ConfigurationXmlParser(this, deviceTagObject);
                    parser.parse(def, name, bufStream, templateMap, templateSeen);
                    break;
                }
                case ".tf_yaml": {
                    ConfigurationYamlParser yamlParser = new ConfigurationYamlParser();
                    yamlParser.parse(def, name, bufStream, false);
                    break;
                }
                default: {
                    throw new ConfigurationException(String.format("The config format for %s is not supported.", name));
                }
            }
            this.trackConfig(name, def);
        }

        protected void trackConfig(String name, ConfigurationDef def) {
            if (!this.isBundledConfig(name)) {
                def.registerSource(new File(name));
            }
        }

        protected boolean isTrackableConfig(String name) {
            return !this.isBundledConfig(name);
        }

        @Override
        public boolean isGlobalConfig() {
            return this.mIsGlobalConfig;
        }
    }

    static class ConfigId {
        public String name = null;
        public Map<String, String> templateMap = new HashMap<String, String>();

        public ConfigId() {
        }

        public ConfigId(String name) {
            this(name, null);
        }

        public ConfigId(String name, Map<String, String> templateMap) {
            this.name = name;
            if (templateMap != null) {
                this.templateMap.putAll(templateMap);
            }
        }

        public int hashCode() {
            return 2 * (this.name == null ? 0 : this.name.hashCode()) + 3 * this.templateMap.hashCode();
        }

        private boolean matches(Object a, Object b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equals(b);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ConfigId)) {
                return false;
            }
            ConfigId otherConf = (ConfigId)other;
            return this.matches(this.name, otherConf.name) && this.matches(this.templateMap, otherConf.templateMap);
        }
    }

    protected class ExceptionLoader
    extends ConfigLoader {
        public ExceptionLoader(boolean isGlobal) {
            super(isGlobal);
        }

        @Override
        public ConfigurationDef getConfigurationDef(String name, Map<String, String> templateMap) throws ConfigurationException {
            throw new ConfigurationException("Templates are not allowed in direct configuration contexts");
        }

        @Override
        public boolean isBundledConfig(String name) {
            throw new RuntimeException(new ConfigurationException("Templates are not allowed in direct configuration contexts"));
        }

        @Override
        protected String findConfigName(String name, String parentName) {
            throw new RuntimeException(new ConfigurationException("Templates are not allowed in direct configuration contexts"));
        }

        @Override
        public void loadIncludedConfiguration(ConfigurationDef def, String parentName, String name, String deviceTagObject, Map<String, String> templateMap, Set<String> templateSeen) throws ConfigurationException {
            throw new ConfigurationException("Templates are not allowed in direct configuration contexts", (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }

        @Override
        public void loadConfiguration(String name, ConfigurationDef def, String deviceTagObject, Map<String, String> templateMap, Set<String> templateSeen) throws ConfigurationException {
            throw new ConfigurationException("Templates are not allowed in direct configuration contexts", (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }

        @Override
        protected void trackConfig(String name, ConfigurationDef def) {
            throw new RuntimeException(new ConfigurationException("Templates are not allowed in direct configuration contexts"));
        }

        @Override
        protected boolean isTrackableConfig(String name) {
            throw new RuntimeException(new ConfigurationException("Templates are not allowed in direct configuration contexts"));
        }
    }

    private static class ConfigDefComparator
    implements Comparator<ConfigurationDef> {
        private ConfigDefComparator() {
        }

        @Override
        public int compare(ConfigurationDef d1, ConfigurationDef d2) {
            return d1.getName().compareTo(d2.getName());
        }
    }

    private class ConfigClasspathFilter
    implements ClassPathScanner.IClassPathFilter {
        private String mPrefix = null;

        public ConfigClasspathFilter(String prefix) {
            this.mPrefix = ConfigurationFactory.this.getConfigPrefix();
            if (prefix != null) {
                this.mPrefix = this.mPrefix + prefix;
            }
            LogUtil.CLog.d("Searching the '%s' config path", this.mPrefix);
        }

        @Override
        public boolean accept(String pathName) {
            ConfigId pathId = new ConfigId(pathName);
            String extension = FileUtil.getExtension(pathName);
            return pathName.startsWith(this.mPrefix) && SUPPORTED_EXTENSIONS.contains(extension) && !ConfigurationFactory.this.mConfigDefMap.containsKey(pathId);
        }

        @Override
        public String transform(String pathName) {
            int pathStartIndex = ConfigurationFactory.this.getConfigPrefix().length();
            String extension = FileUtil.getExtension(pathName);
            int pathEndIndex = pathName.length() - extension.length();
            return pathName.substring(pathStartIndex, pathEndIndex);
        }
    }
}

