/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.IConfigOptionValueTransformer;
import com.android.tradefed.config.NoOpConfigOptionValueTransformer;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kxml2.io.KXmlSerializer;

public class ConfigurationUtil {
    public static final String CONFIGURATION_NAME = "configuration";
    public static final String OPTION_NAME = "option";
    public static final String CLASS_NAME = "class";
    public static final String NAME_NAME = "name";
    public static final String KEY_NAME = "key";
    public static final String VALUE_NAME = "value";

    static KXmlSerializer createSerializer(File outputXml) throws IOException {
        PrintWriter output = new PrintWriter(outputXml);
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(output);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startDocument("UTF-8", null);
        return serializer;
    }

    static void dumpClassToXml(KXmlSerializer serializer, String classTypeName, Object obj, List<String> excludeClassFilter, boolean printDeprecatedOptions, boolean printUnchangedOptions) throws IOException {
        ConfigurationUtil.dumpClassToXml(serializer, classTypeName, obj, false, excludeClassFilter, new NoOpConfigOptionValueTransformer(), printDeprecatedOptions, printUnchangedOptions);
    }

    static void dumpClassToXml(KXmlSerializer serializer, String classTypeName, Object obj, boolean isGenericObject, List<String> excludeClassFilter, IConfigOptionValueTransformer transformer, boolean printDeprecatedOptions, boolean printUnchangedOptions) throws IOException {
        if (excludeClassFilter.contains(classTypeName)) {
            return;
        }
        if (excludeClassFilter.contains(obj.getClass().getName())) {
            return;
        }
        if (isGenericObject) {
            serializer.startTag(null, "object");
            serializer.attribute(null, "type", classTypeName);
            serializer.attribute(null, CLASS_NAME, obj.getClass().getName());
            ConfigurationUtil.dumpOptionsToXml(serializer, obj, transformer, printDeprecatedOptions, printUnchangedOptions);
            serializer.endTag(null, "object");
        } else {
            serializer.startTag(null, classTypeName);
            serializer.attribute(null, CLASS_NAME, obj.getClass().getName());
            ConfigurationUtil.dumpOptionsToXml(serializer, obj, transformer, printDeprecatedOptions, printUnchangedOptions);
            serializer.endTag(null, classTypeName);
        }
    }

    private static void dumpOptionsToXml(KXmlSerializer serializer, Object obj, IConfigOptionValueTransformer transformer, boolean printDeprecatedOptions, boolean printUnchangedOptions) throws IOException {
        Object comparisonBaseObj = null;
        if (!printUnchangedOptions) {
            try {
                comparisonBaseObj = obj.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        for (Field field : OptionSetter.getOptionFieldsForClass(obj.getClass())) {
            Iterator compField;
            Object fieldVal;
            Option option = field.getAnnotation(Option.class);
            Deprecated deprecatedAnnotation = field.getAnnotation(Deprecated.class);
            if (!printDeprecatedOptions && deprecatedAnnotation != null || (fieldVal = OptionSetter.getFieldValue(field, obj)) == null || comparisonBaseObj != null && fieldVal.equals(compField = OptionSetter.getFieldValue(field, comparisonBaseObj))) continue;
            if (fieldVal instanceof Collection) {
                compField = ((Collection)fieldVal).iterator();
                while (compField.hasNext()) {
                    Object entry = compField.next();
                    entry = transformer.transform(obj, option, entry);
                    ConfigurationUtil.dumpOptionToXml(serializer, option.name(), null, entry.toString());
                }
                continue;
            }
            if (fieldVal instanceof Map) {
                Map map = (Map)fieldVal;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = iterator2.next();
                    Object value = entry.getValue();
                    value = transformer.transform(obj, option, value);
                    ConfigurationUtil.dumpOptionToXml(serializer, option.name(), entry.getKey().toString(), value.toString());
                }
                continue;
            }
            if (fieldVal instanceof MultiMap) {
                MultiMap multimap = (MultiMap)fieldVal;
                for (Map.Entry keyObj : multimap.keySet()) {
                    for (Object valueObj : multimap.get(keyObj)) {
                        valueObj = transformer.transform(obj, option, valueObj);
                        ConfigurationUtil.dumpOptionToXml(serializer, option.name(), keyObj.toString(), valueObj.toString());
                    }
                }
                continue;
            }
            fieldVal = transformer.transform(obj, option, fieldVal);
            ConfigurationUtil.dumpOptionToXml(serializer, option.name(), null, fieldVal.toString());
        }
    }

    private static void dumpOptionToXml(KXmlSerializer serializer, String name, String key, String value) throws IOException {
        serializer.startTag(null, OPTION_NAME);
        serializer.attribute(null, NAME_NAME, name);
        if (key != null) {
            serializer.attribute(null, KEY_NAME, key);
        }
        serializer.attribute(null, VALUE_NAME, value);
        serializer.endTag(null, OPTION_NAME);
    }

    public static Set<String> getConfigNamesFromDirs(String subPath, List<File> dirs) {
        Set<File> res = ConfigurationUtil.getConfigNamesFileFromDirs(subPath, dirs);
        if (res.isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> files = new HashSet<String>();
        res.forEach(file2 -> files.add(file2.getAbsolutePath()));
        return files;
    }

    public static Set<File> getConfigNamesFileFromDirs(String subPath, List<File> dirs) {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(".*\\.config$");
        patterns.add(".*\\.xml$");
        return ConfigurationUtil.getConfigNamesFileFromDirs(subPath, dirs, patterns);
    }

    public static Set<File> getConfigNamesFileFromDirs(String subPath, List<File> dirs, List<String> configNamePatterns) {
        return ConfigurationUtil.getConfigNamesFileFromDirs(subPath, dirs, configNamePatterns, false);
    }

    public static Set<File> getConfigNamesFileFromDirs(String subPath, List<File> dirs, List<String> configNamePatterns, boolean includeDuplicateFileNames) {
        LinkedHashSet<File> configNames = new LinkedHashSet<File>();
        for (File dir : dirs) {
            if (subPath != null) {
                dir = new File(dir, subPath);
            }
            if (!dir.isDirectory()) {
                LogUtil.CLog.d("%s doesn't exist or is not a directory.", dir.getAbsolutePath());
                continue;
            }
            try {
                for (String configNamePattern : configNamePatterns) {
                    configNames.addAll(FileUtil.findFilesObject(dir, configNamePattern));
                }
            }
            catch (IOException e) {
                LogUtil.CLog.w("Failed to get test config files from directory %s", dir.getAbsolutePath());
            }
        }
        return ConfigurationUtil.dedupFiles(configNames, includeDuplicateFileNames);
    }

    private static Set<File> dedupFiles(Set<File> origSet, boolean includeDuplicateFileNames) {
        LinkedHashMap newMap = new LinkedHashMap();
        for (File f : origSet) {
            block9: {
                try {
                    if (!FileUtil.readStringFromFile(f).contains("<configuration")) {
                        LogUtil.CLog.e("%s doesn't look like a test configuration.", f);
                    }
                    break block9;
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
                continue;
            }
            if (!newMap.keySet().contains(f.getName())) {
                LinkedList<File> newList = new LinkedList<File>();
                newList.add(f);
                newMap.put(f.getName(), newList);
                continue;
            }
            if (!includeDuplicateFileNames) continue;
            boolean isSameContent = false;
            for (File uniqueFiles : (List)newMap.get(f.getName())) {
                try {
                    isSameContent = FileUtil.compareFileContents(uniqueFiles, f);
                    if (!isSameContent) continue;
                    break;
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
            }
            if (isSameContent) continue;
            ((List)newMap.get(f.getName())).add(f);
            LogUtil.CLog.d("Config %s already exists, but content is different. Not skipping.", f.getName());
        }
        LinkedHashSet<File> uniqueFiles = new LinkedHashSet<File>();
        for (List files : newMap.values()) {
            uniqueFiles.addAll(files);
        }
        return uniqueFiles;
    }
}

