/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DeviceConfigurationHolder;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfigDefLoader;
import com.android.tradefed.config.TemplateResolutionError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigurationXmlParser {
    private final IConfigDefLoader mConfigDefLoader;
    private final String mParentDeviceObject;

    ConfigurationXmlParser(IConfigDefLoader loader, String parentDeviceObject) {
        this.mConfigDefLoader = loader;
        this.mParentDeviceObject = parentDeviceObject;
    }

    void parse(ConfigurationDef configDef, String name, InputStream xmlInput, Map<String, String> templateMap) throws ConfigurationException {
        this.parse(configDef, name, xmlInput, templateMap, null);
    }

    void parse(ConfigurationDef configDef, String name, InputStream xmlInput, Map<String, String> templateMap, Set<String> templateSeen) throws ConfigurationException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            ConfigHandler configHandler = new ConfigHandler(configDef, name, this.mConfigDefLoader, this.mParentDeviceObject, templateMap, templateSeen);
            parser.parse(new InputSource(xmlInput), (DefaultHandler)configHandler);
            this.checkValidMultiConfiguration(configHandler, configDef);
        }
        catch (ParserConfigurationException e) {
            this.throwConfigException(name, e);
        }
        catch (SAXException e) {
            this.throwConfigException(name, e);
        }
        catch (IOException e) {
            this.throwConfigException(name, e);
        }
    }

    private void throwConfigException(String configName, Throwable e) throws ConfigurationException {
        if (e.getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)e.getCause();
        }
        throw new ConfigurationException(String.format("Failed to parse config xml '%s' due to '%s'", configName, e), e);
    }

    private void checkValidMultiConfiguration(ConfigHandler configHandler, ConfigurationDef configDef) throws SAXException {
        Map<String, Boolean> expected = configDef.getExpectedDevices();
        Long numDut = expected.values().stream().filter(value -> value == false).collect(Collectors.counting());
        Long numNonDut = expected.values().stream().filter(value -> value == true).collect(Collectors.counting());
        if (numNonDut > 0L && numDut <= 1L) {
            return;
        }
        if (configDef.isMultiDeviceMode() && !configHandler.mOutsideTag.isEmpty()) {
            throw new SAXException(new ConfigurationException(String.format("You seem to want a multi-devices configuration but you have %s tags outside the <device> tags", configHandler.mOutsideTag)));
        }
    }

    static class ConfigHandler
    extends DefaultHandler {
        private static final String OBJECT_TAG = "object";
        private static final String OPTION_TAG = "option";
        private static final String INCLUDE_TAG = "include";
        private static final String TEMPLATE_INCLUDE_TAG = "template-include";
        private static final String CONFIG_TAG = "configuration";
        private static final String DEVICE_TAG = "device";
        private static final String IS_FAKE_ATTR = "isFake";
        static final String INNER_TEMPLATE_INCLUDE_ERROR = "Configurations which contain a <template-include> tag, not having a 'default' attribute, may not be the target of any <include> or <template-include> tag. However, configuration '%s' attempted to include configuration '%s', which contains a <template-include> tag without a 'default' attribute.";
        private final IConfigDefLoader mConfigDefLoader;
        private final ConfigurationDef mConfigDef;
        private final Map<String, String> mTemplateMap;
        private final Set<String> mTemplateSeen;
        private final String mName;
        private final boolean mInsideParentDeviceTag;
        private String mCurrentConfigObject;
        private String mCurrentObjectType;
        private String mCurrentDeviceObject;
        private List<String> mListDevice = new ArrayList<String>();
        private List<String> mOutsideTag = new ArrayList<String>();
        private Boolean isLocalConfig = null;

        ConfigHandler(ConfigurationDef def, String name, IConfigDefLoader loader, String parentDeviceObject, Map<String, String> templateMap, Set<String> templateSeen) {
            this.mName = name;
            this.mConfigDef = def;
            this.mConfigDefLoader = loader;
            this.mCurrentDeviceObject = parentDeviceObject;
            this.mInsideParentDeviceTag = parentDeviceObject != null;
            this.mTemplateMap = templateMap == null ? Collections.emptyMap() : templateMap;
            this.mTemplateSeen = templateSeen == null ? new HashSet<String>() : templateSeen;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (OBJECT_TAG.equals(localName)) {
                String objectTypeName = attributes.getValue("type");
                if (objectTypeName == null) {
                    throw new SAXException(new ConfigurationException("<object> must have a 'type' attribute"));
                }
                if (GlobalConfiguration.isBuiltInObjType(objectTypeName) || Configuration.isBuiltInObjType(objectTypeName)) {
                    throw new SAXException(new ConfigurationException(String.format("<object> cannot be type '%s' this is a reserved type.", objectTypeName)));
                }
                this.addObject(objectTypeName, attributes);
            } else if (DEVICE_TAG.equals(localName)) {
                if (this.mCurrentDeviceObject != null) {
                    throw new SAXException(new ConfigurationException("<device> tag cannot be included inside another device"));
                }
                String deviceName = attributes.getValue("name");
                if (deviceName == null) {
                    throw new SAXException(new ConfigurationException("device tag requires a name value"));
                }
                if (deviceName.equals("DEFAULT_DEVICE")) {
                    throw new SAXException(new ConfigurationException(String.format("device name cannot be reserved name: '%s'", "DEFAULT_DEVICE")));
                }
                if (deviceName.contains(String.valueOf(':'))) {
                    throw new SAXException(new ConfigurationException(String.format("device name cannot contain reserved character: '%s'", Character.valueOf(':'))));
                }
                this.mConfigDef.setMultiDeviceMode(true);
                this.mCurrentDeviceObject = deviceName;
                this.addObject(localName, attributes);
            } else if (Configuration.isBuiltInObjType(localName)) {
                this.mCurrentObjectType = localName;
                if (this.isLocalConfig == null) {
                    this.isLocalConfig = true;
                } else if (!this.isLocalConfig.booleanValue()) {
                    this.throwException(String.format("Attempted to specify local object '%s' for global config!", localName));
                }
                if (this.mCurrentConfigObject != null) {
                    this.throwException(String.format("Declared '%s' object inside %s is not valid.", localName, this.mCurrentConfigObject));
                }
                if (this.mCurrentDeviceObject == null && Configuration.doesBuiltInObjSupportMultiDevice(localName)) {
                    this.mOutsideTag.add(localName);
                }
                if (this.mCurrentDeviceObject != null && !Configuration.doesBuiltInObjSupportMultiDevice(localName)) {
                    throw new SAXException(new ConfigurationException(String.format("Tag %s should not be included in a <device> tag.", localName)));
                }
                this.addObject(localName, attributes);
            } else if (GlobalConfiguration.isBuiltInObjType(localName)) {
                if (this.isLocalConfig == null) {
                    this.isLocalConfig = false;
                } else if (this.isLocalConfig.booleanValue()) {
                    this.throwException(String.format("Attempted to specify global object '%s' for local config!", localName));
                }
                this.addObject(localName, attributes);
            } else if (OPTION_TAG.equals(localName)) {
                String optionName = attributes.getValue("name");
                if (optionName == null) {
                    this.throwException("Missing 'name' attribute for option");
                }
                String optionKey = attributes.getValue("key");
                String optionValue = attributes.getValue("value");
                if (optionValue == null) {
                    this.throwException("Missing 'value' attribute for option '" + optionName + "'");
                }
                if (this.mCurrentConfigObject != null) {
                    optionName = String.format("%s%c%s", this.mCurrentConfigObject, Character.valueOf(':'), optionName);
                }
                if (this.mCurrentDeviceObject != null) {
                    optionName = String.format("{%s}%s", this.mCurrentDeviceObject, optionName);
                }
                this.mConfigDef.addOptionDef(optionName, optionKey, optionValue, this.mName, this.mCurrentObjectType);
            } else if (CONFIG_TAG.equals(localName)) {
                String description = attributes.getValue("description");
                if (description != null && (this.mConfigDef.getDescription() == null || this.mConfigDef.getDescription().isEmpty())) {
                    this.mConfigDef.setDescription(description);
                }
            } else if (INCLUDE_TAG.equals(localName)) {
                String includeName = attributes.getValue("name");
                if (includeName == null) {
                    this.throwException("Missing 'name' attribute for include");
                }
                if (attributes.getLength() > 1) {
                    this.throwException("<include> tag only expect a 'name' attribute.");
                }
                try {
                    this.mConfigDefLoader.loadIncludedConfiguration(this.mConfigDef, this.mName, includeName, this.mCurrentDeviceObject, this.mTemplateMap, this.mTemplateSeen);
                }
                catch (ConfigurationException e) {
                    if (e instanceof TemplateResolutionError) {
                        this.throwException(String.format(INNER_TEMPLATE_INCLUDE_ERROR, this.mConfigDef.getName(), includeName));
                    }
                    throw new SAXException(e);
                }
            } else if (TEMPLATE_INCLUDE_TAG.equals(localName)) {
                String includeName;
                String templateName = attributes.getValue("name");
                if (templateName == null) {
                    this.throwException("Missing 'name' attribute for template-include");
                }
                if (this.mCurrentDeviceObject != null) {
                    this.throwException("<template> inside device object currently not supported.");
                }
                if (this.mTemplateSeen.contains(templateName)) {
                    this.throwException(String.format("Template named '%s' appeared more than once.", templateName));
                }
                if ((includeName = this.mTemplateMap.get(templateName)) == null) {
                    includeName = attributes.getValue("default");
                }
                if (includeName == null) {
                    this.throwTemplateException(this.mConfigDef.getName(), templateName);
                }
                this.mTemplateSeen.add(templateName);
                this.mTemplateMap.remove(templateName);
                try {
                    this.mConfigDefLoader.loadIncludedConfiguration(this.mConfigDef, this.mName, includeName, null, this.mTemplateMap, this.mTemplateSeen);
                }
                catch (ConfigurationException e) {
                    if (e instanceof TemplateResolutionError) {
                        this.throwException(String.format(INNER_TEMPLATE_INCLUDE_ERROR, this.mConfigDef.getName(), includeName));
                    }
                    throw new SAXException(e);
                }
            } else {
                throw new SAXException(String.format("Unrecognized tag '%s' in configuration", localName));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (OBJECT_TAG.equals(localName) || Configuration.isBuiltInObjType(localName) || GlobalConfiguration.isBuiltInObjType(localName)) {
                this.mCurrentConfigObject = null;
            }
            if (DEVICE_TAG.equals(localName) && !this.mInsideParentDeviceTag) {
                this.mCurrentDeviceObject = null;
            }
            if (this.mCurrentObjectType != null && this.mCurrentObjectType.equals(localName)) {
                this.mCurrentObjectType = null;
            }
        }

        void addObject(String objectTypeName, Attributes attributes) throws SAXException {
            if (DEVICE_TAG.equals(objectTypeName)) {
                String resp;
                String deviceName;
                String isFakeString = attributes.getValue(IS_FAKE_ATTR);
                boolean isFake = false;
                if (isFakeString != null && Boolean.parseBoolean(isFakeString)) {
                    isFake = true;
                }
                if (!this.mListDevice.contains(deviceName = attributes.getValue("name"))) {
                    this.mListDevice.add(deviceName);
                    this.mConfigDef.addConfigObjectDef(objectTypeName, DeviceConfigurationHolder.class.getCanonicalName());
                }
                if ((resp = this.mConfigDef.addExpectedDevice(deviceName, isFake)) != null) {
                    this.throwException(resp);
                }
            } else {
                String className = attributes.getValue("class");
                if (className == null) {
                    this.throwException(String.format("Missing class attribute for object %s", objectTypeName));
                }
                if (this.mCurrentDeviceObject != null) {
                    objectTypeName = this.mCurrentDeviceObject + ':' + objectTypeName;
                }
                int classCount = this.mConfigDef.addConfigObjectDef(objectTypeName, className);
                this.mCurrentConfigObject = String.format("%s%c%d", className, Character.valueOf(':'), classCount);
            }
        }

        private void throwException(String reason) throws SAXException {
            throw new SAXException(new ConfigurationException(String.format("Failed to parse config xml '%s'. Reason: %s", this.mConfigDef.getName(), reason)));
        }

        private void throwTemplateException(String configName, String templateName) throws SAXException {
            throw new SAXException(new TemplateResolutionError(configName, templateName));
        }
    }
}

