/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.WaitDeviceRecovery;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetPreparer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceConfigurationHolder
implements IDeviceConfiguration {
    private final String mDeviceName;
    private final boolean mIsFake;
    private IBuildProvider mBuildProvider = new StubBuildProvider();
    private List<ITargetPreparer> mListTargetPreparer = new ArrayList<ITargetPreparer>();
    private List<ITargetPreparer> mListLabPreparer = new ArrayList<ITargetPreparer>();
    private IDeviceRecovery mDeviceRecovery = new WaitDeviceRecovery();
    private IDeviceSelection mDeviceSelection = new DeviceSelectionOptions();
    private TestDeviceOptions mTestDeviceOption = new TestDeviceOptions();
    private Map<Object, Integer> mFreqMap = new HashMap<Object, Integer>();

    public DeviceConfigurationHolder() {
        this("", false);
    }

    public DeviceConfigurationHolder(String deviceName) {
        this(deviceName, false);
    }

    public DeviceConfigurationHolder(String deviceName, boolean isFake) {
        this.mDeviceName = deviceName;
        this.mIsFake = isFake;
    }

    @Override
    public String getDeviceName() {
        return this.mDeviceName;
    }

    @Override
    public boolean isFake() {
        return this.mIsFake;
    }

    @Override
    public void addSpecificConfig(Object config) throws ConfigurationException {
        if (config instanceof IBuildProvider) {
            this.mBuildProvider = (IBuildProvider)config;
        } else if (config instanceof ITargetPreparer) {
            if (this.isFake()) {
                throw new ConfigurationException("cannot specify a target_preparer for a isFake=true device.");
            }
            this.mListTargetPreparer.add((ITargetPreparer)config);
        } else if (config instanceof IDeviceRecovery) {
            this.mDeviceRecovery = (IDeviceRecovery)config;
        } else if (config instanceof IDeviceSelection) {
            this.mDeviceSelection = (IDeviceSelection)config;
        } else if (config instanceof TestDeviceOptions) {
            this.mTestDeviceOption = (TestDeviceOptions)config;
        } else {
            throw new ConfigurationException(String.format("Cannot add %s class to a device specific definition", config.getClass()));
        }
    }

    @Override
    public void addSpecificConfig(Object config, String type) throws ConfigurationException {
        if (config instanceof IBuildProvider && "build_provider".equals(type)) {
            this.mBuildProvider = (IBuildProvider)config;
        } else if (config instanceof ITargetPreparer && "lab_preparer".equals(type)) {
            if (this.isFake()) {
                throw new ConfigurationException("cannot specify a lab_preparer for a isFake=true device.");
            }
            this.mListLabPreparer.add((ITargetPreparer)config);
        } else if (config instanceof ITargetPreparer && "target_preparer".equals(type)) {
            if (this.isFake()) {
                throw new ConfigurationException("cannot specify a target_preparer for a isFake=true device.");
            }
            this.mListTargetPreparer.add((ITargetPreparer)config);
        } else if (config instanceof IDeviceRecovery && "device_recovery".equals(type)) {
            this.mDeviceRecovery = (IDeviceRecovery)config;
        } else if (config instanceof IDeviceSelection && "device_requirements".equals(type)) {
            this.mDeviceSelection = (IDeviceSelection)config;
        } else if (config instanceof TestDeviceOptions && "device_options".equals(type)) {
            this.mTestDeviceOption = (TestDeviceOptions)config;
        } else {
            throw new ConfigurationException(String.format("Cannot add %s class type '%s' to a device specific definition", config.getClass(), type));
        }
    }

    @Override
    public void removeObjectType(String type) throws ConfigurationException {
        if ("build_provider".equals(type)) {
            this.mBuildProvider = null;
        } else if ("target_preparer".equals(type)) {
            this.mListTargetPreparer.clear();
        } else if ("device_recovery".equals(type)) {
            this.mDeviceRecovery = null;
        } else if ("device_requirements".equals(type)) {
            this.mDeviceSelection = null;
        } else if ("device_options".equals(type)) {
            this.mTestDeviceOption = null;
        } else if ("lab_preparer".equals(type)) {
            this.mListLabPreparer.clear();
        } else {
            throw new ConfigurationException(String.format("'%s' type is not supported by DeviceConfigurationHolder", type));
        }
    }

    @Override
    public void addFrequency(Object config, Integer frequency) {
        this.mFreqMap.put(config, frequency);
    }

    @Override
    public Integer getFrequency(Object config) {
        return this.mFreqMap.get(config);
    }

    @Override
    public List<Object> getAllObjects() {
        ArrayList<Object> allObject = new ArrayList<Object>();
        allObject.add(this.mBuildProvider);
        allObject.addAll(this.mListTargetPreparer);
        allObject.addAll(this.mListLabPreparer);
        allObject.add(this.mDeviceRecovery);
        allObject.add(this.mDeviceSelection);
        allObject.add(this.mTestDeviceOption);
        return allObject;
    }

    @Override
    public List<Object> getAllObjectOfType(String configType) {
        switch (configType) {
            case "build_provider": {
                return Arrays.asList(this.mBuildProvider);
            }
            case "target_preparer": {
                return new ArrayList<Object>(this.mListTargetPreparer);
            }
            case "lab_preparer": {
                return new ArrayList<Object>(this.mListLabPreparer);
            }
            case "device_recovery": {
                return Arrays.asList(this.mDeviceRecovery);
            }
            case "device_requirements": {
                return Arrays.asList(this.mDeviceSelection);
            }
            case "device_options": {
                return Arrays.asList(this.mTestDeviceOption);
            }
        }
        return new ArrayList<Object>();
    }

    @Override
    public IBuildProvider getBuildProvider() {
        return this.mBuildProvider;
    }

    @Override
    public List<ITargetPreparer> getTargetPreparers() {
        return this.mListTargetPreparer;
    }

    @Override
    public List<ITargetPreparer> getLabPreparers() {
        return this.mListLabPreparer;
    }

    @Override
    public IDeviceRecovery getDeviceRecovery() {
        return this.mDeviceRecovery;
    }

    @Override
    public IDeviceSelection getDeviceRequirements() {
        if (this.isFake()) {
            DeviceSelectionOptions select = new DeviceSelectionOptions();
            select.setNullDeviceRequested(true);
            return select;
        }
        return this.mDeviceSelection;
    }

    @Override
    public TestDeviceOptions getDeviceOptions() {
        return this.mTestDeviceOption;
    }

    @Override
    public IDeviceConfiguration clone() {
        return this.clone(this.getDeviceName());
    }

    @Override
    public IDeviceConfiguration clone(String newName) {
        DeviceConfigurationHolder newDeviceConfig = new DeviceConfigurationHolder(newName);
        for (Object obj : this.getAllObjects()) {
            try {
                newDeviceConfig.addSpecificConfig(obj);
            }
            catch (ConfigurationException e) {
                LogUtil.CLog.e(e);
            }
        }
        return newDeviceConfig;
    }
}

