/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.config.remote.ExtendedFile;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationLocal;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.ZipUtil2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

public class DynamicRemoteFileResolver {
    public static final String UNZIP_KEY = "unzip";
    public static final String OPTIONAL_KEY = "optional";
    public static final String OPTION_NAME_KEY = "option_name";
    public static final String OPTION_PARALLEL_KEY = "parallel";
    private static final FileResolverLoader DEFAULT_FILE_RESOLVER_LOADER = new FileResolverLoader(){
        private final InvocationLocal<FileResolverLoader> mInvocationLoader = new InvocationLocal<FileResolverLoader>(){

            @Override
            protected FileResolverLoader initialValue() {
                return new ServiceFileResolverLoader();
            }
        };

        @Override
        public IRemoteFileResolver load(String scheme, Map<String, String> config) {
            return this.mInvocationLoader.get().load(scheme, config);
        }
    };
    private final FileResolverLoader mFileResolverLoader;
    private final boolean mAllowParallelization;
    private Map<String, OptionSetter.OptionFieldsForName> mOptionMap;
    private Map<String, String> mExtraArgs = new LinkedHashMap<String, String>();
    private ITestDevice mDevice;
    private List<ExtendedFile> mParallelExtendedFiles = new ArrayList<ExtendedFile>();

    public DynamicRemoteFileResolver() {
        this(DEFAULT_FILE_RESOLVER_LOADER);
    }

    public DynamicRemoteFileResolver(boolean allowParallel) {
        this(DEFAULT_FILE_RESOLVER_LOADER, allowParallel);
    }

    public DynamicRemoteFileResolver(FileResolverLoader loader) {
        this(loader, false);
    }

    public DynamicRemoteFileResolver(FileResolverLoader loader, boolean allowParallel) {
        this.mFileResolverLoader = loader;
        this.mAllowParallelization = allowParallel;
    }

    public void setOptionMap(Map<String, OptionSetter.OptionFieldsForName> optionMap) {
        this.mOptionMap = optionMap;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void addExtraArgs(Map<String, String> extraArgs) {
        this.mExtraArgs.putAll(extraArgs);
    }

    public List<ExtendedFile> getParallelDownloads() {
        return this.mParallelExtendedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Set<File> validateRemoteFilePath() throws BuildRetrievalError {
        HashSet<File> downloadedFiles = new HashSet<File>();
        try {
            HashMap<Field, Object> fieldSeen = new HashMap<Field, Object>();
            for (Map.Entry<String, OptionSetter.OptionFieldsForName> optionPair : this.mOptionMap.entrySet()) {
                OptionSetter.OptionFieldsForName optionFields = optionPair.getValue();
                for (Map.Entry<Object, Field> fieldEntry : optionFields) {
                    Object finalKey;
                    Object m;
                    MultiMap copy;
                    Object resolvedFile;
                    Object value;
                    Object obj = fieldEntry.getKey();
                    Field field = fieldEntry.getValue();
                    Option option = field.getAnnotation(Option.class);
                    if (option == null) continue;
                    field.setAccessible(true);
                    try {
                        value = field.get(obj);
                        if (value == null) {
                            continue;
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new BuildRetrievalError(String.format("internal error: %s", e.getMessage()), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_UNSUPPORTED_PATH);
                    }
                    if (fieldSeen.get(field) != null && fieldSeen.get(field).equals(obj)) continue;
                    fieldSeen.put(field, obj);
                    if (value instanceof File) {
                        File consideredFile = (File)value;
                        resolvedFile = this.resolveRemoteFiles(consideredFile, option);
                        if (resolvedFile == null) continue;
                        File downloadedFile = ((IRemoteFileResolver.ResolvedFile)resolvedFile).getResolvedFile();
                        if (((IRemoteFileResolver.ResolvedFile)resolvedFile).shouldCleanUp()) {
                            downloadedFiles.add(downloadedFile);
                        }
                        try {
                            field.set(obj, downloadedFile);
                            continue;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            LogUtil.CLog.e(illegalAccessException);
                            throw new BuildRetrievalError(String.format("Failed to download %s due to '%s'", consideredFile.getPath(), illegalAccessException.getMessage()), illegalAccessException);
                        }
                    }
                    if (value instanceof Collection) {
                        Collection c = (Collection)value;
                        resolvedFile = c;
                        synchronized (resolvedFile) {
                            copy = new ArrayList(c);
                            Iterator iterator2 = copy.iterator();
                            while (iterator2.hasNext()) {
                                File consideredFile;
                                IRemoteFileResolver.ResolvedFile resolvedFile2;
                                Object o = iterator2.next();
                                if (!(o instanceof File) || (resolvedFile2 = this.resolveRemoteFiles(consideredFile = (File)o, option)) == null) continue;
                                File downloadedFile = resolvedFile2.getResolvedFile();
                                if (resolvedFile2.shouldCleanUp()) {
                                    downloadedFiles.add(downloadedFile);
                                }
                                c.remove(consideredFile);
                                c.add(downloadedFile);
                            }
                            continue;
                        }
                    }
                    if (value instanceof Map) {
                        m = (Map)value;
                        LinkedHashMap copy2 = new LinkedHashMap(m);
                        for (Map.Entry entry : copy2.entrySet()) {
                            File downloaded;
                            IRemoteFileResolver.ResolvedFile resolved;
                            Object key = entry.getKey();
                            Object val = entry.getValue();
                            finalKey = key;
                            Object finalVal = val;
                            if (key instanceof File && (resolved = this.resolveRemoteFiles((File)key, option)) != null) {
                                downloaded = resolved.getResolvedFile();
                                if (resolved.shouldCleanUp()) {
                                    downloadedFiles.add(downloaded);
                                }
                                finalKey = downloaded;
                            }
                            if (val instanceof File && (resolved = this.resolveRemoteFiles((File)val, option)) != null) {
                                downloaded = resolved.getResolvedFile();
                                if (resolved.shouldCleanUp()) {
                                    downloadedFiles.add(downloaded);
                                }
                                finalVal = downloaded;
                            }
                            m.remove(entry.getKey());
                            m.put(finalKey, finalVal);
                        }
                        continue;
                    }
                    if (!(value instanceof MultiMap)) continue;
                    Object object = m = (MultiMap)value;
                    synchronized (object) {
                        copy = new MultiMap(m);
                        for (Object key : copy.keySet()) {
                            IRemoteFileResolver.ResolvedFile resolved;
                            List mapValues = copy.get(key);
                            ((MultiMap)m).remove(key);
                            finalKey = key;
                            if (key instanceof File && (resolved = this.resolveRemoteFiles((File)key, option)) != null) {
                                File downloaded = resolved.getResolvedFile();
                                if (resolved.shouldCleanUp()) {
                                    downloadedFiles.add(downloaded);
                                }
                                finalKey = downloaded;
                            }
                            for (Object mapValue : mapValues) {
                                IRemoteFileResolver.ResolvedFile resolvedFile3;
                                if (mapValue instanceof File && (resolvedFile3 = this.resolveRemoteFiles((File)mapValue, option)) != null) {
                                    if (resolvedFile3.shouldCleanUp()) {
                                        downloadedFiles.add(resolvedFile3.getResolvedFile());
                                    }
                                    mapValue = resolvedFile3.getResolvedFile();
                                }
                                ((MultiMap)m).put(finalKey, mapValue);
                            }
                        }
                    }
                }
                continue;
                return downloadedFiles;
            }
        }
        catch (BuildRetrievalError | RuntimeException e) {
            for (File f : downloadedFiles) {
                FileUtil.recursiveDelete(f);
            }
            throw e;
        }
    }

    public void resolvePartialDownloadZip(File destDir, String remoteZipFilePath, List<String> includeFilters, List<String> excludeFilters) throws BuildRetrievalError {
        Map<String, String> queryArgs;
        String protocol;
        try {
            URI uri = new URI(remoteZipFilePath);
            protocol = uri.getScheme();
            queryArgs = this.parseQuery(uri.getQuery());
        }
        catch (URISyntaxException e) {
            throw new BuildRetrievalError(String.format("Failed to parse the remote zip file path: %s", remoteZipFilePath), e);
        }
        queryArgs.put("partial_download_dir", destDir.getAbsolutePath());
        if (includeFilters != null) {
            queryArgs.put("include_filters", String.join((CharSequence)";", includeFilters));
        }
        if (excludeFilters != null) {
            queryArgs.put("exclude_filters", String.join((CharSequence)";", excludeFilters));
        }
        try {
            IRemoteFileResolver resolver = this.getResolver(protocol);
            resolver.setPrimaryDevice(this.mDevice);
            IRemoteFileResolver.RemoteFileResolverArgs args = new IRemoteFileResolver.RemoteFileResolverArgs();
            args.setConsideredFile(new File(remoteZipFilePath)).addQueryArgs(queryArgs).setDestinationDir(destDir);
            resolver.resolveRemoteFile(args);
        }
        catch (BuildRetrievalError e) {
            if (this.isOptional(queryArgs)) {
                LogUtil.CLog.d("Failed to partially download '%s' but marked optional so skipping: %s", remoteZipFilePath, e.getMessage());
                return;
            }
            throw e;
        }
    }

    private IRemoteFileResolver getResolver(String protocol) throws BuildRetrievalError {
        try {
            return this.mFileResolverLoader.load(protocol, this.mExtraArgs);
        }
        catch (ResolverLoadingException e) {
            throw new BuildRetrievalError(String.format("Could not load resolver for protocol %s", protocol), e);
        }
    }

    IGlobalConfiguration getGlobalConfig() {
        return GlobalConfiguration.getInstance();
    }

    public static final File unzipIfRequired(File downloadedFile, Map<String, String> query) throws IOException {
        String unzipValue = query.get(UNZIP_KEY);
        if (unzipValue != null && "true".equals(unzipValue.toLowerCase())) {
            try (CloseableTraceScope ignored = new CloseableTraceScope("unzip " + downloadedFile.getName());){
                if (ZipUtil.isZipFileValid(downloadedFile, false)) {
                    File extractedDir = FileUtil.createTempDir(FileUtil.getBaseName(downloadedFile.getName()), CurrentInvocation.getInfo(CurrentInvocation.InvocationInfo.WORK_FOLDER));
                    ZipUtil2.extractZip(downloadedFile, extractedDir);
                    FileUtil.deleteFile(downloadedFile);
                    File file2 = extractedDir;
                    return file2;
                }
                throw new IOException(String.format("%s was requested to be unzipped but is not a valid zip.", downloadedFile));
            }
        }
        return downloadedFile;
    }

    private IRemoteFileResolver.ResolvedFile resolveRemoteFiles(File consideredFile, Option option) throws BuildRetrievalError {
        File fileToResolve;
        Map<String, String> query;
        String protocol;
        String path = consideredFile.getPath();
        try {
            URI uri = new URI(path.replace('\\', '/'));
            protocol = uri.getScheme();
            query = this.parseQuery(uri.getQuery());
            fileToResolve = new File(protocol + ":" + uri.getPath());
        }
        catch (URISyntaxException e) {
            LogUtil.CLog.e(e);
            throw new BuildRetrievalError(e.getMessage(), (Throwable)e, InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        query.put(OPTION_NAME_KEY, option.name());
        if (!this.mAllowParallelization) {
            query.put(OPTION_PARALLEL_KEY, "false");
        }
        try {
            ExtendedFile trackingFile;
            IRemoteFileResolver resolver = this.getResolver(protocol);
            if (resolver == null) {
                return null;
            }
            LogUtil.CLog.d("Considering option '%s' with path: '%s' for download.", option.name(), path);
            resolver.setPrimaryDevice(this.mDevice);
            IRemoteFileResolver.RemoteFileResolverArgs args = new IRemoteFileResolver.RemoteFileResolverArgs();
            args.setConsideredFile(fileToResolve).addQueryArgs(query);
            IRemoteFileResolver.ResolvedFile resolvedFile = resolver.resolveRemoteFile(args);
            if (resolvedFile != null && resolvedFile.getResolvedFile() instanceof ExtendedFile && (trackingFile = (ExtendedFile)resolvedFile.getResolvedFile()).isDownloadingInParallel()) {
                this.mParallelExtendedFiles.add(trackingFile);
            }
            return resolvedFile;
        }
        catch (BuildRetrievalError e) {
            if (this.isOptional(query)) {
                LogUtil.CLog.d("Failed to resolve '%s' but marked optional so skipping: %s", fileToResolve, e.getMessage());
                return null;
            }
            throw e;
        }
    }

    private Map<String, String> parseQuery(String query) {
        HashMap<String, String> values2 = new HashMap<String, String>();
        if (query == null) {
            return values2;
        }
        for (String maps : query.split("&")) {
            String[] keyVal = maps.split("=");
            values2.put(keyVal[0], keyVal[1]);
        }
        return values2;
    }

    private boolean isOptional(Map<String, String> query) {
        String value = query.get(OPTIONAL_KEY);
        if (value == null) {
            return false;
        }
        return "true".equals(value.toLowerCase());
    }

    public static interface FileResolverLoader {
        @Nullable
        public IRemoteFileResolver load(String var1, Map<String, String> var2);
    }

    static final class ResolverLoadingException
    extends HarnessRuntimeException {
        public ResolverLoadingException(@Nullable String message2, ErrorIdentifier errorId) {
            super(message2, errorId);
        }

        public ResolverLoadingException(@Nullable String message2, IHarnessException cause) {
            super(message2, cause);
        }
    }

    @ThreadSafe
    static final class ServiceFileResolverLoader
    implements FileResolverLoader {
        private final Supplier<ClassLoader> mClassLoaderSupplier;
        @Nullable
        @GuardedBy(value="this")
        private LoaderState mLoaderState;

        ServiceFileResolverLoader() {
            this.mClassLoaderSupplier = () -> Thread.currentThread().getContextClassLoader();
        }

        ServiceFileResolverLoader(ClassLoader classLoader) {
            this.mClassLoaderSupplier = () -> classLoader;
        }

        @Override
        public synchronized IRemoteFileResolver load(String scheme, Map<String, String> config) {
            if (this.mLoaderState != null) {
                return this.mLoaderState.getAndInit(scheme);
            }
            HashMap<String, IRemoteFileResolver> resolvers = new HashMap<String, IRemoteFileResolver>();
            ServiceLoader<IRemoteFileResolver> serviceLoader = ServiceLoader.load(IRemoteFileResolver.class, this.mClassLoaderSupplier.get());
            for (IRemoteFileResolver resolver : serviceLoader) {
                resolvers.putIfAbsent(resolver.getSupportedProtocol(), resolver);
            }
            this.mLoaderState = new LoaderState(resolvers, config);
            return this.mLoaderState.getAndInit(scheme);
        }

        private static final class LoaderState {
            private final ImmutableMap<String, String> mConfig;
            private final ImmutableMap<String, ResolverState> mState;

            LoaderState(Map<String, IRemoteFileResolver> resolvers, Map<String, String> config) {
                this.mState = ImmutableMap.copyOf(Maps.transformValues(resolvers, r -> new ResolverState((IRemoteFileResolver)r)));
                this.mConfig = ImmutableMap.copyOf(config);
            }

            @Nullable
            IRemoteFileResolver getAndInit(String scheme) {
                ResolverState state = this.mState.get(scheme);
                if (state == null) {
                    return null;
                }
                return state.getAndInit(this);
            }

            void resolve(IRemoteFileResolver resolver) throws ConfigurationException, BuildRetrievalError {
                OptionSetter setter = new OptionSetter(resolver);
                for (Map.Entry e : this.mConfig.entrySet()) {
                    String name = (String)e.getKey();
                    if (setter.fieldsForArgNoThrow(name) == null) continue;
                    if (setter.isMapOption(name)) {
                        throw new ConfigurationException("Map options are not supported: " + name, (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                    }
                    setter.setOptionValue(name, (String)e.getValue());
                }
                Collection<String> missingOptions = setter.getUnsetMandatoryOptions();
                if (!missingOptions.isEmpty()) {
                    throw new ConfigurationException(String.format("Found missing mandatory options %s for resolver %s", missingOptions, resolver.toString()), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
                DynamicRemoteFileResolver dynamicResolver = new DynamicRemoteFileResolver((scheme, unused) -> this.getAndInit(scheme));
                dynamicResolver.addExtraArgs(this.mConfig);
                setter.validateRemoteFilePath(dynamicResolver);
            }

            static final class ResolverState {
                final IRemoteFileResolver mResolver;
                @Nullable
                Boolean mDone;
                @Nullable
                ResolverLoadingException mException;

                ResolverState(IRemoteFileResolver resolver) {
                    this.mResolver = resolver;
                }

                IRemoteFileResolver getAndInit(LoaderState context) {
                    if (Boolean.TRUE.equals(this.mDone)) {
                        return this.getOrThrow();
                    }
                    if (Boolean.FALSE.equals(this.mDone)) {
                        throw new ResolverLoadingException("Cycle detected while initializing resolver options: " + this.mResolver.toString(), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                    }
                    LogUtil.CLog.i("Initializing file resolver options: %s", this.mResolver);
                    this.mDone = Boolean.FALSE;
                    try {
                        context.resolve(this.mResolver);
                    }
                    catch (BuildRetrievalError | ConfigurationException e) {
                        this.mException = new ResolverLoadingException("Could not initialize resolver options: " + this.mResolver.toString(), e);
                        throw this.mException;
                    }
                    finally {
                        this.mDone = Boolean.TRUE;
                    }
                    return this.mResolver;
                }

                private IRemoteFileResolver getOrThrow() {
                    if (this.mException != null) {
                        throw this.mException;
                    }
                    return this.mResolver;
                }
            }
        }
    }
}

