/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.auth.ICredentialFactory;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.ConfigurationUtil;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfigOptionValueTransformer;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IConfigurationServer;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.config.NoOpConfigOptionValueTransformer;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.config.gcs.GCSConfigurationFactory;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.device.IMultiDeviceRecovery;
import com.android.tradefed.host.HostOptions;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.host.IHostResourceManager;
import com.android.tradefed.host.LocalHostResourceManager;
import com.android.tradefed.invoker.shard.IShardHelper;
import com.android.tradefed.invoker.shard.StrictShardHelper;
import com.android.tradefed.log.ITerribleFailureHandler;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.monitoring.collector.IResourceMetricCollector;
import com.android.tradefed.sandbox.ISandboxFactory;
import com.android.tradefed.sandbox.TradefedSandboxFactory;
import com.android.tradefed.service.TradefedFeatureServer;
import com.android.tradefed.service.management.DeviceManagementGrpcServer;
import com.android.tradefed.service.management.TestInvocationManagementServer;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.hostmetric.IHostMonitor;
import com.android.tradefed.util.keystore.IKeyStoreFactory;
import com.android.tradefed.util.keystore.StubKeyStoreFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.kxml2.io.KXmlSerializer;

public class GlobalConfiguration
implements IGlobalConfiguration {
    public static final String DEVICE_MONITOR_TYPE_NAME = "device_monitor";
    public static final String HOST_MONITOR_TYPE_NAME = "host_monitor";
    public static final String DEVICE_MANAGER_TYPE_NAME = "device_manager";
    public static final String WTF_HANDLER_TYPE_NAME = "wtf_handler";
    public static final String HOST_OPTIONS_TYPE_NAME = "host_options";
    public static final String HOST_RESOURCE_MANAGER_TYPE_NAME = "host_resource_manager";
    public static final String DEVICE_REQUIREMENTS_TYPE_NAME = "device_requirements";
    public static final String SCHEDULER_TYPE_NAME = "command_scheduler";
    public static final String MULTI_DEVICE_RECOVERY_TYPE_NAME = "multi_device_recovery";
    public static final String KEY_STORE_TYPE_NAME = "key_store";
    public static final String SHARDING_STRATEGY_TYPE_NAME = "sharding_strategy";
    public static final String GLOBAL_CONFIG_SERVER = "global_config_server";
    public static final String SANDBOX_FACTORY_TYPE_NAME = "sandbox_factory";
    public static final String RESOURCE_METRIC_COLLECTOR_TYPE_NAME = "resource_metric_collector";
    public static final String CREDENTIAL_FACTORY_TYPE_NAME = "credential_factory";
    public static final String TF_FEATURE_SERVER_NAME = "tf_feature_server";
    public static final String TF_INVOCATION_SERVER_NAME = "tf_invocation_server";
    public static final String TF_DEVICE_MANAGEMENT_SERVER_NAME = "tf_device_management_server";
    public static final String GLOBAL_CONFIG_VARIABLE = "TF_GLOBAL_CONFIG";
    public static final String GLOBAL_CONFIG_SERVER_CONFIG_VARIABLE = "TF_GLOBAL_CONFIG_SERVER_CONFIG";
    private static final String GLOBAL_CONFIG_FILENAME = "tf_global_config.xml";
    private static Map<String, ObjTypeInfo> sObjTypeMap = null;
    private static IGlobalConfiguration sInstance = null;
    private static final Object sInstanceLock = new Object();
    private static final String DEFAULT_EMPTY_CONFIG_NAME = "empty";
    private static final String[] CONFIGS_FOR_SUBPROCESS_ALLOW_LIST = new String[]{"device_manager", "key_store", "host_options", "android-build"};
    private Map<String, List<Object>> mConfigMap;
    private MultiMap<String, String> mOptionMap;
    private String[] mOriginalArgs;
    private final String mName;
    private final String mDescription;
    private IConfigurationFactory mConfigFactory = null;

    public static IGlobalConfiguration getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("GlobalConfiguration has not yet been initialized!");
        }
        return sInstance;
    }

    public static IDeviceManager getDeviceManagerInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("GlobalConfiguration has not yet been initialized!");
        }
        return sInstance.getDeviceManager();
    }

    public static List<IHostMonitor> getHostMonitorInstances() {
        if (sInstance == null) {
            throw new IllegalStateException("GlobalConfiguration has not yet been initialized!");
        }
        return sInstance.getHostMonitors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> createGlobalConfiguration(String[] args) throws ConfigurationException {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance != null) {
                throw new IllegalStateException("GlobalConfiguration is already initialized!");
            }
            ArrayList<String> nonGlobalArgs = new ArrayList<String>(args.length);
            ArrayList<String> nonConfigServerArgs = new ArrayList<String>(args.length);
            IConfigurationServer globalConfigServer = GlobalConfiguration.createGlobalConfigServer(args, nonConfigServerArgs);
            if (globalConfigServer == null) {
                String path = GlobalConfiguration.getGlobalConfigPath();
                String[] arrayArgs = ArrayUtil.buildArray({path}, args);
                IConfigurationFactory configFactory = ConfigurationFactory.getInstance();
                sInstance = configFactory.createGlobalConfigurationFromArgs(arrayArgs, nonGlobalArgs);
                ((GlobalConfiguration)GlobalConfiguration.sInstance).mOriginalArgs = arrayArgs;
            } else {
                String currentHostConfig = globalConfigServer.getCurrentHostConfig();
                IConfigurationFactory configFactory = GCSConfigurationFactory.getInstance(globalConfigServer);
                String[] arrayArgs = ArrayUtil.buildArray({currentHostConfig}, nonConfigServerArgs.toArray(new String[0]));
                sInstance = configFactory.createGlobalConfigurationFromArgs(arrayArgs, nonGlobalArgs);
                ((GlobalConfiguration)GlobalConfiguration.sInstance).mOriginalArgs = arrayArgs;
            }
            sInstance.validateOptions();
            return nonGlobalArgs;
        }
    }

    private static String getGlobalConfigPath() {
        String path = System.getenv(GLOBAL_CONFIG_VARIABLE);
        if (path != null) {
            System.out.format("Attempting to use global config \"%s\" from variable $%s.\n", path, GLOBAL_CONFIG_VARIABLE);
            return path;
        }
        File file2 = new File(GLOBAL_CONFIG_FILENAME);
        if (file2.exists()) {
            path = file2.getPath();
            System.out.format("Attempting to use autodetected global config \"%s\".\n", path);
            return path;
        }
        return DEFAULT_EMPTY_CONFIG_NAME;
    }

    @VisibleForTesting
    static IConfigurationServer createGlobalConfigServer(String[] args, List<String> nonConfigServerArgs) throws ConfigurationException {
        String path = System.getenv(GLOBAL_CONFIG_SERVER_CONFIG_VARIABLE);
        if (path == null) {
            nonConfigServerArgs.addAll(Arrays.asList(args));
            return null;
        }
        System.out.format("Use global config server config %s.\n", path);
        IConfigurationServer configServer = null;
        IConfigurationFactory configFactory = ConfigurationFactory.getInstance();
        IGlobalConfiguration configServerConfig = configFactory.createGlobalConfigurationFromArgs(ArrayUtil.buildArray({path}, args), nonConfigServerArgs);
        configServer = configServerConfig.getGlobalConfigServer();
        return configServer;
    }

    static boolean isBuiltInObjType(String typeName) {
        return GlobalConfiguration.getObjTypeMap().containsKey(typeName);
    }

    private static synchronized Map<String, ObjTypeInfo> getObjTypeMap() {
        if (sObjTypeMap == null) {
            sObjTypeMap = new HashMap<String, ObjTypeInfo>();
            sObjTypeMap.put(HOST_OPTIONS_TYPE_NAME, new ObjTypeInfo(IHostOptions.class, false));
            sObjTypeMap.put(HOST_RESOURCE_MANAGER_TYPE_NAME, new ObjTypeInfo(IHostResourceManager.class, false));
            sObjTypeMap.put(DEVICE_MONITOR_TYPE_NAME, new ObjTypeInfo(IDeviceMonitor.class, true));
            sObjTypeMap.put(HOST_MONITOR_TYPE_NAME, new ObjTypeInfo(IHostMonitor.class, true));
            sObjTypeMap.put(DEVICE_MANAGER_TYPE_NAME, new ObjTypeInfo(IDeviceManager.class, false));
            sObjTypeMap.put(DEVICE_REQUIREMENTS_TYPE_NAME, new ObjTypeInfo(IDeviceSelection.class, false));
            sObjTypeMap.put(WTF_HANDLER_TYPE_NAME, new ObjTypeInfo(ITerribleFailureHandler.class, false));
            sObjTypeMap.put(SCHEDULER_TYPE_NAME, new ObjTypeInfo(ICommandScheduler.class, false));
            sObjTypeMap.put(MULTI_DEVICE_RECOVERY_TYPE_NAME, new ObjTypeInfo(IMultiDeviceRecovery.class, true));
            sObjTypeMap.put(KEY_STORE_TYPE_NAME, new ObjTypeInfo(IKeyStoreFactory.class, false));
            sObjTypeMap.put(SHARDING_STRATEGY_TYPE_NAME, new ObjTypeInfo(IShardHelper.class, false));
            sObjTypeMap.put(GLOBAL_CONFIG_SERVER, new ObjTypeInfo(IConfigurationServer.class, false));
            sObjTypeMap.put(SANDBOX_FACTORY_TYPE_NAME, new ObjTypeInfo(ISandboxFactory.class, false));
            sObjTypeMap.put(RESOURCE_METRIC_COLLECTOR_TYPE_NAME, new ObjTypeInfo(IResourceMetricCollector.class, true));
            sObjTypeMap.put(CREDENTIAL_FACTORY_TYPE_NAME, new ObjTypeInfo(ICredentialFactory.class, false));
        }
        return sObjTypeMap;
    }

    GlobalConfiguration(String name, String description) {
        this.mName = name;
        this.mDescription = description;
        this.mConfigMap = new LinkedHashMap<String, List<Object>>();
        this.mOptionMap = new MultiMap();
        this.mOriginalArgs = new String[]{DEFAULT_EMPTY_CONFIG_NAME};
        this.setHostOptions(new HostOptions());
        this.setHostResourceManager(new LocalHostResourceManager());
        this.setDeviceRequirements(new DeviceSelectionOptions());
        this.setDeviceManager(new DeviceManager());
        this.setCommandScheduler(new CommandScheduler());
        this.setKeyStoreFactory(new StubKeyStoreFactory());
        this.setShardingStrategy(new StrictShardHelper());
        this.setSandboxFactory(new TradefedSandboxFactory());
    }

    @Override
    public void setOriginalConfig(String config) {
        this.mOriginalArgs = new String[]{config};
    }

    @Override
    public void setup() throws ConfigurationException {
        this.getHostResourceManager().setup();
    }

    @Override
    public void cleanup() {
        this.getHostResourceManager().cleanup();
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public IHostOptions getHostOptions() {
        return (IHostOptions)this.getConfigurationObject(HOST_OPTIONS_TYPE_NAME);
    }

    @Override
    public IHostResourceManager getHostResourceManager() {
        return (IHostResourceManager)this.getConfigurationObject(HOST_RESOURCE_MANAGER_TYPE_NAME);
    }

    @Override
    public List<IDeviceMonitor> getDeviceMonitors() {
        return this.getConfigurationObjectList(DEVICE_MONITOR_TYPE_NAME);
    }

    @Override
    public IConfigurationServer getGlobalConfigServer() {
        return (IConfigurationServer)this.getConfigurationObject(GLOBAL_CONFIG_SERVER);
    }

    @Override
    public List<IHostMonitor> getHostMonitors() {
        return this.getConfigurationObjectList(HOST_MONITOR_TYPE_NAME);
    }

    @Override
    public ITerribleFailureHandler getWtfHandler() {
        return (ITerribleFailureHandler)this.getConfigurationObject(WTF_HANDLER_TYPE_NAME);
    }

    @Override
    public IKeyStoreFactory getKeyStoreFactory() {
        return (IKeyStoreFactory)this.getConfigurationObject(KEY_STORE_TYPE_NAME);
    }

    @Override
    public IShardHelper getShardingStrategy() {
        return (IShardHelper)this.getConfigurationObject(SHARDING_STRATEGY_TYPE_NAME);
    }

    @Override
    public IDeviceManager getDeviceManager() {
        return (IDeviceManager)this.getConfigurationObject(DEVICE_MANAGER_TYPE_NAME);
    }

    @Override
    public ISandboxFactory getSandboxFactory() {
        return (ISandboxFactory)this.getConfigurationObject(SANDBOX_FACTORY_TYPE_NAME);
    }

    @Override
    public IDeviceSelection getDeviceRequirements() {
        return (IDeviceSelection)this.getConfigurationObject(DEVICE_REQUIREMENTS_TYPE_NAME);
    }

    @Override
    public ICommandScheduler getCommandScheduler() {
        return (ICommandScheduler)this.getConfigurationObject(SCHEDULER_TYPE_NAME);
    }

    @Override
    public List<IMultiDeviceRecovery> getMultiDeviceRecoveryHandlers() {
        return this.getConfigurationObjectList(MULTI_DEVICE_RECOVERY_TYPE_NAME);
    }

    @Override
    public List<IResourceMetricCollector> getResourceMetricCollectors() {
        return this.getConfigurationObjectList(RESOURCE_METRIC_COLLECTOR_TYPE_NAME);
    }

    @Override
    public ICredentialFactory getCredentialFactory() {
        return (ICredentialFactory)this.getConfigurationObject(CREDENTIAL_FACTORY_TYPE_NAME);
    }

    private List<?> getConfigurationObjectList(String typeName) {
        return this.mConfigMap.get(typeName);
    }

    @Override
    public Object getConfigurationObject(String typeName) {
        List<?> configObjects = this.getConfigurationObjectList(typeName);
        if (configObjects == null) {
            return null;
        }
        ObjTypeInfo typeInfo = GlobalConfiguration.getObjTypeMap().get(typeName);
        if (typeInfo != null && typeInfo.mIsListSupported) {
            throw new IllegalStateException(String.format("Wrong method call for type %s. Used getConfigurationObject() for a config object that is stored as a list", typeName));
        }
        if (configObjects.size() != 1) {
            throw new IllegalStateException(String.format("Attempted to retrieve single object for %s, but %d are present", typeName, configObjects.size()));
        }
        return configObjects.get(0);
    }

    private Collection<Object> getAllConfigurationObjects() {
        ArrayList<Object> objectsCopy = new ArrayList<Object>();
        for (List<Object> objectList : this.mConfigMap.values()) {
            objectsCopy.addAll(objectList);
        }
        return objectsCopy;
    }

    @Override
    public void injectOptionValue(String optionName, String optionValue) throws ConfigurationException {
        this.injectOptionValue(optionName, null, optionValue);
    }

    @Override
    public void injectOptionValue(String optionName, String optionKey, String optionValue) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionValue(optionName, optionKey, optionValue);
        if (optionKey != null) {
            this.mOptionMap.put(optionName, optionKey + "=" + optionValue);
        } else {
            this.mOptionMap.put(optionName, optionValue);
        }
    }

    @Override
    public List<String> getOptionValues(String optionName) {
        return this.mOptionMap.get(optionName);
    }

    @Override
    public void setHostOptions(IHostOptions hostOptions) {
        this.setConfigurationObjectNoThrow(HOST_OPTIONS_TYPE_NAME, hostOptions);
    }

    @Override
    public void setHostResourceManager(IHostResourceManager hostResourceManager) {
        this.setConfigurationObjectNoThrow(HOST_RESOURCE_MANAGER_TYPE_NAME, hostResourceManager);
    }

    @Override
    public void setDeviceMonitor(IDeviceMonitor monitor) {
        this.setConfigurationObjectNoThrow(DEVICE_MONITOR_TYPE_NAME, monitor);
    }

    @Override
    public void setHostMonitors(List<IHostMonitor> hostMonitors) {
        this.setConfigurationObjectListNoThrow(HOST_MONITOR_TYPE_NAME, hostMonitors);
    }

    @Override
    public void setWtfHandler(ITerribleFailureHandler wtfHandler) {
        this.setConfigurationObjectNoThrow(WTF_HANDLER_TYPE_NAME, wtfHandler);
    }

    @Override
    public void setKeyStoreFactory(IKeyStoreFactory factory) {
        this.setConfigurationObjectNoThrow(KEY_STORE_TYPE_NAME, factory);
    }

    @Override
    public void setShardingStrategy(IShardHelper sharding) {
        this.setConfigurationObjectNoThrow(SHARDING_STRATEGY_TYPE_NAME, sharding);
    }

    @Override
    public void setDeviceManager(IDeviceManager manager) {
        this.setConfigurationObjectNoThrow(DEVICE_MANAGER_TYPE_NAME, manager);
    }

    @Override
    public void setDeviceRequirements(IDeviceSelection devRequirements) {
        this.setConfigurationObjectNoThrow(DEVICE_REQUIREMENTS_TYPE_NAME, devRequirements);
    }

    @Override
    public void setCommandScheduler(ICommandScheduler scheduler) {
        this.setConfigurationObjectNoThrow(SCHEDULER_TYPE_NAME, scheduler);
    }

    @Override
    public void setSandboxFactory(ISandboxFactory factory) {
        this.setConfigurationObjectNoThrow(SANDBOX_FACTORY_TYPE_NAME, factory);
    }

    @Override
    public void setResourceMetricCollector(IResourceMetricCollector collector) {
        this.setConfigurationObjectNoThrow(RESOURCE_METRIC_COLLECTOR_TYPE_NAME, collector);
    }

    @Override
    public void setTradefedFeatureServer(TradefedFeatureServer server) {
        this.setConfigurationObjectNoThrow(TF_FEATURE_SERVER_NAME, server);
    }

    @Override
    public void setInvocationServer(TestInvocationManagementServer server) {
        this.setConfigurationObjectNoThrow(TF_INVOCATION_SERVER_NAME, server);
    }

    @Override
    public void setDeviceManagementServer(DeviceManagementGrpcServer server) {
        this.setConfigurationObjectNoThrow(TF_DEVICE_MANAGEMENT_SERVER_NAME, server);
    }

    @Override
    public TradefedFeatureServer getFeatureServer() {
        List<?> configObjects = this.getConfigurationObjectList(TF_FEATURE_SERVER_NAME);
        if (configObjects == null) {
            return null;
        }
        if (configObjects.size() != 1) {
            return null;
        }
        return (TradefedFeatureServer)configObjects.get(0);
    }

    @Override
    public TestInvocationManagementServer getTestInvocationManagementSever() {
        List<?> configObjects = this.getConfigurationObjectList(TF_INVOCATION_SERVER_NAME);
        if (configObjects == null) {
            return null;
        }
        if (configObjects.size() != 1) {
            return null;
        }
        return (TestInvocationManagementServer)configObjects.get(0);
    }

    @Override
    public DeviceManagementGrpcServer getDeviceManagementServer() {
        List<?> configObjects = this.getConfigurationObjectList(TF_DEVICE_MANAGEMENT_SERVER_NAME);
        if (configObjects == null) {
            return null;
        }
        if (configObjects.size() != 1) {
            return null;
        }
        return (DeviceManagementGrpcServer)configObjects.get(0);
    }

    @Override
    public void setConfigurationObject(String typeName, Object configObject) throws ConfigurationException {
        if (configObject == null) {
            throw new IllegalArgumentException("configObject cannot be null");
        }
        this.mConfigMap.remove(typeName);
        this.addObject(typeName, configObject);
    }

    @Override
    public void setConfigurationObjectList(String typeName, List<?> configList) throws ConfigurationException {
        if (configList == null) {
            throw new IllegalArgumentException("configList cannot be null");
        }
        this.mConfigMap.remove(typeName);
        for (Object configObject : configList) {
            this.addObject(typeName, configObject);
        }
    }

    private void setConfigurationObjectListNoThrow(String typeName, List<?> configList) {
        try {
            this.setConfigurationObjectList(typeName, configList);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void addObject(String typeName, Object configObject) throws ConfigurationException {
        ObjTypeInfo typeInfo;
        List<Object> objList = this.mConfigMap.get(typeName);
        if (objList == null) {
            objList = new ArrayList<Object>(1);
            this.mConfigMap.put(typeName, objList);
        }
        if ((typeInfo = GlobalConfiguration.getObjTypeMap().get(typeName)) != null && !typeInfo.mExpectedType.isInstance(configObject)) {
            throw new ConfigurationException(String.format("The config object %s is not the correct type. Expected %s, received %s", typeName, typeInfo.mExpectedType.getCanonicalName(), configObject.getClass().getCanonicalName()));
        }
        if (typeInfo != null && !typeInfo.mIsListSupported && objList.size() > 0) {
            throw new ConfigurationException(String.format("Only one config object allowed for %s, but multiple were specified.", typeName));
        }
        objList.add(configObject);
    }

    private void setConfigurationObjectNoThrow(String typeName, Object configObject) {
        try {
            this.setConfigurationObject(typeName, configObject);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public List<String> setOptionsFromCommandLineArgs(List<String> listArgs) throws ConfigurationException {
        ArgsOptionParser parser = new ArgsOptionParser(this.getAllConfigurationObjects());
        return parser.parse(listArgs);
    }

    public void printCommandUsage(boolean importantOnly, PrintStream out) throws ConfigurationException {
        out.println(String.format("'%s' configuration: %s", this.getName(), this.getDescription()));
        out.println();
        if (importantOnly) {
            out.println("Printing help for only the important options. To see help for all options, use the --help-all flag");
            out.println();
        }
        for (Map.Entry<String, List<Object>> configObjectsEntry : this.mConfigMap.entrySet()) {
            for (Object configObject : configObjectsEntry.getValue()) {
                String optionHelp = this.printOptionsForObject(importantOnly, configObjectsEntry.getKey(), configObject);
                if (optionHelp.length() <= 0) continue;
                String classAlias = "";
                if (configObject.getClass().isAnnotationPresent(OptionClass.class)) {
                    OptionClass classAnnotation = configObject.getClass().getAnnotation(OptionClass.class);
                    classAlias = String.format("'%s' ", classAnnotation.alias());
                }
                out.printf("  %s%s options:", classAlias, configObjectsEntry.getKey());
                out.println();
                out.print(optionHelp);
                out.println();
            }
        }
    }

    private String printOptionsForObject(boolean importantOnly, String objectTypeName, Object configObject) throws ConfigurationException {
        return ArgsOptionParser.getOptionHelp(importantOnly, configObject);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        ArgsOptionParser argsParser = new ArgsOptionParser(this.getAllConfigurationObjects());
        argsParser.validateMandatoryOptions();
        this.getHostOptions().validateOptions();
        LogUtil.CLog.d("Resolve and remote files from @Option");
        ArrayList<File> remoteFiles = new ArrayList<File>();
        try {
            remoteFiles.addAll(argsParser.validateRemoteFilePath(new DynamicRemoteFileResolver()));
        }
        catch (BuildRetrievalError e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        remoteFiles.forEach(File::deleteOnExit);
    }

    @Override
    public File cloneConfigWithFilter(String ... allowlistConfigs) throws IOException {
        return this.cloneConfigWithFilter(new HashSet<String>(), allowlistConfigs);
    }

    @Override
    public File cloneConfigWithFilter(Set<String> exclusionPatterns, String ... allowlistConfigs) throws IOException {
        return this.cloneConfigWithFilter(exclusionPatterns, new NoOpConfigOptionValueTransformer(), true, allowlistConfigs);
    }

    @Override
    public File cloneConfigWithFilter(Set<String> exclusionPatterns, IConfigOptionValueTransformer transformer, boolean deepCopy, String ... allowlistConfigs) throws IOException {
        IConfigurationFactory configFactory = this.getConfigurationFactory();
        IGlobalConfiguration copy = null;
        if (deepCopy) {
            try {
                copy = configFactory.createGlobalConfigurationFromArgs(this.mOriginalArgs, new ArrayList<String>());
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
        } else {
            copy = this;
        }
        File filteredGlobalConfig = FileUtil.createTempFile("filtered_global_config", ".config");
        KXmlSerializer serializer = ConfigurationUtil.createSerializer(filteredGlobalConfig);
        serializer.startTag(null, "configuration");
        if (allowlistConfigs == null || allowlistConfigs.length == 0) {
            allowlistConfigs = CONFIGS_FOR_SUBPROCESS_ALLOW_LIST;
        }
        for (String config : allowlistConfigs) {
            Object configObj = copy.getConfigurationObject(config);
            if (configObj == null) {
                LogUtil.CLog.d("Object '%s' was not found in global config.", config);
                continue;
            }
            String name = configObj.getClass().getCanonicalName();
            if (!this.shouldDump(name, exclusionPatterns)) continue;
            boolean isGenericObject = false;
            if (GlobalConfiguration.getObjTypeMap().get(config) == null) {
                isGenericObject = true;
            }
            ConfigurationUtil.dumpClassToXml(serializer, config, configObj, isGenericObject, new ArrayList<String>(), transformer, true, false);
        }
        serializer.endTag(null, "configuration");
        serializer.endDocument();
        return filteredGlobalConfig;
    }

    @Override
    public void setConfigurationFactory(IConfigurationFactory configFactory) {
        this.mConfigFactory = configFactory;
    }

    @VisibleForTesting
    protected IConfigurationFactory getConfigurationFactory() {
        return this.mConfigFactory;
    }

    private boolean shouldDump(String name, Set<String> patterns) {
        for (String pattern : patterns) {
            if (!Pattern.matches(pattern, name)) continue;
            return false;
        }
        return true;
    }

    private static class ObjTypeInfo {
        final Class<?> mExpectedType;
        final boolean mIsListSupported;

        ObjTypeInfo(Class<?> expectedType, boolean isList) {
            this.mExpectedType = expectedType;
            this.mIsListSupported = isList;
        }
    }
}

