/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.log.LogUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OptionCopier {
    public static void copyOptions(Object origObject, Object destObject) throws ConfigurationException {
        Collection<Field> origFields = OptionSetter.getOptionFieldsForClass(origObject.getClass());
        Map<String, Field> destFieldMap = OptionCopier.getFieldOptionMap(destObject);
        for (Field origField : origFields) {
            Option option = origField.getAnnotation(Option.class);
            Field destField = destFieldMap.remove(option.name());
            if (destField == null) continue;
            Object origValue = OptionSetter.getFieldValue(origField, origObject);
            OptionSetter.setFieldValue(option.name(), destObject, destField, origValue);
        }
    }

    public static void copyOptions(Object origObject, Object destObject, String optionName) throws ConfigurationException {
        Collection<Field> origFields = OptionSetter.getOptionFieldsForClass(origObject.getClass());
        Map<String, Field> destFieldMap = OptionCopier.getFieldOptionMap(destObject);
        for (Field origField : origFields) {
            Field destField;
            Option option = origField.getAnnotation(Option.class);
            if (!option.name().equals(optionName) || (destField = destFieldMap.remove(option.name())) == null) continue;
            Object origValue = OptionSetter.getFieldValue(origField, origObject);
            OptionSetter.setFieldValue(option.name(), destObject, destField, origValue);
        }
    }

    public static void copyOptionsNoThrow(Object source, Object dest) {
        try {
            OptionCopier.copyOptions(source, dest);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e(e);
        }
    }

    public static void copyOptionsNoThrow(Object source, Object dest, String optionName) {
        try {
            OptionCopier.copyOptions(source, dest, optionName);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e(e);
        }
    }

    private static Map<String, Field> getFieldOptionMap(Object destObject) {
        Collection<Field> destFields = OptionSetter.getOptionFieldsForClass(destObject.getClass());
        HashMap<String, Field> fieldMap = new HashMap<String, Field>(destFields.size());
        for (Field field : destFields) {
            Option o = field.getAnnotation(Option.class);
            fieldMap.put(o.name(), field);
        }
        return fieldMap;
    }
}

