/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionUpdateRule;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.TimeVal;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.google.common.base.Objects;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class OptionSetter {
    static final String BOOL_FALSE_PREFIX = "no-";
    private static final HashMap<Class<?>, Handler> handlers = new HashMap();
    public static final char NAMESPACE_SEPARATOR = ':';
    static final Pattern USE_KEYSTORE_REGEX = Pattern.compile("USE_KEYSTORE@(.*)");
    private IKeyStoreClient mKeyStoreClient = null;
    private final Collection<Object> mOptionSources;
    private final Map<String, OptionFieldsForName> mOptionMap;

    private static Handler getHandler(Type type) throws ConfigurationException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawClass)) {
                Type actualType = parameterizedType.getActualTypeArguments()[0];
                if (!(actualType instanceof Class)) {
                    throw new ConfigurationException("cannot handle nested parameterized type " + type);
                }
                return OptionSetter.getHandler(actualType);
            }
            if (Map.class.isAssignableFrom(rawClass) || MultiMap.class.isAssignableFrom(rawClass)) {
                Type keyType = parameterizedType.getActualTypeArguments()[0];
                Type valueType = parameterizedType.getActualTypeArguments()[1];
                if (!(keyType instanceof Class)) {
                    throw new ConfigurationException("cannot handle nested parameterized type " + keyType);
                }
                if (!(valueType instanceof Class)) {
                    throw new ConfigurationException("cannot handle nested parameterized type " + valueType);
                }
                return new MapHandler(OptionSetter.getHandler(keyType), OptionSetter.getHandler(valueType));
            }
            throw new ConfigurationException(String.format("can't handle parameterized type %s; only Collection, Map, and MultiMap are supported", type));
        }
        if (type instanceof Class) {
            Class cType = (Class)type;
            if (cType.isEnum()) {
                return new EnumHandler(cType);
            }
            if (Collection.class.isAssignableFrom(cType)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized collection %s.  Use a generic Collection to specify a desired element type.", type));
            }
            if (Map.class.isAssignableFrom(cType)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized map %s.  Use a generic Map to specify desired element types.", type));
            }
            if (MultiMap.class.isAssignableFrom(cType)) {
                throw new ConfigurationException(String.format("Cannot handle non-parameterized multimap %s.  Use a generic MultiMap to specify desired element types.", type));
            }
            return handlers.get(cType);
        }
        throw new ConfigurationException(String.format("cannot handle unknown field type %s", type));
    }

    private Handler getHandlerOrTimeVal(Field field, Object optionSource) throws ConfigurationException {
        Option option = field.getAnnotation(Option.class);
        if (option == null) {
            throw new ConfigurationException(String.format("internal error: @Option annotation for field %s in class %s was unexpectedly null", field.getName(), optionSource.getClass().getName()));
        }
        Type type = field.getGenericType();
        if (option.isTimeVal()) {
            if (type instanceof Class) {
                Class cType = (Class)type;
                if (Long.TYPE.equals(cType) || Long.class.equals((Object)cType)) {
                    return new TimeValLongHandler();
                }
                if (TimeVal.class.equals((Object)cType)) {
                    return new TimeValHandler();
                }
            }
            throw new ConfigurationException(String.format("Only fields of type long, Long, or TimeVal may be declared as isTimeVal.  Field %s has incompatible type %s.", field.getName(), field.getGenericType()));
        }
        return OptionSetter.getHandler(type);
    }

    public OptionSetter(Object ... optionSources) throws ConfigurationException {
        this(Arrays.asList(optionSources));
    }

    public OptionSetter(Collection<Object> optionSources) throws ConfigurationException {
        this.mOptionSources = optionSources;
        this.mOptionMap = this.makeOptionMap();
    }

    public void setKeyStore(IKeyStoreClient keyStore) {
        this.mKeyStoreClient = keyStore;
    }

    public IKeyStoreClient getKeyStore() {
        return this.mKeyStoreClient;
    }

    private OptionFieldsForName fieldsForArg(String name) throws ConfigurationException {
        OptionFieldsForName fields = this.fieldsForArgNoThrow(name);
        if (fields == null) {
            throw new ConfigurationException(String.format("Could not find option with name '%s'", name), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        return fields;
    }

    OptionFieldsForName fieldsForArgNoThrow(String name) {
        OptionFieldsForName fields = this.mOptionMap.get(name);
        if (fields == null || fields.size() == 0) {
            return null;
        }
        return fields;
    }

    public String getTypeForOption(String name) throws ConfigurationException {
        return this.fieldsForArg(name).getFirstField().getType().getSimpleName().toLowerCase();
    }

    public List<FieldDef> setOptionValue(String optionName, String valueText) throws ConfigurationException {
        return this.setOptionValue(optionName, null, valueText);
    }

    public List<FieldDef> setOptionValue(String optionName, String keyText, String valueText) throws ConfigurationException {
        ArrayList<FieldDef> ret = new ArrayList<FieldDef>();
        OptionFieldsForName optionFields = this.fieldsForArg(optionName);
        for (Map.Entry<Object, Field> fieldEntry : optionFields) {
            Object optionSource = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            Handler handler = this.getHandlerOrTimeVal(field, optionSource);
            Object value = handler.translate(valueText);
            if (value == null) {
                String type = field.getType().getSimpleName();
                if (handler.isMap()) {
                    ParameterizedType pType = (ParameterizedType)field.getGenericType();
                    Type valueType = pType.getActualTypeArguments()[1];
                    type = ((Class)valueType).getSimpleName().toLowerCase();
                }
                throw new ConfigurationException(String.format("Couldn't convert value '%s' to a %s for option '%s'", valueText, type, optionName), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            Object key = null;
            if (handler.isMap() && (key = ((MapHandler)handler).translateKey(keyText)) == null) {
                ParameterizedType pType = (ParameterizedType)field.getGenericType();
                Type keyType = pType.getActualTypeArguments()[0];
                String type = ((Class)keyType).getSimpleName().toLowerCase();
                throw new ConfigurationException(String.format("Couldn't convert key '%s' to a %s for option '%s'", keyText, type, optionName), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            if (!OptionSetter.setFieldValue(optionName, optionSource, field, key, value)) continue;
            ret.add(new FieldDef(optionSource, field, key));
        }
        return ret;
    }

    static boolean setFieldValue(String optionName, Object optionSource, Field field, Object key, Object value) throws ConfigurationException {
        boolean fieldWasSet = true;
        try {
            field.setAccessible(true);
            if (Collection.class.isAssignableFrom(field.getType())) {
                if (key != null) {
                    throw new ConfigurationException(String.format("key not applicable for Collection field '%s'", field.getName()));
                }
                Collection collection = (Collection)field.get(optionSource);
                if (collection == null) {
                    throw new ConfigurationException(String.format("Unable to add value to field '%s'. Field is null.", field.getName()));
                }
                ParameterizedType pType = (ParameterizedType)field.getGenericType();
                Type fieldType = pType.getActualTypeArguments()[0];
                if (value instanceof Collection) {
                    collection.addAll((Collection)value);
                } else {
                    if (!((Class)fieldType).isInstance(value)) {
                        throw new ConfigurationException(String.format("Value '%s' is not of type '%s' like the Collection.", value, fieldType));
                    }
                    collection.add(value);
                }
            } else if (Map.class.isAssignableFrom(field.getType())) {
                Map map = (Map)field.get(optionSource);
                if (map == null) {
                    throw new ConfigurationException(String.format("Unable to add value to field '%s'. Field is null.", field.getName()));
                }
                if (value instanceof Map) {
                    if (key != null) {
                        throw new ConfigurationException(String.format("Key not applicable when setting Map field '%s' from map value", field.getName()));
                    }
                    map.putAll((Map)value);
                } else {
                    if (key == null) {
                        throw new ConfigurationException(String.format("Unable to add value to map field '%s'. Key is null.", field.getName()));
                    }
                    map.put(key, value);
                }
            } else if (MultiMap.class.isAssignableFrom(field.getType())) {
                MultiMap map = (MultiMap)field.get(optionSource);
                if (map == null) {
                    throw new ConfigurationException(String.format("Unable to add value to field '%s'. Field is null.", field.getName()));
                }
                if (value instanceof MultiMap) {
                    if (key != null) {
                        throw new ConfigurationException(String.format("Key not applicable when setting Map field '%s' from map value", field.getName()));
                    }
                    map.putAll((MultiMap)value);
                } else {
                    if (key == null) {
                        throw new ConfigurationException(String.format("Unable to add value to map field '%s'. Key is null.", field.getName()));
                    }
                    map.put(key, value);
                }
            } else {
                if (key != null) {
                    throw new ConfigurationException(String.format("Key not applicable when setting non-map field '%s'", field.getName()));
                }
                Option option = field.getAnnotation(Option.class);
                if (option == null) {
                    throw new ConfigurationException(String.format("internal error: @Option annotation for field %s in class %s was unexpectedly null", field.getName(), optionSource.getClass().getName()));
                }
                OptionUpdateRule rule = option.updateRule();
                if (rule.shouldUpdate(optionName, optionSource, field, value)) {
                    Object curValue = field.get(optionSource);
                    if (value == null || value.equals(curValue)) {
                        fieldWasSet = false;
                    } else {
                        field.set(optionSource, value);
                    }
                } else {
                    fieldWasSet = false;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e);
        }
        return fieldWasSet;
    }

    static void setFieldValue(String optionName, Object optionSource, Field field, Object value) throws ConfigurationException {
        OptionSetter.setFieldValue(optionName, optionSource, field, null, value);
    }

    private Map<String, OptionFieldsForName> makeOptionMap() throws ConfigurationException {
        HashMap<String, Integer> freqMap = new HashMap<String, Integer>(this.mOptionSources.size());
        LinkedHashMap<String, OptionFieldsForName> optionMap = new LinkedHashMap<String, OptionFieldsForName>();
        for (Object objectSource : this.mOptionSources) {
            String className = objectSource.getClass().getName();
            Integer index = (Integer)freqMap.get(className);
            index = index == null ? 1 : index + 1;
            freqMap.put(className, index);
            this.addOptionsForObject(objectSource, optionMap, index, null);
            if (!(objectSource instanceof IDeviceConfiguration)) continue;
            for (Object deviceObject : ((IDeviceConfiguration)objectSource).getAllObjects()) {
                index = (Integer)freqMap.get(deviceObject.getClass().getName());
                index = index == null ? 1 : index + 1;
                freqMap.put(deviceObject.getClass().getName(), index);
                Integer tracked = ((IDeviceConfiguration)objectSource).getFrequency(deviceObject);
                if (tracked != null && !index.equals(tracked)) {
                    index = tracked;
                }
                this.addOptionsForObject(deviceObject, optionMap, index, ((IDeviceConfiguration)objectSource).getDeviceName());
            }
        }
        return optionMap;
    }

    private void addOptionsForObject(Object optionSource, Map<String, OptionFieldsForName> optionMap, int index, String deviceName) throws ConfigurationException {
        Collection<Field> optionFields = OptionSetter.getOptionFieldsForClass(optionSource.getClass());
        for (Field field : optionFields) {
            Option option = field.getAnnotation(Option.class);
            if (option.name().indexOf(58) != -1) {
                throw new ConfigurationException(String.format("Option name '%s' in class '%s' is invalid. Option names cannot contain the namespace separator character '%c'", option.name(), optionSource.getClass().getName(), Character.valueOf(':')));
            }
            Type type = field.getGenericType();
            if (type instanceof Class && !(type instanceof ParameterizedType)) {
                Class cType;
                if (!(option.updateRule() != OptionUpdateRule.GREATEST && option.updateRule() != OptionUpdateRule.LEAST || Comparable.class.isAssignableFrom(cType = (Class)type))) {
                    throw new ConfigurationException(String.format("Option '%s' in class '%s' attempts to use updateRule %s with non-Comparable type '%s'.", new Object[]{option.name(), optionSource.getClass().getName(), option.updateRule(), field.getGenericType()}));
                }
                if ((field.getModifiers() & 0x10) != 0) {
                    throw new ConfigurationException(String.format("Option '%s' in class '%s' is final and cannot be set", option.name(), optionSource.getClass().getName()));
                }
            }
            boolean addToGlobalNamespace = true;
            if (optionSource.getClass().isAnnotationPresent(OptionClass.class)) {
                OptionClass classAnnotation = optionSource.getClass().getAnnotation(OptionClass.class);
                addToGlobalNamespace = classAnnotation.global_namespace();
            }
            if (addToGlobalNamespace) {
                this.addNameToMap(optionMap, optionSource, option.name(), field);
                if (deviceName != null) {
                    this.addNameToMap(optionMap, optionSource, String.format("{%s}%s", deviceName, option.name()), field);
                }
            }
            this.addNamespacedOptionToMap(optionMap, optionSource, option.name(), field, index, deviceName);
            if (option.shortName() != '0') {
                if (addToGlobalNamespace) {
                    this.addNameToMap(optionMap, optionSource, String.valueOf(option.shortName()), field);
                }
                this.addNamespacedOptionToMap(optionMap, optionSource, String.valueOf(option.shortName()), field, index, deviceName);
            }
            if (!OptionSetter.isBooleanField(field)) continue;
            if (addToGlobalNamespace) {
                this.addNameToMap(optionMap, optionSource, BOOL_FALSE_PREFIX + option.name(), field);
                if (deviceName != null) {
                    this.addNameToMap(optionMap, optionSource, String.format("{%s}%s", deviceName, BOOL_FALSE_PREFIX + option.name()), field);
                }
            }
            this.addNamespacedOptionToMap(optionMap, optionSource, BOOL_FALSE_PREFIX + option.name(), field, index, deviceName);
        }
    }

    protected Collection<String> getUnsetMandatoryOptions() throws ConfigurationException {
        HashSet<String> unsetOptions = new HashSet<String>();
        for (Map.Entry<String, OptionFieldsForName> optionPair : this.mOptionMap.entrySet()) {
            String optName = optionPair.getKey();
            OptionFieldsForName optionFields = optionPair.getValue();
            if (optName.indexOf(58) >= 0) continue;
            for (Map.Entry<Object, Field> fieldEntry : optionFields) {
                Object m;
                Object value;
                Object obj = fieldEntry.getKey();
                Field field = fieldEntry.getValue();
                Option option = field.getAnnotation(Option.class);
                if (option == null || !option.mandatory()) continue;
                field.setAccessible(true);
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException(String.format("internal error: %s", e.getMessage()));
                }
                String realOptName = String.format("--%s", option.name());
                if (value == null) {
                    unsetOptions.add(realOptName);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    if (!c.isEmpty()) continue;
                    unsetOptions.add(realOptName);
                    continue;
                }
                if (value instanceof Map) {
                    m = (Map)value;
                    if (!m.isEmpty()) continue;
                    unsetOptions.add(realOptName);
                    continue;
                }
                if (!(value instanceof MultiMap) || !((MultiMap)(m = (MultiMap)value)).isEmpty()) continue;
                unsetOptions.add(realOptName);
            }
        }
        return unsetOptions;
    }

    public final Set<File> validateRemoteFilePath(DynamicRemoteFileResolver resolver) throws BuildRetrievalError {
        resolver.setOptionMap(this.mOptionMap);
        return resolver.validateRemoteFilePath();
    }

    public static Collection<Field> getOptionFieldsForClass(Class<?> optionClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        OptionSetter.buildOptionFieldsForClass(optionClass, fieldList);
        return fieldList;
    }

    private static void buildOptionFieldsForClass(Class<?> optionClass, Collection<Field> optionFields) {
        for (Field field : optionClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            optionFields.add(field);
        }
        Class<?> superClass = optionClass.getSuperclass();
        if (superClass != null) {
            OptionSetter.buildOptionFieldsForClass(superClass, optionFields);
        }
    }

    static String getFieldValueAsString(Field field, Object optionObject) {
        MultiMap multimap;
        Map map;
        Collection collection;
        Object fieldValue = OptionSetter.getFieldValue(field, optionObject);
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Collection ? (collection = (Collection)fieldValue).isEmpty() : (fieldValue instanceof Map ? (map = (Map)fieldValue).isEmpty() : fieldValue instanceof MultiMap && (multimap = (MultiMap)fieldValue).isEmpty())) {
            return null;
        }
        return fieldValue.toString();
    }

    public static Object getFieldValue(Field field, Object optionObject) {
        try {
            field.setAccessible(true);
            return field.get(optionObject);
        }
        catch (IllegalArgumentException e) {
            LogUtil.CLog.w("Could not read value for field %s in class %s. Reason: %s", field.getName(), optionObject.getClass().getName(), e);
            return null;
        }
        catch (IllegalAccessException e) {
            LogUtil.CLog.w("Could not read value for field %s in class %s. Reason: %s", field.getName(), optionObject.getClass().getName(), e);
            return null;
        }
    }

    static String getEnumFieldValuesAsString(Field field) {
        Class<?> type = field.getType();
        Object[] vals = type.getEnumConstants();
        if (vals == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" Valid values: [");
        sb.append(ArrayUtil.join(", ", vals));
        sb.append("]");
        return sb.toString();
    }

    public boolean isBooleanOption(String name) throws ConfigurationException {
        Field field = this.fieldsForArg(name).getFirstField();
        return OptionSetter.isBooleanField(field);
    }

    static boolean isBooleanField(Field field) throws ConfigurationException {
        return OptionSetter.getHandler(field.getGenericType()).isBoolean();
    }

    public boolean isMapOption(String name) throws ConfigurationException {
        Field field = this.fieldsForArg(name).getFirstField();
        return OptionSetter.isMapField(field);
    }

    static boolean isMapField(Field field) throws ConfigurationException {
        return OptionSetter.getHandler(field.getGenericType()).isMap();
    }

    private void addNameToMap(Map<String, OptionFieldsForName> optionMap, Object optionSource, String name, Field field) throws ConfigurationException {
        OptionFieldsForName fields = optionMap.get(name);
        if (fields == null) {
            fields = new OptionFieldsForName();
            optionMap.put(name, fields);
        }
        fields.addField(name, optionSource, field);
        if (OptionSetter.getHandler(field.getGenericType()) == null) {
            throw new ConfigurationException(String.format("Option name '%s' in class '%s' is invalid. Unsupported @Option field type '%s'", name, optionSource.getClass().getName(), field.getType()));
        }
    }

    private void addNamespacedOptionToMap(Map<String, OptionFieldsForName> optionMap, Object optionSource, String name, Field field, int index, String deviceName) throws ConfigurationException {
        String className = optionSource.getClass().getName();
        if (optionSource.getClass().isAnnotationPresent(OptionClass.class)) {
            OptionClass classAnnotation = optionSource.getClass().getAnnotation(OptionClass.class);
            this.addNamespacedAliasOptionToMap(optionMap, optionSource, name, field, index, deviceName, classAnnotation.alias());
        }
        this.addNameToMap(optionMap, optionSource, String.format("%s%c%s", className, Character.valueOf(':'), name), field);
        this.addNameToMap(optionMap, optionSource, String.format("%s%c%d%c%s", className, Character.valueOf(':'), index, Character.valueOf(':'), name), field);
        if (deviceName != null) {
            this.addNameToMap(optionMap, optionSource, String.format("{%s}%s%c%s", deviceName, className, Character.valueOf(':'), name), field);
            this.addNameToMap(optionMap, optionSource, String.format("{%s}%s%c%d%c%s", deviceName, className, Character.valueOf(':'), index, Character.valueOf(':'), name), field);
        }
    }

    private void addNamespacedAliasOptionToMap(Map<String, OptionFieldsForName> optionMap, Object optionSource, String name, Field field, int index, String deviceName, String alias) throws ConfigurationException {
        this.addNameToMap(optionMap, optionSource, String.format("%s%c%s", alias, Character.valueOf(':'), name), field);
        this.addNameToMap(optionMap, optionSource, String.format("%s%c%d%c%s", alias, Character.valueOf(':'), index, Character.valueOf(':'), name), field);
        if (deviceName != null) {
            this.addNameToMap(optionMap, optionSource, String.format("{%s}%s%c%s", deviceName, alias, Character.valueOf(':'), name), field);
            this.addNameToMap(optionMap, optionSource, String.format("{%s}%s%c%d%c%s", deviceName, alias, Character.valueOf(':'), index, Character.valueOf(':'), name), field);
        }
    }

    static {
        handlers.put(Boolean.TYPE, new BooleanHandler());
        handlers.put(Boolean.class, new BooleanHandler());
        handlers.put(Byte.TYPE, new ByteHandler());
        handlers.put(Byte.class, new ByteHandler());
        handlers.put(Short.TYPE, new ShortHandler());
        handlers.put(Short.class, new ShortHandler());
        handlers.put(Integer.TYPE, new IntegerHandler());
        handlers.put(Integer.class, new IntegerHandler());
        handlers.put(Long.TYPE, new LongHandler());
        handlers.put(Long.class, new LongHandler());
        handlers.put(Float.TYPE, new FloatHandler());
        handlers.put(Float.class, new FloatHandler());
        handlers.put(Double.TYPE, new DoubleHandler());
        handlers.put(Double.class, new DoubleHandler());
        handlers.put(String.class, new StringHandler());
        handlers.put(File.class, new FileHandler());
        handlers.put(TimeVal.class, new TimeValHandler());
        handlers.put(Pattern.class, new PatternHandler());
        handlers.put(Duration.class, new DurationHandler());
    }

    private static abstract class Handler<T> {
        private Handler() {
        }

        boolean isBoolean() {
            return false;
        }

        boolean isMap() {
            return false;
        }

        abstract T translate(String var1);
    }

    private static class MapHandler
    extends Handler {
        private Handler mKeyHandler;
        private Handler mValueHandler;

        MapHandler(Handler keyHandler, Handler valueHandler) {
            if (keyHandler == null || valueHandler == null) {
                throw new NullPointerException();
            }
            this.mKeyHandler = keyHandler;
            this.mValueHandler = valueHandler;
        }

        Handler getKeyHandler() {
            return this.mKeyHandler;
        }

        Handler getValueHandler() {
            return this.mValueHandler;
        }

        @Override
        boolean isMap() {
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(MapHandler.class, this.mKeyHandler, this.mValueHandler);
        }

        public boolean equals(Object otherObj) {
            if (otherObj != null && otherObj instanceof MapHandler) {
                MapHandler other = (MapHandler)otherObj;
                Handler otherKeyHandler = other.getKeyHandler();
                Handler otherValueHandler = other.getValueHandler();
                return this.mKeyHandler.equals(otherKeyHandler) && this.mValueHandler.equals(otherValueHandler);
            }
            return false;
        }

        Object translate(String valueText) {
            return this.mValueHandler.translate(valueText);
        }

        Object translateKey(String keyText) {
            return this.mKeyHandler.translate(keyText);
        }
    }

    private static class EnumHandler
    extends Handler {
        private final Class mEnumType;

        EnumHandler(Class<?> enumType) {
            this.mEnumType = enumType;
        }

        Class<?> getEnumType() {
            return this.mEnumType;
        }

        public int hashCode() {
            return Objects.hashCode(EnumHandler.class, this.mEnumType);
        }

        public boolean equals(Object otherObj) {
            if (otherObj != null && otherObj instanceof EnumHandler) {
                EnumHandler other = (EnumHandler)otherObj;
                Class<?> otherType = other.getEnumType();
                return this.mEnumType.isAssignableFrom(otherType) && otherType.isAssignableFrom(this.mEnumType);
            }
            return false;
        }

        Object translate(String valueText) {
            return this.translate(valueText, true);
        }

        Object translate(String valueText, boolean shouldTryUpperCase) {
            try {
                return Enum.valueOf(this.mEnumType, valueText);
            }
            catch (IllegalArgumentException e) {
                if (shouldTryUpperCase) {
                    return this.translate(valueText.toUpperCase(Locale.ENGLISH), false);
                }
                return null;
            }
        }
    }

    private static class TimeValLongHandler
    extends Handler<Long> {
        private TimeValLongHandler() {
        }

        @Override
        Long translate(String valueText) {
            try {
                return TimeVal.fromString(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class TimeValHandler
    extends Handler<TimeVal> {
        private TimeValHandler() {
        }

        @Override
        TimeVal translate(String valueText) {
            try {
                return new TimeVal(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    protected class OptionFieldsForName
    implements Iterable<Map.Entry<Object, Field>> {
        private Map<Object, Field> mSourceFieldMap = new LinkedHashMap<Object, Field>();

        protected OptionFieldsForName() {
        }

        void addField(String name, Object source, Field field) throws ConfigurationException {
            if (this.size() > 0) {
                Handler existingFieldHandler = OptionSetter.getHandler(this.getFirstField().getGenericType());
                Handler newFieldHandler = OptionSetter.getHandler(field.getGenericType());
                if (existingFieldHandler == null || newFieldHandler == null || !existingFieldHandler.getClass().equals(newFieldHandler.getClass())) {
                    throw new ConfigurationException(String.format("@Option field with name '%s' in class '%s' is defined with a different type than same option in class '%s'", name, source.getClass().getName(), this.getFirstObject().getClass().getName()));
                }
            }
            if (this.mSourceFieldMap.put(source, field) != null) {
                throw new ConfigurationException(String.format("@Option field with name '%s' is defined more than once in class '%s'", name, source.getClass().getName()));
            }
        }

        public int size() {
            return this.mSourceFieldMap.size();
        }

        public Field getFirstField() throws ConfigurationException {
            if (this.size() <= 0) {
                throw new ConfigurationException("no option fields found");
            }
            return this.mSourceFieldMap.values().iterator().next();
        }

        public Object getFirstObject() throws ConfigurationException {
            if (this.size() <= 0) {
                throw new ConfigurationException("no option fields found");
            }
            return this.mSourceFieldMap.keySet().iterator().next();
        }

        @Override
        public Iterator<Map.Entry<Object, Field>> iterator() {
            return this.mSourceFieldMap.entrySet().iterator();
        }
    }

    static class FieldDef {
        Object object;
        Field field;
        Object key;

        FieldDef(Object object, Field field, Object key) {
            this.object = object;
            this.field = field;
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FieldDef) {
                FieldDef other = (FieldDef)obj;
                return Objects.equal(this.object, other.object) && Objects.equal(this.field, other.field) && Objects.equal(this.key, other.key);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.object, this.field, this.key);
        }
    }

    private static class BooleanHandler
    extends Handler<Boolean> {
        private BooleanHandler() {
        }

        @Override
        boolean isBoolean() {
            return true;
        }

        @Override
        Boolean translate(String valueText) {
            if (valueText.equalsIgnoreCase("true") || valueText.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (valueText.equalsIgnoreCase("false") || valueText.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    private static class ByteHandler
    extends Handler<Byte> {
        private ByteHandler() {
        }

        @Override
        Byte translate(String valueText) {
            try {
                return Byte.parseByte(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class ShortHandler
    extends Handler<Short> {
        private ShortHandler() {
        }

        @Override
        Short translate(String valueText) {
            try {
                return Short.parseShort(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class IntegerHandler
    extends Handler<Integer> {
        private IntegerHandler() {
        }

        @Override
        Integer translate(String valueText) {
            try {
                return Integer.parseInt(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class LongHandler
    extends Handler<Long> {
        private LongHandler() {
        }

        @Override
        Long translate(String valueText) {
            try {
                return Long.parseLong(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class FloatHandler
    extends Handler<Float> {
        private FloatHandler() {
        }

        @Override
        Float translate(String valueText) {
            try {
                return Float.valueOf(Float.parseFloat(valueText));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class DoubleHandler
    extends Handler<Double> {
        private DoubleHandler() {
        }

        @Override
        Double translate(String valueText) {
            try {
                return Double.parseDouble(valueText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    private static class StringHandler
    extends Handler<String> {
        private StringHandler() {
        }

        @Override
        String translate(String valueText) {
            return valueText;
        }
    }

    private static class FileHandler
    extends Handler<File> {
        private FileHandler() {
        }

        @Override
        File translate(String valueText) {
            return new File(valueText);
        }
    }

    private static class PatternHandler
    extends Handler<Pattern> {
        private PatternHandler() {
        }

        @Override
        Pattern translate(String valueText) {
            try {
                return Pattern.compile(valueText);
            }
            catch (PatternSyntaxException ex) {
                return null;
            }
        }
    }

    private static class DurationHandler
    extends Handler<Duration> {
        private DurationHandler() {
        }

        @Override
        Duration translate(String valueText) {
            try {
                return Duration.ofMillis(TimeVal.fromString(valueText));
            }
            catch (NumberFormatException numberFormatException) {
                return Duration.parse(valueText);
            }
        }
    }
}

