/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import java.lang.reflect.Field;

public enum OptionUpdateRule {
    FIRST{

        @Override
        boolean shouldUpdate(String optionName, Object current, Object update) throws ConfigurationException {
            return current == null;
        }
    }
    ,
    LAST{

        @Override
        boolean shouldUpdate(String optionName, Object current, Object update) throws ConfigurationException {
            return true;
        }
    }
    ,
    GREATEST{

        @Override
        boolean shouldUpdate(String optionName, Object current, Object update) throws ConfigurationException {
            return current == null || OptionUpdateRule.compare(optionName, current, update) < 0;
        }
    }
    ,
    LEAST{

        @Override
        boolean shouldUpdate(String optionName, Object current, Object update) throws ConfigurationException {
            return current == null || OptionUpdateRule.compare(optionName, current, update) > 0;
        }
    }
    ,
    IMMUTABLE{

        @Override
        boolean shouldUpdate(String optionName, Object current, Object update) throws ConfigurationException {
            if (current != null) {
                throw new ConfigurationException(String.format("Attempted to update immutable value (%s) for option \"%s\"", optionName, optionName));
            }
            return true;
        }
    };


    abstract boolean shouldUpdate(String var1, Object var2, Object var3) throws ConfigurationException;

    public boolean shouldUpdate(String optionName, Object optionSource, Field field, Object update) throws ConfigurationException {
        Object current;
        try {
            current = field.get(optionSource);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("internal error when setting option '%s'", optionName), e, InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
        return this.shouldUpdate(optionName, current, update);
    }

    private static int compare(String optionName, Object current, Object update) throws ConfigurationException {
        if (!(current instanceof Comparable)) {
            throw new ConfigurationException(String.format("internal error: Class %s for option %s was used with GREATEST or LEAST updateRule, but does not implement Comparable.", current.getClass().getSimpleName(), optionName), (ErrorIdentifier)InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
        Comparable compCurrent = (Comparable)current;
        try {
            return compCurrent.compareTo(update);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(String.format("internal error: Failed to compare %s (%s) and %s (%s)", current.getClass().getName(), current, update.getClass().getName(), update), e, InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
    }
}

