/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.BootstrapServiceFileResolverLoader;
import com.android.tradefed.config.IFileResolverLoader;
import com.android.tradefed.config.remote.IRemoteFileResolver;
import com.android.tradefed.invoker.logger.InvocationLocal;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RemoteFileResolver {
    private static final IFileResolverLoader DEFAULT_FILE_RESOLVER_LOADER = new IFileResolverLoader(){
        private final InvocationLocal<IFileResolverLoader> mInvocationLoader = new InvocationLocal<IFileResolverLoader>(){

            @Override
            protected IFileResolverLoader initialValue() {
                return new BootstrapServiceFileResolverLoader();
            }
        };

        @Override
        public IRemoteFileResolver load(String scheme, Map<String, String> config) {
            return this.mInvocationLoader.get().load(scheme, config);
        }
    };

    public static IRemoteFileResolver.ResolvedFile resolveRemoteFile(URI fileURI, URI destDir) throws BuildRetrievalError {
        return RemoteFileResolver.resolveRemoteFile(fileURI, destDir, RemoteFileResolver.getDefaultResolver(fileURI, new HashMap<String, String>()));
    }

    public static IRemoteFileResolver.ResolvedFile resolveRemoteFile(URI fileURI, URI destDir, IRemoteFileResolver resolver) throws BuildRetrievalError {
        IRemoteFileResolver.RemoteFileResolverArgs args = new IRemoteFileResolver.RemoteFileResolverArgs();
        args.setConsideredFile(new File(fileURI.toString()));
        args.setDestinationDir(new File(destDir));
        HashMap<String, String> queryArgs = new HashMap<String, String>();
        String query = fileURI.getQuery();
        if (query != null) {
            Arrays.stream(query.split("&")).forEach(x -> {
                String[] splits = x.split("=");
                queryArgs.put(splits[0], splits[1]);
            });
        }
        args.addQueryArgs(queryArgs);
        return resolver.resolveRemoteFile(args);
    }

    public static IRemoteFileResolver getDefaultResolver(URI fileURI, Map<String, String> config) {
        String scheme = fileURI.getScheme();
        IRemoteFileResolver resolver = DEFAULT_FILE_RESOLVER_LOADER.load(scheme, config);
        return resolver;
    }
}

