/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.retry.RetryRescheduler;

public class RetryConfigurationFactory
extends ConfigurationFactory {
    private static RetryConfigurationFactory sInstance = null;

    public static RetryConfigurationFactory getInstance() {
        if (sInstance == null) {
            sInstance = new RetryConfigurationFactory();
        }
        return sInstance;
    }

    public IConfiguration createRetryConfiguration(IConfiguration retryConfig) throws ConfigurationException {
        if (retryConfig.getTests().size() != 1) {
            throw new ConfigurationException(String.format("%s should only have one runner inside it.", retryConfig.getName()));
        }
        IRemoteTest rerunner = retryConfig.getTests().get(0);
        if (!(rerunner instanceof RetryRescheduler)) {
            LogUtil.CLog.e("The runner inside the retry configuration is not a RetryRescheduler type.");
            return retryConfig;
        }
        RetryRescheduler retryRunner = (RetryRescheduler)rerunner;
        retryRunner.setConfiguration(retryConfig);
        try {
            retryRunner.run(null, null);
            return retryRunner.getRetryConfiguration();
        }
        catch (Throwable e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }
}

