/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ClassNotFoundConfigurationException;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.OptionDef;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.sandbox.ISandbox;
import com.android.tradefed.sandbox.SandboxConfigDump;
import com.android.tradefed.sandbox.SandboxConfigUtil;
import com.android.tradefed.sandbox.SandboxConfigurationException;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.android.tradefed.util.keystore.IKeyStoreFactory;
import com.android.tradefed.util.keystore.KeyStoreException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SandboxConfigurationFactory
extends ConfigurationFactory {
    private static SandboxConfigurationFactory sInstance = null;
    public static final Set<String> OPTION_IGNORED_ELEMENTS = new HashSet<String>();

    public static SandboxConfigurationFactory getInstance() {
        if (sInstance == null) {
            sInstance = new SandboxConfigurationFactory();
        }
        return sInstance;
    }

    @Override
    protected ConfigurationDef getConfigurationDef(String name, boolean isGlobal, Map<String, String> templateMap) throws ConfigurationException {
        ConfigurationDef def = this.createConfigurationDef(name);
        new ConfigurationFactory.ConfigLoader(isGlobal).loadConfiguration(name, def, null, templateMap, null);
        return def;
    }

    protected ConfigurationDef createConfigurationDef(String name) {
        return new ConfigurationDef(name);
    }

    public IConfiguration createConfigurationFromArgs(String[] arrayArgs, SandboxConfigDump.DumpCmd command) throws ConfigurationException {
        RunSandboxConfigurationFactory loader = new RunSandboxConfigurationFactory(command);
        return loader.createConfigurationFromArgs(arrayArgs, null, this.getKeyStoreClient());
    }

    public IConfiguration createConfigurationFromArgs(String[] args, IKeyStoreClient keyStoreClient, ISandbox sandbox, IRunUtil runUtil) throws ConfigurationException {
        return this.createConfigurationFromArgs(args, keyStoreClient, sandbox, runUtil, null, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IConfiguration createConfigurationFromArgs(String[] args, IKeyStoreClient keyStoreClient, ISandbox sandbox, IRunUtil runUtil, File globalConfig, boolean skipJavaCheck) throws ConfigurationException {
        File xmlConfig;
        IConfiguration config;
        block10: {
            config = null;
            xmlConfig = null;
            try {
                runUtil.unsetEnvVariable("TF_GLOBAL_CONFIG");
                if (globalConfig == null) {
                    globalConfig = SandboxConfigUtil.dumpFilteredGlobalConfig(new HashSet<String>());
                }
                xmlConfig = SandboxConfigUtil.dumpConfigForVersion(this.createClasspath(), runUtil, args, SandboxConfigDump.DumpCmd.NON_VERSIONED_CONFIG, globalConfig, skipJavaCheck);
                config = super.createConfigurationFromArgs(new String[]{xmlConfig.getAbsolutePath()}, null, keyStoreClient);
                config.setCommandLine(args);
                config.setConfigurationObject("sandbox", sandbox);
                if (config != null) break block10;
                sandbox.tearDown();
            }
            catch (SandboxConfigurationException e) {
                block11: {
                    LogUtil.CLog.w("Using thin launcher as fallback");
                    config = sandbox.createThinLauncherConfig(args, keyStoreClient, runUtil, globalConfig);
                    if (config == null) {
                        LogUtil.CLog.e(e);
                        throw e;
                    }
                    if (config != null) break block11;
                    sandbox.tearDown();
                    {
                        catch (Throwable throwable) {
                            if (config == null) {
                                sandbox.tearDown();
                            }
                            FileUtil.deleteFile(globalConfig);
                            FileUtil.deleteFile(xmlConfig);
                            throw throwable;
                        }
                    }
                }
                FileUtil.deleteFile(globalConfig);
                FileUtil.deleteFile(xmlConfig);
                return config;
                catch (IOException e2) {
                    LogUtil.CLog.e(e2);
                    throw new ConfigurationException("Failed to dump global config.", e2);
                    catch (ConfigurationException e3) {
                        LogUtil.CLog.e(e3);
                        throw e3;
                    }
                }
            }
        }
        FileUtil.deleteFile(globalConfig);
        FileUtil.deleteFile(xmlConfig);
        return config;
    }

    private IKeyStoreClient getKeyStoreClient() {
        try {
            IKeyStoreFactory f = GlobalConfiguration.getInstance().getKeyStoreFactory();
            if (f != null) {
                try {
                    return f.createKeyStoreClient();
                }
                catch (KeyStoreException e) {
                    LogUtil.CLog.e("Failed to create key store client");
                    LogUtil.CLog.e(e);
                }
            }
        }
        catch (IllegalStateException e) {
            LogUtil.CLog.w("Global configuration has not been created, failed to get keystore");
            LogUtil.CLog.e(e);
        }
        return null;
    }

    private String createClasspath() throws ConfigurationException {
        String classpathStr = System.getProperty("java.class.path");
        if (classpathStr == null) {
            throw new ConfigurationException("Could not find the classpath property: java.class.path");
        }
        return classpathStr;
    }

    static {
        OPTION_IGNORED_ELEMENTS.addAll(SandboxConfigDump.VERSIONED_ELEMENTS);
        OPTION_IGNORED_ELEMENTS.add("device_requirements");
        OPTION_IGNORED_ELEMENTS.add("device_options");
        OPTION_IGNORED_ELEMENTS.add("device_recovery");
        OPTION_IGNORED_ELEMENTS.add("cmd_options");
    }

    private class RunSandboxConfigurationFactory
    extends SandboxConfigurationFactory {
        private SandboxConfigDump.DumpCmd mCommand;

        RunSandboxConfigurationFactory(SandboxConfigDump.DumpCmd command) {
            this.mCommand = command;
        }

        @Override
        protected ConfigurationDef createConfigurationDef(String name) {
            return new ConfigurationDef(name){

                @Override
                protected void checkRejectedObjects(Map<String, String> rejectedObjects, Throwable cause) throws ClassNotFoundConfigurationException {
                    if (RunSandboxConfigurationFactory.this.mCommand.equals((Object)SandboxConfigDump.DumpCmd.RUN_CONFIG) || RunSandboxConfigurationFactory.this.mCommand.equals((Object)SandboxConfigDump.DumpCmd.TEST_MODE)) {
                        HashMap<String, String> copyRejected = new HashMap<String, String>();
                        for (Map.Entry<String, String> item : rejectedObjects.entrySet()) {
                            if (!SandboxConfigDump.VERSIONED_ELEMENTS.contains(item.getValue())) continue;
                            copyRejected.put(item.getKey(), item.getValue());
                        }
                        super.checkRejectedObjects(copyRejected, cause);
                    } else {
                        super.checkRejectedObjects(rejectedObjects, cause);
                    }
                }

                @Override
                protected void injectOptions(IConfiguration config, List<OptionDef> optionList) throws ConfigurationException {
                    List<Object> individualAttempt = new ArrayList();
                    if (RunSandboxConfigurationFactory.this.mCommand.equals((Object)SandboxConfigDump.DumpCmd.RUN_CONFIG) || RunSandboxConfigurationFactory.this.mCommand.equals((Object)SandboxConfigDump.DumpCmd.TEST_MODE)) {
                        individualAttempt = optionList.stream().filter(o -> o.applicableObjectType != null && !OPTION_IGNORED_ELEMENTS.contains(o.applicableObjectType)).collect(Collectors.toList());
                        optionList.removeAll(individualAttempt);
                    }
                    super.injectOptions(config, optionList);
                    for (OptionDef optionDef : individualAttempt) {
                        List<OptionDef> tmpList = Arrays.asList(optionDef);
                        try {
                            super.injectOptions(config, tmpList);
                        }
                        catch (ConfigurationException configurationException) {}
                    }
                }
            };
        }
    }
}

