/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.filter;

import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.sandbox.SandboxOptions;
import com.android.tradefed.service.IRemoteFeature;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.MultiPartResponse;
import com.proto.tradefed.feature.PartResponse;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CommandOptionsGetter
implements IRemoteFeature,
IConfigurationReceiver {
    public static final String COMMAND_OPTIONS_GETTER = "getCommandOptions";
    public static final String OPTION_NAME = "option_name";
    private IConfiguration mConfig;

    @Override
    public String getName() {
        return COMMAND_OPTIONS_GETTER;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public FeatureResponse execute(FeatureRequest request) {
        FeatureResponse.Builder responseBuilder = FeatureResponse.newBuilder();
        if (this.mConfig == null) {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace("Internal error, configuration not set."));
            return responseBuilder.build();
        }
        if (request.getArgsMap().isEmpty() || !request.getArgsMap().containsKey(OPTION_NAME)) {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace("No option_name specified in the args."));
            return responseBuilder.build();
        }
        ArrayList<String> optionsToFill = new ArrayList<String>(Arrays.asList(request.getArgsMap().get(OPTION_NAME).split(",")));
        ICommandOptions commandOptions = this.mConfig.getCommandOptions();
        IRetryDecision retryOptions = this.mConfig.getRetryDecision();
        SandboxOptions sandboxOptions = (SandboxOptions)this.mConfig.getConfigurationObject("sandbox_options");
        List<Object> optionObjects = Arrays.asList(commandOptions, retryOptions, sandboxOptions);
        ArrayList<PartResponse> partResponses = new ArrayList<PartResponse>();
        for (Object o : optionObjects) {
            partResponses.addAll(this.findOptionsForObject(o, optionsToFill));
        }
        if (partResponses.isEmpty()) {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(String.format("No option or not value set for '%s'", request.getArgsMap().get(OPTION_NAME))));
        } else if (partResponses.size() == 1) {
            responseBuilder.setResponse(((PartResponse)partResponses.get(0)).getValue());
        } else {
            responseBuilder.setMultiPartResponse(MultiPartResponse.newBuilder().addAllResponsePart(partResponses));
        }
        return responseBuilder.build();
    }

    private List<PartResponse> findOptionsForObject(Object objectForFields, List<String> optionsToResolve) {
        ArrayList<PartResponse> responses = new ArrayList<PartResponse>();
        Collection<Field> allFields = OptionSetter.getOptionFieldsForClass(objectForFields.getClass());
        for (String toResolve : optionsToResolve) {
            for (Field field : allFields) {
                Object fieldValue;
                Option option = field.getAnnotation(Option.class);
                if (!option.name().equals(toResolve) || (fieldValue = OptionSetter.getFieldValue(field, objectForFields)) == null) continue;
                if (fieldValue instanceof Set) {
                    for (Object o : (Set)fieldValue) {
                        responses.add(PartResponse.newBuilder().setKey(toResolve).setValue(o.toString()).build());
                    }
                    continue;
                }
                if (fieldValue instanceof List) {
                    for (Object o : (List)fieldValue) {
                        responses.add(PartResponse.newBuilder().setKey(toResolve).setValue(o.toString()).build());
                    }
                    continue;
                }
                responses.add(PartResponse.newBuilder().setKey(toResolve).setValue(fieldValue.toString()).build());
            }
        }
        return responses;
    }
}

