/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.filter;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.google.common.base.Strings;
import com.proto.tradefed.feature.FeatureResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetPreviousPassedHelper {
    public Set<String> getPreviousPassedFilters(IConfiguration config) {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        ArrayList<SuiteTestFilter> previousPassedFilters = new ArrayList<SuiteTestFilter>();
        if (config == null) {
            return filters;
        }
        if (!config.getCommandOptions().filterPreviousPassedTests()) {
            return filters;
        }
        HashMap<String, String> args = new HashMap<String, String>();
        Map invocationData = config.getCommandOptions().getInvocationData().getUniqueMap();
        String invocationId = (String)invocationData.get("invocation_id");
        if (!Strings.isNullOrEmpty(invocationId)) {
            args.put("invocation_id", invocationId);
        }
        if (args.isEmpty()) {
            return filters;
        }
        String attempt = (String)invocationData.get("attempt_index");
        if ("0".equals(attempt)) {
            return filters;
        }
        if (config.getCommandOptions().getShardIndex() != null) {
            args.put("shard_index", Integer.toString(config.getCommandOptions().getShardIndex()));
        }
        try (TradefedFeatureClient client = new TradefedFeatureClient();){
            FeatureResponse previousPassed = client.triggerFeature("getPreviousPassed", args);
            this.convertResponseToFilter(previousPassed, previousPassedFilters);
            boolean filterShards = previousPassedFilters.removeIf(f -> f.getShardIndex() != null && !f.getShardIndex().equals(config.getCommandOptions().getShardIndex()));
            if (filterShards) {
                LogUtil.CLog.d("Remaining filter for the shard: %s", previousPassedFilters);
            }
            previousPassedFilters.stream().forEach(f -> filters.add(f.toString()));
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e(e);
        }
        return filters;
    }

    private void convertResponseToFilter(FeatureResponse previousPassed, List<SuiteTestFilter> previousPassedFilters) {
        if (previousPassed.hasErrorInfo()) {
            return;
        }
        if (Strings.isNullOrEmpty(previousPassed.getResponse())) {
            return;
        }
        for (String line : previousPassed.getResponse().split("\n")) {
            if (line.isEmpty()) continue;
            previousPassedFilters.add(SuiteTestFilter.createFrom(line));
        }
    }
}

