/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.filter;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.service.IRemoteFeature;
import com.google.common.base.Joiner;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.MultiPartResponse;
import com.proto.tradefed.feature.PartResponse;

public class GlobalFilterGetter
implements IRemoteFeature,
IConfigurationReceiver {
    public static final String GLOBAL_FILTER_GETTER = "getGlobalFilters";
    private static final String DELIMITER = ",";
    private static final String ESCAPED_DELIMITER = ",";
    private IConfiguration mConfig;

    @Override
    public String getName() {
        return GLOBAL_FILTER_GETTER;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public FeatureResponse execute(FeatureRequest request) {
        FeatureResponse.Builder responseBuilder = FeatureResponse.newBuilder();
        if (this.mConfig != null) {
            MultiPartResponse.Builder multiPartBuilder = MultiPartResponse.newBuilder();
            multiPartBuilder.addResponsePart(PartResponse.newBuilder().setKey("delimiter").setValue(","));
            multiPartBuilder.addResponsePart(PartResponse.newBuilder().setKey("include-filter").setValue(Joiner.on(",").join(this.mConfig.getGlobalFilters().getIncludeFilters())));
            multiPartBuilder.addResponsePart(PartResponse.newBuilder().setKey("exclude-filter").setValue(Joiner.on(",").join(this.mConfig.getGlobalFilters().getExcludeFilters())));
            multiPartBuilder.addResponsePart(PartResponse.newBuilder().setKey("strict-include-filter").setValue(Joiner.on(",").join(this.mConfig.getGlobalFilters().getStrictIncludeFilters())));
            responseBuilder.setMultiPartResponse(multiPartBuilder);
        } else {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace("Configuration not set."));
        }
        return responseBuilder.build();
    }
}

