/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config.filter;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.android.tradefed.testtype.suite.TestMappingSuiteRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.PartResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@OptionClass(alias="global-filters")
public final class GlobalTestFilter {
    public static final String INCLUDE_FILTER_OPTION = "include-filter";
    public static final String EXCLUDE_FILTER_OPTION = "exclude-filter";
    public static final String STRICT_INCLUDE_FILTER_OPTION = "strict-include-filter";
    public static final String DELIMITER_NAME = "delimiter";
    @Option(name="include-filter", description="Filters applied to the invocation. Format: [abi] [module-name] [test-class][#method-name]")
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    @Option(name="exclude-filter", description="Filters applied to the invocation. Format: [abi] [module-name] [test-class][#method-name]")
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    @Option(name="strict-include-filter", description="Filters applied to the invocation. Format: [abi] [module-name] [test-class][#method-name]. All other filters will be ignored to strictly run this set.This is still best-effort as not all runners support filtering equally.")
    private Set<String> mStrictIncludeFilters = new LinkedHashSet<String>();
    @Option(name="disable-global-filters", description="Feature flag to enable the global filters")
    private boolean mDisable = false;
    private TradefedFeatureClient mClient;
    private boolean mSetupDone = false;

    public GlobalTestFilter() {
    }

    @VisibleForTesting
    GlobalTestFilter(TradefedFeatureClient client) {
        this.mClient = client;
    }

    public Set<String> getIncludeFilters() {
        return new LinkedHashSet<String>(this.mIncludeFilters);
    }

    public Set<String> getExcludeFilters() {
        return new LinkedHashSet<String>(this.mExcludeFilters);
    }

    public Set<String> getStrictIncludeFilters() {
        return new LinkedHashSet<String>(this.mStrictIncludeFilters);
    }

    public void addPreviousPassedTests(Set<String> previousPassed) {
        if (!previousPassed.isEmpty()) {
            LogUtil.CLog.d("Adding following exclusion to GlobalTestFilter: %s", previousPassed);
        }
        this.mExcludeFilters.addAll(previousPassed);
    }

    public void setUpFilters(IConfiguration config, Set<String> demotedList) {
        if (this.mDisable) {
            LogUtil.CLog.d("Global filters are disabled.");
            return;
        }
        if (this.mSetupDone) {
            LogUtil.CLog.d("Global filters already set.");
            return;
        }
        LogUtil.CLog.d("Setting up global filters");
        if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
            this.populateGlobalFilters();
        } else {
            this.mExcludeFilters.addAll(demotedList);
        }
        if (this.mStrictIncludeFilters.isEmpty()) {
            for (IRemoteTest test : config.getTests()) {
                if (test instanceof BaseTestSuite) {
                    ((BaseTestSuite)test).setIncludeFilter(this.mIncludeFilters);
                    ((BaseTestSuite)test).setExcludeFilter(this.mExcludeFilters);
                    continue;
                }
                if (!(test instanceof ITestFilterReceiver)) continue;
                ITestFilterReceiver filterableTest = (ITestFilterReceiver)((Object)test);
                this.applyFiltersToTest(filterableTest);
            }
        } else {
            LogUtil.CLog.d("Strict include filters specified: %s", this.mStrictIncludeFilters);
            for (IRemoteTest test : config.getTests()) {
                if (test instanceof BaseTestSuite) {
                    ((BaseTestSuite)test).clearExcludeFilter();
                    ((BaseTestSuite)test).clearIncludeFilter();
                    ((BaseTestSuite)test).setIncludeFilter(this.mStrictIncludeFilters);
                    if (!(test instanceof TestMappingSuiteRunner)) continue;
                    ((TestMappingSuiteRunner)test).clearTestGroup();
                    continue;
                }
                if (!(test instanceof ITestFilterReceiver)) continue;
                ITestFilterReceiver filterableTest = (ITestFilterReceiver)((Object)test);
                this.applyFiltersToTest(filterableTest);
            }
        }
        this.mSetupDone = true;
    }

    public void applyFiltersToTest(ITestFilterReceiver filterableTest) {
        if (this.mStrictIncludeFilters.isEmpty()) {
            LinkedHashSet<String> includeFilters = new LinkedHashSet<String>(filterableTest.getIncludeFilters());
            includeFilters.addAll(this.filtersFromGlobal(this.mIncludeFilters));
            filterableTest.clearIncludeFilters();
            filterableTest.addAllIncludeFilters(includeFilters);
            LinkedHashSet<String> excludeFilters = new LinkedHashSet<String>(filterableTest.getExcludeFilters());
            excludeFilters.addAll(this.filtersFromGlobal(this.mExcludeFilters));
            filterableTest.clearExcludeFilters();
            filterableTest.addAllExcludeFilters(excludeFilters);
        } else {
            filterableTest.clearExcludeFilters();
            filterableTest.clearIncludeFilters();
            filterableTest.addAllIncludeFilters(this.filtersFromGlobal(this.mStrictIncludeFilters));
        }
    }

    public void applyFiltersToTest(BaseTestSuite suite) {
        if (this.mStrictIncludeFilters.isEmpty()) {
            suite.setIncludeFilter(this.mIncludeFilters);
            suite.setExcludeFilter(this.mExcludeFilters);
        } else {
            LogUtil.CLog.d("Applying strict filters to suite.");
            suite.clearExcludeFilter();
            suite.clearIncludeFilter();
            suite.setIncludeFilter(this.mStrictIncludeFilters);
            if (suite instanceof TestMappingSuiteRunner) {
                ((TestMappingSuiteRunner)suite).clearTestGroup();
            }
        }
        suite.reevaluateFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGlobalFilters() {
        if (this.mClient == null) {
            this.mClient = new TradefedFeatureClient();
        }
        try {
            FeatureResponse globalFilters = this.mClient.triggerFeature("getGlobalFilters", new HashMap<String, String>());
            if (globalFilters.hasMultiPartResponse()) {
                String delimiter = ",";
                for (PartResponse rep : globalFilters.getMultiPartResponse().getResponsePartList()) {
                    if (!rep.getKey().equals(DELIMITER_NAME)) continue;
                    delimiter = rep.getValue().trim();
                }
                for (PartResponse rep : globalFilters.getMultiPartResponse().getResponsePartList()) {
                    if (rep.getKey().equals(INCLUDE_FILTER_OPTION)) {
                        this.mIncludeFilters.addAll(this.splitStringFilters(delimiter, rep.getValue()));
                        continue;
                    }
                    if (rep.getKey().equals(EXCLUDE_FILTER_OPTION)) {
                        this.mExcludeFilters.addAll(this.splitStringFilters(delimiter, rep.getValue()));
                        continue;
                    }
                    if (rep.getKey().equals(STRICT_INCLUDE_FILTER_OPTION)) {
                        this.mStrictIncludeFilters.addAll(this.splitStringFilters(delimiter, rep.getValue()));
                        continue;
                    }
                    if (rep.getKey().equals(DELIMITER_NAME)) continue;
                    LogUtil.CLog.w("Unexpected response key '%s' for global filters", rep.getKey());
                }
            } else {
                LogUtil.CLog.w("Unexpected response for global filters: %s", globalFilters);
            }
        }
        finally {
            this.mClient.close();
        }
    }

    private List<String> splitStringFilters(String delimiter, String value) {
        if (Strings.isNullOrEmpty(value)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(value.split(delimiter));
    }

    private Set<String> filtersFromGlobal(Set<String> filters) {
        LinkedHashSet<String> globalFilters = new LinkedHashSet<String>();
        filters.forEach(f -> {
            SuiteTestFilter suiteFilter = SuiteTestFilter.createFrom(f);
            if (!Strings.isNullOrEmpty(suiteFilter.getTest())) {
                globalFilters.add(suiteFilter.getTest());
            } else if (!Strings.isNullOrEmpty(suiteFilter.getName())) {
                globalFilters.add(suiteFilter.getName());
            }
        });
        return globalFilters;
    }
}

